/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JsonInstanceInspectorTest {
    private final JsonInspectionService inspectionService = new JsonInspectionService();

    @Test
    public void inspectJsonDocumentEmpty() throws Exception {
        String instance = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonDocument(""));
    }

    @Test
    public void inspectJsonDocumentWhitespaceOnly() throws Exception {
        String instance = " ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonDocument(" "));
    }

    @Test
    public void inspectJsonDocumentNull() throws Exception {
        String instance = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonDocument(instance));
    }

    @Test
    public void inspectJsonDocumentUnparseableHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/unparseable-highly-complex-nested-object.json", new String[0])));
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonDocument(instance));
    }

    @Test
    public void inspectJsonDocumentUnparseableMissingOpenCurly() throws Exception {
        String instance = "\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonDocument("\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}"));
    }

    @Test
    public void inspectJsonDocumentUnparseableMissingClosingCurly() throws Exception {
        String instance = "{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonDocument("{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]"));
    }

    @Test
    public void inspectJsonDocumentUnparseableMissingKeySeperator() throws Exception {
        String instance = "{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonDocument("{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]"));
    }

    @Test
    public void inspectJsonDocumentUnparseableMissingValueSeperator() throws Exception {
        String instance = "{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonDocument("{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}"));
    }

    @Test
    public void inspectJsonDocumentEmptyDocument() throws Exception {
        String instance = "{}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{}");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)0, (int)document.getFields().getField().size());
    }

    @Test
    public void inspectJsonDocumentSimpleArray() throws Exception {
        String instance = "[ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[ 100, 500, 300, 200, 400 ]");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/<>", (Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleArrayStartsWithWhiteSpace() throws Exception {
        String instance = "\n\t\r [ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("\n\t\r [ 100, 500, 300, 200, 400 ]");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/<>", (Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleObjectArray() throws Exception {
        String instance = "[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/<>", (Object)jsonField.getPath());
        JsonComplexType complexType = (JsonComplexType)jsonField;
        Assertions.assertEquals((int)2, (int)complexType.getJsonFields().getJsonField().size());
        JsonField color = (JsonField)complexType.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)color.getStatus());
        Assertions.assertEquals(null, (Object)color.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)color.getFieldType());
        Assertions.assertEquals((Object)"color", (Object)color.getName());
        Assertions.assertEquals((Object)"/<>/color", (Object)color.getPath());
        JsonField value = (JsonField)complexType.getJsonFields().getJsonField().get(1);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)value.getStatus());
        Assertions.assertEquals(null, (Object)value.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)value.getFieldType());
        Assertions.assertEquals((Object)"value", (Object)value.getName());
        Assertions.assertEquals((Object)"/<>/value", (Object)value.getPath());
    }

    @Test
    public void inspectJsonDocumentArrayHighlyNestedObjects() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/array-highly-nested-objects.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)jsonField.getFieldType());
        JsonComplexType complex = (JsonComplexType)jsonField;
        Assertions.assertEquals((int)6, (int)complex.getJsonFields().getJsonField().size());
        JsonField id = (JsonField)complex.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)id.getStatus());
        Assertions.assertEquals(null, (Object)id.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)id.getFieldType());
        Assertions.assertEquals((Object)"id", (Object)id.getName());
        Assertions.assertEquals((Object)"/<>/id", (Object)id.getPath());
        JsonField type = (JsonField)complex.getJsonFields().getJsonField().get(1);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)type.getStatus());
        Assertions.assertEquals(null, (Object)type.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)type.getFieldType());
        Assertions.assertEquals((Object)"type", (Object)type.getName());
        Assertions.assertEquals((Object)"/<>/type", (Object)type.getPath());
        JsonField name = (JsonField)complex.getJsonFields().getJsonField().get(2);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)name.getStatus());
        Assertions.assertEquals(null, (Object)name.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)name.getFieldType());
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals((Object)"/<>/name", (Object)name.getPath());
        JsonField ppu = (JsonField)complex.getJsonFields().getJsonField().get(3);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ppu.getStatus());
        Assertions.assertEquals(null, (Object)ppu.getCollectionType());
        Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)ppu.getFieldType());
        Assertions.assertEquals((Object)"ppu", (Object)ppu.getName());
        Assertions.assertEquals((Object)"/<>/ppu", (Object)ppu.getPath());
        JsonField batters = (JsonField)complex.getJsonFields().getJsonField().get(4);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batters.getStatus());
        Assertions.assertEquals(null, (Object)batters.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)batters.getFieldType());
        Assertions.assertEquals((Object)"batters", (Object)batters.getName());
        Assertions.assertEquals((Object)"/<>/batters", (Object)batters.getPath());
        JsonComplexType battersComplex = (JsonComplexType)batters;
        Assertions.assertEquals((int)1, (int)battersComplex.getJsonFields().getJsonField().size());
        JsonField batter = (JsonField)battersComplex.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batter.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)batter.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)batter.getFieldType());
        Assertions.assertEquals((Object)"batter", (Object)batter.getName());
        Assertions.assertEquals((Object)"/<>/batters/batter<>", (Object)batter.getPath());
        JsonComplexType batterComplex = (JsonComplexType)batter;
        Assertions.assertEquals((int)2, (int)batterComplex.getJsonFields().getJsonField().size());
        JsonField batterId = (JsonField)batterComplex.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterId.getStatus());
        Assertions.assertEquals(null, (Object)batterId.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterId.getFieldType());
        Assertions.assertEquals((Object)"id", (Object)batterId.getName());
        Assertions.assertEquals((Object)"/<>/batters/batter<>/id", (Object)batterId.getPath());
        JsonField batterType = (JsonField)batterComplex.getJsonFields().getJsonField().get(1);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterType.getStatus());
        Assertions.assertEquals(null, (Object)batterType.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterType.getFieldType());
        Assertions.assertEquals((Object)"type", (Object)batterType.getName());
        Assertions.assertEquals((Object)"/<>/batters/batter<>/type", (Object)batterType.getPath());
        JsonField topping = (JsonField)complex.getJsonFields().getJsonField().get(5);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)topping.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)topping.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)topping.getFieldType());
        Assertions.assertEquals((Object)"topping", (Object)topping.getName());
        Assertions.assertEquals((Object)"/<>/topping<>", (Object)topping.getPath());
        JsonComplexType toppingComplex = (JsonComplexType)topping;
        Assertions.assertEquals((int)2, (int)toppingComplex.getJsonFields().getJsonField().size());
        JsonField toppingId = (JsonField)toppingComplex.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingId.getStatus());
        Assertions.assertEquals(null, (Object)toppingId.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingId.getFieldType());
        Assertions.assertEquals((Object)"id", (Object)toppingId.getName());
        Assertions.assertEquals((Object)"/<>/topping<>/id", (Object)toppingId.getPath());
        JsonField toppingType = (JsonField)toppingComplex.getJsonFields().getJsonField().get(1);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingType.getStatus());
        Assertions.assertEquals(null, (Object)toppingType.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingType.getFieldType());
        Assertions.assertEquals((Object)"type", (Object)toppingType.getName());
        Assertions.assertEquals((Object)"/<>/topping<>/type", (Object)toppingType.getPath());
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInKeys() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/keys-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)7, (int)document.getFields().getField().size());
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assertions.assertEquals((Object)"'booleanField'", (Object)field.getName());
                Assertions.assertEquals((Object)false, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 1) {
                Assertions.assertEquals((Object)"\"charField\"", (Object)field.getName());
                Assertions.assertEquals((Object)"a", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 2) {
                Assertions.assertEquals((Object)"\\doubleField", (Object)field.getName());
                Assertions.assertEquals((Object)-2.71527453422E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 3) {
                Assertions.assertEquals((Object)"floatField\t", (Object)field.getName());
                Assertions.assertEquals((Object)-6.3988281E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 4) {
                Assertions.assertEquals((Object)"intField\n", (Object)field.getName());
                Assertions.assertEquals((Object)8281, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 5) {
                Assertions.assertEquals((Object)"shortField", (Object)field.getName());
                Assertions.assertEquals((Object)81, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i != 6) continue;
            Assertions.assertEquals((Object)"longField", (Object)field.getName());
            Assertions.assertEquals((Object)3988281, (Object)field.getValue());
            Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
            Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
            Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        }
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInValue() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/value-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)5, (int)document.getFields().getField().size());
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assertions.assertEquals((Object)"quote", (Object)field.getName());
                Assertions.assertEquals((Object)"\"yadda\"", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 1) {
                Assertions.assertEquals((Object)"singlequote", (Object)field.getName());
                Assertions.assertEquals((Object)"'a'", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 2) {
                Assertions.assertEquals((Object)"backslash", (Object)field.getName());
                Assertions.assertEquals((Object)"\\qwerty", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 3) {
                Assertions.assertEquals((Object)"tab", (Object)field.getName());
                Assertions.assertEquals((Object)"foo\t", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i != 4) continue;
            Assertions.assertEquals((Object)"linefeed", (Object)field.getName());
            Assertions.assertEquals((Object)"bar\n", (Object)field.getValue());
            Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
            Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
            Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        }
    }

    @Test
    public void inspectFlatPrimitiveNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)7, (int)document.getFields().getField().size());
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assertions.assertEquals((Object)"booleanField", (Object)field.getName());
                Assertions.assertEquals((Object)false, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 1) {
                Assertions.assertEquals((Object)"charField", (Object)field.getName());
                Assertions.assertEquals((Object)"a", (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 2) {
                Assertions.assertEquals((Object)"doubleField", (Object)field.getName());
                Assertions.assertEquals((Object)-2.71527453422E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 3) {
                Assertions.assertEquals((Object)"floatField", (Object)field.getName());
                Assertions.assertEquals((Object)-6.3988281E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 4) {
                Assertions.assertEquals((Object)"intField", (Object)field.getName());
                Assertions.assertEquals((Object)8281, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 5) {
                Assertions.assertEquals((Object)"shortField", (Object)field.getName());
                Assertions.assertEquals((Object)81, (Object)field.getValue());
                Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i != 6) continue;
            Assertions.assertEquals((Object)"longField", (Object)field.getName());
            Assertions.assertEquals((Object)3988281, (Object)field.getValue());
            Assertions.assertEquals((Object)"/".concat(field.getName()), (Object)field.getPath());
            Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
            Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        }
    }

    @Test
    public void inspectFlatPrimitiveWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((Object)"SourceFlatPrimitive", (Object)root.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive", (Object)root.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)root.getStatus());
        Assertions.assertEquals((int)8, (int)root.getJsonFields().getJsonField().size());
        for (int i = 0; i < root.getJsonFields().getJsonField().size(); ++i) {
            JsonField field = (JsonField)root.getJsonFields().getJsonField().get(i);
            if (i == 0) {
                Assertions.assertEquals((Object)"booleanField", (Object)field.getName());
                Assertions.assertEquals((Object)false, (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 1) {
                Assertions.assertEquals((Object)"charField", (Object)field.getName());
                Assertions.assertEquals((Object)"a", (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 2) {
                Assertions.assertEquals((Object)"doubleField", (Object)field.getName());
                Assertions.assertEquals((Object)-2.71527453422E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 3) {
                Assertions.assertEquals((Object)"floatField", (Object)field.getName());
                Assertions.assertEquals((Object)-6.3988281E7, (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 4) {
                Assertions.assertEquals((Object)"intField", (Object)field.getName());
                Assertions.assertEquals((Object)8281, (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i == 5) {
                Assertions.assertEquals((Object)"shortField", (Object)field.getName());
                Assertions.assertEquals((Object)81, (Object)field.getValue());
                Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
                Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
                Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
                continue;
            }
            if (i != 6) continue;
            Assertions.assertEquals((Object)"longField", (Object)field.getName());
            Assertions.assertEquals((Object)3988281, (Object)field.getValue());
            Assertions.assertEquals((Object)"/SourceFlatPrimitive/".concat(field.getName()), (Object)field.getPath());
            Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
            Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        }
    }

    @Test
    public void inspectComplexObjectNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)3, (int)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address1);
        Assertions.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assertions.assertEquals((Object)"123 Main St", (Object)address1.getValue());
        Assertions.assertEquals((Object)"/address/addressLine1", (Object)address1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)address2);
        Assertions.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assertions.assertEquals((Object)"Suite 42b", (Object)address2.getValue());
        Assertions.assertEquals((Object)"/address/addressLine2", (Object)address2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"Anytown", (Object)city.getValue());
        Assertions.assertEquals((Object)"/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"NY", (Object)state.getValue());
        Assertions.assertEquals((Object)"/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"90210", (Object)postalCode.getValue());
        Assertions.assertEquals((Object)"/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"Ozzie", (Object)firstName.getValue());
        Assertions.assertEquals((Object)"/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"Smith", (Object)lastName.getValue());
        Assertions.assertEquals((Object)"/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"5551212", (Object)phoneNumber.getValue());
        Assertions.assertEquals((Object)"/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"81111", (Object)zipCode.getValue());
        Assertions.assertEquals((Object)"/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assertions.assertNotNull((Object)orderId);
        Assertions.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assertions.assertEquals((Object)0, (Object)orderId.getValue());
        Assertions.assertEquals((Object)"/orderId", (Object)orderId.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertEquals((int)3, (int)root.getJsonFields().getJsonField().size());
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address1);
        Assertions.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assertions.assertEquals((Object)"123 Main St", (Object)address1.getValue());
        Assertions.assertEquals((Object)"/order/address/addressLine1", (Object)address1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)address2);
        Assertions.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assertions.assertEquals((Object)"Suite 42b", (Object)address2.getValue());
        Assertions.assertEquals((Object)"/order/address/addressLine2", (Object)address2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"Anytown", (Object)city.getValue());
        Assertions.assertEquals((Object)"/order/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"NY", (Object)state.getValue());
        Assertions.assertEquals((Object)"/order/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"90210", (Object)postalCode.getValue());
        Assertions.assertEquals((Object)"/order/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"Ozzie", (Object)firstName.getValue());
        Assertions.assertEquals((Object)"/order/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"Smith", (Object)lastName.getValue());
        Assertions.assertEquals((Object)"/order/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"5551212", (Object)phoneNumber.getValue());
        Assertions.assertEquals((Object)"/order/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"81111", (Object)zipCode.getValue());
        Assertions.assertEquals((Object)"/order/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)orderId);
        Assertions.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assertions.assertEquals((Object)0, (Object)orderId.getValue());
        Assertions.assertEquals((Object)"/order/orderId", (Object)orderId.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectRepeatingComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-repeated-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)3, (int)root.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"SourceOrderList", (Object)root.getName());
        Assertions.assertEquals((Object)"/SourceOrderList", (Object)root.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assertions.assertEquals(null, (Object)root.getCollectionType());
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)3, (int)orders.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"orders", (Object)orders.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>", (Object)orders.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)orders.getFieldType());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)orders.getCollectionType());
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)orderBatchNumber);
        Assertions.assertEquals((Object)"orderBatchNumber", (Object)orderBatchNumber.getName());
        Assertions.assertEquals((Object)4123562, (Object)orderBatchNumber.getValue());
        Assertions.assertEquals((Object)"/SourceOrderList/orderBatchNumber", (Object)orderBatchNumber.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)orderBatchNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderBatchNumber.getStatus());
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)numberOrders);
        Assertions.assertEquals((Object)"numberOrders", (Object)numberOrders.getName());
        Assertions.assertEquals((Object)5, (Object)numberOrders.getValue());
        Assertions.assertEquals((Object)"/SourceOrderList/numberOrders", (Object)numberOrders.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)numberOrders.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)numberOrders.getStatus());
        JsonComplexType address = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        Assertions.assertEquals(null, (Object)address.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)address.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address.getStatus());
        Assertions.assertEquals((Object)"address", (Object)address.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address", (Object)address.getPath());
        JsonField addressLine1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)addressLine1);
        Assertions.assertEquals((Object)"addressLine1", (Object)addressLine1.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/addressLine1", (Object)addressLine1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)addressLine1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine1.getStatus());
        JsonField addressLine2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)addressLine2);
        Assertions.assertEquals((Object)"addressLine2", (Object)addressLine2.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/addressLine2", (Object)addressLine2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)addressLine2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)contact.getFieldType());
        Assertions.assertEquals(null, (Object)contact.getCollectionType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)contact.getStatus());
        Assertions.assertEquals((Object)"contact", (Object)contact.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact", (Object)contact.getPath());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
    }

    @Test
    public void inspectISO8601DatesNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/iso8601dates-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)7, (int)document.getFields().getField().size());
        JsonField yyyy = (JsonField)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)yyyy);
        Assertions.assertEquals((Object)"YYYY", (Object)yyyy.getName());
        Assertions.assertEquals((Object)"1997", (Object)yyyy.getValue());
        Assertions.assertEquals((Object)"/YYYY", (Object)yyyy.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyy.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyy.getStatus());
        JsonField yyyymm = (JsonField)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)yyyymm);
        Assertions.assertEquals((Object)"YYYY-MM", (Object)yyyymm.getName());
        Assertions.assertEquals((Object)"1997-07", (Object)yyyymm.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM", (Object)yyyymm.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymm.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymm.getStatus());
        JsonField yyyymmdd = (JsonField)document.getFields().getField().get(2);
        Assertions.assertNotNull((Object)yyyymmdd);
        Assertions.assertEquals((Object)"YYYY-MM-DD", (Object)yyyymmdd.getName());
        Assertions.assertEquals((Object)"1997-07-16", (Object)yyyymmdd.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM-DD", (Object)yyyymmdd.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymmdd.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymmdd.getStatus());
        JsonField yyyymmddthhmmtzd = (JsonField)document.getFields().getField().get(3);
        Assertions.assertNotNull((Object)yyyymmddthhmmtzd);
        Assertions.assertEquals((Object)"YYYY-MM-DDThh:mmTZD", (Object)yyyymmddthhmmtzd.getName());
        Assertions.assertEquals((Object)"1997-07-16T19:20+01:00", (Object)yyyymmddthhmmtzd.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM-DDThh:mmTZD", (Object)yyyymmddthhmmtzd.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymmddthhmmtzd.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymmddthhmmtzd.getStatus());
        JsonField yyyymmddthhmmsstzd = (JsonField)document.getFields().getField().get(4);
        Assertions.assertNotNull((Object)yyyymmddthhmmsstzd);
        Assertions.assertEquals((Object)"YYYY-MM-DDThh:mm:ssTZD", (Object)yyyymmddthhmmsstzd.getName());
        Assertions.assertEquals((Object)"1997-07-16T19:20:30+01:00", (Object)yyyymmddthhmmsstzd.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM-DDThh:mm:ssTZD", (Object)yyyymmddthhmmsstzd.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymmddthhmmsstzd.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymmddthhmmsstzd.getStatus());
        JsonField yyyymmddthhmmssstzd = (JsonField)document.getFields().getField().get(5);
        Assertions.assertNotNull((Object)yyyymmddthhmmssstzd);
        Assertions.assertEquals((Object)"YYYY-MM-DDThh:mm:ss.sTZD", (Object)yyyymmddthhmmssstzd.getName());
        Assertions.assertEquals((Object)"1997-07-16T19:20:30.45+01:00", (Object)yyyymmddthhmmssstzd.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM-DDThh:mm:ss.sTZD", (Object)yyyymmddthhmmssstzd.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymmddthhmmssstzd.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymmddthhmmssstzd.getStatus());
        JsonField yyyymmddthhmmssutz = (JsonField)document.getFields().getField().get(6);
        Assertions.assertNotNull((Object)yyyymmddthhmmssutz);
        Assertions.assertEquals((Object)"YYYY-MM-DDThh:mm:ssUTZ", (Object)yyyymmddthhmmssutz.getName());
        Assertions.assertEquals((Object)"1994-11-05T13:15:30Z", (Object)yyyymmddthhmmssutz.getValue());
        Assertions.assertEquals((Object)"/YYYY-MM-DDThh:mm:ssUTZ", (Object)yyyymmddthhmmssutz.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)yyyymmddthhmmssutz.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)yyyymmddthhmmssutz.getStatus());
    }

    @Test
    public void inspectJsonDocumentNoRoot() throws Exception {
        String instance = "{ \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{ \"brand\" : \"Mercedes\", \"doors\" : 5 }");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)2, (int)document.getFields().getField().size());
        JsonField field1 = (JsonField)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)field1);
        Assertions.assertEquals((Object)"brand", (Object)field1.getName());
        Assertions.assertEquals((Object)"Mercedes", (Object)field1.getValue());
        Assertions.assertEquals((Object)"/brand", (Object)field1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)field1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field1.getStatus());
        JsonField field2 = (JsonField)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)field2);
        Assertions.assertEquals((Object)"doors", (Object)field2.getName());
        Assertions.assertEquals((Object)5, (Object)field2.getValue());
        Assertions.assertEquals((Object)"/doors", (Object)field2.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field2.getStatus());
    }

    @Test
    public void inspectJsonDocumentWithRoot() throws Exception {
        String instance = "{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType car = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)car);
        Assertions.assertEquals((Object)"car", (Object)car.getName());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)car.getFieldType());
        Assertions.assertEquals((Object)"/car", (Object)car.getPath());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)car.getStatus());
        Assertions.assertEquals((int)2, (int)car.getJsonFields().getJsonField().size());
        JsonField field1 = (JsonField)car.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)field1);
        Assertions.assertEquals((Object)"brand", (Object)field1.getName());
        Assertions.assertEquals((Object)"Mercedes", (Object)field1.getValue());
        Assertions.assertEquals((Object)"/car/brand", (Object)field1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)field1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field1.getStatus());
        JsonField field2 = (JsonField)car.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)field2);
        Assertions.assertEquals((Object)"doors", (Object)field2.getName());
        Assertions.assertEquals((Object)5, (Object)field2.getValue());
        Assertions.assertEquals((Object)"/car/doors", (Object)field2.getPath());
        Assertions.assertEquals((Object)FieldType.INTEGER, (Object)field2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field2.getStatus());
    }

    @Test
    public void inspectJsonDocumentNestedObjectArray() throws Exception {
        String instance = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        Assertions.assertNotNull((Object)document.getFields().getField());
        JsonComplexType jsonComplexType = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)jsonComplexType);
        Assertions.assertNotNull((Object)jsonComplexType.getJsonFields().getJsonField());
        Assertions.assertEquals((int)3, (int)jsonComplexType.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"menu", (Object)jsonComplexType.getName());
        JsonField jsonField1 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)jsonField1);
        Assertions.assertEquals((Object)"id", (Object)jsonField1.getName());
        Assertions.assertEquals((Object)"file", (Object)jsonField1.getValue());
        Assertions.assertEquals((Object)"/menu/id", (Object)jsonField1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)jsonField1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField1.getStatus());
        JsonField jsonField2 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)jsonField2);
        Assertions.assertEquals((Object)"value", (Object)jsonField2.getName());
        Assertions.assertEquals((Object)"Filed", (Object)jsonField2.getValue());
        Assertions.assertEquals((Object)"/menu/value", (Object)jsonField2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)jsonField2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField2.getStatus());
        JsonComplexType popup = (JsonComplexType)jsonComplexType.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)popup);
        Assertions.assertNotNull((Object)popup.getJsonFields().getJsonField());
        Assertions.assertEquals((int)1, (int)popup.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"popup", (Object)popup.getName());
        Assertions.assertEquals((Object)"/menu/popup", (Object)popup.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)popup.getFieldType());
        JsonComplexType menuitem = (JsonComplexType)popup.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)menuitem);
        Assertions.assertNotNull((Object)menuitem.getJsonFields().getJsonField());
        Assertions.assertEquals((Object)"menuitem", (Object)menuitem.getName());
        Assertions.assertEquals((Object)"/menu/popup/menuitem<>", (Object)menuitem.getPath());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)menuitem.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)menuitem.getFieldType());
        Assertions.assertEquals((int)2, (int)menuitem.getJsonFields().getJsonField().size());
        JsonField menuitemValue = (JsonField)menuitem.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)menuitemValue);
        Assertions.assertEquals((Object)"value", (Object)menuitemValue.getName());
        Assertions.assertEquals((Object)"/menu/popup/menuitem<>/value", (Object)menuitemValue.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)menuitemValue.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)menuitemValue.getStatus());
        JsonField menuitemOnclick = (JsonField)menuitem.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)menuitemOnclick);
        Assertions.assertEquals((Object)"onclick", (Object)menuitemOnclick.getName());
        Assertions.assertEquals((Object)"/menu/popup/menuitem<>/onclick", (Object)menuitemOnclick.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)menuitemOnclick.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)menuitemOnclick.getStatus());
    }

    @Test
    public void inspectJsonDocumentHighlyNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)6, (int)document.getFields().getField().size());
        JsonField id = (JsonField)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)id);
        Assertions.assertEquals((Object)"id", (Object)id.getName());
        Assertions.assertEquals((Object)"0001", (Object)id.getValue());
        Assertions.assertEquals((Object)"/id", (Object)id.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)id.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)id.getStatus());
        JsonField value = (JsonField)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)value);
        Assertions.assertEquals((Object)"type", (Object)value.getName());
        Assertions.assertEquals((Object)"donut", (Object)value.getValue());
        Assertions.assertEquals((Object)"/type", (Object)value.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)value.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)value.getStatus());
        JsonField name = (JsonField)document.getFields().getField().get(2);
        Assertions.assertNotNull((Object)name);
        Assertions.assertEquals((Object)"name", (Object)name.getName());
        Assertions.assertEquals((Object)"Cake", (Object)name.getValue());
        Assertions.assertEquals((Object)"/name", (Object)name.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)name.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)name.getStatus());
        JsonField itemPPU = (JsonField)document.getFields().getField().get(3);
        Assertions.assertNotNull((Object)itemPPU);
        Assertions.assertEquals((Object)"ppu", (Object)itemPPU.getName());
        Assertions.assertEquals((Object)"/ppu", (Object)itemPPU.getPath());
        Assertions.assertEquals((Object)0.55, (Object)itemPPU.getValue());
        Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)itemPPU.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)itemPPU.getStatus());
        JsonComplexType batters = (JsonComplexType)document.getFields().getField().get(4);
        Assertions.assertNotNull((Object)batters);
        Assertions.assertEquals((int)1, (int)batters.getJsonFields().getJsonField().size());
        JsonComplexType batterParent = (JsonComplexType)batters.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)batterParent);
        Assertions.assertEquals((Object)"batter", (Object)batterParent.getName());
        Assertions.assertEquals((Object)"/batters/batter<>", (Object)batterParent.getPath());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)batterParent.getCollectionType());
        Assertions.assertEquals((int)2, (int)batterParent.getJsonFields().getJsonField().size());
        JsonField batterId = (JsonField)batterParent.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)batterId);
        Assertions.assertEquals((Object)"id", (Object)batterId.getName());
        Assertions.assertEquals((Object)"/batters/batter<>/id", (Object)batterId.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterId.getStatus());
        JsonField batterType = (JsonField)batterParent.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)batterType);
        Assertions.assertEquals((Object)"type", (Object)batterType.getName());
        Assertions.assertEquals((Object)"/batters/batter<>/type", (Object)batterType.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterType.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterType.getStatus());
        JsonComplexType topping = (JsonComplexType)document.getFields().getField().get(5);
        Assertions.assertNotNull((Object)topping);
        Assertions.assertEquals((Object)"topping", (Object)topping.getName());
        Assertions.assertEquals((Object)"/topping<>", (Object)topping.getPath());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)topping.getCollectionType());
        Assertions.assertEquals((int)2, (int)topping.getJsonFields().getJsonField().size());
        JsonField toppingId = (JsonField)topping.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)toppingId);
        Assertions.assertEquals((Object)"id", (Object)toppingId.getName());
        Assertions.assertEquals((Object)"/topping<>/id", (Object)toppingId.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingId.getStatus());
        JsonField toppingType = (JsonField)topping.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)toppingType);
        Assertions.assertEquals((Object)"type", (Object)toppingType.getName());
        Assertions.assertEquals((Object)"/topping<>/type", (Object)toppingType.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingType.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingType.getStatus());
    }

    @Test
    public void inspectJsonDocumentHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-complex-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType items = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)items);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)items.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)items.getStatus());
        Assertions.assertEquals((Object)"items", (Object)items.getName());
        Assertions.assertEquals((int)1, (int)items.getJsonFields().getJsonField().size());
        JsonComplexType item = (JsonComplexType)items.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)item);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)item.getFieldType());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)item.getCollectionType());
        Assertions.assertEquals((Object)"item", (Object)item.getName());
        Assertions.assertEquals((Object)"/items/item<>", (Object)item.getPath());
        Assertions.assertEquals((int)6, (int)item.getJsonFields().getJsonField().size());
        JsonField itemId = (JsonField)item.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)itemId);
        Assertions.assertEquals((Object)"id", (Object)itemId.getName());
        Assertions.assertEquals((Object)"0001", (Object)itemId.getValue());
        Assertions.assertEquals((Object)"/items/item<>/id", (Object)itemId.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)itemId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)itemId.getStatus());
        JsonField itemValue = (JsonField)item.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)itemValue);
        Assertions.assertEquals((Object)"type", (Object)itemValue.getName());
        Assertions.assertEquals((Object)"donut", (Object)itemValue.getValue());
        Assertions.assertEquals((Object)"/items/item<>/type", (Object)itemValue.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)itemValue.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)itemValue.getStatus());
        JsonField itemName = (JsonField)item.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)itemName);
        Assertions.assertEquals((Object)"name", (Object)itemName.getName());
        Assertions.assertEquals((Object)"Cake", (Object)itemName.getValue());
        Assertions.assertEquals((Object)"/items/item<>/name", (Object)itemName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)itemName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)itemName.getStatus());
        JsonField itemPPU = (JsonField)item.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)itemPPU);
        Assertions.assertEquals((Object)"ppu", (Object)itemPPU.getName());
        Assertions.assertEquals((Object)"/items/item<>/ppu", (Object)itemPPU.getPath());
        Assertions.assertEquals((Object)0.55, (Object)itemPPU.getValue());
        Assertions.assertEquals((Object)FieldType.DOUBLE, (Object)itemPPU.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)itemPPU.getStatus());
        JsonComplexType itemBattersComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)itemBattersComplexType);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)itemBattersComplexType.getFieldType());
        Assertions.assertEquals((Object)"batters", (Object)itemBattersComplexType.getName());
        Assertions.assertEquals((int)1, (int)itemBattersComplexType.getJsonFields().getJsonField().size());
        JsonComplexType itemBatterComplexType = (JsonComplexType)itemBattersComplexType.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)itemBatterComplexType);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)itemBatterComplexType.getFieldType());
        Assertions.assertEquals((Object)"batter", (Object)itemBatterComplexType.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)itemBatterComplexType.getCollectionType());
        Assertions.assertEquals((Object)"/items/item<>/batters/batter<>", (Object)itemBatterComplexType.getPath());
        Assertions.assertEquals((int)2, (int)itemBatterComplexType.getJsonFields().getJsonField().size());
        JsonField batterId = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)batterId);
        Assertions.assertEquals((Object)"id", (Object)batterId.getName());
        Assertions.assertEquals((Object)"1001", (Object)batterId.getValue());
        Assertions.assertEquals((Object)"/items/item<>/batters/batter<>/id", (Object)batterId.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterId.getStatus());
        JsonField batterType = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)batterType);
        Assertions.assertEquals((Object)"type", (Object)batterType.getName());
        Assertions.assertEquals((Object)"Regular", (Object)batterType.getValue());
        Assertions.assertEquals((Object)"/items/item<>/batters/batter<>/type", (Object)batterType.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)batterType.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterType.getStatus());
        JsonComplexType itemToppingComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(5);
        Assertions.assertNotNull((Object)itemToppingComplexType);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)itemToppingComplexType.getFieldType());
        Assertions.assertEquals((Object)"topping", (Object)itemToppingComplexType.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)itemToppingComplexType.getCollectionType());
        Assertions.assertEquals((Object)"/items/item<>/topping<>", (Object)itemToppingComplexType.getPath());
        Assertions.assertEquals((int)2, (int)itemToppingComplexType.getJsonFields().getJsonField().size());
        JsonField toppingID = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)toppingID);
        Assertions.assertEquals((Object)"id", (Object)toppingID.getName());
        Assertions.assertEquals((Object)"/items/item<>/topping<>/id", (Object)toppingID.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingID.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingID.getStatus());
        JsonField toppingType = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)toppingType);
        Assertions.assertEquals((Object)"type", (Object)toppingType.getName());
        Assertions.assertEquals((Object)"/items/item<>/topping<>/type", (Object)toppingType.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)toppingType.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingType.getStatus());
    }

    @Test
    public void testAddress() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/address.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)address.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)address.getCollectionType());
        Assertions.assertEquals((Object)"address", (Object)address.getName());
        Assertions.assertEquals((Object)"/address<>", (Object)address.getPath());
        Assertions.assertEquals((int)6, (int)address.getJsonFields().getJsonField().size());
        JsonField use = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)use);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)use.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)use.getStatus());
        Assertions.assertEquals(null, (Object)use.getCollectionType());
        Assertions.assertEquals((Object)"use", (Object)use.getName());
        Assertions.assertEquals((Object)"/address<>/use", (Object)use.getPath());
        JsonField type = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)type);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)type.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)type.getStatus());
        Assertions.assertEquals(null, (Object)type.getCollectionType());
        Assertions.assertEquals((Object)"type", (Object)type.getName());
        Assertions.assertEquals((Object)"/address<>/type", (Object)type.getPath());
        JsonField line = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)line);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)line.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)line.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)line.getCollectionType());
        Assertions.assertEquals((Object)"line", (Object)line.getName());
        Assertions.assertEquals((Object)"/address<>/line<>", (Object)line.getPath());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        Assertions.assertEquals(null, (Object)city.getCollectionType());
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"/address<>/city", (Object)city.getPath());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        Assertions.assertEquals(null, (Object)postalCode.getCollectionType());
        Assertions.assertEquals((Object)"postalCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"/address<>/postalCode", (Object)postalCode.getPath());
        JsonField country = (JsonField)address.getJsonFields().getJsonField().get(5);
        Assertions.assertNotNull((Object)country);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)country.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)country.getStatus());
        Assertions.assertEquals(null, (Object)country.getCollectionType());
        Assertions.assertEquals((Object)"country", (Object)country.getName());
        Assertions.assertEquals((Object)"/address<>/country", (Object)country.getPath());
    }

    private void printDocument(JsonDocument document) {
        Assertions.assertNotNull((Object)document.getFields());
        this.printFields(document.getFields());
    }

    private void printFields(Fields fields) {
        Assertions.assertNotNull((Object)fields.getField());
        for (Field field : fields.getField()) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField((JsonField)field);
        }
    }

    private void printFields(List<JsonField> jsonField) {
        for (JsonField field : jsonField) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField(field);
        }
    }

    private void printJsonComplexType(JsonComplexType field) {
        Assertions.assertNotNull((Object)field.getJsonFields());
        this.printJsonField((JsonField)field);
        this.printFields(field.getJsonFields().getJsonField());
    }

    private void printJsonField(JsonField jsonField) {
        System.out.println("Name --> " + jsonField.getName());
        System.out.println("Path --> " + jsonField.getPath());
        System.out.println("Value --> " + jsonField.getValue());
        if (jsonField.getFieldType() != null) {
            System.out.println("Type --> " + jsonField.getFieldType().name());
        }
        if (jsonField.getTypeName() != null) {
            System.out.println("Type Name --> " + jsonField.getTypeName());
        }
        if (jsonField.getCollectionType() != null) {
            System.out.println("Collection Type --> " + jsonField.getCollectionType().name());
        }
        if (jsonField.getStatus() != null) {
            System.out.println("Status  --> " + jsonField.getStatus().name());
        }
        System.out.println();
    }
}

