/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.json.core.JsonFieldReader;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class JsonFieldReaderTest {
    private static JsonFieldReader reader = new JsonFieldReader((AtlasConversionService)DefaultAtlasConversionService.getInstance());

    @Test
    public void testWithNullDocument() throws Exception {
        reader.setDocument(null);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)AtlasJsonModelFactory.createJsonField());
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        reader.read(session);
        Assertions.assertEquals((int)1, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)audits.getAudit().get(0)).getStatus());
    }

    @Test
    public void testWithEmptyDocument() throws Exception {
        reader.setDocument("");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)AtlasJsonModelFactory.createJsonField());
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        reader.read(session);
        Assertions.assertEquals((int)1, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)audits.getAudit().get(0)).getStatus());
    }

    @Test
    public void testWithNullJsonField() throws Exception {
        Assertions.assertThrows(AtlasException.class, () -> {
            reader.setDocument("{qwerty : ytrewq}");
            reader.read((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class));
        });
    }

    @Test
    public void testSimpleJsonDocument() throws Exception {
        String document = "   { \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        reader.setDocument("   { \"brand\" : \"Mercedes\", \"doors\" : 5 }");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/brand");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Mercedes", (Object)field.getValue());
        field.setFieldType(null);
        field.setPath("/doors");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)5, (Object)field.getValue());
    }

    @Test
    public void testSimpleJsonDocumentWithRoot() throws Exception {
        String document = " {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        reader.setDocument(" {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/car/doors");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)5, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/car/brand");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Mercedes", (Object)field.getValue());
    }

    @Test
    public void testComplexJsonDocumentNestedObjectArray() throws Exception {
        String document = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        reader.setDocument("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/menu/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"file", (Object)field.getValue());
        field.setPath("/menu/value");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Filed", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[0]/value");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"New", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[0]/onclick");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"CreateNewDoc()", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[1]/value");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Open", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[1]/onclick");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"OpenDoc()", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[2]/value");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Close", (Object)field.getValue());
        field.setPath("/menu/popup/menuitem[2]/onclick");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"CloseDoc()", (Object)field.getValue());
    }

    @Test
    public void testComplexJsonDocumentHighlyNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-nested-object.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"donut", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Cake", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.55, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Regular", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Blueberry", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/batters/batter[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Devil's Food", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"None", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Glazed", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5005", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Sugar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5007", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Powdered Sugar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[4]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5006", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[4]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate with Sprinkles", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[5]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[5]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[6]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/topping[6]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Maple", (Object)field.getValue());
        this.resetField(field);
    }

    @Test
    public void testComplexJsonDocumentHighlyComplexNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-complex-nested-object.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/items/item[0]/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        Mockito.when((Object)session.getAudits()).thenReturn((Object)new Audits());
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"donut", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Cake", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.55, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Regular", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Blueberry", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Devil's Food", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"None", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Glazed", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5005", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Sugar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5007", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Powdered Sugar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[4]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5006", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[4]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate with Sprinkles", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[5]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[5]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[6]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[0]/topping[6]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Maple", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"donut", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Raised", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.55, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"1001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Regular", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[0]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5001", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[0]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"None", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[1]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5002", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[1]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Glazed", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5005", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Sugar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Chocolate", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[4]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"5004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[4]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Maple", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[1]/topping[5]/id");
        reader.read(session);
        Assertions.assertNull((Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0003", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"donut", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Old Fashioned", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.55, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[3]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[3]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"bar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[3]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Bar", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[3]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.75, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[4]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0005", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[4]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"twist", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[4]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Twist", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[4]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.65, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"0006", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/type");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"filled", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/name");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"Filled", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/ppu");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)0.75, (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[2]/id");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"7004", (Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[3]/addcost");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)new BigInteger("100000000000000000000000000000000000"), (Object)field.getValue());
        this.resetField(field);
    }

    @Test
    public void testSameFieldNameInDifferentPath() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/same-field-name-in-different-path.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/name");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertEquals((Object)"name", (Object)field.getValue());
        field.setPath("/object1/name");
        reader.read(session);
        Assertions.assertEquals((Object)"object1-name", (Object)field.getValue());
        field.setPath("/object2/name");
        reader.read(session);
        Assertions.assertEquals((Object)"object2-name", (Object)field.getValue());
        field.setPath("/object1/object2/name");
        reader.read(session);
        Assertions.assertEquals((Object)"object1-object2-name", (Object)field.getValue());
    }

    @Test
    public void testArrayUnderRoot() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/array-under-root.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/array[0]");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertEquals((Object)"array-zero", (Object)field.getValue());
        field.setPath("/array[1]");
        reader.read(session);
        Assertions.assertEquals((Object)"array-one", (Object)field.getValue());
        field.setPath("/array[2]");
        reader.read(session);
        Assertions.assertEquals((Object)"array-two", (Object)field.getValue());
    }

    private void resetField(JsonField field) {
        field.setPath(null);
        field.setValue(null);
        field.setFieldType(null);
    }

    private AtlasInternalSession testBoundaryValue(String fileName, String fieldPath, FieldType fieldType, Object expectedObject) throws Exception {
        String filePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jsonFields" + File.separator + fileName;
        String document = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath(fieldPath);
        field.setFieldType(fieldType);
        AtlasInternalSession session = this.read(field);
        Assertions.assertEquals((Object)expectedObject, (Object)field.getValue());
        return session;
    }

    @Test
    public void testJsonFieldDoubleMax() throws Exception {
        this.testBoundaryValue("field-double-max.json", "/doubleValue", FieldType.DOUBLE, Double.MAX_VALUE);
    }

    @Test
    public void testJsonFieldDoubleMin() throws Exception {
        this.testBoundaryValue("field-double-min.json", "/doubleValue", FieldType.DOUBLE, Double.MIN_VALUE);
    }

    @Test
    public void testJsonFieldFloatMax() throws Exception {
        this.testBoundaryValue("field-float-max.json", "/floatValue", FieldType.FLOAT, Float.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testJsonFieldFloatMin() throws Exception {
        this.testBoundaryValue("field-float-min.json", "/floatValue", FieldType.FLOAT, Float.valueOf(Float.MIN_VALUE));
    }

    @Test
    public void testJsonFieldLongMax() throws Exception {
        this.testBoundaryValue("field-long-max.json", "/longValue", FieldType.LONG, Long.MAX_VALUE);
    }

    @Test
    public void testJsonFieldLongMin() throws Exception {
        this.testBoundaryValue("field-long-min.json", "/longValue", FieldType.LONG, Long.MIN_VALUE);
    }

    @Test
    public void testJsonFieldIntegerMax() throws Exception {
        this.testBoundaryValue("field-integer-max.json", "/integerValue", FieldType.INTEGER, Integer.MAX_VALUE);
    }

    @Test
    public void testJsonFieldIntegerMin() throws Exception {
        this.testBoundaryValue("field-integer-min.json", "/integerValue", FieldType.INTEGER, Integer.MIN_VALUE);
    }

    @Test
    public void testJsonFieldShortMax() throws Exception {
        this.testBoundaryValue("field-short-max.json", "/shortValue", FieldType.SHORT, (short)Short.MAX_VALUE);
    }

    @Test
    public void testJsonFieldShortMin() throws Exception {
        this.testBoundaryValue("field-short-min.json", "/shortValue", FieldType.SHORT, (short)Short.MIN_VALUE);
    }

    @Test
    public void testJsonFieldCharMax() throws Exception {
        this.testBoundaryValue("field-char-max.json", "/charValue", FieldType.CHAR, Character.valueOf('\uffff'));
    }

    @Test
    public void testJsonFieldCharMin() throws Exception {
        this.testBoundaryValue("field-char-min.json", "/charValue", FieldType.CHAR, Character.valueOf('\u0000'));
    }

    @Test
    public void testJsonFieldByteMax() throws Exception {
        this.testBoundaryValue("field-byte-max.json", "/byteValue", FieldType.BYTE, (byte)127);
    }

    @Test
    public void testJsonFieldByteMin() throws Exception {
        this.testBoundaryValue("field-byte-min.json", "/byteValue", FieldType.BYTE, (byte)-128);
    }

    @Test
    public void testJsonFieldBooleanTrue() throws Exception {
        this.testBoundaryValue("field-boolean-true.json", "/booleanValue", FieldType.BOOLEAN, Boolean.TRUE);
    }

    @Test
    public void testJsonFieldBooleanFalse() throws Exception {
        this.testBoundaryValue("field-boolean-false.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldStringNonEmpty() throws Exception {
        this.testBoundaryValue("field-string-nonempty.json", "/stringValue", FieldType.STRING, "testString");
    }

    @Test
    public void testJsonFieldStringNull() throws Exception {
        this.testBoundaryValue("field-string-null.json", "/stringValue", FieldType.STRING, null);
    }

    @Test
    public void testJsonFieldStringEmpty() throws Exception {
        this.testBoundaryValue("field-string-empty.json", "/stringValue", FieldType.STRING, "");
    }

    @Test
    public void testJsonFieldStringNonExist() throws Exception {
        this.testBoundaryValue("field-string-nonexist.json", "/stringValue", FieldType.STRING, null);
    }

    private AtlasInternalSession read(JsonField field) throws AtlasException {
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        reader.read(session);
        return session;
    }

    private void testRangeOutValue(String fileName, String fieldPath, FieldType fieldType, String errorMessage, String errorValue) throws Exception {
        String filePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jsonFields" + File.separator + fileName;
        String document = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath(fieldPath);
        field.setFieldType(fieldType);
        AtlasInternalSession session = this.read(field);
        Assertions.assertEquals(null, (Object)field.getValue());
        Assertions.assertEquals((int)1, (int)session.getAudits().getAudit().size());
        Assertions.assertEquals((Object)errorMessage, (Object)((Audit)session.getAudits().getAudit().get(0)).getMessage());
        Assertions.assertEquals((Object)errorValue, (Object)((Audit)session.getAudits().getAudit().get(0)).getValue());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
    }

    @Test
    public void testJsonFieldDoubleMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-double-max-range-out.json", "/doubleValue", FieldType.DOUBLE, "Failed to convert field value 'Infinity' into type 'DOUBLE'", "Infinity");
    }

    @Test
    public void testJsonFieldDoubleMinRangeOut() throws Exception {
        AtlasInternalSession session = this.testBoundaryValue("field-double-min-range-out.json", "/doubleValue", FieldType.DOUBLE, 0.0);
        Assertions.assertEquals((int)0, (int)session.getAudits().getAudit().size());
    }

    @Test
    public void testJsonFieldFloatMaxRangOut() throws Exception {
        this.testRangeOutValue("field-float-max-range-out.json", "/floatValue", FieldType.FLOAT, "Failed to convert field value '3.4028235E39' into type 'FLOAT'", "3.4028235E39");
    }

    @Test
    public void testJsonFieldFloatMinRangOut() throws Exception {
        AtlasInternalSession session = this.testBoundaryValue("field-float-min-range-out.json", "/floatValue", FieldType.FLOAT, Float.valueOf(0.0f));
        Assertions.assertEquals((int)0, (int)session.getAudits().getAudit().size());
    }

    @Test
    public void testJsonFieldLongMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-long-max-range-out.json", "/longValue", FieldType.LONG, "Failed to convert field value '9223372036854775808' into type 'LONG'", "9223372036854775808");
    }

    @Test
    public void testJsonFieldLongMinRangeOut() throws Exception {
        this.testRangeOutValue("field-long-min-range-out.json", "/longValue", FieldType.LONG, "Failed to convert field value '-9223372036854775809' into type 'LONG'", "-9223372036854775809");
    }

    @Test
    public void testJsonFieldIntegerMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-integer-max-range-out.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '2147483648' into type 'INTEGER'", "2147483648");
    }

    @Test
    public void testJsonFieldIntegerMinRangeOut() throws Exception {
        this.testRangeOutValue("field-integer-min-range-out.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '-2147483649' into type 'INTEGER'", "-2147483649");
    }

    @Test
    public void testJsonFieldShortMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-short-max-range-out.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '32768' into type 'SHORT'", "32768");
    }

    @Test
    public void testJsonFieldShortMinRangeOut() throws Exception {
        this.testRangeOutValue("field-short-min-range-out.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '-32769' into type 'SHORT'", "-32769");
    }

    @Test
    public void testJsonFieldCharMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-char-max-range-out.json", "/charValue", FieldType.CHAR, "Failed to convert field value '65536' into type 'CHAR'", "65536");
    }

    @Test
    public void testJsonFieldCharMinRangeOut() throws Exception {
        this.testRangeOutValue("field-char-min-range-out.json", "/charValue", FieldType.CHAR, "Failed to convert field value '-1' into type 'CHAR'", "-1");
    }

    @Test
    public void testJsonFieldByteMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-byte-max-range-out.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '128' into type 'BYTE'", "128");
    }

    @Test
    public void testJsonFieldByteMinRangeOut() throws Exception {
        this.testRangeOutValue("field-byte-min-range-out.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '-129' into type 'BYTE'", "-129");
    }

    @Test
    public void testJsonFieldBooleanRangeOut() throws Exception {
        this.testBoundaryValue("field-boolean-range-out.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithLetterF() throws Exception {
        this.testBoundaryValue("field-boolean-with-letterF.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithBlankString() throws Exception {
        this.testBoundaryValue("field-boolean-with-blank-string.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithNull() throws Exception {
        this.testBoundaryValue("field-boolean-with-null.json", "/booleanValue", FieldType.BOOLEAN, null);
    }

    @Test
    public void testJsonFieldBooleanWithNumber0() throws Exception {
        this.testBoundaryValue("field-boolean-with-number0.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithNumber1() throws Exception {
        this.testBoundaryValue("field-boolean-with-number1.json", "/booleanValue", FieldType.BOOLEAN, Boolean.TRUE);
    }

    @Test
    public void testJsonFieldLongDecimal() throws Exception {
        this.testRangeOutValue("field-long-decimal.json", "/longValue", FieldType.LONG, "Failed to convert field value '9.223372036854776E18' into type 'LONG'", "9.223372036854776E18");
    }

    @Test
    public void testJsonFieldIntegerDecimal() throws Exception {
        this.testRangeOutValue("field-integer-decimal.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '2.1474836471234E9' into type 'INTEGER'", "2.1474836471234E9");
    }

    @Test
    public void testJsonFieldShortDecimal() throws Exception {
        this.testRangeOutValue("field-short-decimal.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '32767.1234' into type 'SHORT'", "32767.1234");
    }

    @Test
    public void testJsonFieldCharDecimal() throws Exception {
        this.testRangeOutValue("field-char-decimal.json", "/charValue", FieldType.CHAR, "Failed to convert field value '65535.1234' into type 'CHAR'", "65535.1234");
    }

    @Test
    public void testJsonFieldByteDecimal() throws Exception {
        this.testRangeOutValue("field-byte-decimal.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '127.1234' into type 'BYTE'", "127.1234");
    }

    @Test
    public void testJsonFieldDoubleString() throws Exception {
        this.testRangeOutValue("field-double-string.json", "/doubleValue", FieldType.DOUBLE, "Failed to convert field value 'abcd' into type 'DOUBLE'", "abcd");
    }

    @Test
    public void testJsonFieldFloatString() throws Exception {
        this.testRangeOutValue("field-float-string.json", "/floatValue", FieldType.FLOAT, "Failed to convert field value 'abcd' into type 'FLOAT'", "abcd");
    }

    @Test
    public void testJsonFieldLongString() throws Exception {
        this.testRangeOutValue("field-long-string.json", "/longValue", FieldType.LONG, "Failed to convert field value 'abcd' into type 'LONG'", "abcd");
    }

    @Test
    public void testJsonFieldIntegerString() throws Exception {
        this.testRangeOutValue("field-integer-string.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value 'abcd' into type 'INTEGER'", "abcd");
    }

    @Test
    public void testJsonFieldShortString() throws Exception {
        this.testRangeOutValue("field-short-string.json", "/shortValue", FieldType.SHORT, "Failed to convert field value 'abcd' into type 'SHORT'", "abcd");
    }

    @Test
    public void testJsonFieldCharString() throws Exception {
        this.testRangeOutValue("field-char-string.json", "/charValue", FieldType.CHAR, "Failed to convert field value 'abcd' into type 'CHAR'", "abcd");
    }

    @Test
    public void testJsonFieldByteString() throws Exception {
        this.testRangeOutValue("field-byte-string.json", "/byteValue", FieldType.BYTE, "Failed to convert field value 'abcd' into type 'BYTE'", "abcd");
    }

    @Test
    public void testJsonFieldTopmostArraySimple() throws Exception {
        String document = "[ 100, 500, 300, 200, 400 ]";
        reader.setDocument("[ 100, 500, 300, 200, 400 ]");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<1>");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)500, (Object)field.getValue());
        field.setFieldType(null);
        field.setPath("/<>");
        Field readField = reader.read(session);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readFieldGroup = (FieldGroup)readField;
        Assertions.assertEquals((int)5, (int)readFieldGroup.getField().size());
        Assertions.assertEquals((Object)100, (Object)((Field)readFieldGroup.getField().get(0)).getValue());
        Assertions.assertEquals((Object)500, (Object)((Field)readFieldGroup.getField().get(1)).getValue());
        Assertions.assertEquals((Object)300, (Object)((Field)readFieldGroup.getField().get(2)).getValue());
        Assertions.assertEquals((Object)200, (Object)((Field)readFieldGroup.getField().get(3)).getValue());
        Assertions.assertEquals((Object)400, (Object)((Field)readFieldGroup.getField().get(4)).getValue());
    }

    @Test
    public void testJsonFieldTopmostArrayObject() throws Exception {
        String document = "[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]";
        reader.setDocument("[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<0>/color");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"red", (Object)field.getValue());
        field.setPath("/<1>/value");
        reader.read(session);
        Assertions.assertNotNull((Object)field.getValue());
        Assertions.assertEquals((Object)"#0f0", (Object)field.getValue());
        field.setFieldType(null);
        field.setPath("/<>/color");
        Field readField = reader.read(session);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readFieldGroup = (FieldGroup)readField;
        Assertions.assertEquals((int)3, (int)readFieldGroup.getField().size());
        Assertions.assertEquals((Object)"red", (Object)((Field)readFieldGroup.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"green", (Object)((Field)readFieldGroup.getField().get(1)).getValue());
        Assertions.assertEquals((Object)"blue", (Object)((Field)readFieldGroup.getField().get(2)).getValue());
    }

    @Test
    public void testReadParentCollection() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("complex-repeated-result.json").toURI())));
        reader.setDocument(document);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("json");
        address.setPath("/orders[]/address");
        JsonField addressLine1 = AtlasJsonModelFactory.createJsonField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("json");
        addressLine1.setPath("/orders[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)5, (int)readGroup.getField().size());
        for (int i = 0; i < 5; ++i) {
            FieldGroup readAddress = (FieldGroup)readGroup.getField().get(i);
            Assertions.assertEquals((Object)("/orders[" + i + "]/address"), (Object)readAddress.getPath());
            Assertions.assertEquals((int)1, (int)readAddress.getField().size());
            Field readAddressLine = (Field)readAddress.getField().get(0);
            Assertions.assertEquals((Object)("/orders[" + i + "]/address/addressLine1"), (Object)readAddressLine.getPath());
            Assertions.assertEquals((Object)("123 Main St (" + (i + 1) + ")"), (Object)readAddressLine.getValue());
        }
    }

    @Test
    public void testReadParentCollectionEmpty() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("complex-repeated-result-empty.json").toURI())));
        reader.setDocument(document);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("json");
        address.setPath("/orders[]/address");
        JsonField addressLine1 = AtlasJsonModelFactory.createJsonField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("json");
        addressLine1.setPath("/orders[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)0, (int)readGroup.getField().size());
    }

    @Test
    public void testReadParentCollectionEmptyItem() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get(this.getClass().getClassLoader().getResource("complex-repeated-result-empty-item.json").toURI())));
        reader.setDocument(document);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("json");
        address.setPath("/orders[]/address");
        JsonField addressLine1 = AtlasJsonModelFactory.createJsonField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("json");
        addressLine1.setPath("/orders[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)2, (int)readGroup.getField().size());
        FieldGroup readAddress = (FieldGroup)readGroup.getField().get(0);
        Assertions.assertEquals((Object)"/orders[0]/address", (Object)readAddress.getPath());
        Assertions.assertEquals((int)1, (int)readAddress.getField().size());
        Field readAddressLine = (Field)readAddress.getField().get(0);
        Assertions.assertEquals((Object)"/orders[0]/address/addressLine1", (Object)readAddressLine.getPath());
        Assertions.assertEquals((Object)"123 Main St (1)", (Object)readAddressLine.getValue());
        readAddress = (FieldGroup)readGroup.getField().get(1);
        Assertions.assertEquals((Object)"/orders[2]/address", (Object)readAddress.getPath());
        Assertions.assertEquals((int)1, (int)readAddress.getField().size());
        readAddressLine = (Field)readAddress.getField().get(0);
        Assertions.assertEquals((Object)"/orders[2]/address/addressLine1", (Object)readAddressLine.getPath());
        Assertions.assertEquals((Object)"123 Main St (3)", (Object)readAddressLine.getValue());
    }
}

