/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldReader
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFieldReader.class);
    private AtlasConversionService conversionService;
    private JsonNode rootNode;

    private JsonFieldReader() {
    }

    public JsonFieldReader(AtlasConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Field read(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (this.rootNode == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)field.getDocId(), (String)String.format("Cannot read a field '%s' of JSON document '%s', document is null", field.getPath(), field.getDocId()), (String)field.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return field;
        }
        AtlasPath path = new AtlasPath(field.getPath());
        List<JsonField> fields = this.getJsonFieldsForPath(session, this.rootNode, field, path, 0);
        if (path.hasCollection() && !path.isIndexedCollection()) {
            FieldGroup fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field);
            fieldGroup.getField().addAll(fields);
            session.head().setSourceField((Field)fieldGroup);
            return fieldGroup;
        }
        if (fields.size() == 1) {
            field.setValue(fields.get(0).getValue());
            return field;
        }
        return field;
    }

    private List<JsonField> getJsonFieldsForPath(AtlasInternalSession session, JsonNode node, Field field, AtlasPath path, int depth) throws AtlasException {
        ArrayList<JsonField> fields = new ArrayList<JsonField>();
        List segments = path.getSegments(true);
        if (node.isValueNode() && segments.size() == depth) {
            JsonField jsonField = new JsonField();
            AtlasModelFactory.copyField((Field)field, (Field)jsonField, (boolean)true);
            Object value = this.handleValueNode(session, node, jsonField);
            jsonField.setValue(value);
            fields.add(jsonField);
        } else if (segments.size() > depth) {
            AtlasPath.SegmentContext segmentContext;
            JsonNode child;
            if (depth == 0 && path.hasCollectionRoot().booleanValue()) {
                child = node;
                segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
            } else {
                if (depth == 0) {
                    if (node.size() == 1 && !((AtlasPath.SegmentContext)path.getSegments(false).get(0)).getExpression().startsWith((String)this.rootNode.fieldNames().next())) {
                        node = (JsonNode)node.elements().next();
                    }
                    if (segments.size() > 1) {
                        depth = 1;
                    }
                }
                segmentContext = (AtlasPath.SegmentContext)segments.get(depth);
                String fieldName = segmentContext.getName();
                child = node.get(fieldName);
            }
            if (child != null) {
                if (child.isArray()) {
                    if (segmentContext.getCollectionIndex() != null) {
                        if (child.size() <= segmentContext.getCollectionIndex()) {
                            return fields;
                        }
                        List<JsonField> arrayFields = this.getJsonFieldsForPath(session, child.get(segmentContext.getCollectionIndex().intValue()), field, path, depth + 1);
                        fields.addAll(arrayFields);
                    } else {
                        int arrayIndex = 0;
                        for (JsonNode arrayItem : child) {
                            List<JsonField> arrayFields = this.getJsonFieldsForPath(session, arrayItem, field, path, depth + 1);
                            for (JsonField arrayField : arrayFields) {
                                AtlasPath subPath = new AtlasPath(arrayField.getPath());
                                subPath.setCollectionIndex(depth, Integer.valueOf(arrayIndex));
                                arrayField.setPath(subPath.toString());
                            }
                            fields.addAll(arrayFields);
                            ++arrayIndex;
                        }
                    }
                } else {
                    List<JsonField> childFields = this.getJsonFieldsForPath(session, child, field, path, depth + 1);
                    fields.addAll(childFields);
                }
            }
        }
        return fields;
    }

    private Object handleValueNode(AtlasInternalSession session, JsonNode valueNode, JsonField jsonField) throws AtlasException {
        if (valueNode.isNull()) {
            return null;
        }
        if (valueNode.isObject()) {
            jsonField.setFieldType(FieldType.COMPLEX);
            return null;
        }
        if (valueNode.isArray()) {
            AtlasUtil.addAudit((AtlasSession)session, (String)jsonField.getDocId(), (String)String.format("Unexpected array node is detected: '%s'", valueNode.asText()), (String)jsonField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)valueNode.asText());
            return null;
        }
        if (jsonField.getFieldType() != null) {
            try {
                return this.conversionService.convertType((Object)valueNode.asText(), jsonField.getFormat(), jsonField.getFieldType(), null);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)jsonField.getDocId(), (String)String.format("Failed to convert field value '%s' into type '%s'", valueNode.asText(), jsonField.getFieldType()), (String)jsonField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)valueNode.asText());
                return null;
            }
        }
        if (valueNode.isTextual()) {
            return this.handleTextualNode(valueNode, jsonField);
        }
        if (valueNode.isNumber()) {
            return this.handleNumberNode(valueNode, jsonField);
        }
        if (valueNode.isBoolean()) {
            return this.handleBooleanNode(valueNode, jsonField);
        }
        if (valueNode.isContainerNode()) {
            return this.handleContainerNode(valueNode, jsonField);
        }
        if (valueNode.isNull()) {
            return null;
        }
        LOG.warn(String.format("Detected unsupported json type for field p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
        jsonField.setFieldType(FieldType.UNSUPPORTED);
        return valueNode.toString();
    }

    private Object handleTextualNode(JsonNode valueNode, JsonField jsonField) {
        if (jsonField.getFieldType() == null || FieldType.STRING.equals((Object)jsonField.getFieldType())) {
            jsonField.setFieldType(FieldType.STRING);
            return valueNode.textValue();
        }
        if (FieldType.CHAR.equals((Object)jsonField.getFieldType())) {
            return Character.valueOf(valueNode.textValue().charAt(0));
        }
        LOG.warn(String.format("Unsupported FieldType for text data t=%s p=%s docId=%s", jsonField.getFieldType().value(), jsonField.getPath(), jsonField.getDocId()));
        return valueNode.textValue();
    }

    private Object handleNumberNode(JsonNode valueNode, JsonField jsonField) {
        if (valueNode.isInt()) {
            jsonField.setFieldType(FieldType.INTEGER);
            return valueNode.intValue();
        }
        if (valueNode.isDouble()) {
            jsonField.setFieldType(FieldType.DOUBLE);
            return valueNode.doubleValue();
        }
        if (valueNode.isBigDecimal()) {
            jsonField.setFieldType(FieldType.DECIMAL);
            return valueNode.decimalValue();
        }
        if (valueNode.isFloat()) {
            jsonField.setFieldType(FieldType.DOUBLE);
            return Float.valueOf(valueNode.floatValue());
        }
        if (valueNode.isLong()) {
            jsonField.setFieldType(FieldType.LONG);
            return valueNode.longValue();
        }
        if (valueNode.isShort()) {
            jsonField.setFieldType(FieldType.SHORT);
            return valueNode.shortValue();
        }
        if (valueNode.isBigInteger()) {
            jsonField.setFieldType(FieldType.BIG_INTEGER);
            return valueNode.bigIntegerValue();
        }
        jsonField.setFieldType(FieldType.NUMBER);
        return valueNode.numberValue();
    }

    private Object handleBooleanNode(JsonNode valueNode, JsonField jsonField) {
        jsonField.setFieldType(FieldType.BOOLEAN);
        return valueNode.booleanValue();
    }

    private Object handleContainerNode(JsonNode valueNode, JsonField jsonField) throws AtlasException {
        if (valueNode.isArray()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Detected json array p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setFieldType(FieldType.COMPLEX);
            jsonField.setCollectionType(CollectionType.ARRAY);
            return valueNode.toString();
        }
        if (valueNode.isObject()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Detected json complex object p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
            }
            jsonField.setFieldType(FieldType.COMPLEX);
            return valueNode.toString();
        }
        throw new AtlasException("Unknown error: detected a container JSON node which is not ARRAY nor OBJECT");
    }

    public void setDocument(String document) throws AtlasException {
        if (document == null || document.isEmpty()) {
            this.rootNode = null;
            return;
        }
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            JsonParser parser = factory.createParser(document);
            this.rootNode = (JsonNode)mapper.readTree(parser);
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }
}

