/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class JsonInstanceInspectorTest {
    private final JsonInspectionService inspectionService = new JsonInspectionService();

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentEmpty() throws Exception {
        String instance = "";
        this.inspectionService.inspectJsonDocument("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentWhitespaceOnly() throws Exception {
        String instance = " ";
        this.inspectionService.inspectJsonDocument(" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonDocumentNull() throws Exception {
        String instance = null;
        this.inspectionService.inspectJsonDocument(instance);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/unparseable-highly-complex-nested-object.json", new String[0])));
        this.inspectionService.inspectJsonDocument(instance);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingOpenCurly() throws Exception {
        String instance = "\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}";
        this.inspectionService.inspectJsonDocument("\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]}");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingClosingCurly() throws Exception {
        String instance = "{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        this.inspectionService.inspectJsonDocument("{\"ads\":[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingKeySeperator() throws Exception {
        String instance = "{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]";
        this.inspectionService.inspectJsonDocument("{\"ads\"[{\"id_ad\":\"20439\"}, {\"id_ad\":\"20449\"}]");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonDocumentUnparseableMissingValueSeperator() throws Exception {
        String instance = "{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}";
        this.inspectionService.inspectJsonDocument("{\"id_ad\":\"20439\" \"id_ad\":\"20449\"}");
    }

    @Test
    public void inspectJsonDocumentEmptyDocument() throws Exception {
        String instance = "{}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{}");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void inspectJsonDocumentSimpleArray() throws Exception {
        String instance = "[ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[ 100, 500, 300, 200, 400 ]");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assert.assertEquals((Object)"", (Object)jsonField.getName());
        Assert.assertEquals((Object)"/<>", (Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleArrayStartsWithWhiteSpace() throws Exception {
        String instance = "\n\t\r [ 100, 500, 300, 200, 400 ]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("\n\t\r [ 100, 500, 300, 200, 400 ]");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assert.assertEquals((Object)"", (Object)jsonField.getName());
        Assert.assertEquals((Object)"/<>", (Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonDocumentSimpleObjectArray() throws Exception {
        String instance = "[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]";
        JsonDocument document = this.inspectionService.inspectJsonDocument("[\n\t{\n\t\t\"color\": \"red\",\n\t\t\"value\": \"#f00\"\n\t},\n\t{\n\t\t\"color\": \"green\",\n\t\t\"value\": \"#0f0\"\n\t},\n\t{\n\t\t\"color\": \"blue\",\n\t\t\"value\": \"#00f\"\n\t}]");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)jsonField.getFieldType());
        Assert.assertEquals((Object)"", (Object)jsonField.getName());
        Assert.assertEquals((Object)"/<>", (Object)jsonField.getPath());
        JsonComplexType complexType = (JsonComplexType)jsonField;
        Assert.assertEquals((long)2L, (long)complexType.getJsonFields().getJsonField().size());
        JsonField color = (JsonField)complexType.getJsonFields().getJsonField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)color.getStatus());
        Assert.assertEquals(null, (Object)color.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)color.getFieldType());
        Assert.assertEquals((Object)"color", (Object)color.getName());
        Assert.assertEquals((Object)"/<>/color", (Object)color.getPath());
        JsonField value = (JsonField)complexType.getJsonFields().getJsonField().get(1);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)value.getStatus());
        Assert.assertEquals(null, (Object)value.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)value.getFieldType());
        Assert.assertEquals((Object)"value", (Object)value.getName());
        Assert.assertEquals((Object)"/<>/value", (Object)value.getPath());
    }

    @Test
    public void inspectJsonDocumentArrayHighlyNestedObjects() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/array-highly-nested-objects.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)jsonField.getFieldType());
        JsonComplexType complex = (JsonComplexType)jsonField;
        Assert.assertEquals((long)6L, (long)complex.getJsonFields().getJsonField().size());
        JsonField id = (JsonField)complex.getJsonFields().getJsonField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)id.getStatus());
        Assert.assertEquals(null, (Object)id.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)id.getFieldType());
        Assert.assertEquals((Object)"id", (Object)id.getName());
        Assert.assertEquals((Object)"/<>/id", (Object)id.getPath());
        JsonField type = (JsonField)complex.getJsonFields().getJsonField().get(1);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)type.getStatus());
        Assert.assertEquals(null, (Object)type.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)type.getFieldType());
        Assert.assertEquals((Object)"type", (Object)type.getName());
        Assert.assertEquals((Object)"/<>/type", (Object)type.getPath());
        JsonField name = (JsonField)complex.getJsonFields().getJsonField().get(2);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)name.getStatus());
        Assert.assertEquals(null, (Object)name.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)name.getFieldType());
        Assert.assertEquals((Object)"name", (Object)name.getName());
        Assert.assertEquals((Object)"/<>/name", (Object)name.getPath());
        JsonField ppu = (JsonField)complex.getJsonFields().getJsonField().get(3);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ppu.getStatus());
        Assert.assertEquals(null, (Object)ppu.getCollectionType());
        Assert.assertEquals((Object)FieldType.DOUBLE, (Object)ppu.getFieldType());
        Assert.assertEquals((Object)"ppu", (Object)ppu.getName());
        Assert.assertEquals((Object)"/<>/ppu", (Object)ppu.getPath());
        JsonField batters = (JsonField)complex.getJsonFields().getJsonField().get(4);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batters.getStatus());
        Assert.assertEquals(null, (Object)batters.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)batters.getFieldType());
        Assert.assertEquals((Object)"batters", (Object)batters.getName());
        Assert.assertEquals((Object)"/<>/batters", (Object)batters.getPath());
        JsonComplexType battersComplex = (JsonComplexType)batters;
        Assert.assertEquals((long)1L, (long)battersComplex.getJsonFields().getJsonField().size());
        JsonField batter = (JsonField)battersComplex.getJsonFields().getJsonField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batter.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)batter.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)batter.getFieldType());
        Assert.assertEquals((Object)"batter", (Object)batter.getName());
        Assert.assertEquals((Object)"/<>/batters/batter<>", (Object)batter.getPath());
        JsonComplexType batterComplex = (JsonComplexType)batter;
        Assert.assertEquals((long)2L, (long)batterComplex.getJsonFields().getJsonField().size());
        JsonField batterId = (JsonField)batterComplex.getJsonFields().getJsonField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterId.getStatus());
        Assert.assertEquals(null, (Object)batterId.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)batterId.getFieldType());
        Assert.assertEquals((Object)"id", (Object)batterId.getName());
        Assert.assertEquals((Object)"/<>/batters/batter<>/id", (Object)batterId.getPath());
        JsonField batterType = (JsonField)batterComplex.getJsonFields().getJsonField().get(1);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)batterType.getStatus());
        Assert.assertEquals(null, (Object)batterType.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)batterType.getFieldType());
        Assert.assertEquals((Object)"type", (Object)batterType.getName());
        Assert.assertEquals((Object)"/<>/batters/batter<>/type", (Object)batterType.getPath());
        JsonField topping = (JsonField)complex.getJsonFields().getJsonField().get(5);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)topping.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)topping.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)topping.getFieldType());
        Assert.assertEquals((Object)"topping", (Object)topping.getName());
        Assert.assertEquals((Object)"/<>/topping<>", (Object)topping.getPath());
        JsonComplexType toppingComplex = (JsonComplexType)topping;
        Assert.assertEquals((long)2L, (long)toppingComplex.getJsonFields().getJsonField().size());
        JsonField toppingId = (JsonField)toppingComplex.getJsonFields().getJsonField().get(0);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingId.getStatus());
        Assert.assertEquals(null, (Object)toppingId.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)toppingId.getFieldType());
        Assert.assertEquals((Object)"id", (Object)toppingId.getName());
        Assert.assertEquals((Object)"/<>/topping<>/id", (Object)toppingId.getPath());
        JsonField toppingType = (JsonField)toppingComplex.getJsonFields().getJsonField().get(1);
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)toppingType.getStatus());
        Assert.assertEquals(null, (Object)toppingType.getCollectionType());
        Assert.assertEquals((Object)FieldType.STRING, (Object)toppingType.getFieldType());
        Assert.assertEquals((Object)"type", (Object)toppingType.getName());
        Assert.assertEquals((Object)"/<>/topping<>/type", (Object)toppingType.getPath());
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInKeys() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/keys-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"'booleanField'"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"\"charField\""));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"\\doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField\t"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField\n"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectJsonDocumentEscapedCharsInValue() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/value-with-escaped-characters.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)5));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"quote"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"\"yadda\""));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"singlequote"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"'a'"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"backslash"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"\\qwerty"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"tab"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"foo\t"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 4) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"linefeed"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"bar\n"));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectFlatPrimitiveNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        for (int i = 0; i < document.getFields().getField().size(); ++i) {
            JsonField field = (JsonField)document.getFields().getField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"booleanField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"charField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectFlatPrimitiveWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getName(), (Matcher)Is.is((Object)"SourceFlatPrimitive"));
        Assert.assertThat((Object)root.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive"));
        Assert.assertThat((Object)root.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)root.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)8));
        for (int i = 0; i < root.getJsonFields().getJsonField().size(); ++i) {
            JsonField field = (JsonField)root.getJsonFields().getJsonField().get(i);
            if (i == 0) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"booleanField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)false));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.BOOLEAN));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 1) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"charField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"a"));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 2) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"doubleField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-2.71527453422E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 3) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"floatField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)-6.3988281E7));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 4) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"intField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)8281));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i == 5) {
                Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"shortField"));
                Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)81));
                Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
                Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
                Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
                continue;
            }
            if (i != 6) continue;
            Assert.assertThat((Object)field.getName(), (Matcher)Is.is((Object)"longField"));
            Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)3988281));
            Assert.assertThat((Object)field.getPath(), (Matcher)Is.is((Object)"/SourceFlatPrimitive/".concat(field.getName())));
            Assert.assertThat((Object)field.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
            Assert.assertThat((Object)field.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        }
    }

    @Test
    public void inspectComplexObjectNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)3));
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertThat((Object)address.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertThat((Object)address1.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address1.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address1.getPath(), (Matcher)Is.is((Object)"/address/addressLine1"));
        Assert.assertThat((Object)address1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertThat((Object)address2.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address2.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address2.getPath(), (Matcher)Is.is((Object)"/address/addressLine2"));
        Assert.assertThat((Object)address2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertThat((Object)contact.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertThat((Object)orderId.getName(), (Matcher)Is.is((Object)"orderId"));
        Assert.assertThat((Object)orderId.getValue(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)orderId.getPath(), (Matcher)Is.is((Object)"/orderId"));
        Assert.assertThat((Object)orderId.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertThat((Object)address.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertThat((Object)address1.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)address1.getValue(), (Matcher)Is.is((Object)"123 Main St"));
        Assert.assertThat((Object)address1.getPath(), (Matcher)Is.is((Object)"/order/address/addressLine1"));
        Assert.assertThat((Object)address1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertThat((Object)address2.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)address2.getValue(), (Matcher)Is.is((Object)"Suite 42b"));
        Assert.assertThat((Object)address2.getPath(), (Matcher)Is.is((Object)"/order/address/addressLine2"));
        Assert.assertThat((Object)address2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)address2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getValue(), (Matcher)Is.is((Object)"Anytown"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/order/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getValue(), (Matcher)Is.is((Object)"NY"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/order/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getValue(), (Matcher)Is.is((Object)"90210"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/order/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertThat((Object)contact.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getValue(), (Matcher)Is.is((Object)"Ozzie"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/order/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getValue(), (Matcher)Is.is((Object)"Smith"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/order/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getValue(), (Matcher)Is.is((Object)"5551212"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/order/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getValue(), (Matcher)Is.is((Object)"81111"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/order/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertThat((Object)orderId.getName(), (Matcher)Is.is((Object)"orderId"));
        Assert.assertThat((Object)orderId.getValue(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)orderId.getPath(), (Matcher)Is.is((Object)"/order/orderId"));
        Assert.assertThat((Object)orderId.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectRepeatingComplexObjectWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/complex-repeated-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)root.getName(), (Matcher)Is.is((Object)"SourceOrderList"));
        Assert.assertEquals((Object)"/SourceOrderList", (Object)root.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assert.assertEquals(null, (Object)root.getCollectionType());
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)orders);
        Assert.assertThat((Object)orders.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)orders.getName(), (Matcher)Is.is((Object)"orders"));
        Assert.assertEquals((Object)"/SourceOrderList/orders<>", (Object)orders.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)orders.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)orders.getCollectionType());
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)orderBatchNumber);
        Assert.assertThat((Object)orderBatchNumber.getName(), (Matcher)Is.is((Object)"orderBatchNumber"));
        Assert.assertThat((Object)orderBatchNumber.getValue(), (Matcher)Is.is((Object)4123562));
        Assert.assertThat((Object)orderBatchNumber.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orderBatchNumber"));
        Assert.assertThat((Object)orderBatchNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)orderBatchNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)numberOrders);
        Assert.assertThat((Object)numberOrders.getName(), (Matcher)Is.is((Object)"numberOrders"));
        Assert.assertThat((Object)numberOrders.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)numberOrders.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/numberOrders"));
        Assert.assertThat((Object)numberOrders.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)numberOrders.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType address = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertThat((Object)address.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)5));
        Assert.assertEquals(null, (Object)address.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)address.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address.getStatus());
        Assert.assertThat((Object)address.getName(), (Matcher)Is.is((Object)"address"));
        Assert.assertThat((Object)address.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address"));
        JsonField addressLine1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)addressLine1);
        Assert.assertThat((Object)addressLine1.getName(), (Matcher)Is.is((Object)"addressLine1"));
        Assert.assertThat((Object)addressLine1.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address/addressLine1"));
        Assert.assertThat((Object)addressLine1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)addressLine1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField addressLine2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)addressLine2);
        Assert.assertThat((Object)addressLine2.getName(), (Matcher)Is.is((Object)"addressLine2"));
        Assert.assertThat((Object)addressLine2.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address/addressLine2"));
        Assert.assertThat((Object)addressLine2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)addressLine2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertThat((Object)city.getName(), (Matcher)Is.is((Object)"city"));
        Assert.assertThat((Object)city.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address/city"));
        Assert.assertThat((Object)city.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)city.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertThat((Object)state.getName(), (Matcher)Is.is((Object)"state"));
        Assert.assertThat((Object)state.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address/state"));
        Assert.assertThat((Object)state.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)state.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertThat((Object)postalCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)postalCode.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/address/zipCode"));
        Assert.assertThat((Object)postalCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)postalCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType contact = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertThat((Object)contact.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)4));
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)contact.getFieldType());
        Assert.assertEquals(null, (Object)contact.getCollectionType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)contact.getStatus());
        Assert.assertThat((Object)contact.getName(), (Matcher)Is.is((Object)"contact"));
        Assert.assertThat((Object)contact.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/contact"));
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertThat((Object)firstName.getName(), (Matcher)Is.is((Object)"firstName"));
        Assert.assertThat((Object)firstName.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/contact/firstName"));
        Assert.assertThat((Object)firstName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)firstName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertThat((Object)lastName.getName(), (Matcher)Is.is((Object)"lastName"));
        Assert.assertThat((Object)lastName.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/contact/lastName"));
        Assert.assertThat((Object)lastName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)lastName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertThat((Object)phoneNumber.getName(), (Matcher)Is.is((Object)"phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/contact/phoneNumber"));
        Assert.assertThat((Object)phoneNumber.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)phoneNumber.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertThat((Object)zipCode.getName(), (Matcher)Is.is((Object)"zipCode"));
        Assert.assertThat((Object)zipCode.getPath(), (Matcher)Is.is((Object)"/SourceOrderList/orders<>/contact/zipCode"));
        Assert.assertThat((Object)zipCode.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)zipCode.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectISO8601DatesNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/iso8601dates-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)7));
        JsonField yyyy = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)yyyy);
        Assert.assertThat((Object)yyyy.getName(), (Matcher)Is.is((Object)"YYYY"));
        Assert.assertThat((Object)yyyy.getValue(), (Matcher)Is.is((Object)"1997"));
        Assert.assertThat((Object)yyyy.getPath(), (Matcher)Is.is((Object)"/YYYY"));
        Assert.assertThat((Object)yyyy.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyy.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymm = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)yyyymm);
        Assert.assertThat((Object)yyyymm.getName(), (Matcher)Is.is((Object)"YYYY-MM"));
        Assert.assertThat((Object)yyyymm.getValue(), (Matcher)Is.is((Object)"1997-07"));
        Assert.assertThat((Object)yyyymm.getPath(), (Matcher)Is.is((Object)"/YYYY-MM"));
        Assert.assertThat((Object)yyyymm.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymm.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmdd = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)yyyymmdd);
        Assert.assertThat((Object)yyyymmdd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DD"));
        Assert.assertThat((Object)yyyymmdd.getValue(), (Matcher)Is.is((Object)"1997-07-16"));
        Assert.assertThat((Object)yyyymmdd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DD"));
        Assert.assertThat((Object)yyyymmdd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmdd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmtzd = (JsonField)document.getFields().getField().get(3);
        Assert.assertNotNull((Object)yyyymmddthhmmtzd);
        Assert.assertThat((Object)yyyymmddthhmmtzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mmTZD"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mmTZD"));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmtzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmsstzd = (JsonField)document.getFields().getField().get(4);
        Assert.assertNotNull((Object)yyyymmddthhmmsstzd);
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ssTZD"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20:30+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ssTZD"));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmsstzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmssstzd = (JsonField)document.getFields().getField().get(5);
        Assert.assertNotNull((Object)yyyymmddthhmmssstzd);
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ss.sTZD"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getValue(), (Matcher)Is.is((Object)"1997-07-16T19:20:30.45+01:00"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ss.sTZD"));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmssstzd.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField yyyymmddthhmmssutz = (JsonField)document.getFields().getField().get(6);
        Assert.assertNotNull((Object)yyyymmddthhmmssutz);
        Assert.assertThat((Object)yyyymmddthhmmssutz.getName(), (Matcher)Is.is((Object)"YYYY-MM-DDThh:mm:ssUTZ"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getValue(), (Matcher)Is.is((Object)"1994-11-05T13:15:30Z"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getPath(), (Matcher)Is.is((Object)"/YYYY-MM-DDThh:mm:ssUTZ"));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)yyyymmddthhmmssutz.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentNoRoot() throws Exception {
        String instance = "{ \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{ \"brand\" : \"Mercedes\", \"doors\" : 5 }");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)2));
        JsonField field1 = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)field1);
        Assert.assertThat((Object)field1.getName(), (Matcher)Is.is((Object)"brand"));
        Assert.assertThat((Object)field1.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        Assert.assertThat((Object)field1.getPath(), (Matcher)Is.is((Object)"/brand"));
        Assert.assertThat((Object)field1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)field1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField field2 = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)field2);
        Assert.assertThat((Object)field2.getName(), (Matcher)Is.is((Object)"doors"));
        Assert.assertThat((Object)field2.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)field2.getPath(), (Matcher)Is.is((Object)"/doors"));
        Assert.assertThat((Object)field2.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)field2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentWithRoot() throws Exception {
        String instance = "{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType car = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)car);
        Assert.assertThat((Object)car.getName(), (Matcher)Is.is((Object)"car"));
        Assert.assertThat((Object)car.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)car.getPath(), (Matcher)Is.is((Object)"/car"));
        Assert.assertThat((Object)car.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)car.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField field1 = (JsonField)car.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)field1);
        Assert.assertThat((Object)field1.getName(), (Matcher)Is.is((Object)"brand"));
        Assert.assertThat((Object)field1.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        Assert.assertThat((Object)field1.getPath(), (Matcher)Is.is((Object)"/car/brand"));
        Assert.assertThat((Object)field1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)field1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField field2 = (JsonField)car.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)field2);
        Assert.assertThat((Object)field2.getName(), (Matcher)Is.is((Object)"doors"));
        Assert.assertThat((Object)field2.getValue(), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)field2.getPath(), (Matcher)Is.is((Object)"/car/doors"));
        Assert.assertThat((Object)field2.getFieldType(), (Matcher)Is.is((Object)FieldType.INTEGER));
        Assert.assertThat((Object)field2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentNestedObjectArray() throws Exception {
        String instance = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        JsonDocument document = this.inspectionService.inspectJsonDocument("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}");
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)1, (Matcher)Is.is((Object)document.getFields().getField().size()));
        Assert.assertNotNull((Object)document.getFields().getField());
        JsonComplexType jsonComplexType = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)jsonComplexType);
        Assert.assertNotNull((Object)jsonComplexType.getJsonFields().getJsonField());
        Assert.assertThat((Object)jsonComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)jsonComplexType.getName(), (Matcher)Is.is((Object)"menu"));
        JsonField jsonField1 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)jsonField1);
        Assert.assertThat((Object)jsonField1.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)jsonField1.getValue(), (Matcher)Is.is((Object)"file"));
        Assert.assertThat((Object)jsonField1.getPath(), (Matcher)Is.is((Object)"/menu/id"));
        Assert.assertThat((Object)jsonField1.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)jsonField1.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField jsonField2 = (JsonField)jsonComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)jsonField2);
        Assert.assertThat((Object)jsonField2.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)jsonField2.getValue(), (Matcher)Is.is((Object)"Filed"));
        Assert.assertThat((Object)jsonField2.getPath(), (Matcher)Is.is((Object)"/menu/value"));
        Assert.assertThat((Object)jsonField2.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)jsonField2.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType popup = (JsonComplexType)jsonComplexType.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)popup);
        Assert.assertNotNull((Object)popup.getJsonFields().getJsonField());
        Assert.assertThat((Object)popup.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)popup.getName(), (Matcher)Is.is((Object)"popup"));
        Assert.assertThat((Object)popup.getPath(), (Matcher)Is.is((Object)"/menu/popup"));
        Assert.assertThat((Object)popup.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        JsonComplexType menuitem = (JsonComplexType)popup.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)menuitem);
        Assert.assertNotNull((Object)menuitem.getJsonFields().getJsonField());
        Assert.assertEquals((Object)"menuitem", (Object)menuitem.getName());
        Assert.assertEquals((Object)"/menu/popup/menuitem<>", (Object)menuitem.getPath());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)menuitem.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)menuitem.getFieldType());
        Assert.assertThat((Object)menuitem.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField menuitemValue = (JsonField)menuitem.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)menuitemValue);
        Assert.assertThat((Object)menuitemValue.getName(), (Matcher)Is.is((Object)"value"));
        Assert.assertThat((Object)menuitemValue.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem<>/value"));
        Assert.assertThat((Object)menuitemValue.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitemValue.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField menuitemOnclick = (JsonField)menuitem.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)menuitemOnclick);
        Assert.assertThat((Object)menuitemOnclick.getName(), (Matcher)Is.is((Object)"onclick"));
        Assert.assertThat((Object)menuitemOnclick.getPath(), (Matcher)Is.is((Object)"/menu/popup/menuitem<>/onclick"));
        Assert.assertThat((Object)menuitemOnclick.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)menuitemOnclick.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentHighlyNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)6));
        JsonField id = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)id);
        Assert.assertThat((Object)id.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)id.getValue(), (Matcher)Is.is((Object)"0001"));
        Assert.assertThat((Object)id.getPath(), (Matcher)Is.is((Object)"/id"));
        Assert.assertThat((Object)id.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)id.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField value = (JsonField)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)value);
        Assert.assertThat((Object)value.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)value.getValue(), (Matcher)Is.is((Object)"donut"));
        Assert.assertThat((Object)value.getPath(), (Matcher)Is.is((Object)"/type"));
        Assert.assertThat((Object)value.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)value.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField name = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)name);
        Assert.assertThat((Object)name.getName(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)name.getValue(), (Matcher)Is.is((Object)"Cake"));
        Assert.assertThat((Object)name.getPath(), (Matcher)Is.is((Object)"/name"));
        Assert.assertThat((Object)name.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)name.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemPPU = (JsonField)document.getFields().getField().get(3);
        Assert.assertNotNull((Object)itemPPU);
        Assert.assertThat((Object)itemPPU.getName(), (Matcher)Is.is((Object)"ppu"));
        Assert.assertThat((Object)itemPPU.getPath(), (Matcher)Is.is((Object)"/ppu"));
        Assert.assertThat((Object)itemPPU.getValue(), (Matcher)Is.is((Object)0.55));
        Assert.assertThat((Object)itemPPU.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
        Assert.assertThat((Object)itemPPU.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType batters = (JsonComplexType)document.getFields().getField().get(4);
        Assert.assertNotNull((Object)batters);
        Assert.assertThat((Object)batters.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType batterParent = (JsonComplexType)batters.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterParent);
        Assert.assertEquals((Object)"batter", (Object)batterParent.getName());
        Assert.assertEquals((Object)"/batters/batter<>", (Object)batterParent.getPath());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)batterParent.getCollectionType());
        Assert.assertThat((Object)batterParent.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField batterId = (JsonField)batterParent.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterId);
        Assert.assertThat((Object)batterId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId.getPath(), (Matcher)Is.is((Object)"/batters/batter<>/id"));
        Assert.assertThat((Object)batterId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType = (JsonField)batterParent.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)batterType);
        Assert.assertThat((Object)batterType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType.getPath(), (Matcher)Is.is((Object)"/batters/batter<>/type"));
        Assert.assertThat((Object)batterType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType topping = (JsonComplexType)document.getFields().getField().get(5);
        Assert.assertNotNull((Object)topping);
        Assert.assertEquals((Object)"topping", (Object)topping.getName());
        Assert.assertEquals((Object)"/topping<>", (Object)topping.getPath());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)topping.getCollectionType());
        Assert.assertThat((Object)topping.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField toppingId = (JsonField)topping.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)toppingId);
        Assert.assertThat((Object)toppingId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingId.getPath(), (Matcher)Is.is((Object)"/topping<>/id"));
        Assert.assertThat((Object)toppingId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType = (JsonField)topping.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)toppingType);
        Assert.assertThat((Object)toppingType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType.getPath(), (Matcher)Is.is((Object)"/topping<>/type"));
        Assert.assertThat((Object)toppingType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void inspectJsonDocumentHighlyComplexNestedObject() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/highly-complex-nested-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertThat((Object)document.getFields().getField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType items = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)items);
        Assert.assertThat((Object)items.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)items.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        Assert.assertThat((Object)items.getName(), (Matcher)Is.is((Object)"items"));
        Assert.assertThat((Object)items.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType item = (JsonComplexType)items.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertThat((Object)item.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertEquals((Object)CollectionType.LIST, (Object)item.getCollectionType());
        Assert.assertEquals((Object)"item", (Object)item.getName());
        Assert.assertEquals((Object)"/items/item<>", (Object)item.getPath());
        Assert.assertThat((Object)item.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)6));
        JsonField itemId = (JsonField)item.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)itemId);
        Assert.assertThat((Object)itemId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)itemId.getValue(), (Matcher)Is.is((Object)"0001"));
        Assert.assertThat((Object)itemId.getPath(), (Matcher)Is.is((Object)"/items/item<>/id"));
        Assert.assertThat((Object)itemId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemValue = (JsonField)item.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)itemValue);
        Assert.assertThat((Object)itemValue.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)itemValue.getValue(), (Matcher)Is.is((Object)"donut"));
        Assert.assertThat((Object)itemValue.getPath(), (Matcher)Is.is((Object)"/items/item<>/type"));
        Assert.assertThat((Object)itemValue.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemValue.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemName = (JsonField)item.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)itemName);
        Assert.assertThat((Object)itemName.getName(), (Matcher)Is.is((Object)"name"));
        Assert.assertThat((Object)itemName.getValue(), (Matcher)Is.is((Object)"Cake"));
        Assert.assertThat((Object)itemName.getPath(), (Matcher)Is.is((Object)"/items/item<>/name"));
        Assert.assertThat((Object)itemName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)itemName.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField itemPPU = (JsonField)item.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)itemPPU);
        Assert.assertThat((Object)itemPPU.getName(), (Matcher)Is.is((Object)"ppu"));
        Assert.assertThat((Object)itemPPU.getPath(), (Matcher)Is.is((Object)"/items/item<>/ppu"));
        Assert.assertThat((Object)itemPPU.getValue(), (Matcher)Is.is((Object)0.55));
        Assert.assertThat((Object)itemPPU.getFieldType(), (Matcher)Is.is((Object)FieldType.DOUBLE));
        Assert.assertThat((Object)itemPPU.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemBattersComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)itemBattersComplexType);
        Assert.assertThat((Object)itemBattersComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBattersComplexType.getName(), (Matcher)Is.is((Object)"batters"));
        Assert.assertThat((Object)itemBattersComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)1));
        JsonComplexType itemBatterComplexType = (JsonComplexType)itemBattersComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)itemBatterComplexType);
        Assert.assertThat((Object)itemBatterComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemBatterComplexType.getName(), (Matcher)Is.is((Object)"batter"));
        Assert.assertEquals((Object)CollectionType.LIST, (Object)itemBatterComplexType.getCollectionType());
        Assert.assertEquals((Object)"/items/item<>/batters/batter<>", (Object)itemBatterComplexType.getPath());
        Assert.assertThat((Object)itemBatterComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField batterId = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)batterId);
        Assert.assertThat((Object)batterId.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)batterId.getValue(), (Matcher)Is.is((Object)"1001"));
        Assert.assertThat((Object)batterId.getPath(), (Matcher)Is.is((Object)"/items/item<>/batters/batter<>/id"));
        Assert.assertThat((Object)batterId.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterId.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField batterType = (JsonField)itemBatterComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)batterType);
        Assert.assertThat((Object)batterType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)batterType.getValue(), (Matcher)Is.is((Object)"Regular"));
        Assert.assertThat((Object)batterType.getPath(), (Matcher)Is.is((Object)"/items/item<>/batters/batter<>/type"));
        Assert.assertThat((Object)batterType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)batterType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonComplexType itemToppingComplexType = (JsonComplexType)item.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)itemToppingComplexType);
        Assert.assertThat((Object)itemToppingComplexType.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)itemToppingComplexType.getName(), (Matcher)Is.is((Object)"topping"));
        Assert.assertEquals((Object)CollectionType.LIST, (Object)itemToppingComplexType.getCollectionType());
        Assert.assertEquals((Object)"/items/item<>/topping<>", (Object)itemToppingComplexType.getPath());
        Assert.assertThat((Object)itemToppingComplexType.getJsonFields().getJsonField().size(), (Matcher)Is.is((Object)2));
        JsonField toppingID = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)toppingID);
        Assert.assertThat((Object)toppingID.getName(), (Matcher)Is.is((Object)"id"));
        Assert.assertThat((Object)toppingID.getPath(), (Matcher)Is.is((Object)"/items/item<>/topping<>/id"));
        Assert.assertThat((Object)toppingID.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingID.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
        JsonField toppingType = (JsonField)itemToppingComplexType.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)toppingType);
        Assert.assertThat((Object)toppingType.getName(), (Matcher)Is.is((Object)"type"));
        Assert.assertThat((Object)toppingType.getPath(), (Matcher)Is.is((Object)"/items/item<>/topping<>/type"));
        Assert.assertThat((Object)toppingType.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)toppingType.getStatus(), (Matcher)Is.is((Object)FieldStatus.SUPPORTED));
    }

    @Test
    public void testAddress() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/address.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonDocument(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)address.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)address.getCollectionType());
        Assert.assertEquals((Object)"address", (Object)address.getName());
        Assert.assertEquals((Object)"/address<>", (Object)address.getPath());
        Assert.assertEquals((long)6L, (long)address.getJsonFields().getJsonField().size());
        JsonField use = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)use);
        Assert.assertEquals((Object)FieldType.STRING, (Object)use.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)use.getStatus());
        Assert.assertEquals(null, (Object)use.getCollectionType());
        Assert.assertEquals((Object)"use", (Object)use.getName());
        Assert.assertEquals((Object)"/address<>/use", (Object)use.getPath());
        JsonField type = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals((Object)FieldType.STRING, (Object)type.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)type.getStatus());
        Assert.assertEquals(null, (Object)type.getCollectionType());
        Assert.assertEquals((Object)"type", (Object)type.getName());
        Assert.assertEquals((Object)"/address<>/type", (Object)type.getPath());
        JsonField line = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)line);
        Assert.assertEquals((Object)FieldType.STRING, (Object)line.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)line.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)line.getCollectionType());
        Assert.assertEquals((Object)"line", (Object)line.getName());
        Assert.assertEquals((Object)"/address<>/line<>", (Object)line.getPath());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        Assert.assertEquals(null, (Object)city.getCollectionType());
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/address<>/city", (Object)city.getPath());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        Assert.assertEquals(null, (Object)postalCode.getCollectionType());
        Assert.assertEquals((Object)"postalCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/address<>/postalCode", (Object)postalCode.getPath());
        JsonField country = (JsonField)address.getJsonFields().getJsonField().get(5);
        Assert.assertNotNull((Object)country);
        Assert.assertEquals((Object)FieldType.STRING, (Object)country.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)country.getStatus());
        Assert.assertEquals(null, (Object)country.getCollectionType());
        Assert.assertEquals((Object)"country", (Object)country.getName());
        Assert.assertEquals((Object)"/address<>/country", (Object)country.getPath());
    }

    private void printDocument(JsonDocument document) {
        Assert.assertNotNull((Object)document.getFields());
        this.printFields(document.getFields());
    }

    private void printFields(Fields fields) {
        Assert.assertNotNull((Object)fields.getField());
        for (Field field : fields.getField()) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField((JsonField)field);
        }
    }

    private void printFields(List<JsonField> jsonField) {
        for (JsonField field : jsonField) {
            if (field instanceof JsonComplexType) {
                this.printJsonComplexType((JsonComplexType)field);
                continue;
            }
            this.printJsonField(field);
        }
    }

    private void printJsonComplexType(JsonComplexType field) {
        Assert.assertNotNull((Object)field.getJsonFields());
        this.printJsonField((JsonField)field);
        this.printFields(field.getJsonFields().getJsonField());
    }

    private void printJsonField(JsonField jsonField) {
        System.out.println("Name --> " + jsonField.getName());
        System.out.println("Path --> " + jsonField.getPath());
        System.out.println("Value --> " + jsonField.getValue());
        if (jsonField.getFieldType() != null) {
            System.out.println("Type --> " + jsonField.getFieldType().name());
        }
        if (jsonField.getTypeName() != null) {
            System.out.println("Type Name --> " + jsonField.getTypeName());
        }
        if (jsonField.getCollectionType() != null) {
            System.out.println("Collection Type --> " + jsonField.getCollectionType().name());
        }
        if (jsonField.getStatus() != null) {
            System.out.println("Status  --> " + jsonField.getStatus().name());
        }
        System.out.println();
    }
}

