/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.json.core.JsonComplexTypeFactory;
import io.atlasmap.json.core.JsonFieldReader;
import io.atlasmap.json.core.JsonFieldWriter;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.json.v2.JsonFields;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class JsonFieldWriterTest {
    private static JsonFieldReader reader = new JsonFieldReader((AtlasConversionService)DefaultAtlasConversionService.getInstance());
    private JsonFieldWriter writer = null;

    @Before
    public void setupWriter() {
        this.writer = new JsonFieldWriter();
    }

    @Test(expected=AtlasException.class)
    public void testWriteNullField() throws Exception {
        this.write(null);
    }

    @Test
    public void testWriteSimpleObjectNoRoot() throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/brand");
        field.setValue((Object)"Mercedes");
        field.setFieldType(FieldType.STRING);
        this.write((Field)field);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"brand\":\"Mercedes\"}"));
        JsonField field2 = AtlasJsonModelFactory.createJsonField();
        field2.setPath("/doors");
        field2.setValue((Object)5);
        field2.setFieldType(FieldType.INTEGER);
        this.write((Field)field2);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"brand\":\"Mercedes\",\"doors\":5}"));
    }

    @Test
    public void testWriteSimpleObjectWithRoot() throws Exception {
        JsonField field1 = AtlasJsonModelFactory.createJsonField();
        field1.setPath("/car/brand");
        field1.setValue((Object)"Mercedes");
        field1.setFieldType(FieldType.STRING);
        this.write((Field)field1);
        JsonField field2 = AtlasJsonModelFactory.createJsonField();
        field2.setPath("/car/doors");
        field2.setValue((Object)5);
        field2.setFieldType(FieldType.INTEGER);
        this.write((Field)field2);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"car\":{\"brand\":\"Mercedes\",\"doors\":5}}"));
    }

    @Test
    public void testWriteFlatPrimitiveObjectUnrooted() throws Exception {
        JsonField booleanField = AtlasJsonModelFactory.createJsonField();
        booleanField.setFieldType(FieldType.BOOLEAN);
        booleanField.setValue((Object)false);
        booleanField.setPath("/booleanField");
        booleanField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)booleanField);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        JsonField charField = AtlasJsonModelFactory.createJsonField();
        charField.setFieldType(FieldType.CHAR);
        charField.setValue((Object)Character.valueOf('a'));
        charField.setPath("/charField");
        charField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)charField);
        JsonField doubleField = AtlasJsonModelFactory.createJsonField();
        doubleField.setFieldType(FieldType.DOUBLE);
        doubleField.setValue((Object)-2.71527453422E7);
        doubleField.setPath("/doubleField");
        doubleField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)doubleField);
        JsonField floatField = AtlasJsonModelFactory.createJsonField();
        floatField.setFieldType(FieldType.FLOAT);
        floatField.setValue((Object)-6.3988281E7);
        floatField.setPath("/floatField");
        floatField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)floatField);
        JsonField numberField = AtlasJsonModelFactory.createJsonField();
        numberField.setFieldType(FieldType.NUMBER);
        numberField.setValue((Object)-6.3988281E7);
        numberField.setPath("/numberField");
        numberField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)numberField);
        JsonField intField = AtlasJsonModelFactory.createJsonField();
        intField.setFieldType(FieldType.INTEGER);
        intField.setValue((Object)8281);
        intField.setPath("/intField");
        intField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)intField);
        JsonField shortField = AtlasJsonModelFactory.createJsonField();
        shortField.setFieldType(FieldType.SHORT);
        shortField.setValue((Object)81);
        shortField.setPath("/shortField");
        shortField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)shortField);
        JsonField longField = AtlasJsonModelFactory.createJsonField();
        longField.setFieldType(FieldType.LONG);
        longField.setValue((Object)3988281);
        longField.setPath("/longField");
        longField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)longField);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"booleanField\":false,\"charField\":\"a\",\"doubleField\":-27152745.3422,\"floatField\":-63988281,\"numberField\":-63988281,\"intField\":8281,\"shortField\":81,\"longField\":3988281}"));
    }

    @Test
    public void testWriteFlatPrimitiveObjectRooted() throws Exception {
        JsonField booleanField = AtlasJsonModelFactory.createJsonField();
        booleanField.setFieldType(FieldType.BOOLEAN);
        booleanField.setValue((Object)false);
        booleanField.setPath("/SourceFlatPrimitive/booleanField");
        booleanField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)booleanField);
        JsonField charField = AtlasJsonModelFactory.createJsonField();
        charField.setFieldType(FieldType.CHAR);
        charField.setValue((Object)Character.valueOf('a'));
        charField.setPath("/SourceFlatPrimitive/charField");
        charField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)charField);
        JsonField numberField = AtlasJsonModelFactory.createJsonField();
        numberField.setFieldType(FieldType.DOUBLE);
        numberField.setValue((Object)-2.71527453422E7);
        numberField.setPath("/SourceFlatPrimitive/doubleField");
        numberField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)numberField);
        JsonField doubleField = AtlasJsonModelFactory.createJsonField();
        doubleField.setFieldType(FieldType.DOUBLE);
        doubleField.setValue((Object)-2.71527453422E7);
        doubleField.setPath("/SourceFlatPrimitive/doubleField");
        doubleField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)doubleField);
        JsonField floatField = AtlasJsonModelFactory.createJsonField();
        floatField.setFieldType(FieldType.FLOAT);
        floatField.setValue((Object)-6.3988281E7);
        floatField.setPath("/SourceFlatPrimitive/floatField");
        floatField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)floatField);
        JsonField intField = AtlasJsonModelFactory.createJsonField();
        intField.setFieldType(FieldType.INTEGER);
        intField.setValue((Object)8281);
        intField.setPath("/SourceFlatPrimitive/intField");
        intField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)intField);
        JsonField shortField = AtlasJsonModelFactory.createJsonField();
        shortField.setFieldType(FieldType.SHORT);
        shortField.setValue((Object)81);
        shortField.setPath("/SourceFlatPrimitive/shortField");
        shortField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)shortField);
        JsonField longField = AtlasJsonModelFactory.createJsonField();
        longField.setFieldType(FieldType.LONG);
        longField.setValue((Object)3988281);
        longField.setPath("/SourceFlatPrimitive/longField");
        longField.setStatus(FieldStatus.SUPPORTED);
        this.write((Field)longField);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"SourceFlatPrimitive\":{\"booleanField\":false,\"charField\":\"a\",\"doubleField\":-27152745.3422,\"floatField\":-63988281,\"intField\":8281,\"shortField\":81,\"longField\":3988281}}"));
    }

    @Test
    public void testSimpleRepeated() throws Exception {
        this.writeString("/orders[0]/orderid", "orderid1");
        this.writeString("/orders[1]/orderid", "orderid2");
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"orders\":[{\"orderid\":\"orderid1\"},{\"orderid\":\"orderid2\"}]}"));
    }

    public void writeString(String path, String value) throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setValue((Object)value);
        field.setStatus(FieldStatus.SUPPORTED);
        field.setFieldType(FieldType.STRING);
        field.setPath(path);
        this.write((Field)field);
    }

    public void writeInteger(String path, Integer value) throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setValue((Object)value);
        field.setStatus(FieldStatus.SUPPORTED);
        field.setFieldType(FieldType.INTEGER);
        field.setPath(path);
        this.write((Field)field);
    }

    @Test
    public void testWriteComplexObjectUnrooted() throws Exception {
        this.writeComplexTestData("", "");
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"address\":{\"addressLine1\":\"123 Main St\",\"addressLine2\":\"Suite 42b\",\"city\":\"Anytown\",\"state\":\"NY\",\"zipCode\":\"90210\"},\"contact\":{\"firstName\":\"Ozzie\",\"lastName\":\"Smith\",\"phoneNumber\":\"5551212\",\"zipCode\":\"81111\"},\"orderId\":9}"));
    }

    @Test
    public void testWriteComplexObjectRooted() throws Exception {
        this.writeComplexTestData("/order", "");
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/complex-rooted-result.json", new String[0])));
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)this.prettyPrintJson(this.writer.getRootNode().toString()), (Matcher)Is.is((Object)this.prettyPrintJson(instance)));
    }

    public void writeComplexTestData(String prefix, String valueSuffix) throws Exception {
        System.out.println("\nNow writing with prefix: " + prefix + ", suffix: " + valueSuffix);
        this.writeString(prefix + "/address/addressLine1", "123 Main St" + valueSuffix);
        this.writeString(prefix + "/address/addressLine2", "Suite 42b" + valueSuffix);
        this.writeString(prefix + "/address/city", "Anytown" + valueSuffix);
        this.writeString(prefix + "/address/state", "NY" + valueSuffix);
        this.writeString(prefix + "/address/zipCode", "90210" + valueSuffix);
        this.writeString(prefix + "/contact/firstName", "Ozzie" + valueSuffix);
        this.writeString(prefix + "/contact/lastName", "Smith" + valueSuffix);
        this.writeString(prefix + "/contact/phoneNumber", "5551212" + valueSuffix);
        this.writeString(prefix + "/contact/zipCode", "81111" + valueSuffix);
        this.writeInteger(prefix + "/orderId", 9);
    }

    @Test
    public void testWriteComplexObjectRepeated() throws Exception {
        for (int i = 0; i < 5; ++i) {
            String prefix = "/SourceOrderList/orders[" + i + "]";
            String valueSuffix = " (" + (i + 1) + ")";
            this.writeComplexTestData(prefix, valueSuffix);
        }
        this.writeInteger("/SourceOrderList/orderBatchNumber", 4123562);
        this.writeInteger("/SourceOrderList/numberOfOrders", 5);
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/complex-repeated-result.json", new String[0])));
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)this.prettyPrintJson(this.writer.getRootNode().toString()), (Matcher)Is.is((Object)this.prettyPrintJson(instance)));
    }

    @Test
    @Ignore
    public void testWriteHighlyComplexObject() throws Exception {
        JsonComplexType items = JsonComplexTypeFactory.createJsonComlexField();
        items.setPath("/items");
        items.setJsonFields(new JsonFields());
        this.write((Field)items);
        JsonComplexType item = JsonComplexTypeFactory.createJsonComlexField();
        item.setJsonFields(new JsonFields());
        item.setPath("/items/item");
        item.setCollectionType(CollectionType.LIST);
        items.getJsonFields().getJsonField().add(item);
        this.write((Field)item);
        JsonField itemid = new JsonField();
        itemid.setPath("/items/item/id");
        itemid.setValue((Object)"0001");
        itemid.setFieldType(FieldType.STRING);
        itemid.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(itemid);
        this.write((Field)itemid);
        JsonField type = new JsonField();
        type.setPath("/items/item/type");
        type.setValue((Object)"donut");
        type.setFieldType(FieldType.STRING);
        type.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(type);
        this.write((Field)type);
        JsonField name = new JsonField();
        name.setPath("/items/item/name");
        name.setValue((Object)"Cake");
        name.setFieldType(FieldType.STRING);
        name.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(name);
        this.write((Field)name);
        JsonField ppu = new JsonField();
        ppu.setPath("/items/item/ppu");
        ppu.setValue((Object)0.55);
        ppu.setFieldType(FieldType.DOUBLE);
        ppu.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(ppu);
        this.write((Field)ppu);
        JsonComplexType batters = JsonComplexTypeFactory.createJsonComlexField();
        batters.setJsonFields(new JsonFields());
        batters.setPath("/items/item/batters");
        items.getJsonFields().getJsonField().add(batters);
        this.write((Field)batters);
        JsonComplexType batter = JsonComplexTypeFactory.createJsonComlexField();
        batter.setPath("/items/item/batters/batter");
        batter.setJsonFields(new JsonFields());
        batter.setStatus(FieldStatus.SUPPORTED);
        batter.setCollectionType(CollectionType.LIST);
        batters.getJsonFields().getJsonField().add(batter);
        this.write((Field)batter);
        JsonField batter1Id = new JsonField();
        batter1Id.setPath("/items/item/batters/batter/id");
        batter1Id.setValue((Object)"1001");
        batter1Id.setFieldType(FieldType.STRING);
        batter1Id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter1Id);
        this.write((Field)batter1Id);
        JsonField batter1Type = new JsonField();
        batter1Type.setPath("/items/item/batters/batter/type");
        batter1Type.setValue((Object)"Regular");
        batter1Type.setFieldType(FieldType.STRING);
        batter1Type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter1Type);
        this.write((Field)batter1Type);
        JsonField batter2Id = new JsonField();
        batter2Id.setPath("/items/item/batters/batter[1]/id");
        batter2Id.setValue((Object)"1002");
        batter2Id.setFieldType(FieldType.STRING);
        batter2Id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter2Id);
        this.write((Field)batter2Id);
        JsonField batter2Type = new JsonField();
        batter2Type.setPath("/items/item/batters/batter[1]/type");
        batter2Type.setValue((Object)"Chocolate");
        batter2Type.setFieldType(FieldType.STRING);
        batter2Type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter2Type);
        this.write((Field)batter2Type);
        JsonField batter3Id = new JsonField();
        batter3Id.setPath("/items/item/batters/batter[2]/id");
        batter3Id.setValue((Object)"1003");
        batter3Id.setFieldType(FieldType.STRING);
        batter3Id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter3Id);
        this.write((Field)batter3Id);
        JsonField batter3Type = new JsonField();
        batter3Type.setPath("/items/item/batters/batter[2]/type");
        batter3Type.setValue((Object)"Blueberry");
        batter3Type.setFieldType(FieldType.STRING);
        batter3Type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter3Type);
        this.write((Field)batter3Type);
        JsonField batter4Id = new JsonField();
        batter4Id.setPath("/items/item/batters/batter[3]/id");
        batter4Id.setValue((Object)"1004");
        batter4Id.setFieldType(FieldType.STRING);
        batter4Id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter4Id);
        this.write((Field)batter4Id);
        JsonField batter4Type = new JsonField();
        batter4Type.setPath("/items/item/batters/batter[3]/type");
        batter4Type.setValue((Object)"Devil's Food");
        batter4Type.setFieldType(FieldType.STRING);
        batter4Type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter4Type);
        this.write((Field)batter4Type);
        JsonComplexType topping = JsonComplexTypeFactory.createJsonComlexField();
        topping.setJsonFields(new JsonFields());
        topping.setPath("/items/item/topping");
        topping.setCollectionType(CollectionType.ARRAY);
        items.getJsonFields().getJsonField().add(topping);
        this.write((Field)topping);
        JsonField topping1Id = new JsonField();
        topping1Id.setPath("/items/item/topping/id");
        topping1Id.setValue((Object)"5001");
        topping1Id.setFieldType(FieldType.STRING);
        topping1Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping1Id);
        this.write((Field)topping1Id);
        JsonField topping1Type = new JsonField();
        topping1Type.setPath("/items/item/topping/type");
        topping1Type.setValue((Object)"None");
        topping1Type.setFieldType(FieldType.STRING);
        topping1Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping1Type);
        this.write((Field)topping1Type);
        JsonField topping2Id = new JsonField();
        topping2Id.setPath("/items/item/topping/id[1]");
        topping2Id.setValue((Object)"5002");
        topping2Id.setFieldType(FieldType.STRING);
        topping2Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping2Id);
        this.write((Field)topping2Id);
        JsonField topping2Type = new JsonField();
        topping2Type.setPath("/items/item/topping/type[1]");
        topping2Type.setValue((Object)"Glazed");
        topping2Type.setFieldType(FieldType.STRING);
        topping2Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping2Type);
        this.write((Field)topping2Type);
        JsonField topping3Id = new JsonField();
        topping3Id.setPath("/items/item/topping/id[2]");
        topping3Id.setValue((Object)"5005");
        topping3Id.setFieldType(FieldType.STRING);
        topping3Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping3Id);
        this.write((Field)topping3Id);
        JsonField topping3Type = new JsonField();
        topping3Type.setPath("/items/item/topping/type[2]");
        topping3Type.setValue((Object)"Sugar");
        topping3Type.setFieldType(FieldType.STRING);
        topping3Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping3Type);
        this.write((Field)topping3Type);
        JsonField topping4Id = new JsonField();
        topping4Id.setPath("/items/item/topping/id[3]");
        topping4Id.setValue((Object)"5007");
        topping4Id.setFieldType(FieldType.STRING);
        topping4Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping4Id);
        this.write((Field)topping4Id);
        JsonField topping4Type = new JsonField();
        topping4Type.setPath("/items/item/topping/type[3]");
        topping4Type.setValue((Object)"Powdered Sugar");
        topping4Type.setFieldType(FieldType.STRING);
        topping4Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping4Type);
        this.write((Field)topping4Type);
        JsonField topping5Id = new JsonField();
        topping5Id.setPath("/items/item/topping/id[4]");
        topping5Id.setValue((Object)"5006");
        topping5Id.setFieldType(FieldType.STRING);
        topping5Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping5Id);
        this.write((Field)topping5Id);
        JsonField topping5Type = new JsonField();
        topping5Type.setPath("/items/item/topping/type[4]");
        topping5Type.setValue((Object)"Chocolate with Sprinkles");
        topping5Type.setFieldType(FieldType.STRING);
        topping5Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping5Type);
        this.write((Field)topping5Type);
        JsonField topping6Id = new JsonField();
        topping6Id.setPath("/items/item/topping/id[5]");
        topping6Id.setValue((Object)"5003");
        topping6Id.setFieldType(FieldType.STRING);
        topping6Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping6Id);
        this.write((Field)topping6Id);
        JsonField topping6Type = new JsonField();
        topping6Type.setPath("/items/item/topping/type[5]");
        topping6Type.setValue((Object)"Chocolate");
        topping6Type.setFieldType(FieldType.STRING);
        topping6Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping6Type);
        this.write((Field)topping6Type);
        JsonField topping7Id = new JsonField();
        topping7Id.setPath("/items/item/topping/id[6]");
        topping7Id.setValue((Object)"5004");
        topping7Id.setFieldType(FieldType.STRING);
        topping7Id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping7Id);
        this.write((Field)topping7Id);
        JsonField topping7Type = new JsonField();
        topping7Type.setPath("/items/item/topping/type[6]");
        topping7Type.setValue((Object)"Maple");
        topping7Type.setFieldType(FieldType.STRING);
        topping7Type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping7Type);
        this.write((Field)topping7Type);
        JsonComplexType item1 = JsonComplexTypeFactory.createJsonComlexField();
        item1.setJsonFields(new JsonFields());
        item1.setPath("/items/item[1]");
        item1.setCollectionType(CollectionType.LIST);
        items.getJsonFields().getJsonField().add(item1);
        this.write((Field)item1);
        JsonField itemId1 = new JsonField();
        itemId1.setPath("/items/item[1]/id");
        itemId1.setValue((Object)"0002");
        itemId1.setFieldType(FieldType.STRING);
        itemId1.setStatus(FieldStatus.SUPPORTED);
        item1.getJsonFields().getJsonField().add(itemId1);
        this.write((Field)itemId1);
        JsonField type1 = new JsonField();
        type1.setPath("/items/item[1]/type");
        type1.setValue((Object)"donut");
        type1.setFieldType(FieldType.STRING);
        type1.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(type1);
        this.write((Field)type1);
        JsonField name1 = new JsonField();
        name1.setPath("/items/item[1]/name");
        name1.setValue((Object)"Raised");
        name1.setFieldType(FieldType.STRING);
        name1.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(name1);
        this.write((Field)name1);
        JsonField ppu2 = new JsonField();
        ppu2.setPath("/items/item[1]/ppu");
        ppu2.setValue((Object)0.55);
        ppu2.setFieldType(FieldType.DOUBLE);
        ppu2.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(ppu2);
        this.write((Field)ppu2);
        JsonComplexType batters1 = JsonComplexTypeFactory.createJsonComlexField();
        batters1.setJsonFields(new JsonFields());
        batters1.setPath("/items/item[1]/batters");
        items.getJsonFields().getJsonField().add(batters1);
        this.write((Field)batters1);
        JsonComplexType batter1 = JsonComplexTypeFactory.createJsonComlexField();
        batter1.setPath("/items/item[1]/batters/batter");
        batter1.setJsonFields(new JsonFields());
        batter1.setStatus(FieldStatus.SUPPORTED);
        batter1.setCollectionType(CollectionType.LIST);
        batters1.getJsonFields().getJsonField().add(batter1);
        this.write((Field)batter1);
        System.out.println(this.prettyPrintJson(this.writer.getRootNode().toString()));
    }

    @Test
    public void testJsonFieldDoubleMax() throws Exception {
        this.testBoundaryValue("test-write-field-double-max.json", "/primitiveValue", Double.MAX_VALUE, FieldType.DOUBLE);
    }

    @Test
    public void testJsonFieldDoubleMin() throws Exception {
        this.testBoundaryValue("test-write-field-double-min.json", "/primitiveValue", Double.MIN_VALUE, FieldType.DOUBLE);
    }

    @Test
    public void testJsonFieldFloatMax() throws Exception {
        this.testBoundaryValue("test-write-field-float-max.json", "/primitiveValue", Float.valueOf(Float.MAX_VALUE), FieldType.FLOAT);
    }

    @Test
    public void testJsonFieldFloatMin() throws Exception {
        this.testBoundaryValue("test-write-field-float-min.json", "/primitiveValue", Float.valueOf(Float.MIN_VALUE), FieldType.FLOAT);
    }

    @Test
    public void testJsonFieldLongMax() throws Exception {
        this.testBoundaryValue("test-write-field-long-max.json", "/primitiveValue", Long.MAX_VALUE, FieldType.LONG);
    }

    @Test
    public void testJsonFieldLongMin() throws Exception {
        this.testBoundaryValue("test-write-field-long-min.json", "/primitiveValue", Long.MIN_VALUE, FieldType.LONG);
    }

    @Test
    public void testJsonFieldIntegerMax() throws Exception {
        this.testBoundaryValue("test-write-field-integer-max.json", "/primitiveValue", Integer.MAX_VALUE, FieldType.INTEGER);
    }

    @Test
    public void testJsonFieldIntegerMin() throws Exception {
        this.testBoundaryValue("test-write-field-integer-min.json", "/primitiveValue", Integer.MIN_VALUE, FieldType.INTEGER);
    }

    @Test
    public void testJsonFieldShortMax() throws Exception {
        this.testBoundaryValue("test-write-field-short-max.json", "/primitiveValue", (short)Short.MAX_VALUE, FieldType.SHORT);
    }

    @Test
    public void testJsonFieldShortMin() throws Exception {
        this.testBoundaryValue("test-write-field-short-min.json", "/primitiveValue", (short)Short.MIN_VALUE, FieldType.SHORT);
    }

    @Test
    public void testJsonFieldChar() throws Exception {
        this.testBoundaryValue("test-write-field-char.json", "/primitiveValue", new Character('\u007f'), FieldType.CHAR);
    }

    @Test
    public void testJsonFieldCharMin() throws Exception {
        this.testBoundaryValue("test-write-field-char-min.json", "/primitiveValue", Character.valueOf('\u0000'), FieldType.CHAR);
    }

    @Test
    public void testJsonFieldByteMax() throws Exception {
        this.testBoundaryValue("test-write-field-byte-max.json", "/primitiveValue", (byte)127, FieldType.BYTE);
    }

    @Test
    public void testJsonFieldByteMin() throws Exception {
        this.testBoundaryValue("test-write-field-byte-min.json", "/primitiveValue", (byte)-128, FieldType.BYTE);
    }

    @Test
    public void testJsonFieldBooleanTrue() throws Exception {
        this.testBoundaryValue("test-write-field-boolean-true.json", "/primitiveValue", Boolean.TRUE, FieldType.BOOLEAN);
    }

    @Test
    public void testJsonFieldBooleanFalse() throws Exception {
        this.testBoundaryValue("test-write-field-boolean-false.json", "/primitiveValue", Boolean.FALSE, FieldType.BOOLEAN);
    }

    @Test
    public void testJsonFieldStringEmpty() throws Exception {
        this.testBoundaryValue("test-write-field-string-empty.json", "/stringValue", "", FieldType.STRING);
    }

    @Test
    public void testJsonFieldStringNonEmpty() throws Exception {
        this.testBoundaryValue("test-write-field-string-nonempty.json", "/stringValue", "testString", FieldType.STRING);
    }

    @Test
    public void testJsonFieldStringNull() throws Exception {
        this.testBoundaryValue("test-write-field-string-null.json", "/stringValue", null, FieldType.STRING);
    }

    @Test
    public void testJsonFieldDoubleMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-double-max-range-out.json", "/primitiveValue", "1.7976931348623157E309", FieldType.STRING, FieldType.DOUBLE);
    }

    @Test
    public void testJsonFieldDoubleMinRangeOut() throws Exception {
        this.testMinRangeOutValue("test-write-field-double-min-range-out.json", "/primitiveValue", "4.9E-325", FieldType.STRING, FieldType.DOUBLE, 0.0);
    }

    @Test
    public void testJsonFieldFloatMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-float-max-range-out.json", "/primitiveValue", "3.4028235E39", FieldType.STRING, FieldType.FLOAT);
    }

    @Test
    public void testJsonFieldFloatMinRangeOut() throws Exception {
        this.testMinRangeOutValue("test-write-field-float-min-range-out.json", "/primitiveValue", "1.4E-46", FieldType.STRING, FieldType.FLOAT, Float.valueOf(0.0f));
    }

    @Test
    public void testJsonFieldLongMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-long-max-range-out.json", "/primitiveValue", "9223372036854775808", FieldType.STRING, FieldType.LONG);
    }

    @Test
    public void testJsonFieldLongMinRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-long-min-range-out.json", "/primitiveValue", "-9223372036854775809", FieldType.STRING, FieldType.LONG);
    }

    @Test
    public void testJsonFieldIntegerMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-integer-max-range-out.json", "/primitiveValue", Long.MAX_VALUE, FieldType.LONG, FieldType.INTEGER);
    }

    @Test
    public void testJsonFieldIntegerMinRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-integer-min-range-out.json", "/primitiveValue", Long.MIN_VALUE, FieldType.LONG, FieldType.INTEGER);
    }

    @Test
    public void testJsonFieldShortMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-short-max-range-out.json", "/primitiveValue", Long.MAX_VALUE, FieldType.LONG, FieldType.SHORT);
    }

    @Test
    public void testJsonFieldShortMinRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-short-min-range-out.json", "/primitiveValue", Long.MIN_VALUE, FieldType.LONG, FieldType.SHORT);
    }

    @Test
    public void testJsonFieldCharMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-char-max-range-out.json", "/primitiveValue", Long.MAX_VALUE, FieldType.LONG, FieldType.CHAR);
    }

    @Test
    public void testJsonFieldCharMinRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-char-min-range-out.json", "/primitiveValue", Long.MIN_VALUE, FieldType.LONG, FieldType.CHAR);
    }

    @Test
    public void testJsonFieldByteMaxRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-byte-max-range-out.json", "/primitiveValue", Long.MAX_VALUE, FieldType.LONG, FieldType.BYTE);
    }

    @Test
    public void testJsonFieldByteMinRangeOut() throws Exception {
        this.testRangeOutValue("test-write-field-byte-min-range-out.json", "/primitiveValue", Long.MIN_VALUE, FieldType.LONG, FieldType.BYTE);
    }

    @Test
    public void testJsonFieldBooleanRangeOut() throws Exception {
        this.testMinRangeOutValue("test-write-field-boolean-range-out.json", "/primitiveValue", null, FieldType.NONE, FieldType.BOOLEAN, null);
    }

    @Test
    public void testJsonFieldLongDecimal() throws Exception {
        this.testDecimalValue("test-write-field-long-decimal.json", "/primitiveValue", Double.valueOf("126.1234"), FieldType.DOUBLE, FieldType.LONG, 126L);
    }

    @Test
    public void testJsonFieldIntegerDecimal() throws Exception {
        this.testDecimalValue("test-write-field-integer-decimal.json", "/primitiveValue", Double.valueOf("126.1234"), FieldType.DOUBLE, FieldType.INTEGER, 126);
    }

    @Test
    public void testJsonFieldShortDecimal() throws Exception {
        this.testDecimalValue("test-write-field-short-decimal.json", "/primitiveValue", Double.valueOf("126.1234"), FieldType.DOUBLE, FieldType.SHORT, (short)126);
    }

    @Test
    public void testJsonFieldCharDecimal() throws Exception {
        this.testRangeOutValue("test-write-field-char-decimal.json", "/primitiveValue", Double.valueOf("126.1234"), FieldType.DOUBLE, FieldType.CHAR);
    }

    @Test
    public void testJsonFieldByteDecimal() throws Exception {
        this.testDecimalValue("test-write-field-byte-decimal.json", "/primitiveValue", Double.valueOf("126.1234"), FieldType.DOUBLE, FieldType.BYTE, (byte)126);
    }

    @Test
    public void testJsonFieldDoubleString() throws Exception {
        this.testRangeOutValue("test-write-field-double-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.DOUBLE);
    }

    @Test
    public void testJsonFieldFloatString() throws Exception {
        this.testRangeOutValue("test-write-field-float-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.FLOAT);
    }

    @Test
    public void testJsonFieldLongString() throws Exception {
        this.testRangeOutValue("test-write-field-long-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.LONG);
    }

    @Test
    public void testJsonFieldIntegerString() throws Exception {
        this.testRangeOutValue("test-write-field-integer-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.INTEGER);
    }

    @Test
    public void testJsonFieldShortString() throws Exception {
        this.testRangeOutValue("test-write-field-short-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.SHORT);
    }

    @Test
    public void testJsonFieldCharString() throws Exception {
        this.testRangeOutValue("test-write-field-char-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.CHAR);
    }

    @Test
    public void testJsonFieldByteString() throws Exception {
        this.testRangeOutValue("test-write-field-byte-string.json", "/primitiveValue", "abcd", FieldType.STRING, FieldType.BYTE);
    }

    @Test
    public void testJsonFieldBooleanString() throws Exception {
        Path path = Paths.get("target" + File.separator + "test-write-field-byte-string.json", new String[0]);
        String fieldPath = "/primitiveValue";
        String testObject = "abcd";
        FieldType inputFieldType = FieldType.STRING;
        FieldType outputFieldType = FieldType.BOOLEAN;
        this.write(path, fieldPath, testObject, inputFieldType);
        AtlasInternalSession session = this.read(path, outputFieldType, fieldPath);
        Assert.assertEquals((Object)false, (Object)session.head().getSourceField().getValue());
    }

    @Test
    public void testJsonFieldTopmostArraySimple() throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<1>");
        field.setValue((Object)300);
        field.setFieldType(FieldType.INTEGER);
        this.write((Field)field);
        field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<3>");
        field.setValue((Object)500);
        field.setFieldType(FieldType.INTEGER);
        this.write((Field)field);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"[null,300,null,500]"));
    }

    @Test
    public void testJsonFieldTopmostArrayObject() throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<1>/color");
        field.setValue((Object)"red");
        field.setFieldType(FieldType.STRING);
        this.write((Field)field);
        field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<2>/value");
        field.setValue((Object)"foobar");
        field.setFieldType(FieldType.STRING);
        this.write((Field)field);
        field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<5>/color");
        field.setValue((Object)"black");
        field.setFieldType(FieldType.STRING);
        this.write((Field)field);
        field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/<5>/value");
        field.setValue((Object)"123");
        field.setFieldType(FieldType.STRING);
        this.write((Field)field);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"[{},{\"color\":\"red\"},{\"value\":\"foobar\"},{},{},{\"color\":\"black\",\"value\":\"123\"}]"));
    }

    private void write(Path path, String fieldPath, Object testObject, FieldType fieldType) throws Exception, IOException, JsonGenerationException, JsonMappingException {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath(fieldPath);
        field.setValue(testObject);
        field.setFieldType(fieldType);
        this.write((Field)field);
        this.writer.getObjectMapper().writeValue(path.toFile(), (Object)this.writer.getRootNode());
    }

    private AtlasInternalSession read(Path path, FieldType outputFieldType, String fieldPath) throws IOException, AtlasException {
        String document = new String(Files.readAllBytes(path));
        reader.setDocument(document);
        JsonField jsonField = AtlasJsonModelFactory.createJsonField();
        jsonField.setPath(fieldPath);
        jsonField.setFieldType(outputFieldType);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)jsonField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        reader.read(session);
        return session;
    }

    private void testRangeOutValue(String fileName, String fieldPath, Object testObject, FieldType inputFieldType, FieldType outputFieldType) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        this.write(path, fieldPath, testObject, inputFieldType);
        AtlasInternalSession session = this.read(path, outputFieldType, fieldPath);
        Assert.assertEquals(null, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)1L, (long)session.getAudits().getAudit().size());
        Assert.assertEquals((Object)("Failed to convert field value '" + testObject.toString() + "' into type '" + outputFieldType.value().toUpperCase() + "'"), (Object)((Audit)session.getAudits().getAudit().get(0)).getMessage());
        Assert.assertEquals((Object)testObject.toString(), (Object)((Audit)session.getAudits().getAudit().get(0)).getValue());
        Assert.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
    }

    private void write(Field field) throws Exception {
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn(Mockito.mock(Field.class));
        Mockito.when((Object)session.head().getTargetField()).thenReturn((Object)field);
        this.writer.write(session);
    }

    private String prettyPrintJson(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object objJSON = objectMapper.readValue(json, Object.class);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objJSON);
    }

    private void testBoundaryValue(String fileName, String fieldPath, Object testObject, FieldType fieldType) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        this.write(path, fieldPath, testObject, fieldType);
        AtlasInternalSession session = this.read(path, fieldType, fieldPath);
        Assert.assertEquals((Object)testObject, (Object)session.head().getSourceField().getValue());
    }

    private void testMinRangeOutValue(String fileName, String fieldPath, Object testObject, FieldType inputFieldType, FieldType outputFieldType, Object expectedValue) throws Exception, IOException, JsonGenerationException, JsonMappingException, AtlasException {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        this.write(path, fieldPath, testObject, inputFieldType);
        AtlasInternalSession session = this.read(path, outputFieldType, fieldPath);
        Assert.assertEquals((Object)expectedValue, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }

    private void testDecimalValue(String fileName, String fieldPath, Object testObject, FieldType inputFieldType, FieldType outputFieldType, Object expectedValue) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        this.write(path, fieldPath, testObject, inputFieldType);
        AtlasInternalSession session = this.read(path, outputFieldType, fieldPath);
        Assert.assertEquals((Object)expectedValue, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }
}

