/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonDocumentInspectionService;
import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaInspectorTest {
    private final JsonDocumentInspectionService inspectionService = new JsonDocumentInspectionService();

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchemaEmpty() throws Exception {
        String schema = "";
        this.inspectionService.inspectJsonSchema("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchemaWhitespaceOnly() throws Exception {
        String schema = " ";
        this.inspectionService.inspectJsonSchema(" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchemaNull() throws Exception {
        String schema = null;
        this.inspectionService.inspectJsonSchema(schema);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonSchemaUnparseableMissingOpenCurly() throws Exception {
        String schema = "\"$schema\": \"http://json-schema.org/\"}";
        this.inspectionService.inspectJsonSchema("\"$schema\": \"http://json-schema.org/\"}");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonSchemaUnparseableMissingClosingCurly() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"";
        this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\"");
    }

    @Test
    public void inspectJsonSchemaEmptyDocument() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\"}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)0L, (long)document.getFields().getField().size());
    }

    @Test
    public void inspectJsonSchemaSimpleArray() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.UNSUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonSchemaSimpleString() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.SUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)FieldType.STRING, (Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectFlatPrimitiveNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)5L, (long)document.getFields().getField().size());
        List fields = document.getFields().getField();
        JsonField field = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"booleanField", (Object)field.getName());
        Assert.assertEquals((Object)"/booleanField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"stringField", (Object)field.getName());
        Assert.assertEquals((Object)"/stringField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"numberField", (Object)field.getName());
        Assert.assertEquals((Object)"/numberField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"intField", (Object)field.getName());
        Assert.assertEquals((Object)"/intField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"nullField", (Object)field.getName());
        Assert.assertEquals((Object)"/nullField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectFlatPrimitiveWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"SourceFlatPrimitive", (Object)root.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive", (Object)root.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)root.getStatus());
        Assert.assertEquals((long)5L, (long)root.getJsonFields().getJsonField().size());
        List fields = root.getJsonFields().getJsonField();
        JsonField field = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"booleanField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/booleanField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"stringField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/stringField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"numberField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/numberField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"intField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/intField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"nullField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/nullField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectComplexObjectNoRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)3L, (long)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assert.assertEquals((Object)"/address/addressLine1", (Object)address1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assert.assertEquals((Object)"/address/addressLine2", (Object)address2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectComplexObjectWithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertEquals((long)3L, (long)root.getJsonFields().getJsonField().size());
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assert.assertEquals((Object)"/order/address/addressLine1", (Object)address1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assert.assertEquals((Object)"/order/address/addressLine2", (Object)address2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/order/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/order/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/order/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/order/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/order/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/order/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/order/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/order/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectObjectArrayWithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-array-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)3L, (long)root.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"SourceOrderList", (Object)root.getName());
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)3L, (long)orders.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"orders", (Object)orders.getName());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)orders.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)orders.getFieldType());
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)orderBatchNumber);
        Assert.assertEquals((Object)"orderBatchNumber", (Object)orderBatchNumber.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orderBatchNumber", (Object)orderBatchNumber.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderBatchNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderBatchNumber.getStatus());
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)numberOrders);
        Assert.assertEquals((Object)"numberOrders", (Object)numberOrders.getName());
        Assert.assertEquals((Object)"/SourceOrderList/numberOrders", (Object)numberOrders.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)numberOrders.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)numberOrders.getStatus());
        JsonComplexType address = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"address", (Object)address.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address", (Object)address.getPath());
        JsonField addressLine1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)addressLine1);
        Assert.assertEquals((Object)"addressLine1", (Object)addressLine1.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/addressLine1", (Object)addressLine1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)addressLine1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine1.getStatus());
        JsonField addressLine2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)addressLine2);
        Assert.assertEquals((Object)"addressLine2", (Object)addressLine2.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/addressLine2", (Object)addressLine2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)addressLine2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"contact", (Object)contact.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact", (Object)contact.getPath());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)orders.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectJsonSchemaRef() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/ref.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)3L, (long)document.getFields().getField().size());
        JsonField refA = (JsonField)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)refA);
        Assert.assertEquals((Object)"ref-a", (Object)refA.getName());
        Assert.assertEquals((Object)"/ref-a", (Object)refA.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)refA.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refA.getStatus());
        JsonComplexType refB = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)refB);
        Assert.assertEquals((Object)"ref-b", (Object)refB.getName());
        Assert.assertEquals((Object)"/ref-b", (Object)refB.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)refB.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refB.getStatus());
        Assert.assertEquals((long)2L, (long)refB.getJsonFields().getJsonField().size());
        JsonComplexType refCFromB = (JsonComplexType)refB.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)refCFromB);
        Assert.assertEquals((Object)"ref-c-from-b", (Object)refCFromB.getName());
        Assert.assertEquals((Object)"/ref-b/ref-c-from-b", (Object)refCFromB.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)refCFromB.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refCFromB.getStatus());
        Assert.assertEquals((long)1L, (long)refCFromB.getJsonFields().getJsonField().size());
        JsonField strCFromB = (JsonField)refCFromB.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)strCFromB);
        Assert.assertEquals((Object)"str-c", (Object)strCFromB.getName());
        Assert.assertEquals((Object)"/ref-b/ref-c-from-b/str-c", (Object)strCFromB.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)strCFromB.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strCFromB.getStatus());
        JsonField strB = (JsonField)refB.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)strB);
        Assert.assertEquals((Object)"str-b", (Object)strB.getName());
        Assert.assertEquals((Object)"/ref-b/str-b", (Object)strB.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)strB.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strB.getStatus());
        JsonComplexType refC = (JsonComplexType)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)refC);
        Assert.assertEquals((Object)"ref-c", (Object)refC.getName());
        Assert.assertEquals((Object)"/ref-c", (Object)refC.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)refC.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refC.getStatus());
        Assert.assertEquals((long)1L, (long)refC.getJsonFields().getJsonField().size());
        JsonField strC = (JsonField)refC.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)strC);
        Assert.assertEquals((Object)"str-c", (Object)strC.getName());
        Assert.assertEquals((Object)"/ref-c/str-c", (Object)strC.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)strC.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strC.getStatus());
    }

    @Test
    public void inspectJsonSchemaGeo() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/geo.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Test
    public void inspectJsonSchemaAddress() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/address.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assert.assertEquals((Object)"/post-office-box", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"extended-address", (Object)f.getName());
        Assert.assertEquals((Object)"/extended-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"street-address", (Object)f.getName());
        Assert.assertEquals((Object)"/street-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"locality", (Object)f.getName());
        Assert.assertEquals((Object)"/locality", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"region", (Object)f.getName());
        Assert.assertEquals((Object)"/region", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(5);
        Assert.assertEquals((Object)"postal-code", (Object)f.getName());
        Assert.assertEquals((Object)"/postal-code", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(6);
        Assert.assertEquals((Object)"country-name", (Object)f.getName());
        Assert.assertEquals((Object)"/country-name", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }

    @Ignore(value="internet access")
    @Test
    public void inspectJsonSchemaCalendarExternal() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    @Test
    public void inspectJsonSchemaCalendarInternal() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-internal.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    @Test
    public void inspectJsonSchemaCalendarInline() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-inline.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    private void doInspectJsonSchemaCalendar(String instance) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"dtstart", (Object)f.getName());
        Assert.assertEquals((Object)"/dtstart", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"dtend", (Object)f.getName());
        Assert.assertEquals((Object)"/dtend", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"summary", (Object)f.getName());
        Assert.assertEquals((Object)"/summary", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"location", (Object)f.getName());
        Assert.assertEquals((Object)"/location", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"url", (Object)f.getName());
        Assert.assertEquals((Object)"/url", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(5);
        Assert.assertEquals((Object)"duration", (Object)f.getName());
        Assert.assertEquals((Object)"/duration", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(6);
        Assert.assertEquals((Object)"rdate", (Object)f.getName());
        Assert.assertEquals((Object)"/rdate", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(7);
        Assert.assertEquals((Object)"rrule", (Object)f.getName());
        Assert.assertEquals((Object)"/rrule", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(8);
        Assert.assertEquals((Object)"category", (Object)f.getName());
        Assert.assertEquals((Object)"/category", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(9);
        Assert.assertEquals((Object)"description", (Object)f.getName());
        Assert.assertEquals((Object)"/description", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assert.assertEquals((Object)"geo", (Object)f.getName());
        Assert.assertEquals((Object)"/geo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)geofields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)geofields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Ignore(value="internet access")
    @Test
    public void inspectJsonSchemaCardExternal() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    @Test
    public void inspectJsonSchemaCardInternal() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-internal.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    @Test
    public void inspectJsonSchemaCardInline() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-inline.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    private void doInspectJsonSchemaCard(String schema) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"fn", (Object)f.getName());
        Assert.assertEquals((Object)"/fn", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"familyName", (Object)f.getName());
        Assert.assertEquals((Object)"/familyName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"givenName", (Object)f.getName());
        Assert.assertEquals((Object)"/givenName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"additionalName", (Object)f.getName());
        Assert.assertEquals((Object)"/additionalName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"honorificPrefix", (Object)f.getName());
        Assert.assertEquals((Object)"/honorificPrefix", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(5);
        Assert.assertEquals((Object)"honorificSuffix", (Object)f.getName());
        Assert.assertEquals((Object)"/honorificSuffix", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(6);
        Assert.assertEquals((Object)"nickname", (Object)f.getName());
        Assert.assertEquals((Object)"/nickname", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(7);
        Assert.assertEquals((Object)"url", (Object)f.getName());
        Assert.assertEquals((Object)"/url", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(8);
        Assert.assertEquals((Object)"email", (Object)f.getName());
        Assert.assertEquals((Object)"/email", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List emailfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)emailfields.get(0);
        Assert.assertEquals((Object)"type", (Object)f.getName());
        Assert.assertEquals((Object)"/email/type", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)emailfields.get(1);
        Assert.assertEquals((Object)"value", (Object)f.getName());
        Assert.assertEquals((Object)"/email/value", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(9);
        Assert.assertEquals((Object)"tel", (Object)f.getName());
        Assert.assertEquals((Object)"/tel", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List telfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)telfields.get(0);
        Assert.assertEquals((Object)"type", (Object)f.getName());
        Assert.assertEquals((Object)"/tel/type", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)telfields.get(1);
        Assert.assertEquals((Object)"value", (Object)f.getName());
        Assert.assertEquals((Object)"/tel/value", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assert.assertEquals((Object)"adr", (Object)f.getName());
        Assert.assertEquals((Object)"/adr", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List addrfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)addrfields.get(0);
        Assert.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/post-office-box", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(1);
        Assert.assertEquals((Object)"extended-address", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/extended-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(2);
        Assert.assertEquals((Object)"street-address", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/street-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(3);
        Assert.assertEquals((Object)"locality", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/locality", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(4);
        Assert.assertEquals((Object)"region", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/region", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(5);
        Assert.assertEquals((Object)"postal-code", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/postal-code", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(6);
        Assert.assertEquals((Object)"country-name", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/country-name", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(11);
        Assert.assertEquals((Object)"geo", (Object)f.getName());
        Assert.assertEquals((Object)"/geo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)geofields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)geofields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)fields.get(12);
        Assert.assertEquals((Object)"tz", (Object)f.getName());
        Assert.assertEquals((Object)"/tz", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(13);
        Assert.assertEquals((Object)"photo", (Object)f.getName());
        Assert.assertEquals((Object)"/photo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(14);
        Assert.assertEquals((Object)"logo", (Object)f.getName());
        Assert.assertEquals((Object)"/logo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(15);
        Assert.assertEquals((Object)"sound", (Object)f.getName());
        Assert.assertEquals((Object)"/sound", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(16);
        Assert.assertEquals((Object)"bday", (Object)f.getName());
        Assert.assertEquals((Object)"/bday", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(17);
        Assert.assertEquals((Object)"title", (Object)f.getName());
        Assert.assertEquals((Object)"/title", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(18);
        Assert.assertEquals((Object)"role", (Object)f.getName());
        Assert.assertEquals((Object)"/role", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(19);
        Assert.assertEquals((Object)"org", (Object)f.getName());
        Assert.assertEquals((Object)"/org", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List orgfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)orgfields.get(0);
        Assert.assertEquals((Object)"organizationName", (Object)f.getName());
        Assert.assertEquals((Object)"/org/organizationName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)orgfields.get(1);
        Assert.assertEquals((Object)"organizationUnit", (Object)f.getName());
        Assert.assertEquals((Object)"/org/organizationUnit", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }
}

