/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.json.core.JsonFieldReader;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.FieldType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JsonFieldReaderTest {
    private static JsonFieldReader reader = new JsonFieldReader((AtlasConversionService)DefaultAtlasConversionService.getInstance());

    @Test(expected=AtlasException.class)
    public void testWithNullDocument() throws Exception {
        reader.setDocument(null);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)AtlasJsonModelFactory.createJsonField());
        reader.read(session);
    }

    @Test(expected=AtlasException.class)
    public void testWithEmptyDocument() throws Exception {
        reader.setDocument("");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)AtlasJsonModelFactory.createJsonField());
        reader.read(session);
    }

    @Test(expected=AtlasException.class)
    public void testWithNullJsonField() throws Exception {
        reader.setDocument("{qwerty : ytrewq}");
        reader.read((AtlasInternalSession)Mockito.mock(AtlasInternalSession.class));
    }

    @Test
    public void testSimpleJsonDocument() throws Exception {
        String document = "   { \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        reader.setDocument("   { \"brand\" : \"Mercedes\", \"doors\" : 5 }");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/brand");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        field.setFieldType(null);
        field.setPath("/doors");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void testSimpleJsonDocumentWithRoot() throws Exception {
        String document = " {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        reader.setDocument(" {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/car/doors");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)5));
        this.resetField(field);
        field.setPath("/car/brand");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Mercedes"));
    }

    @Test
    public void testComplexJsonDocumentNestedObjectArray() throws Exception {
        String document = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        reader.setDocument("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}");
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/menu/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"file"));
        field.setPath("/menu/value");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Filed"));
        field.setPath("/menu/popup/menuitem[0]/value");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"New"));
        field.setPath("/menu/popup/menuitem[0]/onclick");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"CreateNewDoc()"));
        field.setPath("/menu/popup/menuitem[1]/value");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Open"));
        field.setPath("/menu/popup/menuitem[1]/onclick");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"OpenDoc()"));
        field.setPath("/menu/popup/menuitem[2]/value");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Close"));
        field.setPath("/menu/popup/menuitem[2]/onclick");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"CloseDoc()"));
    }

    @Test
    public void testComplexJsonDocumentHighlyNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-nested-object.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0001"));
        this.resetField(field);
        field.setPath("/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Cake"));
        this.resetField(field);
        field.setPath("/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/batters/batter[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/batters/batter[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/batters/batter[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1002"));
        this.resetField(field);
        field.setPath("/batters/batter[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/batters/batter[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1003"));
        this.resetField(field);
        field.setPath("/batters/batter[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        this.resetField(field);
        field.setPath("/batters/batter[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1004"));
        this.resetField(field);
        field.setPath("/batters/batter[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        this.resetField(field);
        field.setPath("/topping[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/topping[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/topping[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/topping[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/topping[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/topping[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/topping[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5007"));
        this.resetField(field);
        field.setPath("/topping[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Powdered Sugar"));
        this.resetField(field);
        field.setPath("/topping[4]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5006"));
        this.resetField(field);
        field.setPath("/topping[4]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate with Sprinkles"));
        this.resetField(field);
        field.setPath("/topping[5]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/topping[5]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/topping[6]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/topping[6]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
    }

    @Test
    public void testComplexJsonDocumentHighlyComplexNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-complex-nested-object.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/items/item[0]/id");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0001"));
        this.resetField(field);
        field.setPath("/items/item[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item[0]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Cake"));
        this.resetField(field);
        field.setPath("/items/item[0]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1002"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1003"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1004"));
        this.resetField(field);
        field.setPath("/items/item[0]/batters/batter[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5007"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Powdered Sugar"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[4]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5006"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[4]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate with Sprinkles"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[5]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[5]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[6]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/items/item[0]/topping[6]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
        field.setPath("/items/item[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0002"));
        this.resetField(field);
        field.setPath("/items/item[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item[1]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Raised"));
        this.resetField(field);
        field.setPath("/items/item[1]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[0]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[0]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[1]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[1]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[4]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[4]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping[5]/id");
        reader.read(session);
        Assert.assertNull((Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0003"));
        this.resetField(field);
        field.setPath("/items/item[2]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item[2]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Old Fashioned"));
        this.resetField(field);
        field.setPath("/items/item[2]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item[3]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0004"));
        this.resetField(field);
        field.setPath("/items/item[3]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"bar"));
        this.resetField(field);
        field.setPath("/items/item[3]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Bar"));
        this.resetField(field);
        field.setPath("/items/item[3]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.75));
        this.resetField(field);
        field.setPath("/items/item[4]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0005"));
        this.resetField(field);
        field.setPath("/items/item[4]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"twist"));
        this.resetField(field);
        field.setPath("/items/item[4]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Twist"));
        this.resetField(field);
        field.setPath("/items/item[4]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.65));
        this.resetField(field);
        field.setPath("/items/item[5]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0006"));
        this.resetField(field);
        field.setPath("/items/item[5]/type");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"filled"));
        this.resetField(field);
        field.setPath("/items/item[5]/name");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Filled"));
        this.resetField(field);
        field.setPath("/items/item[5]/ppu");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.75));
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[2]/id");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"7004"));
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[3]/addcost");
        reader.read(session);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0));
        this.resetField(field);
    }

    @Test
    public void testSameFieldNameInDifferentPath() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/same-field-name-in-different-path.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/name");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertEquals((Object)"name", (Object)field.getValue());
        field.setPath("/object1/name");
        reader.read(session);
        Assert.assertEquals((Object)"object1-name", (Object)field.getValue());
        field.setPath("/object2/name");
        reader.read(session);
        Assert.assertEquals((Object)"object2-name", (Object)field.getValue());
        field.setPath("/object1/object2/name");
        reader.read(session);
        Assert.assertEquals((Object)"object1-object2-name", (Object)field.getValue());
    }

    @Test
    public void testArrayUnderRoot() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/array-under-root.json", new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/array[0]");
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        reader.read(session);
        Assert.assertEquals((Object)"array-zero", (Object)field.getValue());
        field.setPath("/array[1]");
        reader.read(session);
        Assert.assertEquals((Object)"array-one", (Object)field.getValue());
        field.setPath("/array[2]");
        reader.read(session);
        Assert.assertEquals((Object)"array-two", (Object)field.getValue());
    }

    private void resetField(JsonField field) {
        field.setPath(null);
        field.setValue(null);
        field.setFieldType(null);
    }

    private AtlasInternalSession testBoundaryValue(String fileName, String fieldPath, FieldType fieldType, Object expectedObject) throws Exception {
        String filePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jsonFields" + File.separator + fileName;
        String document = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath(fieldPath);
        field.setFieldType(fieldType);
        AtlasInternalSession session = this.read(field);
        Assert.assertEquals((Object)expectedObject, (Object)field.getValue());
        return session;
    }

    @Test
    public void testJsonFieldDoubleMax() throws Exception {
        this.testBoundaryValue("field-double-max.json", "/doubleValue", FieldType.DOUBLE, Double.MAX_VALUE);
    }

    @Test
    public void testJsonFieldDoubleMin() throws Exception {
        this.testBoundaryValue("field-double-min.json", "/doubleValue", FieldType.DOUBLE, Double.MIN_VALUE);
    }

    @Test
    public void testJsonFieldFloatMax() throws Exception {
        this.testBoundaryValue("field-float-max.json", "/floatValue", FieldType.FLOAT, Float.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testJsonFieldFloatMin() throws Exception {
        this.testBoundaryValue("field-float-min.json", "/floatValue", FieldType.FLOAT, Float.valueOf(Float.MIN_VALUE));
    }

    @Test
    public void testJsonFieldLongMax() throws Exception {
        this.testBoundaryValue("field-long-max.json", "/longValue", FieldType.LONG, Long.MAX_VALUE);
    }

    @Test
    public void testJsonFieldLongMin() throws Exception {
        this.testBoundaryValue("field-long-min.json", "/longValue", FieldType.LONG, Long.MIN_VALUE);
    }

    @Test
    public void testJsonFieldIntegerMax() throws Exception {
        this.testBoundaryValue("field-integer-max.json", "/integerValue", FieldType.INTEGER, Integer.MAX_VALUE);
    }

    @Test
    public void testJsonFieldIntegerMin() throws Exception {
        this.testBoundaryValue("field-integer-min.json", "/integerValue", FieldType.INTEGER, Integer.MIN_VALUE);
    }

    @Test
    public void testJsonFieldShortMax() throws Exception {
        this.testBoundaryValue("field-short-max.json", "/shortValue", FieldType.SHORT, (short)Short.MAX_VALUE);
    }

    @Test
    public void testJsonFieldShortMin() throws Exception {
        this.testBoundaryValue("field-short-min.json", "/shortValue", FieldType.SHORT, (short)Short.MIN_VALUE);
    }

    @Test
    public void testJsonFieldCharMax() throws Exception {
        this.testBoundaryValue("field-char-max.json", "/charValue", FieldType.CHAR, Character.valueOf('\uffff'));
    }

    @Test
    public void testJsonFieldCharMin() throws Exception {
        this.testBoundaryValue("field-char-min.json", "/charValue", FieldType.CHAR, Character.valueOf('\u0000'));
    }

    @Test
    public void testJsonFieldByteMax() throws Exception {
        this.testBoundaryValue("field-byte-max.json", "/byteValue", FieldType.BYTE, (byte)127);
    }

    @Test
    public void testJsonFieldByteMin() throws Exception {
        this.testBoundaryValue("field-byte-min.json", "/byteValue", FieldType.BYTE, (byte)-128);
    }

    @Test
    public void testJsonFieldBooleanTrue() throws Exception {
        this.testBoundaryValue("field-boolean-true.json", "/booleanValue", FieldType.BOOLEAN, Boolean.TRUE);
    }

    @Test
    public void testJsonFieldBooleanFalse() throws Exception {
        this.testBoundaryValue("field-boolean-false.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldStringNonEmpty() throws Exception {
        this.testBoundaryValue("field-string-nonempty.json", "/stringValue", FieldType.STRING, "testString");
    }

    @Test
    public void testJsonFieldStringNull() throws Exception {
        this.testBoundaryValue("field-string-null.json", "/stringValue", FieldType.STRING, null);
    }

    @Test
    public void testJsonFieldStringEmpty() throws Exception {
        this.testBoundaryValue("field-string-empty.json", "/stringValue", FieldType.STRING, "");
    }

    @Test
    public void testJsonFieldStringNonExist() throws Exception {
        this.testBoundaryValue("field-string-nonexist.json", "/stringValue", FieldType.STRING, null);
    }

    private AtlasInternalSession read(JsonField field) throws AtlasException {
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        reader.read(session);
        return session;
    }

    private void testRangeOutValue(String fileName, String fieldPath, FieldType fieldType, String errorMessage, String errorValue) throws Exception {
        String filePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator + "jsonFields" + File.separator + fileName;
        String document = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        reader.setDocument(document);
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath(fieldPath);
        field.setFieldType(fieldType);
        AtlasInternalSession session = this.read(field);
        Assert.assertEquals(null, (Object)field.getValue());
        Assert.assertEquals((long)1L, (long)session.getAudits().getAudit().size());
        Assert.assertEquals((Object)errorMessage, (Object)((Audit)session.getAudits().getAudit().get(0)).getMessage());
        Assert.assertEquals((Object)errorValue, (Object)((Audit)session.getAudits().getAudit().get(0)).getValue());
        Assert.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
    }

    @Test
    public void testJsonFieldDoubleMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-double-max-range-out.json", "/doubleValue", FieldType.DOUBLE, "Failed to convert field value 'Infinity' into type 'DOUBLE'", "Infinity");
    }

    @Test
    public void testJsonFieldDoubleMinRangeOut() throws Exception {
        AtlasInternalSession session = this.testBoundaryValue("field-double-min-range-out.json", "/doubleValue", FieldType.DOUBLE, 0.0);
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }

    @Test
    public void testJsonFieldFloatMaxRangOut() throws Exception {
        this.testRangeOutValue("field-float-max-range-out.json", "/floatValue", FieldType.FLOAT, "Failed to convert field value '3.4028235E39' into type 'FLOAT'", "3.4028235E39");
    }

    @Test
    public void testJsonFieldFloatMinRangOut() throws Exception {
        AtlasInternalSession session = this.testBoundaryValue("field-float-min-range-out.json", "/floatValue", FieldType.FLOAT, Float.valueOf(0.0f));
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }

    @Test
    public void testJsonFieldLongMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-long-max-range-out.json", "/longValue", FieldType.LONG, "Failed to convert field value '9223372036854775808' into type 'LONG'", "9223372036854775808");
    }

    @Test
    public void testJsonFieldLongMinRangeOut() throws Exception {
        this.testRangeOutValue("field-long-min-range-out.json", "/longValue", FieldType.LONG, "Failed to convert field value '-9223372036854775809' into type 'LONG'", "-9223372036854775809");
    }

    @Test
    public void testJsonFieldIntegerMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-integer-max-range-out.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '2147483648' into type 'INTEGER'", "2147483648");
    }

    @Test
    public void testJsonFieldIntegerMinRangeOut() throws Exception {
        this.testRangeOutValue("field-integer-min-range-out.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '-2147483649' into type 'INTEGER'", "-2147483649");
    }

    @Test
    public void testJsonFieldShortMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-short-max-range-out.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '32768' into type 'SHORT'", "32768");
    }

    @Test
    public void testJsonFieldShortMinRangeOut() throws Exception {
        this.testRangeOutValue("field-short-min-range-out.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '-32769' into type 'SHORT'", "-32769");
    }

    @Test
    public void testJsonFieldCharMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-char-max-range-out.json", "/charValue", FieldType.CHAR, "Failed to convert field value '65536' into type 'CHAR'", "65536");
    }

    @Test
    public void testJsonFieldCharMinRangeOut() throws Exception {
        this.testRangeOutValue("field-char-min-range-out.json", "/charValue", FieldType.CHAR, "Failed to convert field value '-1' into type 'CHAR'", "-1");
    }

    @Test
    public void testJsonFieldByteMaxRangeOut() throws Exception {
        this.testRangeOutValue("field-byte-max-range-out.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '128' into type 'BYTE'", "128");
    }

    @Test
    public void testJsonFieldByteMinRangeOut() throws Exception {
        this.testRangeOutValue("field-byte-min-range-out.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '-129' into type 'BYTE'", "-129");
    }

    @Test
    public void testJsonFieldBooleanRangeOut() throws Exception {
        this.testBoundaryValue("field-boolean-range-out.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithLetterF() throws Exception {
        this.testBoundaryValue("field-boolean-with-letterF.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithBlankString() throws Exception {
        this.testBoundaryValue("field-boolean-with-blank-string.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithNull() throws Exception {
        this.testBoundaryValue("field-boolean-with-null.json", "/booleanValue", FieldType.BOOLEAN, null);
    }

    @Test
    public void testJsonFieldBooleanWithNumber0() throws Exception {
        this.testBoundaryValue("field-boolean-with-number0.json", "/booleanValue", FieldType.BOOLEAN, Boolean.FALSE);
    }

    @Test
    public void testJsonFieldBooleanWithNumber1() throws Exception {
        this.testBoundaryValue("field-boolean-with-number1.json", "/booleanValue", FieldType.BOOLEAN, Boolean.TRUE);
    }

    @Test
    public void testJsonFieldLongDecimal() throws Exception {
        this.testRangeOutValue("field-long-decimal.json", "/longValue", FieldType.LONG, "Failed to convert field value '9.223372036854776E18' into type 'LONG'", "9.223372036854776E18");
    }

    @Test
    public void testJsonFieldIntegerDecimal() throws Exception {
        this.testRangeOutValue("field-integer-decimal.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value '2.1474836471234E9' into type 'INTEGER'", "2.1474836471234E9");
    }

    @Test
    public void testJsonFieldShortDecimal() throws Exception {
        this.testRangeOutValue("field-short-decimal.json", "/shortValue", FieldType.SHORT, "Failed to convert field value '32767.1234' into type 'SHORT'", "32767.1234");
    }

    @Test
    public void testJsonFieldCharDecimal() throws Exception {
        this.testRangeOutValue("field-char-decimal.json", "/charValue", FieldType.CHAR, "Failed to convert field value '65535.1234' into type 'CHAR'", "65535.1234");
    }

    @Test
    public void testJsonFieldByteDecimal() throws Exception {
        this.testRangeOutValue("field-byte-decimal.json", "/byteValue", FieldType.BYTE, "Failed to convert field value '127.1234' into type 'BYTE'", "127.1234");
    }

    @Test
    public void testJsonFieldDoubleString() throws Exception {
        this.testRangeOutValue("field-double-string.json", "/doubleValue", FieldType.DOUBLE, "Failed to convert field value 'abcd' into type 'DOUBLE'", "abcd");
    }

    @Test
    public void testJsonFieldFloatString() throws Exception {
        this.testRangeOutValue("field-float-string.json", "/floatValue", FieldType.FLOAT, "Failed to convert field value 'abcd' into type 'FLOAT'", "abcd");
    }

    @Test
    public void testJsonFieldLongString() throws Exception {
        this.testRangeOutValue("field-long-string.json", "/longValue", FieldType.LONG, "Failed to convert field value 'abcd' into type 'LONG'", "abcd");
    }

    @Test
    public void testJsonFieldIntegerString() throws Exception {
        this.testRangeOutValue("field-integer-string.json", "/integerValue", FieldType.INTEGER, "Failed to convert field value 'abcd' into type 'INTEGER'", "abcd");
    }

    @Test
    public void testJsonFieldShortString() throws Exception {
        this.testRangeOutValue("field-short-string.json", "/shortValue", FieldType.SHORT, "Failed to convert field value 'abcd' into type 'SHORT'", "abcd");
    }

    @Test
    public void testJsonFieldCharString() throws Exception {
        this.testRangeOutValue("field-char-string.json", "/charValue", FieldType.CHAR, "Failed to convert field value 'abcd' into type 'CHAR'", "abcd");
    }

    @Test
    public void testJsonFieldByteString() throws Exception {
        this.testRangeOutValue("field-byte-string.json", "/byteValue", FieldType.BYTE, "Failed to convert field value 'abcd' into type 'BYTE'", "abcd");
    }
}

