/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspector;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.json.v2.JsonFields;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceInspector
implements JsonInspector {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInspector.class);
    private static InstanceInspector myself = new InstanceInspector();

    private InstanceInspector() {
    }

    public static InstanceInspector instance() {
        return myself;
    }

    @Override
    public JsonDocument inspect(String instance) throws JsonInspectionException {
        if (instance == null || instance.isEmpty()) {
            throw new IllegalArgumentException("JSON instance cannot be null");
        }
        try {
            JsonDocument jsonDocument = AtlasJsonModelFactory.createJsonDocument();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(instance);
            if (rootNode.isArray()) {
                JsonComplexType field = new JsonComplexType();
                field.setJsonFields(new JsonFields());
                field.setStatus(FieldStatus.UNSUPPORTED);
                field.setCollectionType(CollectionType.ARRAY);
                field.setValue((Object)rootNode.toString());
                jsonDocument.getFields().getField().add(field);
            } else if (rootNode.isObject()) {
                Iterator nodes = rootNode.fields();
                while (nodes.hasNext()) {
                    JsonComplexType parent;
                    Map.Entry entry = (Map.Entry)nodes.next();
                    if (((JsonNode)entry.getValue()).isObject()) {
                        logger.trace("NODE IS AN OBJECT --> " + (String)entry.getKey() + " WITH ---> " + ((JsonNode)entry.getValue()).size() + " FIELDS");
                        parent = this.getJsonComplexTypeFromEntry(entry);
                        jsonDocument.getFields().getField().add(parent);
                        this.handleObjectNode(jsonDocument, (JsonNode)entry.getValue(), parent, 0);
                        continue;
                    }
                    if (((JsonNode)entry.getValue()).isArray()) {
                        logger.trace("NODE IS AN ARRAY --> " + (String)entry.getKey() + " WITH ---> " + ((JsonNode)entry.getValue()).size() + " CHILDREN");
                        parent = this.getJsonComplexTypeFromEntry(entry);
                        parent.setCollectionType(CollectionType.ARRAY);
                        jsonDocument.getFields().getField().add(parent);
                        this.handleArrayNode(jsonDocument, (ArrayNode)entry.getValue(), parent, (String)entry.getKey(), 0);
                        continue;
                    }
                    if (!((JsonNode)entry.getValue()).isValueNode()) continue;
                    logger.trace("NODE IS A VALUE --> " + (String)entry.getKey() + " WITH ---> " + ((JsonNode)entry.getValue()).size() + " CHILDREN");
                    this.handleValueEntry(jsonDocument, entry, null, 0);
                }
            }
            return jsonDocument;
        }
        catch (IOException e) {
            throw new JsonInspectionException(e);
        }
    }

    private void handleArrayNode(JsonDocument jsonDocument, ArrayNode aNode, JsonComplexType parent, String aKey, int index) throws IOException {
        if (aNode.get(0).isObject()) {
            logger.trace("ARRAY OF OBJECTS WITH PARENT ---> " + parent.getName().concat(String.valueOf(index)) + " WITH KEY ----> " + aKey + " AND SIZE OF ---> " + aNode.size());
            int childIndex = 0;
            JsonComplexType childObject = null;
            if (!aKey.equals(parent.getName())) {
                childObject = this.getJsonComplexType(parent, aKey, index);
                childObject.setCollectionType(CollectionType.LIST);
            }
            for (JsonNode jsonNode : aNode) {
                if (childObject != null) {
                    this.handleObjectNode(jsonDocument, jsonNode, childObject, childIndex);
                } else {
                    this.handleObjectNode(jsonDocument, jsonNode, parent, index);
                }
                ++childIndex;
                ++index;
            }
        } else if (aNode.get(0).isArray()) {
            logger.trace("**TODO** > HANDLE ARRAY OF AN ARRAY WITH PARENT ---> " + parent.getName() + " WITH KEY ----> " + aKey);
        } else if (aNode.get(0).isValueNode()) {
            logger.trace("**TODO** > HANDLE ARRAY OF A VALUES WITH PARENT ---> " + parent.getName() + " WITH KEY ----> " + aKey);
        }
    }

    private void handleObjectNode(JsonDocument jsonDocument, JsonNode jsonNode, JsonComplexType parent, int index) throws IOException {
        logger.trace("HANDLING AN OBJECT NODE " + (String)((Map.Entry)jsonNode.fields().next()).getKey() + " WITH PARENT ---> " + parent.getName() + " WITH INDEX OF " + index);
        Iterator fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry next = (Map.Entry)fields.next();
            String key = (String)next.getKey();
            JsonNode node = (JsonNode)next.getValue();
            if (node.isValueNode()) {
                this.handleValueEntry(jsonDocument, next, parent, index);
                continue;
            }
            if (node.isObject()) {
                logger.trace("FOUND AN OBJECT NODE THAT IS A CONTAINER WITH KEY --> " + key + " WITH A PARENT INDEX OF " + index);
                JsonComplexType container = this.getJsonComplexType(parent, key, index);
                this.handleObjectNode(jsonDocument, (JsonNode)next.getValue(), container, 0);
                continue;
            }
            if (!node.isArray() || !node.get(0).isObject()) continue;
            ArrayNode arrayNode = (ArrayNode)node;
            int innerIndex = 0;
            JsonComplexType deeperChild = this.getJsonComplexType(parent, key, index);
            if (parent.getCollectionType() == null) {
                deeperChild.setCollectionType(CollectionType.LIST);
            } else {
                deeperChild.setCollectionType(CollectionType.ARRAY);
            }
            for (JsonNode deeperJsonNode : arrayNode) {
                this.handleObjectNode(jsonDocument, deeperJsonNode, deeperChild, innerIndex);
                ++innerIndex;
            }
        }
    }

    private void handleValueEntry(JsonDocument jsonDocument, Map.Entry<String, JsonNode> jsonNodeEntry, JsonComplexType parent, int index) {
        JsonNode theNode = jsonNodeEntry.getValue();
        String nodeKey = jsonNodeEntry.getKey();
        JsonField field = AtlasJsonModelFactory.createJsonField();
        if (nodeKey != null) {
            field.setName(nodeKey);
            if (parent != null) {
                logger.trace("HANDLING AN VALUE NODE WITH PARENT ---> " + parent.getName() + " WITH INDEX OF " + index);
                if (index > 0 && parent.getCollectionType() != null && parent.getCollectionType().compareTo((Enum)CollectionType.ARRAY) == 0) {
                    field.setPath(parent.getPath().concat("/").concat(nodeKey).concat("[").concat(String.valueOf(index)).concat("]"));
                } else if (index > 0 && parent.getCollectionType() != null && parent.getCollectionType().compareTo((Enum)CollectionType.LIST) == 0) {
                    field.setPath(parent.getPath().concat("[").concat(String.valueOf(index)).concat("]/").concat(nodeKey));
                } else {
                    field.setPath(parent.getPath().concat("/").concat(nodeKey));
                }
            } else {
                logger.trace("HANDLING AN VALUE NODE WITH NO PARENT WITH INDEX OF " + index);
                field.setPath("/".concat(nodeKey));
            }
        }
        this.setNodeValueOnField(theNode, field);
        if (parent == null) {
            jsonDocument.getFields().getField().add(field);
        } else {
            parent.getJsonFields().getJsonField().add(field);
        }
    }

    private void setNodeValueOnField(JsonNode valueNode, JsonField field) {
        logger.trace("VALUE IS A " + valueNode.getNodeType().name());
        if (valueNode.isNumber()) {
            if (valueNode.isInt()) {
                field.setFieldType(FieldType.INTEGER);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.intValue());
            } else if (valueNode.isBigInteger()) {
                field.setFieldType(FieldType.INTEGER);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.bigIntegerValue());
            } else if (valueNode.isFloat()) {
                field.setFieldType(FieldType.FLOAT);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)Float.valueOf(valueNode.floatValue()));
            } else if (valueNode.isDouble()) {
                field.setFieldType(FieldType.DOUBLE);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.asDouble());
            } else if (valueNode.isBigDecimal()) {
                field.setFieldType(FieldType.DECIMAL);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.decimalValue());
            } else if (valueNode.isShort()) {
                field.setFieldType(FieldType.SHORT);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.shortValue());
            } else if (valueNode.isLong()) {
                field.setFieldType(FieldType.LONG);
                field.setStatus(FieldStatus.SUPPORTED);
                field.setValue((Object)valueNode.longValue());
            }
        } else if (valueNode.isTextual()) {
            field.setFieldType(FieldType.STRING);
            field.setStatus(FieldStatus.SUPPORTED);
            field.setValue((Object)valueNode.textValue());
        } else if (valueNode.isBoolean()) {
            field.setFieldType(FieldType.BOOLEAN);
            field.setStatus(FieldStatus.SUPPORTED);
            field.setValue((Object)valueNode.booleanValue());
        } else if (valueNode.isBinary() || valueNode.isPojo()) {
            field.setFieldType(FieldType.UNSUPPORTED);
            field.setStatus(FieldStatus.UNSUPPORTED);
        }
    }

    private JsonComplexType getJsonComplexType(JsonComplexType parent, String aKey, int index) {
        JsonComplexType jsonComplexType = new JsonComplexType();
        jsonComplexType.setJsonFields(new JsonFields());
        jsonComplexType.setName(aKey);
        jsonComplexType.setFieldType(FieldType.COMPLEX);
        jsonComplexType.setStatus(FieldStatus.SUPPORTED);
        if (index > 0) {
            jsonComplexType.setPath(parent.getPath().concat("[").concat(String.valueOf(index)).concat("]/").concat(aKey));
        } else {
            jsonComplexType.setPath(parent.getPath().concat("/").concat(aKey));
        }
        parent.getJsonFields().getJsonField().add(jsonComplexType);
        return jsonComplexType;
    }

    private JsonComplexType getJsonComplexTypeFromEntry(Map.Entry<String, JsonNode> entry) {
        JsonComplexType parent = new JsonComplexType();
        parent.setJsonFields(new JsonFields());
        parent.setFieldType(FieldType.COMPLEX);
        parent.setName(entry.getKey());
        parent.setStatus(FieldStatus.SUPPORTED);
        parent.setPath("/".concat(entry.getKey()));
        return parent;
    }
}

