/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.atlasmap.api.AtlasException;
import io.atlasmap.core.PathUtil;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldWriter {
    private static final Logger logger = LoggerFactory.getLogger(JsonFieldWriter.class);
    private ObjectMapper objectMapper = null;
    private ObjectNode rootNode = null;

    public JsonFieldWriter() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        this.rootNode = this.objectMapper.createObjectNode();
    }

    public JsonFieldWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.rootNode = objectMapper.createObjectNode();
    }

    public ObjectNode getRootNode() {
        return this.rootNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void write(Field field) throws AtlasException {
        if (field == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Field: " + AtlasModelFactory.toString((Field)field));
            logger.debug("Field type=" + field.getFieldType() + " path=" + field.getPath() + " v=" + field.getValue());
        }
        PathUtil path = new PathUtil(field.getPath());
        String lastSegment = path.getLastSegment();
        ObjectNode parentNode = this.rootNode;
        String parentSegment = null;
        for (String segment : path.getSegments()) {
            if (segment != lastSegment) {
                JsonNode childNode;
                if (logger.isDebugEnabled()) {
                    logger.debug("Now processing parent segment: " + segment);
                }
                if ((childNode = JsonFieldWriter.getChildNode(parentNode, parentSegment, segment)) == null) {
                    childNode = this.createParentNode(parentNode, parentSegment, segment);
                } else if (childNode instanceof ArrayNode) {
                    int index = PathUtil.indexOfSegment((String)segment);
                    ArrayNode arrayChild = (ArrayNode)childNode;
                    if (arrayChild.size() < index + 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                        }
                        while (arrayChild.size() < index + 1) {
                            arrayChild.addObject();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Object Array after resizing: " + arrayChild);
                        }
                    }
                    childNode = arrayChild.get(index);
                }
                parentNode = (ObjectNode)childNode;
                parentSegment = segment;
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Now processing field value segment: " + segment);
            }
            this.writeValue(parentNode, parentSegment, segment, field);
        }
    }

    public void writeValue(ObjectNode parentNode, String parentSegment, String segment, Field field) throws AtlasException {
        if (logger.isDebugEnabled()) {
            logger.debug("Writing field value '" + segment + "' in parent node '" + parentSegment + "', parentNode: " + parentNode);
        }
        JsonNode valueNode = this.createValueNode(field);
        if (logger.isDebugEnabled()) {
            logger.debug("Value to write: " + valueNode);
        }
        String cleanedSegment = PathUtil.cleanPathSegment((String)segment);
        if (PathUtil.isCollectionSegment((String)segment).booleanValue()) {
            ArrayNode arrayChild;
            if (logger.isDebugEnabled()) {
                logger.debug("Field type is collection. Fetching array '" + segment + "' from parent '" + parentSegment + "': " + parentNode);
            }
            if ((arrayChild = (ArrayNode)JsonFieldWriter.getChildNode(parentNode, parentSegment, segment)) == null) {
                arrayChild = parentNode.putArray(cleanedSegment);
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not find array to place value in, created it in parent: " + parentNode);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Array before placing value: " + arrayChild);
            }
            int index = PathUtil.indexOfSegment((String)segment);
            if (arrayChild.size() < index + 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Value Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addNull();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Value Array after resizing: " + arrayChild);
                }
            }
            arrayChild.set(index, valueNode);
        } else {
            parentNode.replace(cleanedSegment, valueNode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parent node after value written: " + parentNode);
        }
    }

    public static JsonNode getChildNode(ObjectNode parentNode, String parentSegment, String segment) {
        String cleanedSegment;
        JsonNode childNode;
        if (logger.isDebugEnabled()) {
            logger.debug("Looking for child node '" + segment + "' in parent '" + parentSegment + "': " + parentNode);
        }
        if (JsonNodeType.MISSING.equals((Object)(childNode = parentNode.path(cleanedSegment = PathUtil.cleanPathSegment((String)segment))).getNodeType())) {
            childNode = null;
        }
        if (logger.isDebugEnabled()) {
            if (childNode == null) {
                logger.debug("Could not find child node '" + segment + "' in parent '" + parentSegment + "'.");
            } else {
                logger.debug("Found child node '" + segment + "' in parent '" + parentSegment + "', class: " + childNode.getClass().getName() + ", node: " + childNode);
            }
        }
        return childNode;
    }

    public ObjectNode createParentNode(ObjectNode parentNode, String parentSegment, String segment) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating parent node '" + segment + "' under previous parent '" + parentSegment + "' (" + parentNode.getClass().getName() + ")");
        }
        ObjectNode childNode = null;
        String cleanedSegment = PathUtil.cleanPathSegment((String)segment);
        if (PathUtil.isCollectionSegment((String)segment).booleanValue()) {
            ArrayNode arrayChild = parentNode.putArray(cleanedSegment);
            int index = PathUtil.indexOfSegment((String)segment);
            if (arrayChild.size() < index + 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Object Array is too small, resizing to accomodate index: " + index + ", current array: " + arrayChild);
                }
                while (arrayChild.size() < index + 1) {
                    arrayChild.addObject();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Object Array after resizing: " + arrayChild);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Created wrapper parent array node '" + segment + "': " + arrayChild);
            }
            childNode = (ObjectNode)arrayChild.get(index);
        } else {
            childNode = parentNode.putObject(cleanedSegment);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parent Node '" + parentSegment + "' after adding child parent node '" + segment + "':" + parentNode);
        }
        return childNode;
    }

    public JsonNode createValueNode(Field jsonField) throws AtlasException {
        FieldType type = jsonField.getFieldType();
        Object value = jsonField.getValue();
        TextNode valueNode = null;
        if (FieldType.STRING.equals((Object)type)) {
            valueNode = this.rootNode.textNode(String.valueOf(value));
        } else if (FieldType.CHAR.equals((Object)type)) {
            valueNode = this.rootNode.textNode(Character.toString(((Character)value).charValue()));
        } else if (FieldType.BOOLEAN.equals((Object)type)) {
            valueNode = this.rootNode.booleanNode(((Boolean)value).booleanValue());
        } else if (FieldType.INTEGER.equals((Object)type)) {
            valueNode = this.rootNode.numberNode((Integer)value);
        } else if (FieldType.DOUBLE.equals((Object)type) || FieldType.FLOAT.equals((Object)type)) {
            valueNode = this.rootNode.numberNode(new BigDecimal(String.valueOf(value)));
        } else if (FieldType.SHORT.equals((Object)type)) {
            valueNode = this.rootNode.numberNode(Short.valueOf(String.valueOf(value)));
        } else if (FieldType.LONG.equals((Object)type)) {
            valueNode = this.rootNode.numberNode(Long.valueOf(String.valueOf(value)));
        } else {
            throw new AtlasException("Cannot set value for " + jsonField.getPath() + " --> " + value + " for field type " + type);
        }
        if (logger.isDebugEnabled()) {
            String valueClass = value == null ? "null" : value.getClass().getName();
            logger.debug("Converted JsonField value to ValueNode. Type: " + type + ", value: " + value + "(" + valueClass + "), node class: " + valueNode.getClass().getName() + ", node: " + valueNode);
        }
        return valueNode;
    }
}

