/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasException;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFieldReader {
    private static final Logger logger = LoggerFactory.getLogger(JsonFieldReader.class);

    public void read(String document, JsonField jsonField) throws AtlasException {
        if (document == null || document.isEmpty()) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'document' cannot be null nor empty"));
        }
        if (jsonField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode valueNode = null;
        try {
            JsonParser parser = jsonFactory.createParser(document);
            JsonNode rootNode = (JsonNode)objectMapper.readTree(parser);
            String[] nodes = jsonField.getPath().replaceFirst("/", "").split("/");
            int index = 0;
            if (nodes.length == 1) {
                valueNode = rootNode.findValue(nodes[0]);
            } else if (nodes.length > 1) {
                valueNode = rootNode;
                for (String nodeName : nodes) {
                    if (nodeName.contains("[")) {
                        index = Integer.parseInt(nodeName.substring(nodeName.indexOf("[") + 1, nodeName.indexOf("]")));
                        nodeName = nodeName.substring(0, nodeName.indexOf("["));
                    }
                    if (nodeName.contains("<")) {
                        index = Integer.parseInt(nodeName.substring(nodeName.indexOf("<") + 1, nodeName.indexOf(">")));
                        nodeName = nodeName.substring(0, nodeName.indexOf("<"));
                    }
                    if (valueNode != null && valueNode.isArray() && index > 0) {
                        valueNode = valueNode.get(index);
                        index = 0;
                    }
                    if (valueNode == null) {
                        valueNode = null;
                        break;
                    }
                    valueNode = valueNode.findValue(nodeName);
                }
            }
            if (valueNode != null) {
                if (valueNode.isTextual()) {
                    if (jsonField.getFieldType() == null || FieldType.STRING.equals((Object)jsonField.getFieldType())) {
                        jsonField.setValue((Object)valueNode.textValue());
                        jsonField.setFieldType(FieldType.STRING);
                    } else if (FieldType.CHAR.equals((Object)jsonField.getFieldType())) {
                        jsonField.setValue((Object)Character.valueOf(valueNode.textValue().charAt(0)));
                    } else {
                        logger.warn(String.format("Unsupported FieldType for text data t=%s p=%s docId=%s", jsonField.getFieldType().value(), jsonField.getPath(), jsonField.getDocId()));
                    }
                } else if (valueNode.isNumber()) {
                    if (valueNode.isInt()) {
                        jsonField.setValue((Object)valueNode.intValue());
                        jsonField.setFieldType(FieldType.INTEGER);
                    } else if (valueNode.isDouble()) {
                        jsonField.setValue((Object)valueNode.doubleValue());
                        jsonField.setFieldType(FieldType.DOUBLE);
                    } else if (valueNode.isBigDecimal()) {
                        jsonField.setValue((Object)valueNode.decimalValue());
                        jsonField.setFieldType(FieldType.DECIMAL);
                    } else if (valueNode.isFloat()) {
                        jsonField.setValue((Object)Float.valueOf(valueNode.floatValue()));
                        jsonField.setFieldType(FieldType.DOUBLE);
                    } else if (valueNode.isLong()) {
                        jsonField.setValue((Object)valueNode.longValue());
                        jsonField.setFieldType(FieldType.LONG);
                    } else if (valueNode.isShort()) {
                        jsonField.setValue((Object)valueNode.shortValue());
                        jsonField.setFieldType(FieldType.SHORT);
                    } else if (valueNode.isBigInteger()) {
                        jsonField.setValue((Object)valueNode.bigIntegerValue());
                        jsonField.setFieldType(FieldType.NUMBER);
                    } else {
                        jsonField.setValue((Object)valueNode.numberValue());
                        jsonField.setFieldType(FieldType.NUMBER);
                    }
                } else if (valueNode.isBoolean()) {
                    jsonField.setValue((Object)valueNode.booleanValue());
                    jsonField.setFieldType(FieldType.BOOLEAN);
                } else if (valueNode.isContainerNode()) {
                    if (valueNode.isArray()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Detected json array p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
                        }
                        jsonField.setValue((Object)valueNode.toString());
                        jsonField.setFieldType(FieldType.COMPLEX);
                        jsonField.setCollectionType(CollectionType.ARRAY);
                    } else if (valueNode.isObject()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Detected json complex object p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
                        }
                        jsonField.setValue((Object)valueNode.toString());
                        jsonField.setFieldType(FieldType.COMPLEX);
                    }
                } else if (valueNode.isNull()) {
                    jsonField.setValue(null);
                } else {
                    logger.warn(String.format("Detected unsupported json type for field p=%s docId=%s", jsonField.getPath(), jsonField.getDocId()));
                    jsonField.setValue((Object)valueNode.toString());
                    jsonField.setFieldType(FieldType.UNSUPPORTED);
                }
            }
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Integer getCollectionCount(String document, JsonField jsonField, String collectionSegment) throws AtlasException {
        if (document == null || document.isEmpty()) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'document' cannot be null nor empty"));
        }
        if (jsonField == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'jsonField' cannot be null"));
        }
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonParser parser = jsonFactory.createParser(document);
            JsonNode rootNode = (JsonNode)objectMapper.readTree(parser);
            JsonNode collectionNode = rootNode.findValue(collectionSegment);
            if (collectionNode != null && collectionNode.isArray()) {
                return collectionNode.size();
            }
            return null;
        }
        catch (IOException e) {
            throw new AtlasException(e.getMessage(), (Throwable)e);
        }
    }
}

