/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonDocumentInspectionService;
import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaInspectorTest {
    private final JsonDocumentInspectionService inspectionService = new JsonDocumentInspectionService();

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchema_Empty() throws Exception {
        String schema = "";
        this.inspectionService.inspectJsonSchema("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchema_WhitespaceOnly() throws Exception {
        String schema = " ";
        this.inspectionService.inspectJsonSchema(" ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void inspectJsonSchema_Null() throws Exception {
        String schema = null;
        this.inspectionService.inspectJsonSchema(schema);
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonSchema_UnparseableMissingOpenCurly() throws Exception {
        String schema = "\"$schema\": \"http://json-schema.org/\"}";
        this.inspectionService.inspectJsonSchema("\"$schema\": \"http://json-schema.org/\"}");
    }

    @Test(expected=JsonInspectionException.class)
    public void inspectJsonSchema_UnparseableMissingClosingCurly() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"";
        this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\"");
    }

    @Test
    public void inspectJsonSchema_emptyDocument() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\"}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)0L, (long)document.getFields().getField().size());
    }

    @Test
    public void inspectJsonSchema_SimpleArray() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertEquals((Object)FieldStatus.UNSUPPORTED, (Object)jsonField.getStatus());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonSchema_SimpleString() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}");
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assert.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.SUPPORTED) == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)FieldType.STRING, (Object)jsonField.getFieldType());
        Assert.assertNull((Object)jsonField.getName());
        Assert.assertNull((Object)jsonField.getPath());
    }

    @Test
    public void inspectFlatPrimitive_NoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)5L, (long)document.getFields().getField().size());
        List fields = document.getFields().getField();
        JsonField field = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"booleanField", (Object)field.getName());
        Assert.assertEquals((Object)"/booleanField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"stringField", (Object)field.getName());
        Assert.assertEquals((Object)"/stringField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"numberField", (Object)field.getName());
        Assert.assertEquals((Object)"/numberField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"intField", (Object)field.getName());
        Assert.assertEquals((Object)"/intField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"nullField", (Object)field.getName());
        Assert.assertEquals((Object)"/nullField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectFlatPrimitive_WithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"SourceFlatPrimitive", (Object)root.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive", (Object)root.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)root.getStatus());
        Assert.assertEquals((long)5L, (long)root.getJsonFields().getJsonField().size());
        List fields = root.getJsonFields().getJsonField();
        JsonField field = (JsonField)fields.get(0);
        Assert.assertEquals((Object)"booleanField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/booleanField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assert.assertEquals((Object)"stringField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/stringField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assert.assertEquals((Object)"numberField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/numberField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assert.assertEquals((Object)"intField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/intField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assert.assertEquals((Object)"nullField", (Object)field.getName());
        Assert.assertEquals((Object)"/SourceFlatPrimitive/nullField", (Object)field.getPath());
        Assert.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectComplexObject_NoRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)3L, (long)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assert.assertEquals((Object)"/address/addressLine1", (Object)address1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assert.assertEquals((Object)"/address/addressLine2", (Object)address2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectComplexObject_WithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertEquals((long)3L, (long)root.getJsonFields().getJsonField().size());
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address1);
        Assert.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assert.assertEquals((Object)"/order/address/addressLine1", (Object)address1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)address2);
        Assert.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assert.assertEquals((Object)"/order/address/addressLine2", (Object)address2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/order/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/order/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/order/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/order/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/order/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/order/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/order/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/order/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectObjectArray_WithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-array-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)1L, (long)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)3L, (long)root.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"SourceOrderList", (Object)root.getName());
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)3L, (long)orders.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"orders", (Object)orders.getName());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)orders.getCollectionType());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)orders.getFieldType());
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)orderBatchNumber);
        Assert.assertEquals((Object)"orderBatchNumber", (Object)orderBatchNumber.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orderBatchNumber", (Object)orderBatchNumber.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderBatchNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderBatchNumber.getStatus());
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)numberOrders);
        Assert.assertEquals((Object)"numberOrders", (Object)numberOrders.getName());
        Assert.assertEquals((Object)"/SourceOrderList/numberOrders", (Object)numberOrders.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)numberOrders.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)numberOrders.getStatus());
        JsonComplexType address = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)address);
        Assert.assertEquals((long)5L, (long)address.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"address", (Object)address.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address", (Object)address.getPath());
        JsonField addressLine1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)addressLine1);
        Assert.assertEquals((Object)"addressLine1", (Object)addressLine1.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/addressLine1", (Object)addressLine1.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)addressLine1.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine1.getStatus());
        JsonField addressLine2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)addressLine2);
        Assert.assertEquals((Object)"addressLine2", (Object)addressLine2.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/addressLine2", (Object)addressLine2.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)addressLine2.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)city);
        Assert.assertEquals((Object)"city", (Object)city.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/city", (Object)city.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)state);
        Assert.assertEquals((Object)"state", (Object)state.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/state", (Object)state.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assert.assertNotNull((Object)postalCode);
        Assert.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/address/zipCode", (Object)postalCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)contact);
        Assert.assertEquals((long)4L, (long)contact.getJsonFields().getJsonField().size());
        Assert.assertEquals((Object)"contact", (Object)contact.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact", (Object)contact.getPath());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/firstName", (Object)firstName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)lastName);
        Assert.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/lastName", (Object)lastName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)phoneNumber);
        Assert.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assert.assertNotNull((Object)zipCode);
        Assert.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/contact/zipCode", (Object)zipCode.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)orders.getJsonFields().getJsonField().get(2);
        Assert.assertNotNull((Object)orderId);
        Assert.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assert.assertEquals((Object)"/SourceOrderList/orders/orderId", (Object)orderId.getPath());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)orderId.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectJsonSchema_ref() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/ref.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((long)3L, (long)document.getFields().getField().size());
        JsonComplexType ref_a = (JsonComplexType)document.getFields().getField().get(0);
        Assert.assertNotNull((Object)ref_a);
        Assert.assertEquals((Object)"ref-a", (Object)ref_a.getName());
        Assert.assertEquals((Object)"/ref-a", (Object)ref_a.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)ref_a.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ref_a.getStatus());
        JsonComplexType ref_b = (JsonComplexType)document.getFields().getField().get(1);
        Assert.assertNotNull((Object)ref_b);
        Assert.assertEquals((Object)"ref-b", (Object)ref_b.getName());
        Assert.assertEquals((Object)"/ref-b", (Object)ref_b.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)ref_b.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ref_b.getStatus());
        Assert.assertEquals((long)2L, (long)ref_b.getJsonFields().getJsonField().size());
        JsonComplexType ref_c_from_b = (JsonComplexType)ref_b.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)ref_c_from_b);
        Assert.assertEquals((Object)"ref-c-from-b", (Object)ref_c_from_b.getName());
        Assert.assertEquals((Object)"/ref-b/ref-c-from-b", (Object)ref_c_from_b.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)ref_c_from_b.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ref_c_from_b.getStatus());
        Assert.assertEquals((long)1L, (long)ref_c_from_b.getJsonFields().getJsonField().size());
        JsonField str_c_from_b = (JsonField)ref_c_from_b.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)str_c_from_b);
        Assert.assertEquals((Object)"str-c", (Object)str_c_from_b.getName());
        Assert.assertEquals((Object)"/ref-b/ref-c-from-b/str-c", (Object)str_c_from_b.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)str_c_from_b.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)str_c_from_b.getStatus());
        JsonField str_b = (JsonField)ref_b.getJsonFields().getJsonField().get(1);
        Assert.assertNotNull((Object)str_b);
        Assert.assertEquals((Object)"str-b", (Object)str_b.getName());
        Assert.assertEquals((Object)"/ref-b/str-b", (Object)str_b.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)str_b.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)str_b.getStatus());
        JsonComplexType ref_c = (JsonComplexType)document.getFields().getField().get(2);
        Assert.assertNotNull((Object)ref_c);
        Assert.assertEquals((Object)"ref-c", (Object)ref_c.getName());
        Assert.assertEquals((Object)"/ref-c", (Object)ref_c.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)ref_c.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)ref_c.getStatus());
        Assert.assertEquals((long)1L, (long)ref_c.getJsonFields().getJsonField().size());
        JsonField str_c = (JsonField)ref_c.getJsonFields().getJsonField().get(0);
        Assert.assertNotNull((Object)str_c);
        Assert.assertEquals((Object)"str-c", (Object)str_c.getName());
        Assert.assertEquals((Object)"/ref-c/str-c", (Object)str_c.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)str_c.getFieldType());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)str_c.getStatus());
    }

    @Test
    public void inspectJsonSchema_geo() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/geo.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonComplexType f = (JsonComplexType)fields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Test
    public void inspectJsonSchema_address() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/address.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonComplexType f = (JsonComplexType)fields.get(0);
        Assert.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assert.assertEquals((Object)"/post-office-box", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(1);
        Assert.assertEquals((Object)"extended-address", (Object)f.getName());
        Assert.assertEquals((Object)"/extended-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(2);
        Assert.assertEquals((Object)"street-address", (Object)f.getName());
        Assert.assertEquals((Object)"/street-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(3);
        Assert.assertEquals((Object)"locality", (Object)f.getName());
        Assert.assertEquals((Object)"/locality", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(4);
        Assert.assertEquals((Object)"region", (Object)f.getName());
        Assert.assertEquals((Object)"/region", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(5);
        Assert.assertEquals((Object)"postal-code", (Object)f.getName());
        Assert.assertEquals((Object)"/postal-code", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(6);
        Assert.assertEquals((Object)"country-name", (Object)f.getName());
        Assert.assertEquals((Object)"/country-name", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }

    @Ignore(value="internet access")
    @Test
    public void inspectJsonSchema_calendar_external() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar.json", new String[0])));
        this.doInspectJsonSchema_calendar(instance);
    }

    @Test
    public void inspectJsonSchema_calendar_internal() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-internal.json", new String[0])));
        this.doInspectJsonSchema_calendar(instance);
    }

    @Test
    public void inspectJsonSchema_calendar_inline() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-inline.json", new String[0])));
        this.doInspectJsonSchema_calendar(instance);
    }

    private void doInspectJsonSchema_calendar(String instance) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        List fields = document.getFields().getField();
        JsonComplexType f = (JsonComplexType)fields.get(0);
        Assert.assertEquals((Object)"dtstart", (Object)f.getName());
        Assert.assertEquals((Object)"/dtstart", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(1);
        Assert.assertEquals((Object)"dtend", (Object)f.getName());
        Assert.assertEquals((Object)"/dtend", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(2);
        Assert.assertEquals((Object)"summary", (Object)f.getName());
        Assert.assertEquals((Object)"/summary", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(3);
        Assert.assertEquals((Object)"location", (Object)f.getName());
        Assert.assertEquals((Object)"/location", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(4);
        Assert.assertEquals((Object)"url", (Object)f.getName());
        Assert.assertEquals((Object)"/url", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(5);
        Assert.assertEquals((Object)"duration", (Object)f.getName());
        Assert.assertEquals((Object)"/duration", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(6);
        Assert.assertEquals((Object)"rdate", (Object)f.getName());
        Assert.assertEquals((Object)"/rdate", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(7);
        Assert.assertEquals((Object)"rrule", (Object)f.getName());
        Assert.assertEquals((Object)"/rrule", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(8);
        Assert.assertEquals((Object)"category", (Object)f.getName());
        Assert.assertEquals((Object)"/category", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(9);
        Assert.assertEquals((Object)"description", (Object)f.getName());
        Assert.assertEquals((Object)"/description", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assert.assertEquals((Object)"geo", (Object)f.getName());
        Assert.assertEquals((Object)"/geo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)geofields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonComplexType)geofields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Ignore(value="internet access")
    @Test
    public void inspectJsonSchema_card_external() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card.json", new String[0])));
        this.doInspectJsonSchema_card(schema);
    }

    @Test
    public void inspectJsonSchema_card_internal() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-internal.json", new String[0])));
        this.doInspectJsonSchema_card(schema);
    }

    @Test
    public void inspectJsonSchema_card_inline() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-inline.json", new String[0])));
        this.doInspectJsonSchema_card(schema);
    }

    private void doInspectJsonSchema_card(String schema) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonComplexType f = (JsonComplexType)fields.get(0);
        Assert.assertEquals((Object)"fn", (Object)f.getName());
        Assert.assertEquals((Object)"/fn", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(1);
        Assert.assertEquals((Object)"familyName", (Object)f.getName());
        Assert.assertEquals((Object)"/familyName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(2);
        Assert.assertEquals((Object)"givenName", (Object)f.getName());
        Assert.assertEquals((Object)"/givenName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(3);
        Assert.assertEquals((Object)"additionalName", (Object)f.getName());
        Assert.assertEquals((Object)"/additionalName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonComplexType)fields.get(4);
        Assert.assertEquals((Object)"honorificPrefix", (Object)f.getName());
        Assert.assertEquals((Object)"/honorificPrefix", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonComplexType)fields.get(5);
        Assert.assertEquals((Object)"honorificSuffix", (Object)f.getName());
        Assert.assertEquals((Object)"/honorificSuffix", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonComplexType)fields.get(6);
        Assert.assertEquals((Object)"nickname", (Object)f.getName());
        Assert.assertEquals((Object)"/nickname", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(7);
        Assert.assertEquals((Object)"url", (Object)f.getName());
        Assert.assertEquals((Object)"/url", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(8);
        Assert.assertEquals((Object)"email", (Object)f.getName());
        Assert.assertEquals((Object)"/email", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List emailfields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)emailfields.get(0);
        Assert.assertEquals((Object)"type", (Object)f.getName());
        Assert.assertEquals((Object)"/email/type", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)emailfields.get(1);
        Assert.assertEquals((Object)"value", (Object)f.getName());
        Assert.assertEquals((Object)"/email/value", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(9);
        Assert.assertEquals((Object)"tel", (Object)f.getName());
        Assert.assertEquals((Object)"/tel", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List telfields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)telfields.get(0);
        Assert.assertEquals((Object)"type", (Object)f.getName());
        Assert.assertEquals((Object)"/tel/type", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)telfields.get(1);
        Assert.assertEquals((Object)"value", (Object)f.getName());
        Assert.assertEquals((Object)"/tel/value", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assert.assertEquals((Object)"adr", (Object)f.getName());
        Assert.assertEquals((Object)"/adr", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List addrfields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)addrfields.get(0);
        Assert.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/post-office-box", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(1);
        Assert.assertEquals((Object)"extended-address", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/extended-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(2);
        Assert.assertEquals((Object)"street-address", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/street-address", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(3);
        Assert.assertEquals((Object)"locality", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/locality", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(4);
        Assert.assertEquals((Object)"region", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/region", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(5);
        Assert.assertEquals((Object)"postal-code", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/postal-code", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)addrfields.get(6);
        Assert.assertEquals((Object)"country-name", (Object)f.getName());
        Assert.assertEquals((Object)"/adr/country-name", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(11);
        Assert.assertEquals((Object)"geo", (Object)f.getName());
        Assert.assertEquals((Object)"/geo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)geofields.get(0);
        Assert.assertEquals((Object)"latitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonComplexType)geofields.get(1);
        Assert.assertEquals((Object)"longitude", (Object)f.getName());
        Assert.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(12);
        Assert.assertEquals((Object)"tz", (Object)f.getName());
        Assert.assertEquals((Object)"/tz", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(13);
        Assert.assertEquals((Object)"photo", (Object)f.getName());
        Assert.assertEquals((Object)"/photo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(14);
        Assert.assertEquals((Object)"logo", (Object)f.getName());
        Assert.assertEquals((Object)"/logo", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(15);
        Assert.assertEquals((Object)"sound", (Object)f.getName());
        Assert.assertEquals((Object)"/sound", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(16);
        Assert.assertEquals((Object)"bday", (Object)f.getName());
        Assert.assertEquals((Object)"/bday", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(17);
        Assert.assertEquals((Object)"title", (Object)f.getName());
        Assert.assertEquals((Object)"/title", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(18);
        Assert.assertEquals((Object)"role", (Object)f.getName());
        Assert.assertEquals((Object)"/role", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(19);
        Assert.assertEquals((Object)"org", (Object)f.getName());
        Assert.assertEquals((Object)"/org", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List orgfields = f.getJsonFields().getJsonField();
        f = (JsonComplexType)orgfields.get(0);
        Assert.assertEquals((Object)"organizationName", (Object)f.getName());
        Assert.assertEquals((Object)"/org/organizationName", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)orgfields.get(1);
        Assert.assertEquals((Object)"organizationUnit", (Object)f.getName());
        Assert.assertEquals((Object)"/org/organizationUnit", (Object)f.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }
}

