/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlasmap.api.AtlasException;
import io.atlasmap.json.core.JsonFieldWriter;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.json.v2.JsonFields;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JsonFieldWriterTest {
    private JsonFieldWriter writer = null;

    @Before
    public void setupWriter() {
        this.writer = new JsonFieldWriter();
        Assert.assertNotNull((Object)this.writer.getRootNode());
    }

    @Test(expected=AtlasException.class)
    public void testWriteNullField() throws Exception {
        this.writer.write(null);
    }

    @Test
    public void testWriteSimpleObjectNoRoot() throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/brand");
        field.setValue((Object)"Mercedes");
        field.setFieldType(FieldType.STRING);
        this.writer.write((Field)field);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"brand\":\"Mercedes\"}"));
        JsonField field2 = AtlasJsonModelFactory.createJsonField();
        field2.setPath("/doors");
        field2.setValue((Object)5);
        field2.setFieldType(FieldType.INTEGER);
        this.writer.write((Field)field2);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"brand\":\"Mercedes\",\"doors\":5}"));
    }

    @Test
    public void testWriteSimpleObjectWithRoot() throws Exception {
        JsonField field1 = AtlasJsonModelFactory.createJsonField();
        field1.setPath("/car/brand");
        field1.setValue((Object)"Mercedes");
        field1.setFieldType(FieldType.STRING);
        this.writer.write((Field)field1);
        JsonField field2 = AtlasJsonModelFactory.createJsonField();
        field2.setPath("/car/doors");
        field2.setValue((Object)5);
        field2.setFieldType(FieldType.INTEGER);
        this.writer.write((Field)field2);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"car\":{\"brand\":\"Mercedes\",\"doors\":5}}"));
    }

    @Test
    public void testWriteFlatPrimitiveObject_Unrooted() throws Exception {
        JsonField booleanField = AtlasJsonModelFactory.createJsonField();
        booleanField.setFieldType(FieldType.BOOLEAN);
        booleanField.setValue((Object)false);
        booleanField.setPath("/booleanField");
        booleanField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)booleanField);
        Assert.assertNotNull((Object)this.writer.getRootNode());
        JsonField charField = AtlasJsonModelFactory.createJsonField();
        charField.setFieldType(FieldType.CHAR);
        charField.setValue((Object)Character.valueOf('a'));
        charField.setPath("/charField");
        charField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)charField);
        JsonField doubleField = AtlasJsonModelFactory.createJsonField();
        doubleField.setFieldType(FieldType.DOUBLE);
        doubleField.setValue((Object)-2.71527453422E7);
        doubleField.setPath("/doubleField");
        doubleField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)doubleField);
        JsonField floatField = AtlasJsonModelFactory.createJsonField();
        floatField.setFieldType(FieldType.FLOAT);
        floatField.setValue((Object)-6.3988281E7);
        floatField.setPath("/floatField");
        floatField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)floatField);
        JsonField intField = AtlasJsonModelFactory.createJsonField();
        intField.setFieldType(FieldType.INTEGER);
        intField.setValue((Object)8281);
        intField.setPath("/intField");
        intField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)intField);
        JsonField shortField = AtlasJsonModelFactory.createJsonField();
        shortField.setFieldType(FieldType.SHORT);
        shortField.setValue((Object)81);
        shortField.setPath("/shortField");
        shortField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)shortField);
        JsonField longField = AtlasJsonModelFactory.createJsonField();
        longField.setFieldType(FieldType.LONG);
        longField.setValue((Object)3988281);
        longField.setPath("/longField");
        longField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)longField);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"booleanField\":false,\"charField\":\"a\",\"doubleField\":-27152745.3422,\"floatField\":-63988281,\"intField\":8281,\"shortField\":81,\"longField\":3988281}"));
    }

    @Test
    public void testWriteFlatPrimitiveObject_Rooted() throws Exception {
        JsonField booleanField = AtlasJsonModelFactory.createJsonField();
        booleanField.setFieldType(FieldType.BOOLEAN);
        booleanField.setValue((Object)false);
        booleanField.setPath("/SourceFlatPrimitive/booleanField");
        booleanField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)booleanField);
        JsonField charField = AtlasJsonModelFactory.createJsonField();
        charField.setFieldType(FieldType.CHAR);
        charField.setValue((Object)Character.valueOf('a'));
        charField.setPath("/SourceFlatPrimitive/charField");
        charField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)charField);
        JsonField doubleField = AtlasJsonModelFactory.createJsonField();
        doubleField.setFieldType(FieldType.DOUBLE);
        doubleField.setValue((Object)-2.71527453422E7);
        doubleField.setPath("/SourceFlatPrimitive/doubleField");
        doubleField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)doubleField);
        JsonField floatField = AtlasJsonModelFactory.createJsonField();
        floatField.setFieldType(FieldType.FLOAT);
        floatField.setValue((Object)-6.3988281E7);
        floatField.setPath("/SourceFlatPrimitive/floatField");
        floatField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)floatField);
        JsonField intField = AtlasJsonModelFactory.createJsonField();
        intField.setFieldType(FieldType.INTEGER);
        intField.setValue((Object)8281);
        intField.setPath("/SourceFlatPrimitive/intField");
        intField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)intField);
        JsonField shortField = AtlasJsonModelFactory.createJsonField();
        shortField.setFieldType(FieldType.SHORT);
        shortField.setValue((Object)81);
        shortField.setPath("/SourceFlatPrimitive/shortField");
        shortField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)shortField);
        JsonField longField = AtlasJsonModelFactory.createJsonField();
        longField.setFieldType(FieldType.LONG);
        longField.setValue((Object)3988281);
        longField.setPath("/SourceFlatPrimitive/longField");
        longField.setStatus(FieldStatus.SUPPORTED);
        this.writer.write((Field)longField);
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"SourceFlatPrimitive\":{\"booleanField\":false,\"charField\":\"a\",\"doubleField\":-27152745.3422,\"floatField\":-63988281,\"intField\":8281,\"shortField\":81,\"longField\":3988281}}"));
    }

    @Test
    public void testSimpleRepeated() throws Exception {
        this.writeString("/orders[0]/orderid", "orderid1");
        this.writeString("/orders[1]/orderid", "orderid2");
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"orders\":[{\"orderid\":\"orderid1\"},{\"orderid\":\"orderid2\"}]}"));
    }

    public void writeString(String path, String value) throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setValue((Object)value);
        field.setStatus(FieldStatus.SUPPORTED);
        field.setFieldType(FieldType.STRING);
        field.setPath(path);
        this.writer.write((Field)field);
    }

    public void writeInteger(String path, Integer value) throws Exception {
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setValue((Object)value);
        field.setStatus(FieldStatus.SUPPORTED);
        field.setFieldType(FieldType.INTEGER);
        field.setPath(path);
        this.writer.write((Field)field);
    }

    @Test
    public void testWriteComplexObject_Unrooted() throws Exception {
        this.writeComplexTestData("", "");
        Assert.assertThat((Object)this.writer.getRootNode().toString(), (Matcher)Is.is((Object)"{\"address\":{\"addressLine1\":\"123 Main St\",\"addressLine2\":\"Suite 42b\",\"city\":\"Anytown\",\"state\":\"NY\",\"zipCode\":\"90210\"},\"contact\":{\"firstName\":\"Ozzie\",\"lastName\":\"Smith\",\"phoneNumber\":\"5551212\",\"zipCode\":\"81111\"},\"orderId\":9}"));
    }

    @Test
    public void testWriteComplexObject_Rooted() throws Exception {
        this.writeComplexTestData("/order", "");
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/complex-rooted-result.json", new String[0])));
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)this.prettyPrintJson(this.writer.getRootNode().toString()), (Matcher)Is.is((Object)this.prettyPrintJson(instance)));
    }

    public void writeComplexTestData(String prefix, String valueSuffix) throws Exception {
        System.out.println("\nNow writing with prefix: " + prefix + ", suffix: " + valueSuffix);
        this.writeString(prefix + "/address/addressLine1", "123 Main St" + valueSuffix);
        this.writeString(prefix + "/address/addressLine2", "Suite 42b" + valueSuffix);
        this.writeString(prefix + "/address/city", "Anytown" + valueSuffix);
        this.writeString(prefix + "/address/state", "NY" + valueSuffix);
        this.writeString(prefix + "/address/zipCode", "90210" + valueSuffix);
        this.writeString(prefix + "/contact/firstName", "Ozzie" + valueSuffix);
        this.writeString(prefix + "/contact/lastName", "Smith" + valueSuffix);
        this.writeString(prefix + "/contact/phoneNumber", "5551212" + valueSuffix);
        this.writeString(prefix + "/contact/zipCode", "81111" + valueSuffix);
        this.writeInteger(prefix + "/orderId", 9);
    }

    @Test
    public void testWriteComplexObject_Repeated() throws Exception {
        for (int i = 0; i < 5; ++i) {
            String prefix = "/SourceOrderList/orders[" + i + "]";
            String valueSuffix = " (" + (i + 1) + ")";
            this.writeComplexTestData(prefix, valueSuffix);
        }
        this.writeInteger("/SourceOrderList/orderBatchNumber", 4123562);
        this.writeInteger("/SourceOrderList/numberOfOrders", 5);
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/complex-repeated-result.json", new String[0])));
        Assert.assertNotNull((Object)instance);
        Assert.assertThat((Object)this.prettyPrintJson(this.writer.getRootNode().toString()), (Matcher)Is.is((Object)this.prettyPrintJson(instance)));
    }

    @Test
    @Ignore
    public void testWriteHighlyComplexObject() throws Exception {
        JsonComplexType items = new JsonComplexType();
        items.setPath("/items");
        items.setFieldType(FieldType.COMPLEX);
        items.setJsonFields(new JsonFields());
        this.writer.write((Field)items);
        JsonComplexType item = new JsonComplexType();
        item.setJsonFields(new JsonFields());
        item.setPath("/items/item");
        item.setFieldType(FieldType.COMPLEX);
        item.setCollectionType(CollectionType.LIST);
        items.getJsonFields().getJsonField().add(item);
        this.writer.write((Field)item);
        JsonField itemid = new JsonField();
        itemid.setPath("/items/item/id");
        itemid.setValue((Object)"0001");
        itemid.setFieldType(FieldType.STRING);
        itemid.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(itemid);
        this.writer.write((Field)itemid);
        JsonField type = new JsonField();
        type.setPath("/items/item/type");
        type.setValue((Object)"donut");
        type.setFieldType(FieldType.STRING);
        type.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(type);
        this.writer.write((Field)type);
        JsonField name = new JsonField();
        name.setPath("/items/item/name");
        name.setValue((Object)"Cake");
        name.setFieldType(FieldType.STRING);
        name.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(name);
        this.writer.write((Field)name);
        JsonField ppu = new JsonField();
        ppu.setPath("/items/item/ppu");
        ppu.setValue((Object)0.55);
        ppu.setFieldType(FieldType.DOUBLE);
        ppu.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(ppu);
        this.writer.write((Field)ppu);
        JsonComplexType batters = new JsonComplexType();
        batters.setJsonFields(new JsonFields());
        batters.setPath("/items/item/batters");
        batters.setFieldType(FieldType.COMPLEX);
        items.getJsonFields().getJsonField().add(batters);
        this.writer.write((Field)batters);
        JsonComplexType batter = new JsonComplexType();
        batter.setPath("/items/item/batters/batter");
        batter.setJsonFields(new JsonFields());
        batter.setFieldType(FieldType.COMPLEX);
        batter.setStatus(FieldStatus.SUPPORTED);
        batter.setCollectionType(CollectionType.LIST);
        batters.getJsonFields().getJsonField().add(batter);
        this.writer.write((Field)batter);
        JsonField batter1_id = new JsonField();
        batter1_id.setPath("/items/item/batters/batter/id");
        batter1_id.setValue((Object)"1001");
        batter1_id.setFieldType(FieldType.STRING);
        batter1_id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter1_id);
        this.writer.write((Field)batter1_id);
        JsonField batter1_type = new JsonField();
        batter1_type.setPath("/items/item/batters/batter/type");
        batter1_type.setValue((Object)"Regular");
        batter1_type.setFieldType(FieldType.STRING);
        batter1_type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter1_type);
        this.writer.write((Field)batter1_type);
        JsonField batter2_id = new JsonField();
        batter2_id.setPath("/items/item/batters/batter[1]/id");
        batter2_id.setValue((Object)"1002");
        batter2_id.setFieldType(FieldType.STRING);
        batter2_id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter2_id);
        this.writer.write((Field)batter2_id);
        JsonField batter2_type = new JsonField();
        batter2_type.setPath("/items/item/batters/batter[1]/type");
        batter2_type.setValue((Object)"Chocolate");
        batter2_type.setFieldType(FieldType.STRING);
        batter2_type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter2_type);
        this.writer.write((Field)batter2_type);
        JsonField batter3_id = new JsonField();
        batter3_id.setPath("/items/item/batters/batter[2]/id");
        batter3_id.setValue((Object)"1003");
        batter3_id.setFieldType(FieldType.STRING);
        batter3_id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter3_id);
        this.writer.write((Field)batter3_id);
        JsonField batter3_type = new JsonField();
        batter3_type.setPath("/items/item/batters/batter[2]/type");
        batter3_type.setValue((Object)"Blueberry");
        batter3_type.setFieldType(FieldType.STRING);
        batter3_type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter3_type);
        this.writer.write((Field)batter3_type);
        JsonField batter4_id = new JsonField();
        batter4_id.setPath("/items/item/batters/batter[3]/id");
        batter4_id.setValue((Object)"1004");
        batter4_id.setFieldType(FieldType.STRING);
        batter4_id.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter4_id);
        this.writer.write((Field)batter4_id);
        JsonField batter4_type = new JsonField();
        batter4_type.setPath("/items/item/batters/batter[3]/type");
        batter4_type.setValue((Object)"Devil's Food");
        batter4_type.setFieldType(FieldType.STRING);
        batter4_type.setStatus(FieldStatus.SUPPORTED);
        batter.getJsonFields().getJsonField().add(batter4_type);
        this.writer.write((Field)batter4_type);
        JsonComplexType topping = new JsonComplexType();
        topping.setJsonFields(new JsonFields());
        topping.setPath("/items/item/topping");
        topping.setFieldType(FieldType.COMPLEX);
        topping.setCollectionType(CollectionType.ARRAY);
        items.getJsonFields().getJsonField().add(topping);
        this.writer.write((Field)topping);
        JsonField topping1_id = new JsonField();
        topping1_id.setPath("/items/item/topping/id");
        topping1_id.setValue((Object)"5001");
        topping1_id.setFieldType(FieldType.STRING);
        topping1_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping1_id);
        this.writer.write((Field)topping1_id);
        JsonField topping1_type = new JsonField();
        topping1_type.setPath("/items/item/topping/type");
        topping1_type.setValue((Object)"None");
        topping1_type.setFieldType(FieldType.STRING);
        topping1_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping1_type);
        this.writer.write((Field)topping1_type);
        JsonField topping2_id = new JsonField();
        topping2_id.setPath("/items/item/topping/id[1]");
        topping2_id.setValue((Object)"5002");
        topping2_id.setFieldType(FieldType.STRING);
        topping2_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping2_id);
        this.writer.write((Field)topping2_id);
        JsonField topping2_type = new JsonField();
        topping2_type.setPath("/items/item/topping/type[1]");
        topping2_type.setValue((Object)"Glazed");
        topping2_type.setFieldType(FieldType.STRING);
        topping2_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping2_type);
        this.writer.write((Field)topping2_type);
        JsonField topping3_id = new JsonField();
        topping3_id.setPath("/items/item/topping/id[2]");
        topping3_id.setValue((Object)"5005");
        topping3_id.setFieldType(FieldType.STRING);
        topping3_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping3_id);
        this.writer.write((Field)topping3_id);
        JsonField topping3_type = new JsonField();
        topping3_type.setPath("/items/item/topping/type[2]");
        topping3_type.setValue((Object)"Sugar");
        topping3_type.setFieldType(FieldType.STRING);
        topping3_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping3_type);
        this.writer.write((Field)topping3_type);
        JsonField topping4_id = new JsonField();
        topping4_id.setPath("/items/item/topping/id[3]");
        topping4_id.setValue((Object)"5007");
        topping4_id.setFieldType(FieldType.STRING);
        topping4_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping4_id);
        this.writer.write((Field)topping4_id);
        JsonField topping4_type = new JsonField();
        topping4_type.setPath("/items/item/topping/type[3]");
        topping4_type.setValue((Object)"Powdered Sugar");
        topping4_type.setFieldType(FieldType.STRING);
        topping4_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping4_type);
        this.writer.write((Field)topping4_type);
        JsonField topping5_id = new JsonField();
        topping5_id.setPath("/items/item/topping/id[4]");
        topping5_id.setValue((Object)"5006");
        topping5_id.setFieldType(FieldType.STRING);
        topping5_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping5_id);
        this.writer.write((Field)topping5_id);
        JsonField topping5_type = new JsonField();
        topping5_type.setPath("/items/item/topping/type[4]");
        topping5_type.setValue((Object)"Chocolate with Sprinkles");
        topping5_type.setFieldType(FieldType.STRING);
        topping5_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping5_type);
        this.writer.write((Field)topping5_type);
        JsonField topping6_id = new JsonField();
        topping6_id.setPath("/items/item/topping/id[5]");
        topping6_id.setValue((Object)"5003");
        topping6_id.setFieldType(FieldType.STRING);
        topping6_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping6_id);
        this.writer.write((Field)topping6_id);
        JsonField topping6_type = new JsonField();
        topping6_type.setPath("/items/item/topping/type[5]");
        topping6_type.setValue((Object)"Chocolate");
        topping6_type.setFieldType(FieldType.STRING);
        topping6_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping6_type);
        this.writer.write((Field)topping6_type);
        JsonField topping7_id = new JsonField();
        topping7_id.setPath("/items/item/topping/id[6]");
        topping7_id.setValue((Object)"5004");
        topping7_id.setFieldType(FieldType.STRING);
        topping7_id.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping7_id);
        this.writer.write((Field)topping7_id);
        JsonField topping7_type = new JsonField();
        topping7_type.setPath("/items/item/topping/type[6]");
        topping7_type.setValue((Object)"Maple");
        topping7_type.setFieldType(FieldType.STRING);
        topping7_type.setStatus(FieldStatus.SUPPORTED);
        topping.getJsonFields().getJsonField().add(topping7_type);
        this.writer.write((Field)topping7_type);
        JsonComplexType item1 = new JsonComplexType();
        item1.setJsonFields(new JsonFields());
        item1.setPath("/items/item[1]");
        item1.setFieldType(FieldType.COMPLEX);
        item1.setCollectionType(CollectionType.LIST);
        items.getJsonFields().getJsonField().add(item1);
        this.writer.write((Field)item1);
        JsonField itemId1 = new JsonField();
        itemId1.setPath("/items/item[1]/id");
        itemId1.setValue((Object)"0002");
        itemId1.setFieldType(FieldType.STRING);
        itemId1.setStatus(FieldStatus.SUPPORTED);
        item1.getJsonFields().getJsonField().add(itemId1);
        this.writer.write((Field)itemId1);
        JsonField type1 = new JsonField();
        type1.setPath("/items/item[1]/type");
        type1.setValue((Object)"donut");
        type1.setFieldType(FieldType.STRING);
        type1.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(type1);
        this.writer.write((Field)type1);
        JsonField name1 = new JsonField();
        name1.setPath("/items/item[1]/name");
        name1.setValue((Object)"Raised");
        name1.setFieldType(FieldType.STRING);
        name1.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(name1);
        this.writer.write((Field)name1);
        JsonField ppu2 = new JsonField();
        ppu2.setPath("/items/item[1]/ppu");
        ppu2.setValue((Object)0.55);
        ppu2.setFieldType(FieldType.DOUBLE);
        ppu2.setStatus(FieldStatus.SUPPORTED);
        item.getJsonFields().getJsonField().add(ppu2);
        this.writer.write((Field)ppu2);
        JsonComplexType batters1 = new JsonComplexType();
        batters1.setJsonFields(new JsonFields());
        batters1.setPath("/items/item[1]/batters");
        batters1.setFieldType(FieldType.COMPLEX);
        items.getJsonFields().getJsonField().add(batters1);
        this.writer.write((Field)batters1);
        JsonComplexType batter1 = new JsonComplexType();
        batter1.setPath("/items/item[1]/batters/batter");
        batter1.setJsonFields(new JsonFields());
        batter1.setFieldType(FieldType.COMPLEX);
        batter1.setStatus(FieldStatus.SUPPORTED);
        batter1.setCollectionType(CollectionType.LIST);
        batters1.getJsonFields().getJsonField().add(batter1);
        this.writer.write((Field)batter1);
        System.out.println(this.prettyPrintJson(this.writer.getRootNode().toString()));
    }

    private String prettyPrintJson(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object objJSON = objectMapper.readValue(json, Object.class);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(objJSON);
    }
}

