/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.json.core.JsonFieldReader;
import io.atlasmap.json.v2.AtlasJsonModelFactory;
import io.atlasmap.json.v2.JsonField;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class JsonFieldReaderTest {
    private static JsonFieldReader reader = new JsonFieldReader();

    @Test(expected=AtlasException.class)
    public void testWithNullDocument() throws Exception {
        reader.read(null, AtlasJsonModelFactory.createJsonField());
    }

    @Test(expected=AtlasException.class)
    public void testWithEmptyDocument() throws Exception {
        reader.read("", AtlasJsonModelFactory.createJsonField());
    }

    @Test(expected=AtlasException.class)
    public void testWithNullJsonField() throws Exception {
        reader.read("{qwerty : ytrewq}", null);
    }

    @Test
    public void testSimpleJsonDocument() throws Exception {
        String document = "   { \"brand\" : \"Mercedes\", \"doors\" : 5 }";
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/brand");
        reader.read("   { \"brand\" : \"Mercedes\", \"doors\" : 5 }", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Mercedes"));
        field.setPath("/doors");
        reader.read("   { \"brand\" : \"Mercedes\", \"doors\" : 5 }", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void testSimpleJsonDocument_WithRoot() throws Exception {
        String document = " {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }";
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/car/doors");
        reader.read(" {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)5));
        this.resetField(field);
        field.setPath("/car/brand");
        reader.read(" {\"car\" :{ \"brand\" : \"Mercedes\", \"doors\" : 5 } }", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Mercedes"));
    }

    @Test
    public void testComplexJsonDocument_NestedObjectArray() throws Exception {
        String document = "{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}";
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/menu/id");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"file"));
        field.setPath("/menu/value");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Filed"));
        field.setPath("/menu/popup/menuitem/value");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"New"));
        field.setPath("/menu/popup/menuitem/onclick");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"CreateNewDoc()"));
        field.setPath("/menu/popup/menuitem[1]/value");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Open"));
        field.setPath("/menu/popup/menuitem[1]/onclick");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"OpenDoc()"));
        field.setPath("/menu/popup/menuitem[2]/value");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Close"));
        field.setPath("/menu/popup/menuitem[2]/onclick");
        reader.read("{\"menu\": {\n  \"id\": \"file\",\n  \"value\": \"Filed\",\n  \"popup\": {\n    \"menuitem\": [\n      {\"value\": \"New\", \"onclick\": \"CreateNewDoc()\"},\n      {\"value\": \"Open\", \"onclick\": \"OpenDoc()\"},\n      {\"value\": \"Close\", \"onclick\": \"CloseDoc()\"}\n    ]\n  }\n}}", field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"CloseDoc()"));
    }

    @Test
    public void testComplexJsonDocument_HighlyNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-nested-object.json", new String[0])));
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0001"));
        this.resetField(field);
        field.setPath("/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Cake"));
        this.resetField(field);
        field.setPath("/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/batters/batter/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/batters/batter/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/batters/batter[1]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1002"));
        this.resetField(field);
        field.setPath("/batters/batter[1]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/batters/batter[2]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1003"));
        this.resetField(field);
        field.setPath("/batters/batter[2]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        this.resetField(field);
        field.setPath("/batters/batter[3]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1004"));
        this.resetField(field);
        field.setPath("/batters/batter[3]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        this.resetField(field);
        field.setPath("/topping/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/topping/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/topping/id[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/topping/type[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/topping/id[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/topping/type[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/topping/id[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5007"));
        this.resetField(field);
        field.setPath("/topping/type[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Powdered Sugar"));
        this.resetField(field);
        field.setPath("/topping/id[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5006"));
        this.resetField(field);
        field.setPath("/topping/type[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate with Sprinkles"));
        this.resetField(field);
        field.setPath("/topping/id[5]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/topping/type[5]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/topping/id[6]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/topping/type[6]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
    }

    @Test
    public void testCollectionCount_HighlyNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-nested-object.json", new String[0])));
        JsonField field = AtlasJsonModelFactory.createJsonField();
        Integer count = reader.getCollectionCount(document, field, "batter");
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((Object)4, (Object)count);
    }

    @Test
    public void testCollectionCount_HighlyNestedSegmentDoesNotExist() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-nested-object.json", new String[0])));
        JsonField field = AtlasJsonModelFactory.createJsonField();
        Integer count = reader.getCollectionCount(document, field, "battery");
        Assert.assertNull((Object)count);
    }

    @Test
    public void testComplexJsonDocument_HighlyComplexNested() throws Exception {
        String document = new String(Files.readAllBytes(Paths.get("src/test/resources/highly-complex-nested-object.json", new String[0])));
        JsonField field = AtlasJsonModelFactory.createJsonField();
        field.setPath("/items/item/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0001"));
        this.resetField(field);
        field.setPath("/items/item/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Cake"));
        this.resetField(field);
        field.setPath("/items/item/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item/batters/batter/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[1]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1002"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[1]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[2]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1003"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[2]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Blueberry"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[3]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1004"));
        this.resetField(field);
        field.setPath("/items/item/batters/batter[3]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Devil's Food"));
        this.resetField(field);
        field.setPath("/items/item/topping/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/items/item/topping/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5007"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Powdered Sugar"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5006"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate with Sprinkles"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[5]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[5]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item/topping/id[6]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/items/item/topping/type[6]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
        field.setPath("/items/item[1]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0002"));
        this.resetField(field);
        field.setPath("/items/item[1]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item[1]/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Raised"));
        this.resetField(field);
        field.setPath("/items/item[1]/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"1001"));
        this.resetField(field);
        field.setPath("/items/item[1]/batters/batter/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Regular"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5001"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"None"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5002"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/type[1]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Glazed"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5005"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/type[2]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Sugar"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5003"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/type[3]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Chocolate"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"5004"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/type[4]");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Maple"));
        this.resetField(field);
        field.setPath("/items/item[1]/topping/id[5]");
        reader.read(document, field);
        Assert.assertNull((Object)field.getValue());
        this.resetField(field);
        field.setPath("/items/item[2]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0003"));
        this.resetField(field);
        field.setPath("/items/item[2]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"donut"));
        this.resetField(field);
        field.setPath("/items/item[2]/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Old Fashioned"));
        this.resetField(field);
        field.setPath("/items/item[2]/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.55));
        this.resetField(field);
        field.setPath("/items/item[3]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0004"));
        this.resetField(field);
        field.setPath("/items/item[3]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"bar"));
        this.resetField(field);
        field.setPath("/items/item[3]/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Bar"));
        this.resetField(field);
        field.setPath("/items/item[3]/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.75));
        this.resetField(field);
        field.setPath("/items/item[4]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0005"));
        this.resetField(field);
        field.setPath("/items/item[4]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"twist"));
        this.resetField(field);
        field.setPath("/items/item[4]/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Twist"));
        this.resetField(field);
        field.setPath("/items/item[4]/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.65));
        this.resetField(field);
        field.setPath("/items/item[5]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"0006"));
        this.resetField(field);
        field.setPath("/items/item[5]/type");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"filled"));
        this.resetField(field);
        field.setPath("/items/item[5]/name");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"Filled"));
        this.resetField(field);
        field.setPath("/items/item[5]/ppu");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0.75));
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[2]/id");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)"7004"));
        this.resetField(field);
        field.setPath("/items/item[5]/fillings/filling[3]/addcost");
        reader.read(document, field);
        Assert.assertNotNull((Object)field.getValue());
        Assert.assertThat((Object)field.getValue(), (Matcher)Is.is((Object)0));
        this.resetField(field);
    }

    private void resetField(JsonField field) {
        field.setPath(null);
        field.setValue(null);
        field.setFieldType(null);
    }
}

