/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.core.CsvFieldWriter;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CsvFieldWriterTest {
    private void write(CsvFieldWriter writer, Field sourceField, Field targetField) throws Exception {
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)sourceField);
        Mockito.when((Object)session.head().getTargetField()).thenReturn((Object)targetField);
        writer.write(session);
    }

    @Test
    public void testWithSimpleDocumentWithHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"givenName\r\nBob\r\nAndrew\r\n", (Object)csv);
    }

    @Test
    public void testWithSimpleDocumentWithoutHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setSkipHeaderRecord(Boolean.valueOf(true));
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"Bob\r\nAndrew\r\n", (Object)csv);
    }

    @Test
    public void testWithSimpleDocumentWithHeaderSpecified() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setHeaders("givenName");
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"givenName\r\nBob\r\nAndrew\r\n", (Object)csv);
    }

    @Test
    public void testWithNoMatchingHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setHeaders("FAMILYNAME,GIVENNAME");
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"FAMILYNAME,GIVENNAME\r\n,\r\n,\r\n", (Object)csv);
    }

    @Test
    public void testWithHeaderAndIgnoreHeaderCase() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setHeaders("FAMILYNAME,GIVENNAME");
        csvConfig.setIgnoreHeaderCase(Boolean.valueOf(true));
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"FAMILYNAME,GIVENNAME\r\n,Bob\r\n,Andrew\r\n", (Object)csv);
    }

    @Test
    public void testWithSimpleDocumentWithHeaderAndDelimiterSpecified() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setDelimiter(Character.valueOf(';'));
        csvConfig.setHeaders("familyName;givenName");
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        sourceField = new FieldGroup();
        sourceField.setName("family");
        sourceField.setPath("/<>/family");
        sourceSubField0 = new CsvField();
        sourceSubField0.setName("family");
        sourceSubField0.setPath("/<0>/family");
        sourceSubField0.setValue((Object)"Smith");
        sourceField.getField().add(sourceSubField0);
        sourceSubField1 = new CsvField();
        sourceSubField1.setName("family");
        sourceSubField1.setPath("/<1>/family");
        sourceSubField1.setValue((Object)"Johnson");
        sourceField.getField().add(sourceSubField1);
        targetField = new CsvField();
        targetField.setName("familyName");
        targetField.setPath("/<>/familyName");
        this.write(writer, (Field)sourceField, (Field)targetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"familyName;givenName\r\nSmith;Bob\r\nJohnson;Andrew\r\n", (Object)csv);
    }

    @Test
    public void testWithSimpleDocumentWithTargetColumnsDefined() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        CsvFieldWriter writer = new CsvFieldWriter(csvConfig);
        FieldGroup sourceField = new FieldGroup();
        sourceField.setName("name");
        sourceField.setPath("/<>/name");
        CsvField sourceSubField0 = new CsvField();
        sourceSubField0.setName("name");
        sourceSubField0.setPath("/<0>/name");
        sourceSubField0.setValue((Object)"Bob");
        sourceField.getField().add(sourceSubField0);
        CsvField sourceSubField1 = new CsvField();
        sourceSubField1.setName("name");
        sourceSubField1.setPath("/<1>/name");
        sourceSubField1.setValue((Object)"Andrew");
        sourceField.getField().add(sourceSubField1);
        CsvField targetField = new CsvField();
        targetField.setName("givenName");
        targetField.setPath("/<>/givenName");
        targetField.setColumn(Integer.valueOf(1));
        this.write(writer, (Field)sourceField, (Field)targetField);
        FieldGroup secondSourceField = new FieldGroup();
        CsvField secondSourceSubField = new CsvField();
        secondSourceSubField.setName("familyName");
        secondSourceSubField.setPath("/<0>/familyName");
        secondSourceSubField.setValue((Object)"Smith");
        secondSourceField.getField().add(secondSourceSubField);
        CsvField secondSourceSubField1 = new CsvField();
        secondSourceSubField1.setName("familyName");
        secondSourceSubField1.setPath("/<1>/familyName");
        secondSourceSubField1.setValue((Object)"Johnson");
        secondSourceField.getField().add(secondSourceSubField1);
        CsvField secondTargetField = new CsvField();
        secondTargetField.setName("familyName");
        secondTargetField.setPath("/<>/familyName");
        secondTargetField.setColumn(Integer.valueOf(0));
        this.write(writer, (Field)secondSourceField, (Field)secondTargetField);
        String csv = writer.toCsv();
        Assertions.assertEquals((Object)"familyName,givenName\r\nSmith,Bob\r\nJohnson,Andrew\r\n", (Object)csv);
    }
}

