/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.core.CsvFieldReader;
import io.atlasmap.csv.v2.CsvComplexType;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CsvFieldReaderTest {
    @Test
    public void testWithNullDocument() throws Exception {
        CsvFieldReader csvFieldReader = new CsvFieldReader(new CsvConfig());
        csvFieldReader.setDocument(null);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)new CsvField());
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        csvFieldReader.read(session);
        Assertions.assertEquals((int)1, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)audits.getAudit().get(0)).getStatus());
    }

    @Test
    public void testWithSimpleDocumentWithHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setFirstRecordAsHeader(Boolean.valueOf(true));
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("givenName,familyName\nBob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        CsvField csvField = new CsvField();
        csvField.setName("givenName");
        csvField.setPath("/<>/givenName");
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)csvField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        FieldGroup field = (FieldGroup)csvFieldReader.read(session);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)"Bob", (Object)((Field)field.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"Andrew", (Object)((Field)field.getField().get(1)).getValue());
    }

    @Test
    public void testWithSimpleDocumentWithoutHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("Bob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        CsvField csvField = new CsvField();
        csvField.setName("1");
        csvField.setColumn(Integer.valueOf(1));
        csvField.setPath("/<>/1");
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)csvField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        FieldGroup field = (FieldGroup)csvFieldReader.read(session);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)"Smith", (Object)((Field)field.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"Johnson", (Object)((Field)field.getField().get(1)).getValue());
    }

    @Test
    public void testWithSimpleDocumentWithHeaderSpecified() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setHeaders("givenName,familyName");
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("Bob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        CsvField csvField = new CsvField();
        csvField.setName("familyName");
        csvField.setPath("/<>/familyName");
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)csvField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        FieldGroup field = (FieldGroup)csvFieldReader.read(session);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)"Smith", (Object)((Field)field.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"Johnson", (Object)((Field)field.getField().get(1)).getValue());
    }

    @Test
    public void testWithSimpleDocumentWithHeaderAndDelimiterSpecified() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setDelimiter(Character.valueOf(';'));
        csvConfig.setHeaders("givenName;familyName");
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("Bob;Smith\nAndrew;Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        CsvField csvField = new CsvField();
        csvField.setName("familyName");
        csvField.setPath("/<>/familyName");
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)csvField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        FieldGroup field = (FieldGroup)csvFieldReader.read(session);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)"Smith", (Object)((Field)field.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"/<0>/familyName", (Object)((Field)field.getField().get(0)).getPath());
        Assertions.assertEquals((Object)"Johnson", (Object)((Field)field.getField().get(1)).getValue());
        Assertions.assertEquals((Object)"/<1>/familyName", (Object)((Field)field.getField().get(1)).getPath());
    }

    @Test
    public void testIgnoreHeaderCase() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setIgnoreHeaderCase(Boolean.valueOf(true));
        csvConfig.setHeaders("givenName,familyName");
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("Bob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        CsvField csvField = new CsvField();
        csvField.setName("FAMILYNAME");
        csvField.setPath("/<>/FAMILYNAME");
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)csvField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        FieldGroup field = (FieldGroup)csvFieldReader.read(session);
        Assertions.assertEquals((int)0, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)"Smith", (Object)((Field)field.getField().get(0)).getValue());
        Assertions.assertEquals((Object)"/<0>/FAMILYNAME", (Object)((Field)field.getField().get(0)).getPath());
        Assertions.assertEquals((Object)"Johnson", (Object)((Field)field.getField().get(1)).getValue());
        Assertions.assertEquals((Object)"/<1>/FAMILYNAME", (Object)((Field)field.getField().get(1)).getPath());
    }

    @Test
    public void testReadSchemaWithHeaderSpecified() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setHeaders("givenName,familyName");
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("Bob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Document document = csvFieldReader.readSchema();
        CsvComplexType list = (CsvComplexType)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)"givenName", (Object)((CsvField)list.getCsvFields().getCsvField().get(0)).getName());
        Assertions.assertEquals((Object)"familyName", (Object)((CsvField)list.getCsvFields().getCsvField().get(1)).getName());
    }

    @Test
    public void testReadSchemaWithFirstRecordAsHeader() throws Exception {
        CsvConfig csvConfig = new CsvConfig();
        csvConfig.setFirstRecordAsHeader(Boolean.valueOf(true));
        CsvFieldReader csvFieldReader = new CsvFieldReader(csvConfig);
        csvFieldReader.setDocument((InputStream)new ByteArrayInputStream("givenName,familyName\nBob,Smith\nAndrew,Johnson".getBytes()));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Document document = csvFieldReader.readSchema();
        CsvComplexType list = (CsvComplexType)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)"givenName", (Object)((CsvField)list.getCsvFields().getCsvField().get(0)).getName());
        Assertions.assertEquals((Object)"familyName", (Object)((CsvField)list.getCsvFields().getCsvField().get(1)).getName());
    }
}

