/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor.builder;

import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import lombok.NonNull;

public final class ForkJoinPoolBuilder {
    private int parallelism;
    private ForkJoinPool.ForkJoinWorkerThreadFactory threadFactory;
    private Thread.UncaughtExceptionHandler handler;
    private boolean asyncMode = true;

    public ForkJoinPoolBuilder parallelism(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Parallelism must be greater than 0");
        }
        this.parallelism = value;
        return this;
    }

    public ForkJoinPoolBuilder threadFactory(@NonNull ForkJoinPool.ForkJoinWorkerThreadFactory value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.threadFactory = value;
        return this;
    }

    public ForkJoinPoolBuilder handler(@NonNull Thread.UncaughtExceptionHandler value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.handler = value;
        return this;
    }

    public ForkJoinPoolBuilder enableAsyncMode() {
        return this.asyncMode(true);
    }

    public ForkJoinPoolBuilder asyncMode(boolean value) {
        this.asyncMode = value;
        return this;
    }

    public ForkJoinPool build() {
        if (this.parallelism < 1) {
            this.parallelism = Runtime.getRuntime().availableProcessors();
        }
        this.threadFactory = Optional.ofNullable(this.threadFactory).orElse(ForkJoinPool.defaultForkJoinWorkerThreadFactory);
        return new ForkJoinPool(this.parallelism, this.threadFactory, this.handler, this.asyncMode);
    }
}

