/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor;

import io.appulse.utils.threads.executor.ExecutorServiceWrapper;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceWithTimeMonitor
extends ExecutorServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceWithTimeMonitor.class);

    public ExecutorServiceWithTimeMonitor(ExecutorService delegate) {
        super(delegate);
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        long submitTime = System.currentTimeMillis();
        super.execute(() -> {
            long startTime = System.currentTimeMillis();
            long queueDuration = startTime - submitTime;
            log.debug("Task {} spent {}ms in queue", (Object)command, (Object)queueDuration);
            try {
                command.run();
            }
            finally {
                long endTime = System.currentTimeMillis() - startTime;
                log.debug("Task {} end after {}ms", (Object)command, (Object)endTime);
            }
        });
    }
}

