/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads;

import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;

public final class AppulseThreadFactory
implements ThreadFactory {
    private final ThreadFactory parent;
    private final int priority;
    private final Optional<String> name;
    private final AtomicLong threadCount;
    private final Optional<Boolean> daemon;
    private final Optional<Thread.UncaughtExceptionHandler> uncaughtExceptionHandler;

    public AppulseThreadFactory(String name, Boolean daemon, Integer priority, ThreadFactory parent, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = Optional.ofNullable(name);
        this.threadCount = this.name.filter(it -> it.contains("%d")).map(it -> new AtomicLong(1L)).orElse(null);
        this.daemon = Optional.ofNullable(daemon);
        this.uncaughtExceptionHandler = Optional.ofNullable(uncaughtExceptionHandler);
        this.priority = Optional.ofNullable(priority).orElse(5);
        this.parent = Optional.ofNullable(parent).orElse(Executors.defaultThreadFactory());
    }

    @Override
    public Thread newThread(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable");
        }
        Thread thread = this.parent.newThread(runnable);
        thread.setPriority(this.priority);
        this.name.map(it -> Optional.ofNullable(this.threadCount).map(counter -> String.format(Locale.ROOT, it, counter.getAndIncrement())).orElse((String)it)).ifPresent(thread::setName);
        this.daemon.ifPresent(thread::setDaemon);
        this.uncaughtExceptionHandler.ifPresent(thread::setUncaughtExceptionHandler);
        return thread;
    }

    public static AppulseThreadFactoryBuilder builder() {
        return new AppulseThreadFactoryBuilder();
    }

    public static class AppulseThreadFactoryBuilder {
        private String name;
        private Boolean daemon;
        private Integer priority;
        private ThreadFactory parent;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        AppulseThreadFactoryBuilder() {
        }

        public AppulseThreadFactoryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AppulseThreadFactoryBuilder daemon(Boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public AppulseThreadFactoryBuilder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public AppulseThreadFactoryBuilder parent(ThreadFactory parent) {
            this.parent = parent;
            return this;
        }

        public AppulseThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public AppulseThreadFactory build() {
            return new AppulseThreadFactory(this.name, this.daemon, this.priority, this.parent, this.uncaughtExceptionHandler);
        }

        public String toString() {
            return "AppulseThreadFactory.AppulseThreadFactoryBuilder(name=" + this.name + ", daemon=" + this.daemon + ", priority=" + this.priority + ", parent=" + this.parent + ", uncaughtExceptionHandler=" + this.uncaughtExceptionHandler + ")";
        }
    }
}

