/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor.builder;

import io.appulse.utils.threads.executor.ExecutorServiceWithClientTrace;
import io.appulse.utils.threads.executor.ExecutorServiceWithTimeMonitor;
import java.util.Optional;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class ExecutorServiceBuilder {
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private int corePoolSize;
    private int maxPoolSize;
    private long keepAliveTime;
    private TimeUnit unit;
    private BlockingQueue<Runnable> queue;
    private int queueLimit;
    private boolean clientTrace;
    private boolean timeLogging;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;

    public ExecutorServiceBuilder corePoolSize(int value) {
        this.corePoolSize = value;
        return this;
    }

    public ExecutorServiceBuilder maxPoolSize(int value) {
        this.maxPoolSize = value;
        return this;
    }

    public ExecutorServiceBuilder keepAliveTime(long value) {
        this.keepAliveTime = value;
        return this;
    }

    public ExecutorServiceBuilder unit(@NonNull TimeUnit value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.unit = value;
        return this;
    }

    public ExecutorServiceBuilder queue(@NonNull BlockingQueue<Runnable> value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.queue = value;
        return this;
    }

    public ExecutorServiceBuilder queueLimit(int value) {
        this.queueLimit = value;
        this.queue = null;
        return this;
    }

    public ExecutorServiceBuilder enableClientTrace() {
        return this.clientTrace(true);
    }

    public ExecutorServiceBuilder clientTrace(boolean value) {
        this.clientTrace = value;
        return this;
    }

    public ExecutorServiceBuilder enableTimeLogging() {
        return this.timeLogging(true);
    }

    public ExecutorServiceBuilder timeLogging(boolean value) {
        this.timeLogging = value;
        return this;
    }

    public ExecutorServiceBuilder threadFactory(@NonNull ThreadFactory value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.threadFactory = value;
        return this;
    }

    public ExecutorServiceBuilder handler(@NonNull RejectedExecutionHandler value) {
        if (value == null) {
            throw new NullPointerException("value is marked @NonNull but is null");
        }
        this.handler = value;
        return this;
    }

    public ExecutorService build() {
        if (this.corePoolSize < 0) {
            throw new IllegalArgumentException("Core pool size must be greater or equals than 0");
        }
        if (this.maxPoolSize <= 0) {
            throw new IllegalArgumentException("Max pool size must be greater than 0");
        }
        if (this.maxPoolSize < this.corePoolSize) {
            this.maxPoolSize = this.corePoolSize;
        }
        if (this.keepAliveTime < 0L) {
            throw new IllegalArgumentException("Keep alive time must be greater than 0");
        }
        if (this.queueLimit < 0) {
            throw new IllegalArgumentException("Queue limit must be greater than 0");
        }
        if (this.queueLimit > 0 && this.queue != null) {
            throw new IllegalArgumentException("I couldn't set queue limit and queue simultaneously");
        }
        if (this.queueLimit > 0) {
            this.queue = new LinkedBlockingQueue<Runnable>(this.queueLimit);
        } else if (this.queue == null) {
            this.queue = new LinkedBlockingQueue<Runnable>();
        }
        this.threadFactory = Optional.ofNullable(this.threadFactory).orElse(Executors.defaultThreadFactory());
        this.handler = Optional.ofNullable(this.handler).orElse(DEFAULT_HANDLER);
        AbstractExecutorService result = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, this.unit, this.queue, this.threadFactory, this.handler);
        if (this.clientTrace) {
            result = new ExecutorServiceWithClientTrace(result);
        }
        if (this.timeLogging) {
            result = new ExecutorServiceWithTimeMonitor(result);
        }
        return result;
    }
}

