/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads;

import io.appulse.utils.threads.executor.builder.ExecutorServiceBuilder;
import io.appulse.utils.threads.executor.builder.ForkJoinPoolBuilder;
import io.appulse.utils.threads.executor.builder.ScheduledExecutorServiceBuilder;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;

public final class AppulseExecutors {
    public static ExecutorServiceBuilder newFixedThreadPool(int threads) {
        return new ExecutorServiceBuilder().corePoolSize(threads).maxPoolSize(threads).keepAliveTime(0L).unit(TimeUnit.MILLISECONDS);
    }

    public static ForkJoinPoolBuilder newWorkStealingPool() {
        return new ForkJoinPoolBuilder().parallelism(Runtime.getRuntime().availableProcessors()).threadFactory(ForkJoinPool.defaultForkJoinWorkerThreadFactory).asyncMode(true);
    }

    public static ExecutorServiceBuilder newSingleThreadExecutor() {
        return new ExecutorServiceBuilder().corePoolSize(1).maxPoolSize(1).keepAliveTime(0L).unit(TimeUnit.MILLISECONDS);
    }

    public static ExecutorServiceBuilder newCachedThreadPool() {
        return new ExecutorServiceBuilder().corePoolSize(0).maxPoolSize(Integer.MAX_VALUE).keepAliveTime(1L).unit(TimeUnit.MINUTES).queue(new SynchronousQueue<Runnable>());
    }

    public static ScheduledExecutorServiceBuilder newScheduledThreadPool() {
        return new ScheduledExecutorServiceBuilder();
    }

    private AppulseExecutors() {
    }
}

