/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesAbstract;
import io.appulse.utils.BytesUtils;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.NonNull;

class BytesFixedArray
extends BytesAbstract {
    protected byte[] buffer;
    protected int writerIndex;
    protected int readerIndex;

    static BytesFixedArray copy(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        byte[] copy = Arrays.copyOf(bytes, bytes.length);
        return new BytesFixedArray(copy);
    }

    BytesFixedArray(int size) {
        this.buffer = new byte[size];
    }

    BytesFixedArray(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        this.buffer = bytes;
        this.writerIndex(bytes.length);
    }

    @Override
    public boolean isAutoResizable() {
        return false;
    }

    @Override
    public Bytes writeNB(@NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        this.setNB(this.writerIndex, bytes, offset, length);
        this.writerIndex += length;
        return this;
    }

    @Override
    public Bytes write1B(byte value) {
        this.set1B(this.writerIndex, value);
        ++this.writerIndex;
        return this;
    }

    @Override
    public Bytes write2B(short value) {
        this.set2B(this.writerIndex, value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public Bytes write4B(int value) {
        this.set4B(this.writerIndex, value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public Bytes write8B(long value) {
        this.set8B(this.writerIndex, value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public Bytes setNB(int index, @NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        this.checkWriteBounds(index, length);
        System.arraycopy(bytes, offset, this.buffer, index, length);
        return this;
    }

    @Override
    public Bytes set1B(int index, byte value) {
        this.checkWriteBounds(index, 1);
        this.buffer[index] = value;
        return this;
    }

    @Override
    public Bytes set2B(int index, short value) {
        this.checkWriteBounds(index, 2);
        BytesUtils.unsafeWriteShort(value, this.buffer, index);
        return this;
    }

    @Override
    public Bytes set4B(int index, int value) {
        this.checkWriteBounds(index, 4);
        BytesUtils.unsafeWriteInteger(value, this.buffer, index);
        return this;
    }

    @Override
    public Bytes set8B(int index, long value) {
        this.checkWriteBounds(index, 8);
        BytesUtils.unsafeWriteLong(value, this.buffer, index);
        return this;
    }

    @Override
    public byte readByte() {
        byte result = this.getByte(this.readerIndex);
        ++this.readerIndex;
        return result;
    }

    @Override
    public short readShort() {
        short result = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.getLong(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public float readFloat() {
        float result = this.getFloat(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public double readDouble() {
        double result = this.getDouble(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public char readChar() {
        char result = this.getChar(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public Bytes readBytes(@NonNull byte[] destination, int offset, int length) {
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        this.checkReaderBounds(this.readerIndex, length);
        System.arraycopy(this.buffer, this.readerIndex, destination, offset, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public byte getByte(int index) {
        this.checkReaderBounds(index, 1);
        return this.buffer[index];
    }

    @Override
    public short getShort(int index) {
        this.checkReaderBounds(index, 2);
        return BytesUtils.unsafeReadShort(this.buffer, index);
    }

    @Override
    public int getInt(int index) {
        this.checkReaderBounds(index, 4);
        return BytesUtils.unsafeReadInteger(this.buffer, index);
    }

    @Override
    public long getLong(int index) {
        this.checkReaderBounds(index, 8);
        return BytesUtils.unsafeReadLong(this.buffer, index);
    }

    @Override
    public float getFloat(int index) {
        this.checkReaderBounds(index, 4);
        return BytesUtils.unsafeReadFloat(this.buffer, index);
    }

    @Override
    public double getDouble(int index) {
        this.checkReaderBounds(index, 8);
        return BytesUtils.unsafeReadDouble(this.buffer, index);
    }

    @Override
    public char getChar(int index) {
        this.checkReaderBounds(index, 2);
        return BytesUtils.unsafeReadCharacter(this.buffer, index);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        this.checkReaderBounds(index, length);
        return Arrays.copyOfRange(this.buffer, index, index + length);
    }

    @Override
    public String getString(int index, int length, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked @NonNull but is null");
        }
        this.checkReaderBounds(index, length);
        return new String(this.buffer, index, length, charset);
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public void capacity(int bytes) {
        if (this.capacity() == bytes) {
            return;
        }
        this.buffer = Arrays.copyOf(this.buffer, bytes);
        this.writerIndex = Math.min(this.writerIndex, bytes - 1);
        this.readerIndex = Math.min(this.readerIndex, bytes - 1);
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        if (newIndex < this.readerIndex() || newIndex > this.capacity()) {
            String msg = String.format("Writer index error: newIndex(%d) < readerIndex(%d) || newIndex(%d) > capacity(%d)", newIndex, this.readerIndex(), newIndex, this.capacity());
            throw new IndexOutOfBoundsException(msg);
        }
        this.writerIndex = newIndex;
        return this;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public Bytes readerIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.writerIndex()) {
            String msg = String.format("Reader index error: newIndex(%d) < 0 || newIndex(%d) > writerIndex(%d)", newIndex, newIndex, this.writerIndex());
            throw new IndexOutOfBoundsException(msg);
        }
        this.readerIndex = newIndex;
        return this;
    }

    @Override
    public byte[] array() {
        return this.buffer;
    }
}

