/*
 * Decompiled with CFR 0.152.
 */
package io.appbase.requestbuilders;

import io.appbase.client.AppbaseClient;
import io.appbase.requestbuilders.Param;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class AppbaseRequestBuilder {
    public static final int Index = 1;
    public static final int Update = 2;
    public static final int Delete = 3;
    public static final int Rest = 0;
    Request.Builder builder;
    String type = null;
    String id = null;
    AppbaseClient ac;
    URI uri;
    int method;
    String body;

    public AppbaseRequestBuilder(AppbaseClient a, String type, String id, int method) {
        this.ac = a;
        this.id = id;
        this.type = type;
        this.method = method;
        this.builder = new Request.Builder();
    }

    public AppbaseRequestBuilder addHeader(String name, String value) {
        this.builder.addHeader(name, value);
        return this;
    }

    public Request build() {
        return this.builder.build();
    }

    public AppbaseRequestBuilder cacheControl(CacheControl cacheControl) {
        this.builder.cacheControl(cacheControl);
        return this;
    }

    public AppbaseRequestBuilder delete() {
        this.builder.delete();
        return this;
    }

    public AppbaseRequestBuilder delete(String body) {
        this.body = body;
        this.builder.delete(AppbaseClient.createBody(body));
        return this;
    }

    public boolean equals(Object obj) {
        return this.builder.equals(obj);
    }

    public AppbaseRequestBuilder get() {
        this.builder.get();
        return this;
    }

    public int hashCode() {
        return this.builder.hashCode();
    }

    public AppbaseRequestBuilder head() {
        this.builder.head();
        return this;
    }

    public AppbaseRequestBuilder header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public AppbaseRequestBuilder headers(Headers headers) {
        this.builder.headers(headers);
        return this;
    }

    public AppbaseRequestBuilder method(String method, String body) {
        this.body = body;
        this.builder.method(method, AppbaseClient.createBody(body));
        return this;
    }

    public AppbaseRequestBuilder patch(String body) {
        this.body = body;
        this.builder.patch(AppbaseClient.createBody(body));
        return this;
    }

    public AppbaseRequestBuilder post(String body) {
        this.body = body;
        this.builder.post(AppbaseClient.createBody(body));
        return this;
    }

    public AppbaseRequestBuilder put(String body) {
        this.body = body;
        this.builder.put(AppbaseClient.createBody(body));
        return this;
    }

    public AppbaseRequestBuilder removeHeader(String name) {
        this.builder.removeHeader(name);
        return this;
    }

    public AppbaseRequestBuilder tag(Object tag) {
        this.builder.tag(tag);
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    public AppbaseRequestBuilder url(HttpUrl url) {
        this.uri = url.uri();
        return this;
    }

    public AppbaseRequestBuilder url(String url) {
        try {
            this.uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.uri = null;
        }
        return this;
    }

    public AppbaseRequestBuilder url(URL url) {
        try {
            this.uri = url.toURI();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.uri = null;
        }
        return this;
    }

    public AppbaseRequestBuilder addQueryParams(List<Param> parameters) {
        if (parameters == null) {
            return this;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            try {
                AppbaseRequestBuilder.appendUri(this.uri, parameters.get((int)i).key + "=" + parameters.get((int)i).value);
                continue;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    public AppbaseRequestBuilder addQueryParam(String key, String value) {
        try {
            AppbaseRequestBuilder.appendUri(this.uri, key + "=" + value);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    private static URI appendUri(URI oldUri, String appendQuery) throws URISyntaxException {
        String newQuery = oldUri.getQuery();
        newQuery = newQuery == null ? appendQuery : newQuery + "&" + appendQuery;
        URI newUri = new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), newQuery, oldUri.getFragment());
        return newUri;
    }

    public Response execute() {
        this.builder.url(this.uri.toString());
        try {
            return this.ac.newCall(this.builder.build()).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

