/*
 * Decompiled with CFR 0.152.
 */
package io.appbase.client;

import io.appbase.client.Stream;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.java_websocket.client.DefaultSSLWebSocketClientFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ServerHandshake;

public class AppbaseWebsocketClient
extends WebSocketClient {
    Stream on;

    public AppbaseWebsocketClient(URI serverUri, Stream on, Draft draft) {
        super(serverUri, draft);
        this.on = on;
        this.trustAllHosts();
    }

    public AppbaseWebsocketClient(URI serverURI, Stream on) {
        super(serverURI);
        this.on = on;
        this.trustAllHosts();
    }

    public void onOpen(ServerHandshake handshakedata) {
        if (this.on != null) {
            this.on.onOpen(handshakedata);
        } else {
            System.out.println("null " + handshakedata.toString());
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.on != null) {
            this.on.onClose(code, reason, remote);
        } else {
            System.out.println("null close");
        }
    }

    public void onError(Exception ex) {
        if (this.on != null) {
            this.on.onError(ex);
        } else {
            System.out.println("null " + ex.getMessage());
        }
    }

    public void onMessage(String message) {
        if (this.on != null) {
            this.on.onMessage(message);
        } else {
            System.out.println("null " + message);
        }
    }

    private void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            this.setWebSocketFactory((WebSocketClient.WebSocketClientFactory)new DefaultSSLWebSocketClientFactory(sc));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

