/*
 * Decompiled with CFR 0.152.
 */
package io.appbase.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.appbase.interceptor.BasicAuthInterceptor;
import io.appbase.requestbuilders.AppbaseRequestBuilder;
import io.appbase.requestbuilders.AppbaseWebsocketRequest;
import io.appbase.requestbuilders.Param;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.java_websocket.util.Base64;

public class AppbaseClient {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient ok;
    private String baseURL;
    private String app;
    private String URL;
    private String basicauth = null;
    private static final String SEPARATOR = "/";

    public Call newCall(Request request) {
        return this.ok.newCall(request);
    }

    public AppbaseClient(String baseURL, String app, String username, String password) {
        this.initialize(username, password);
        this.baseURL = baseURL;
        this.app = app;
        this.constructURL();
    }

    private void setBasicAuth(String username, String password) {
        this.basicauth = Credentials.basic((String)username, (String)password);
    }

    private void initialize(String username, String password) {
        this.setBasicAuth(username, password);
        this.ok = AppbaseClient.getUnsafeOkHttpClient().addInterceptor((Interceptor)new BasicAuthInterceptor(username, password)).build();
    }

    private static OkHttpClient.Builder getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AppbaseClient(String URL2, String app) {
        this.baseURL = URL2;
        this.initialize();
        this.app = app;
        this.constructURL();
    }

    private void initialize() {
        if (this.baseURL.contains("://") && this.baseURL.contains("@")) {
            int b;
            int a = this.baseURL.indexOf("://");
            if (this.baseURL.substring(a + 3, b = this.baseURL.indexOf("@")).contains(":")) {
                String[] x = this.baseURL.substring(a + 3, b).split(":");
                this.setBasicAuth(x[0], x[1]);
                this.ok = AppbaseClient.getUnsafeOkHttpClient().addInterceptor((Interceptor)new BasicAuthInterceptor(x[0], x[1])).build();
            }
            this.baseURL = this.baseURL.substring(0, a + 3) + this.baseURL.substring(b + 1);
            return;
        }
        this.ok = AppbaseClient.getUnsafeOkHttpClient().build();
    }

    private String constructURL() {
        if (this.baseURL.endsWith(SEPARATOR)) {
            this.URL = this.baseURL + this.app;
            return this.URL;
        }
        this.URL = this.baseURL + SEPARATOR + this.app;
        return this.URL;
    }

    private String querify(String body) {
        return "{\"query\":" + body + "}";
    }

    private String getURL(String type) {
        return this.URL + SEPARATOR + type;
    }

    private String getURL(String[] type) {
        String returnURL = this.URL + SEPARATOR;
        for (int i = 0; i < type.length; ++i) {
            returnURL = returnURL + type[i] + ",";
        }
        return returnURL.substring(0, returnURL.length() - 1);
    }

    private String getURL(String type, String id) {
        return this.URL + SEPARATOR + type + SEPARATOR + id;
    }

    public void setURL(String URL2) {
        this.baseURL = URL2;
        this.constructURL();
    }

    public void setApp(String app) {
        this.app = app;
        this.constructURL();
    }

    public AppbaseRequestBuilder prepareIndex(String type, String jsonDoc) {
        return new AppbaseRequestBuilder(this, type, null, 1).url(this.getURL(type)).post(jsonDoc);
    }

    public static RequestBody createBody(String jsonDoc) {
        return RequestBody.create((MediaType)JSON, (String)jsonDoc);
    }

    public AppbaseRequestBuilder prepareIndex(String type, byte[] jsonDoc) {
        return this.prepareIndex(type, new String(jsonDoc));
    }

    public AppbaseRequestBuilder prepareIndex(String type, JsonObject jsonDoc) {
        return this.prepareIndex(type, jsonDoc.toString());
    }

    public AppbaseRequestBuilder prepareIndex(String type, Map<String, Object> jsonDoc) {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(jsonDoc);
        return this.prepareIndex(type, json);
    }

    public AppbaseRequestBuilder prepareIndex(String type, String id, String jsonDoc) {
        return new AppbaseRequestBuilder(this, type, id, 1).url(this.getURL(type, id)).put(jsonDoc);
    }

    public AppbaseRequestBuilder prepareIndex(String type, String id, byte[] jsonDoc) {
        return this.prepareIndex(type, id, new String(jsonDoc));
    }

    public AppbaseRequestBuilder prepareIndex(String type, String id, JsonObject jsonDoc) {
        return this.prepareIndex(type, id, jsonDoc.toString());
    }

    public AppbaseRequestBuilder prepareIndex(String type, String id, Map<String, String> jsonDoc) {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(jsonDoc);
        return this.prepareIndex(type, id, json);
    }

    public AppbaseRequestBuilder prepareUpdate(String type, String id, List<Param> parameters, String jsonDoc) {
        return new AppbaseRequestBuilder(this, type, id, 2).url(this.getURL(type, id) + SEPARATOR + "_update").post(jsonDoc).addQueryParams(parameters);
    }

    public AppbaseRequestBuilder prepareUpdate(String type, String id, List<Param> parameters, byte[] jsonDoc) {
        return this.prepareUpdate(type, id, parameters, new String(jsonDoc));
    }

    public AppbaseRequestBuilder prepareUpdate(String type, String id, List<Param> parameters, JsonObject jsonDoc) {
        return this.prepareUpdate(type, id, parameters, jsonDoc.toString());
    }

    public AppbaseRequestBuilder prepareUpdate(String type, String id, List<Param> parameters, Map<String, Object> jsonDoc) {
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson(jsonDoc);
        return this.prepareUpdate(type, id, parameters, json);
    }

    public AppbaseRequestBuilder prepareDelete(String type, String id) {
        return new AppbaseRequestBuilder(this, type, id, 3).url(this.getURL(type, id)).delete();
    }

    public AppbaseRequestBuilder prepareBulkExecute(String request) {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.getURL("_bulk")).post(request);
    }

    public AppbaseRequestBuilder prepareGet(String type, String id) {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.getURL(type, id)).get();
    }

    public String getMappings() {
        Response f = this.prepareGetMappings().execute();
        try {
            return new String(f.body().bytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public AppbaseRequestBuilder prepareGetMappings() {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.URL + SEPARATOR + "_mapping").get();
    }

    public String getTypes() {
        String result = this.getMappings();
        JsonParser parser = new JsonParser();
        JsonObject object = parser.parse(result).getAsJsonObject();
        Set entries = object.getAsJsonObject(this.app).getAsJsonObject("mappings").entrySet();
        JsonArray ret = new JsonArray();
        for (Map.Entry entry : entries) {
            if (((String)entry.getKey()).equals("_default_")) continue;
            ret.add((String)entry.getKey());
        }
        return ret.toString();
    }

    public AppbaseRequestBuilder prepareSearch(String type, String body) {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.getURL(type) + SEPARATOR + "_search").post(this.querify(body));
    }

    public AppbaseRequestBuilder prepareSearch(String[] type, String body) {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.getURL(type) + SEPARATOR + "_search").post(this.querify(body));
    }

    public AppbaseRequestBuilder prepareSearch(String type, List<Param> parameters) {
        return new AppbaseRequestBuilder(this, null, null, 0).url(this.getURL(type) + SEPARATOR + "_search").addQueryParams(parameters).post(null);
    }

    public AppbaseRequestBuilder prepareSearchStreamToURL(String type, String query, String webhook) {
        JsonParser parser = new JsonParser();
        query = this.querify(query);
        JsonObject object = parser.parse(query).getAsJsonObject();
        JsonObject o = parser.parse(webhook).getAsJsonObject();
        object.add("webhooks", o.get("webhooks"));
        JsonArray arr = new JsonArray();
        arr.add(type);
        object.add("type", (JsonElement)arr);
        String path = ".percolator/webhooks-0-" + type + "-0-" + Base64.encodeBytes((byte[])this.getSerializedJson(query).getBytes());
        return this.prepareIndex(path, object);
    }

    private String getSerializedJson(String query) {
        JsonParser parser = new JsonParser();
        JsonObject object = parser.parse(query).getAsJsonObject();
        Gson gson = new Gson();
        TreeMap map = (TreeMap)gson.fromJson((JsonElement)object, TreeMap.class);
        String sortedJson = gson.toJson((Object)map);
        return sortedJson;
    }

    private JsonObject getSearchStreamJson(String type, String request) {
        JsonObject json = new JsonObject();
        Random r = new Random();
        int n = r.nextInt(5) + 5;
        String id = "";
        for (int i = 0; i < n + 1; ++i) {
            id = id + (char)(r.nextInt(25) + 97) + "";
        }
        json.addProperty("id", id);
        if (this.basicauth != null) {
            json.addProperty("authorization", this.basicauth);
        }
        json.addProperty("path", this.app + SEPARATOR + type + SEPARATOR + "_search?streamonly=true");
        JsonParser parser = new JsonParser();
        json.add("body", (JsonElement)parser.parse(request).getAsJsonObject());
        json.addProperty("method", "POST");
        return json;
    }

    public AppbaseWebsocketRequest prepareSearchStream(String type, String request) {
        return new AppbaseWebsocketRequest(this.getSearchStreamJson(type, request), this.baseURL);
    }
}

