/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing;

import java.util.LinkedList;
import spoon.SpoonException;
import spoon.processing.Processor;

public abstract class AbstractAssert<T extends AbstractAssert<T, A>, A> {
    protected final LinkedList<Processor<?>> processors = new LinkedList();
    protected final A actual;
    protected final T myself;

    protected AbstractAssert(A actual, Class<?> selfType) {
        this.myself = (AbstractAssert)selfType.cast(this);
        this.actual = actual;
    }

    public T withProcessor(Processor<?> processor) {
        this.processors.add(processor);
        return this.myself;
    }

    public T withProcessor(Class<? extends Processor<?>> processor) {
        try {
            this.withProcessor(processor.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instante class processor.", e);
        }
        return this.myself;
    }

    public T withProcessor(String qualifiedName) {
        try {
            this.withProcessor(Thread.currentThread().getContextClassLoader().loadClass(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            throw new SpoonException("Unable to load processor \"" + qualifiedName + "\"", e);
        }
        return this.myself;
    }

    public int hashCode() {
        return 1;
    }
}

