/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import spoon.SpoonException;

public class RtMethod {
    private Class<?> clazz;
    private String name;
    private Class<?> returnType;
    private TypeVariable<Method>[] typeParameters;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private int modifiers;
    private Annotation[] annotations;
    private Annotation[][] parameterAnnotations;
    private boolean isVarArgs;
    private boolean isDefault;
    private static Method _method_isDefault;

    public RtMethod(Class<?> clazz, String name, Class<?> returnType, TypeVariable<Method>[] typeParameters, Class<?>[] parameterTypes, Class<?>[] exceptionTypes, int modifiers, Annotation[] annotations, Annotation[][] parameterAnnotations, boolean isVarArgs, boolean isDefault) {
        this.clazz = clazz;
        this.name = name;
        this.returnType = returnType;
        this.typeParameters = typeParameters;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptionTypes;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.isVarArgs = isVarArgs;
        this.isDefault = isDefault;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        return this.typeParameters;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtMethod rtMethod = (RtMethod)o;
        if (this.name != null ? !this.name.equals(rtMethod.name) : rtMethod.name != null) {
            return false;
        }
        if (this.returnType != null ? !this.returnType.equals(rtMethod.returnType) : rtMethod.returnType != null) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, rtMethod.parameterTypes)) {
            return false;
        }
        return Arrays.equals(this.exceptionTypes, rtMethod.exceptionTypes);
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public static RtMethod create(Method method) {
        return new RtMethod(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameterTypes(), method.getExceptionTypes(), method.getModifiers(), method.getDeclaredAnnotations(), method.getParameterAnnotations(), method.isVarArgs(), RtMethod._java8_isDefault(method));
    }

    private static boolean _java8_isDefault(Method method) {
        if (_method_isDefault == null) {
            return false;
        }
        try {
            return (Boolean)_method_isDefault.invoke((Object)method, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SpoonException("Calling of Java8 Method#isDefault() failed", e);
        }
        catch (InvocationTargetException e) {
            throw new SpoonException("Calling of Java8 Method#isDefault() failed", e.getTargetException());
        }
    }

    public static <T> RtMethod[] methodsOf(Class<T> clazz) {
        RtMethod[] methods = new RtMethod[clazz.getDeclaredMethods().length];
        int i = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            methods[i++] = RtMethod.create(method);
        }
        return methods;
    }

    public static <T> RtMethod[] sameMethodsWithDifferentTypeOf(Class<T> superClass, List<RtMethod> comparedMethods) {
        ArrayList<RtMethod> methods = new ArrayList<RtMethod>();
        for (Method method : superClass.getDeclaredMethods()) {
            RtMethod rtMethod = RtMethod.create(method);
            for (RtMethod potential : comparedMethods) {
                if (!potential.isLightEquals(rtMethod) || rtMethod.returnType.equals(potential.returnType)) continue;
                methods.add(rtMethod);
            }
        }
        return methods.toArray(new RtMethod[methods.size()]);
    }

    private boolean isLightEquals(RtMethod rtMethod) {
        if (this == rtMethod) {
            return true;
        }
        if (rtMethod == null || this.getClass() != rtMethod.getClass()) {
            return false;
        }
        if (this.name != null ? !this.name.equals(rtMethod.name) : rtMethod.name != null) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, rtMethod.parameterTypes);
    }

    static {
        try {
            _method_isDefault = Method.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            _method_isDefault = null;
        }
    }
}

