/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;

public abstract class RtHelper {
    private RtHelper() {
    }

    public static Field[] getAllFields(Class<?> c) {
        ArrayList<Field> fields = new ArrayList<Field>();
        RtHelper.addAllFields(c, fields);
        Field[] result = new Field[fields.size()];
        return fields.toArray(result);
    }

    private static void addAllFields(Class<?> c, List<Field> fields) {
        if (c != null && c != Object.class) {
            for (Field field : c.getDeclaredFields()) {
                fields.add(field);
            }
            RtHelper.addAllFields(c.getSuperclass(), fields);
            for (AnnotatedElement annotatedElement : c.getInterfaces()) {
                RtHelper.addAllFields(annotatedElement, fields);
            }
        }
    }

    public static Collection<CtFieldReference<?>> getAllFields(Class<?> c, Factory factory) {
        ArrayList l = new ArrayList();
        for (Field f : RtHelper.getAllFields(c)) {
            l.add(factory.Field().createReference(f));
        }
        return l;
    }

    public static Method[] getAllMethods(Class<?> c) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (c.isInterface()) {
            RtHelper.getAllIMethods(c, methods);
        } else {
            while (c != null && c != Object.class) {
                for (Method m : c.getDeclaredMethods()) {
                    methods.add(m);
                }
                c = c.getSuperclass();
            }
        }
        Method[] result = new Method[methods.size()];
        return methods.toArray(result);
    }

    private static void getAllIMethods(Class<?> c, List<Method> methods) {
        for (Method method : c.getDeclaredMethods()) {
            methods.add(method);
        }
        for (GenericDeclaration genericDeclaration : c.getInterfaces()) {
            RtHelper.getAllIMethods(genericDeclaration, methods);
        }
    }

    public static <T> T invoke(CtInvocation<T> i) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object target = i.getTarget() == null ? null : ((CtLiteral)i.getTarget()).getValue();
        ArrayList args = new ArrayList();
        for (CtExpression<?> e : i.getArguments()) {
            args.add(((CtLiteral)e).getValue());
        }
        Class<?> c = i.getExecutable().getDeclaringType().getActualClass();
        ArrayList argTypes = new ArrayList();
        for (CtTypeReference<?> type : i.getExecutable().getActualTypeArguments()) {
            argTypes.add(type.getActualClass());
        }
        return (T)c.getMethod(i.getExecutable().getSimpleName(), argTypes.toArray(new Class[argTypes.size()])).invoke(target, args.toArray());
    }

    public static Set<ModifierKind> getModifiers(int mod) {
        HashSet<ModifierKind> set = new HashSet<ModifierKind>();
        if (Modifier.isAbstract(mod)) {
            set.add(ModifierKind.ABSTRACT);
        }
        if (Modifier.isFinal(mod)) {
            set.add(ModifierKind.FINAL);
        }
        if (Modifier.isNative(mod)) {
            set.add(ModifierKind.NATIVE);
        }
        if (Modifier.isPrivate(mod)) {
            set.add(ModifierKind.PRIVATE);
        }
        if (Modifier.isProtected(mod)) {
            set.add(ModifierKind.PROTECTED);
        }
        if (Modifier.isPublic(mod)) {
            set.add(ModifierKind.PUBLIC);
        }
        if (Modifier.isStatic(mod)) {
            set.add(ModifierKind.STATIC);
        }
        if (Modifier.isStrict(mod)) {
            set.add(ModifierKind.STRICTFP);
        }
        if (Modifier.isSynchronized(mod)) {
            set.add(ModifierKind.SYNCHRONIZED);
        }
        if (Modifier.isTransient(mod)) {
            set.add(ModifierKind.TRANSIENT);
        }
        if (Modifier.isVolatile(mod)) {
            set.add(ModifierKind.VOLATILE);
        }
        return set;
    }

    public static Collection<CtExecutableReference<?>> getAllExecutables(Class<?> clazz, Factory factory) {
        ArrayList l = new ArrayList();
        for (Method method : clazz.getDeclaredMethods()) {
            l.add(factory.Method().createReference(method));
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            l.add(factory.Constructor().createReference(executable));
        }
        return l;
    }

    public static Method getMethod(Class<?> clazz, String methodName, int numParams) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals(methodName) || (params = method.getParameterTypes()).length != numParams) continue;
            return method;
        }
        return null;
    }
}

