/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.reference;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import spoon.Launcher;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.reflect.visitor.filter.NameFilter;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.reference.CtReferenceImpl;
import spoon.support.reflect.reference.CtTypeReferenceImpl;
import spoon.support.util.RtHelper;
import spoon.support.visitor.SignaturePrinter;

public class CtExecutableReferenceImpl<T>
extends CtReferenceImpl
implements CtExecutableReference<T> {
    private static final long serialVersionUID = 1L;
    boolean stat = false;
    List<CtTypeReference<?>> actualTypeArguments = CtElementImpl.emptyList();
    CtTypeReference<?> declaringType;
    CtTypeReference<T> type;
    List<CtTypeReference<?>> parameters = CtElementImpl.emptyList();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtExecutableReference(this);
    }

    @Override
    public List<CtTypeReference<?>> getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public boolean isConstructor() {
        return this.getSimpleName().equals("<init>");
    }

    @Override
    public CtExecutable<T> getDeclaration() {
        CtTypeReference<?> typeRef = this.getDeclaringType();
        return typeRef == null ? null : this.getCtExecutable(typeRef.getDeclaration());
    }

    @Override
    public CtExecutable<T> getExecutableDeclaration() {
        return this.getCtExecutable(this.getDeclaringType().getTypeDeclaration());
    }

    private CtExecutable<T> getCtExecutable(CtType<?> typeDecl) {
        if (typeDecl == null) {
            return null;
        }
        CtMethod method = typeDecl.getMethod(this.getSimpleName(), this.parameters.toArray(new CtTypeReferenceImpl[this.parameters.size()]));
        if (method == null && typeDecl instanceof CtClass && this.getSimpleName().equals("<init>")) {
            try {
                return ((CtClass)typeDecl).getConstructor(this.parameters.toArray(new CtTypeReferenceImpl[this.parameters.size()]));
            }
            catch (ClassCastException e) {
                Launcher.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (method == null && this.getSimpleName().startsWith("lambda$")) {
            List elements = typeDecl.getElements(new NameFilter(this.getSimpleName()));
            if (elements.size() == 0) {
                return null;
            }
            return (CtExecutable)elements.get(0);
        }
        return method;
    }

    @Override
    public CtTypeReference<?> getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public CtTypeReference<T> getType() {
        return this.type;
    }

    @Override
    public List<CtTypeReference<?>> getParameters() {
        return CtExecutableReferenceImpl.unmodifiableList(this.parameters);
    }

    @Override
    public <C extends CtExecutableReference<T>> C setParameters(List<CtTypeReference<?>> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList();
        }
        this.parameters.clear();
        for (CtTypeReference<?> parameter : parameters) {
            if (parameter == null) continue;
            parameter.setParent(this);
            this.parameters.add(parameter);
        }
        return (C)this;
    }

    @Override
    public <S extends T> CtExecutableReference<S> getOverridingExecutable(CtTypeReference<?> subType) {
        if (subType == null || subType.equals(this.getDeclaringType())) {
            return null;
        }
        CtType<?> t = subType.getDeclaration();
        if (t == null) {
            return null;
        }
        if (!(t instanceof CtClass)) {
            return null;
        }
        CtClass c = (CtClass)t;
        for (CtMethod<?> m : c.getMethods()) {
            if (!m.getReference().isOverriding(this)) continue;
            return m.getReference();
        }
        return this.getOverridingExecutable(c.getSuperclass());
    }

    @Override
    public boolean isOverriding(CtExecutableReference<?> executable) {
        boolean isSame;
        boolean bl = isSame = this.getSimpleName().equals(executable.getSimpleName()) && this.getParameters().equals(executable.getParameters()) && this.getActualTypeArguments().equals(executable.getActualTypeArguments());
        if (!isSame) {
            return false;
        }
        return this.getDeclaringType().isSubtypeOf(executable.getDeclaringType());
    }

    public <C extends CtActualTypeContainer> C setActualTypeArguments(List<? extends CtTypeReference<?>> actualTypeArguments) {
        if (actualTypeArguments == null || actualTypeArguments.isEmpty()) {
            this.actualTypeArguments = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList();
        }
        this.actualTypeArguments.clear();
        for (CtTypeReference<?> actualTypeArgument : actualTypeArguments) {
            this.addActualTypeArgument(actualTypeArgument);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setDeclaringType(CtTypeReference<?> declaringType) {
        if (declaringType != null) {
            declaringType.setParent(this);
        }
        this.declaringType = declaringType;
        return (C)this;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setType(CtTypeReference<T> type) {
        if (type != null) {
            type.setParent(this);
        }
        this.type = type;
        return (C)this;
    }

    @Override
    protected AnnotatedElement getActualAnnotatedElement() {
        if (this.isConstructor()) {
            return this.getActualConstructor();
        }
        return this.getActualMethod();
    }

    @Override
    public Method getActualMethod() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        block0: for (Method m : this.getDeclaringType().getActualClass().getDeclaredMethods()) {
            if (!m.getDeclaringClass().isSynthetic() && m.isSynthetic() || !m.getName().equals(this.getSimpleName()) || m.getParameterTypes().length != parameters.size()) continue;
            for (int i = 0; i < parameters.size(); ++i) {
                if (m.getParameterTypes()[i] != parameters.get(i).getActualClass()) continue block0;
            }
            return m;
        }
        return null;
    }

    @Override
    public Constructor<?> getActualConstructor() {
        List<CtTypeReference<?>> parameters = this.getParameters();
        block0: for (Constructor<?> c : this.getDeclaringType().getActualClass().getDeclaredConstructors()) {
            if (c.getParameterTypes().length != parameters.size()) continue;
            for (int i = 0; i < parameters.size(); ++i) {
                if (c.getParameterTypes()[i] != parameters.get(i).getActualClass()) continue block0;
            }
            return c;
        }
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.stat;
    }

    @Override
    public <C extends CtExecutableReference<T>> C setStatic(boolean b) {
        this.stat = b;
        return (C)this;
    }

    @Override
    public boolean isFinal() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).hasModifier(ModifierKind.FINAL);
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).hasModifier(ModifierKind.FINAL);
            }
            return false;
        }
        Method m = this.getActualMethod();
        return m != null && Modifier.isFinal(m.getModifiers());
    }

    @Override
    public void replace(CtExecutableReference<?> reference) {
        super.replace(reference);
    }

    public Set<ModifierKind> getModifiers() {
        CtElement e = this.getDeclaration();
        if (e != null) {
            if (e instanceof CtMethod) {
                return ((CtMethod)e).getModifiers();
            }
            if (e instanceof CtConstructor) {
                return ((CtConstructor)e).getModifiers();
            }
            return CtElementImpl.emptySet();
        }
        Method m = this.getActualMethod();
        if (m != null) {
            return RtHelper.getModifiers(m.getModifiers());
        }
        Constructor<?> c = this.getActualConstructor();
        if (c != null) {
            return RtHelper.getModifiers(c.getModifiers());
        }
        return Collections.emptySet();
    }

    @Override
    public CtExecutableReference<?> getOverridingExecutable() {
        CtTypeReference<?> st = this.getDeclaringType().getSuperclass();
        CtTypeReference<Object> objectType = this.getFactory().Type().createReference(Object.class);
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(st, objectType);
    }

    private CtExecutableReference<?> getOverloadedExecutable(CtTypeReference<?> t, CtTypeReference<Object> objectType) {
        if (t == null) {
            return null;
        }
        for (CtExecutableReference<?> e : t.getDeclaredExecutables()) {
            if (!this.isOverriding(e)) continue;
            return e;
        }
        if (t.equals(objectType)) {
            return null;
        }
        CtTypeReference<?> st = t.getSuperclass();
        if (st == null) {
            return this.getOverloadedExecutable(objectType, objectType);
        }
        return this.getOverloadedExecutable(t.getSuperclass(), objectType);
    }

    public <C extends CtActualTypeContainer> C addActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        if (actualTypeArgument == null) {
            return (C)this;
        }
        if (this.actualTypeArguments == CtElementImpl.emptyList()) {
            this.actualTypeArguments = new ArrayList(2);
        }
        actualTypeArgument.setParent(this);
        this.actualTypeArguments.add(actualTypeArgument);
        return (C)this;
    }

    @Override
    public boolean removeActualTypeArgument(CtTypeReference<?> actualTypeArgument) {
        return this.actualTypeArguments != CtElementImpl.emptyList() && this.actualTypeArguments.remove(actualTypeArgument);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<T> clone() {
        return (CtExecutableReference)super.clone();
    }
}

