/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModifiable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtShadowable;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.EarlyTerminatingScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.AllTypeMembersFunction;
import spoon.reflect.visitor.filter.NameFilter;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.UnsettableProperty;
import spoon.support.compiler.SnippetCompilationHelper;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.util.SignatureBasedSortedSet;

public abstract class CtTypeImpl<T>
extends CtNamedElementImpl
implements CtType<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeParameter> formalCtTypeParameters = CtTypeImpl.emptyList();
    Set<CtTypeReference<?>> interfaces = CtTypeImpl.emptySet();
    Set<ModifierKind> modifiers = CtTypeImpl.emptySet();
    List<CtTypeMember> typeMembers = CtTypeImpl.emptyList();
    boolean isShadow;

    @Override
    public List<CtTypeMember> getTypeMembers() {
        return this.typeMembers;
    }

    @Override
    public <C extends CtType<T>> C addTypeMember(CtTypeMember member) {
        if (member == null) {
            return (C)this;
        }
        return this.addTypeMemberAt(this.typeMembers.size(), member);
    }

    @Override
    public <C extends CtType<T>> C addTypeMemberAt(int position, CtTypeMember member) {
        if (member == null) {
            return (C)this;
        }
        if (this.typeMembers == CtElementImpl.emptyList()) {
            this.typeMembers = new ArrayList<CtTypeMember>();
        }
        if (!this.typeMembers.contains(member)) {
            member.setParent(this);
            this.typeMembers.add(position, member);
        }
        return (C)this;
    }

    @Override
    public boolean removeTypeMember(CtTypeMember member) {
        if (this.typeMembers.size() == 1) {
            if (this.typeMembers.contains(member)) {
                this.typeMembers = CtTypeImpl.emptyList();
                return true;
            }
            return false;
        }
        return this.typeMembers.remove(member);
    }

    @Override
    public <C extends CtType<T>> C setTypeMembers(List<CtTypeMember> members) {
        if (members == null || members.isEmpty()) {
            this.typeMembers = CtTypeImpl.emptyList();
            return (C)this;
        }
        this.typeMembers.clear();
        for (CtTypeMember typeMember : members) {
            this.addTypeMember(typeMember);
        }
        return (C)this;
    }

    @Override
    public <F, C extends CtType<T>> C addFieldAtTop(CtField<F> field) {
        return this.addTypeMemberAt(0, field);
    }

    @Override
    public <F, C extends CtType<T>> C addField(CtField<F> field) {
        return this.addTypeMember(field);
    }

    @Override
    public <F, C extends CtType<T>> C addField(int index, CtField<F> field) {
        return this.addTypeMemberAt(index, field);
    }

    @Override
    public <C extends CtType<T>> C setFields(List<CtField<?>> fields) {
        if (fields == null || fields.isEmpty()) {
            this.typeMembers.removeAll(this.getFields());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getFields());
        for (CtField<?> field : fields) {
            this.addField(field);
        }
        return (C)this;
    }

    @Override
    public <F> boolean removeField(CtField<F> field) {
        return this.removeTypeMember(field);
    }

    @Override
    public CtField<?> getField(String name) {
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField) || !((CtField)typeMember).getSimpleName().equals(name)) continue;
            return (CtField)typeMember;
        }
        return null;
    }

    @Override
    public CtFieldReference<?> getDeclaredField(String name) {
        CtField<?> field = this.getField(name);
        return field != null ? this.getFactory().Field().createReference(field) : null;
    }

    @Override
    public CtFieldReference<?> getDeclaredOrInheritedField(String fieldName) {
        CtField field = (CtField)this.map(new AllTypeMembersFunction(CtField.class)).select(new NameFilter(fieldName)).first();
        return field == null ? null : field.getReference();
    }

    @Override
    public List<CtField<?>> getFields() {
        ArrayList fields = new ArrayList();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField)) continue;
            fields.add((CtField)typeMember);
        }
        return fields;
    }

    @Override
    public <N, C extends CtType<T>> C addNestedType(CtType<N> nestedType) {
        return this.addTypeMember(nestedType);
    }

    @Override
    public <N> boolean removeNestedType(CtType<N> nestedType) {
        return this.removeTypeMember(nestedType);
    }

    @Override
    public <C extends CtType<T>> C setNestedTypes(Set<CtType<?>> nestedTypes) {
        if (nestedTypes == null || nestedTypes.isEmpty()) {
            this.typeMembers.removeAll(this.getNestedTypes());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getNestedTypes());
        for (CtType<?> nestedType : nestedTypes) {
            this.addNestedType(nestedType);
        }
        return (C)this;
    }

    @Override
    public Set<CtTypeReference<?>> getUsedTypes(boolean includeSamePackage) {
        QualifiedNameBasedSortedSet typeRefs = new QualifiedNameBasedSortedSet();
        for (CtTypeReference typeRef : Query.getReferences(this, new ReferenceTypeFilter<CtTypeReference>(CtTypeReference.class))) {
            if (!this.isValidTypeReference(typeRef) || !this.shouldIncludeSamePackage(includeSamePackage, typeRef)) continue;
            typeRefs.add(typeRef);
        }
        return typeRefs;
    }

    private boolean shouldIncludeSamePackage(boolean includeSamePackage, CtTypeReference<?> typeRef) {
        return includeSamePackage || this.getPackage() != null && !CtTypeImpl.getPackageReference(typeRef).equals(this.getPackage().getReference());
    }

    private boolean isValidTypeReference(CtTypeReference<?> typeRef) {
        return !this.isFromJavaLang(typeRef) && !typeRef.isPrimitive() && !(typeRef instanceof CtArrayTypeReference) && !"<nulltype>".equals(typeRef.toString());
    }

    private boolean isFromJavaLang(CtTypeReference<?> typeRef) {
        return typeRef.getPackage() != null && "java.lang".equals(typeRef.getPackage().toString());
    }

    private static CtPackageReference getPackageReference(CtTypeReference<?> tref) {
        CtPackageReference pref = tref.getPackage();
        while (pref == null) {
            tref = tref.getDeclaringType();
            pref = tref.getPackage();
        }
        return pref;
    }

    @Override
    public Class<T> getActualClass() {
        return this.getFactory().Type().createReference(this).getActualClass();
    }

    @Override
    public CtType<?> getDeclaringType() {
        try {
            return this.getParent(CtType.class);
        }
        catch (ParentNotInitializedException ex) {
            return null;
        }
    }

    @Override
    public <T> CtType<T> getTopLevelType() {
        CtType<Object> top = this;
        CtType<?> nextTop;
        while ((nextTop = top.getDeclaringType()) != null) {
            top = nextTop;
        }
        return top;
    }

    @Override
    public <N extends CtType<?>> N getNestedType(final String name) {
        class NestedTypeScanner
        extends EarlyTerminatingScanner<CtType<?>> {
            NestedTypeScanner() {
            }

            private boolean checkType(CtType<?> type) {
                if (type.getSimpleName().equals(name) && CtTypeImpl.this.equals(type.getDeclaringType())) {
                    this.setResult(type);
                    this.terminate();
                    return true;
                }
                return false;
            }

            public <U> void visitCtClass(CtClass<U> ctClass) {
                if (!this.checkType(ctClass)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : ctClass.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtConstructor) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            public <U> void visitCtInterface(CtInterface<U> intrface) {
                if (!this.checkType(intrface)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : intrface.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            public <U extends Enum<?>> void visitCtEnum(CtEnum<U> ctEnum) {
                if (!this.checkType(ctEnum)) {
                    ArrayList<CtTypeMember> typeMembers = new ArrayList<CtTypeMember>();
                    for (CtTypeMember typeMember : ctEnum.getTypeMembers()) {
                        if (!(typeMember instanceof CtType) && !(typeMember instanceof CtConstructor) && !(typeMember instanceof CtMethod)) continue;
                        typeMembers.add(typeMember);
                    }
                    this.scan(typeMembers);
                }
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                if (!this.checkType(annotationType)) {
                    this.scan(annotationType.getNestedTypes());
                }
            }
        }
        NestedTypeScanner scanner = new NestedTypeScanner();
        scanner.scan(this);
        return (N)((CtType)scanner.getResult());
    }

    @Override
    public Set<CtType<?>> getNestedTypes() {
        QualifiedNameBasedSortedSet nestedTypes = new QualifiedNameBasedSortedSet();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtType)) continue;
            nestedTypes.add((CtType)typeMember);
        }
        return nestedTypes;
    }

    @Override
    public CtPackage getPackage() {
        if (this.parent instanceof CtPackage) {
            return (CtPackage)this.getParent();
        }
        if (this.parent instanceof CtType) {
            return ((CtType)this.parent).getPackage();
        }
        return null;
    }

    @Override
    public CtTypeReference<T> getReference() {
        return this.getFactory().Type().createReference(this);
    }

    @Override
    public boolean isTopLevel() {
        return this.getDeclaringType() == null && this.getPackage() != null;
    }

    @Override
    public void compileAndReplaceSnippets() {
        SnippetCompilationHelper.compileAndReplaceSnippetsIn(this);
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    public <C extends CtModifiable> C setModifiers(Set<ModifierKind> modifiers) {
        if (modifiers.size() > 0) {
            this.modifiers = EnumSet.copyOf(modifiers);
        }
        return (C)this;
    }

    public <C extends CtModifiable> C addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.of(modifier);
        }
        this.modifiers.add(modifier);
        return (C)this;
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return this.modifiers != CtElementImpl.emptySet() && this.modifiers.remove((Object)modifier);
    }

    public <C extends CtModifiable> C setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.emptySet()) {
            this.modifiers = EnumSet.noneOf(ModifierKind.class);
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
        return (C)this;
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isLocalType() {
        return this.isParentInitialized() && this.getParent() instanceof CtBlock;
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isGenerics() {
        return false;
    }

    public List<CtFieldReference<?>> getAllFields() {
        final ArrayList fields = new ArrayList();
        this.map(new AllTypeMembersFunction(CtField.class)).forEach(new CtConsumer<CtField<?>>(){

            @Override
            public void accept(CtField<?> field) {
                fields.add(field.getReference());
            }
        });
        return fields;
    }

    public List<CtFieldReference<?>> getDeclaredFields() {
        if (this.typeMembers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList fields = new ArrayList(this.typeMembers.size());
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtField)) continue;
            fields.add(((CtField)typeMember).getReference());
        }
        return fields;
    }

    @Override
    public <M, C extends CtType<T>> C addMethod(CtMethod<M> method) {
        if (method != null) {
            for (CtTypeMember typeMember : new ArrayList<CtTypeMember>(this.typeMembers)) {
                if (!(typeMember instanceof CtMethod)) continue;
                CtMethod m = (CtMethod)typeMember;
                if (m.getSignature().equals(method.getSignature())) {
                    this.typeMembers.remove(m);
                    continue;
                }
                if (!this.factory.getEnvironment().checksAreSkipped() && m.equals(method)) {
                    throw new AssertionError((Object)"violation of core contract! different signature but same equal");
                }
            }
        }
        return this.addTypeMember(method);
    }

    @Override
    public <M> boolean removeMethod(CtMethod<M> method) {
        return this.removeTypeMember(method);
    }

    @Override
    public <S, C extends CtType<T>> C addSuperInterface(CtTypeReference<S> interfac) {
        if (interfac == null) {
            return (C)this;
        }
        if (this.interfaces == CtElementImpl.emptySet()) {
            this.interfaces = new QualifiedNameBasedSortedSet();
        }
        interfac.setParent(this);
        this.interfaces.add(interfac);
        return (C)this;
    }

    @Override
    public <S> boolean removeSuperInterface(CtTypeReference<S> interfac) {
        if (this.interfaces.isEmpty()) {
            return false;
        }
        if (this.interfaces.size() == 1) {
            if (this.interfaces.contains(interfac)) {
                this.interfaces = CtElementImpl.emptySet();
                return true;
            }
            return false;
        }
        return this.interfaces.contains(interfac) && this.interfaces.remove(interfac);
    }

    @Override
    public List<CtTypeParameter> getFormalCtTypeParameters() {
        return this.formalCtTypeParameters;
    }

    public <C extends CtFormalTypeDeclarer> C setFormalCtTypeParameters(List<CtTypeParameter> formalTypeParameters) {
        if (formalTypeParameters == null || formalTypeParameters.isEmpty()) {
            this.formalCtTypeParameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        this.formalCtTypeParameters.clear();
        for (CtTypeParameter formalTypeParameter : formalTypeParameters) {
            this.addFormalCtTypeParameter(formalTypeParameter);
        }
        return (C)this;
    }

    public <C extends CtFormalTypeDeclarer> C addFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        if (formalTypeParameter == null) {
            return (C)this;
        }
        if (this.formalCtTypeParameters == CtElementImpl.emptyList()) {
            this.formalCtTypeParameters = new ArrayList<CtTypeParameter>(2);
        }
        formalTypeParameter.setParent(this);
        this.formalCtTypeParameters.add(formalTypeParameter);
        return (C)this;
    }

    @Override
    public boolean removeFormalCtTypeParameter(CtTypeParameter formalTypeParameter) {
        return this.formalCtTypeParameters.contains(formalTypeParameter) && this.formalCtTypeParameters.remove(formalTypeParameter);
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        for (CtTypeMember typeMember : this.typeMembers) {
            CtMethod m;
            if (!(typeMember instanceof CtMethod) || !(m = (CtMethod)typeMember).getSimpleName().equals(name) || !m.getType().equals(returnType)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        if (name == null) {
            return null;
        }
        for (CtMethod<?> candidate : this.getMethodsByName(name)) {
            boolean cont = candidate.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < candidate.getParameters().size() && i < parameterTypes.length; ++i) {
                CtTypeReference ctParameterType = candidate.getParameters().get(i).getType();
                CtTypeReference<?> parameterType = parameterTypes[i];
                if (parameterType instanceof CtArrayTypeReference) {
                    if (ctParameterType instanceof CtArrayTypeReference) {
                        if (!this.isSameParameter(((CtArrayTypeReference)ctParameterType).getComponentType(), ((CtArrayTypeReference)parameterType).getComponentType())) {
                            cont = false;
                            continue;
                        }
                        if (((CtArrayTypeReference)ctParameterType).getDimensionCount() == ((CtArrayTypeReference)parameterType).getDimensionCount()) continue;
                        cont = false;
                        continue;
                    }
                    cont = false;
                    continue;
                }
                if (this.isSameParameter(ctParameterType, parameterType)) continue;
                cont = false;
            }
            if (!cont) continue;
            return candidate;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSameParameter(CtTypeReference<?> ctParameterType, CtTypeReference<?> expectedType) {
        if (expectedType instanceof CtTypeParameterReference && ctParameterType instanceof CtTypeParameterReference) {
            if (ctParameterType.equals(expectedType)) return true;
            return false;
        }
        if (expectedType instanceof CtTypeParameterReference) {
            if (ctParameterType.isSubtypeOf(this.factory.Type().createReference(expectedType.getActualClass()))) return true;
            return false;
        }
        if (ctParameterType instanceof CtTypeParameterReference) {
            CtTypeParameter declaration = (CtTypeParameter)ctParameterType.getDeclaration();
            if (declaration.getSuperclass() instanceof CtIntersectionTypeReference) {
                for (CtTypeReference<?> ctTypeReference : declaration.getSuperclass().asCtIntersectionTypeReference().getBounds()) {
                    if (!ctTypeReference.equals(expectedType)) continue;
                    return true;
                }
                return true;
            } else {
                if (declaration.getSuperclass() == null) return this.getFactory().Type().objectType().equals(expectedType);
                return declaration.getSuperclass().equals(expectedType);
            }
        }
        if (expectedType.getQualifiedName().equals(ctParameterType.getQualifiedName())) return true;
        return false;
    }

    @Override
    public Set<CtMethod<?>> getMethods() {
        SignatureBasedSortedSet methods = new SignatureBasedSortedSet();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtMethod)) continue;
            methods.add((CtMethod)typeMember);
        }
        return methods;
    }

    @Override
    public Set<CtMethod<?>> getMethodsAnnotatedWith(CtTypeReference<?> ... annotationTypes) {
        SignatureBasedSortedSet result = new SignatureBasedSortedSet();
        for (CtTypeMember typeMember : this.typeMembers) {
            if (!(typeMember instanceof CtMethod)) continue;
            CtMethod m = (CtMethod)typeMember;
            for (CtAnnotation<? extends Annotation> a : m.getAnnotations()) {
                if (!Arrays.asList(annotationTypes).contains(a.getAnnotationType())) continue;
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public List<CtMethod<?>> getMethodsByName(String name) {
        ArrayList result = new ArrayList(1);
        for (CtTypeMember typeMember : this.typeMembers) {
            CtMethod m;
            if (!(typeMember instanceof CtMethod) || !name.equals((m = (CtMethod)typeMember).getSimpleName())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public boolean hasMethod(CtMethod<?> method) {
        if (method == null) {
            return false;
        }
        String over = method.getSignature();
        for (CtMethod<?> m : this.getMethods()) {
            if (!m.getSignature().equals(over)) continue;
            return true;
        }
        CtTypeReference<?> superCl = this.getSuperclass();
        try {
            if (superCl != null && superCl.getTypeDeclaration().hasMethod(method)) {
                return true;
            }
        }
        catch (SpoonException spoonException) {
            // empty catch block
        }
        for (CtTypeReference<?> interf : this.getSuperInterfaces()) {
            try {
                if (!interf.getTypeDeclaration().hasMethod(method)) continue;
                return true;
            }
            catch (SpoonException spoonException) {
            }
        }
        return false;
    }

    @Override
    public String getQualifiedName() {
        if (this.isTopLevel()) {
            if (this.getPackage() != null && !this.getPackage().isUnnamedPackage()) {
                return this.getPackage().getQualifiedName() + "." + this.getSimpleName();
            }
            return this.getSimpleName();
        }
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        return this.interfaces;
    }

    @Override
    public <C extends CtType<T>> C setMethods(Set<CtMethod<?>> methods) {
        if (methods == null || methods.isEmpty()) {
            this.typeMembers.removeAll(this.getMethods());
            return (C)this;
        }
        this.typeMembers.removeAll(this.getMethods());
        for (CtMethod<?> meth : methods) {
            this.addMethod(meth);
        }
        return (C)this;
    }

    @Override
    @UnsettableProperty
    public <C extends CtType<T>> C setSuperclass(CtTypeReference<?> superClass) {
        return (C)this;
    }

    @Override
    public <C extends CtType<T>> C setSuperInterfaces(Set<CtTypeReference<?>> interfaces) {
        if (interfaces == null || interfaces.isEmpty()) {
            this.interfaces = CtElementImpl.emptySet();
            return (C)this;
        }
        if (this.interfaces == CtElementImpl.emptySet()) {
            this.interfaces = new QualifiedNameBasedSortedSet();
        }
        this.interfaces.clear();
        for (CtTypeReference<?> anInterface : interfaces) {
            this.addSuperInterface(anInterface);
        }
        return (C)this;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        if (this.getMethods().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList l = new ArrayList(this.getMethods().size());
        for (CtExecutable ctExecutable : this.getMethods()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        SignatureBasedSortedSet l = new SignatureBasedSortedSet();
        for (CtMethod<?> m : this.getAllMethods()) {
            l.add(m.getReference());
        }
        return l;
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        final HashSet distinctSignatures = new HashSet();
        final SignatureBasedSortedSet l = new SignatureBasedSortedSet();
        this.map(new AllTypeMembersFunction(CtMethod.class)).forEach(new CtConsumer<CtMethod<?>>(){

            @Override
            public void accept(CtMethod<?> method) {
                if (distinctSignatures.add(method.getSignature())) {
                    l.add(method);
                }
            }
        });
        return Collections.unmodifiableSet(l);
    }

    @Override
    public boolean isShadow() {
        return this.isShadow;
    }

    @Override
    public <E extends CtShadowable> E setShadow(boolean isShadow) {
        this.isShadow = isShadow;
        return (E)this;
    }

    @Override
    public CtType<T> clone() {
        return (CtType)super.clone();
    }
}

