/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import spoon.reflect.code.CtComment;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.DefaultJavaPrettyPrinter;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.ModelConsistencyChecker;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtFunction;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.filter.AnnotationFilter;
import spoon.support.util.EmptyClearableList;
import spoon.support.util.EmptyClearableSet;
import spoon.support.visitor.HashcodeVisitor;
import spoon.support.visitor.TypeReferenceScanner;
import spoon.support.visitor.equals.CloneHelper;
import spoon.support.visitor.equals.EqualsVisitor;
import spoon.support.visitor.replace.ReplacementVisitor;

public abstract class CtElementImpl
implements CtElement,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(CtElementImpl.class);
    public static final String ERROR_MESSAGE_TO_STRING = "Error in printing the node. One parent isn't initialized!";
    transient Factory factory;
    protected CtElement parent;
    List<CtAnnotation<? extends Annotation>> annotations = CtElementImpl.emptyList();
    private List<CtComment> comments = CtElementImpl.emptyList();
    SourcePosition position = SourcePosition.NOPOSITION;
    Map<String, Object> metadata;
    boolean implicit = false;

    public static <T> List<T> emptyList() {
        return EmptyClearableList.instance();
    }

    public static <T> Set<T> emptySet() {
        return EmptyClearableSet.instance();
    }

    public static <T> List<T> unmodifiableList(List<T> list) {
        return list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public String getShortRepresentation() {
        return super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean ret = EqualsVisitor.equals(this, (CtElement)o);
        if (ret && !this.factory.getEnvironment().checksAreSkipped() && this.hashCode() != o.hashCode()) {
            throw new IllegalStateException("violation of equal/hashcode contract between \n" + this.toString() + "\nand\n" + o.toString() + "\n");
        }
        return ret;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().toString().equals(annotationType.getName().replace('$', '.'))) continue;
            return (A)a.getActualAnnotation();
        }
        return null;
    }

    @Override
    public <A extends Annotation> CtAnnotation<A> getAnnotation(CtTypeReference<A> annotationType) {
        for (CtAnnotation<? extends Annotation> a : this.getAnnotations()) {
            if (!a.getAnnotationType().equals(annotationType)) continue;
            return a;
        }
        return null;
    }

    @Override
    public List<CtAnnotation<? extends Annotation>> getAnnotations() {
        return CtElementImpl.unmodifiableList(this.annotations);
    }

    @Override
    public String getDocComment() {
        for (CtComment ctComment : this.comments) {
            if (ctComment.getCommentType() != CtComment.CommentType.JAVADOC) continue;
            return ctComment.getContent();
        }
        return null;
    }

    @Override
    public SourcePosition getPosition() {
        if (this.position != null) {
            return this.position;
        }
        return null;
    }

    public int hashCode() {
        HashcodeVisitor pr = new HashcodeVisitor();
        pr.scan(this);
        return pr.getHasCode();
    }

    @Override
    public <E extends CtElement> E setAnnotations(List<CtAnnotation<? extends Annotation>> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            this.annotations = CtElementImpl.emptyList();
            return (E)this;
        }
        this.annotations.clear();
        for (CtAnnotation<? extends Annotation> annot : annotations) {
            this.addAnnotation(annot);
        }
        return (E)this;
    }

    @Override
    public void delete() {
        this.replace(null);
    }

    @Override
    public <E extends CtElement> E addAnnotation(CtAnnotation<? extends Annotation> annotation) {
        if (annotation == null) {
            return (E)this;
        }
        if (this.annotations == CtElementImpl.emptyList()) {
            this.annotations = new ArrayList<CtAnnotation<? extends Annotation>>(2);
        }
        annotation.setParent(this);
        this.annotations.add(annotation);
        return (E)this;
    }

    @Override
    public boolean removeAnnotation(CtAnnotation<? extends Annotation> annotation) {
        return this.annotations != CtElementImpl.emptyList() && this.annotations.remove(annotation);
    }

    @Override
    public <E extends CtElement> E setDocComment(String docComment) {
        for (CtComment ctComment : this.comments) {
            if (ctComment.getCommentType() != CtComment.CommentType.JAVADOC) continue;
            ctComment.setContent(docComment);
            return (E)this;
        }
        this.addComment(this.factory.Code().createComment(docComment, CtComment.CommentType.JAVADOC));
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setPosition(SourcePosition position) {
        this.position = position;
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setPositions(final SourcePosition position) {
        this.accept(new CtScanner(){

            @Override
            public void enter(CtElement e) {
                e.setPosition(position);
            }
        });
        return (E)this;
    }

    public String toString() {
        DefaultJavaPrettyPrinter printer = new DefaultJavaPrettyPrinter(this.getFactory().getEnvironment());
        String errorMessage = "";
        try {
            printer.computeImports(this);
            printer.scan(this);
        }
        catch (ParentNotInitializedException ignore) {
            LOGGER.error((Object)ERROR_MESSAGE_TO_STRING, (Throwable)ignore);
            errorMessage = ERROR_MESSAGE_TO_STRING;
        }
        return printer.toString() + errorMessage;
    }

    @Override
    public <E extends CtElement> List<E> getAnnotatedChildren(Class<? extends Annotation> annotationType) {
        return Query.getElements(this, new AnnotationFilter<CtElement>(CtElement.class, annotationType));
    }

    @Override
    public boolean isImplicit() {
        return this.implicit;
    }

    @Override
    public <E extends CtElement> E setImplicit(boolean implicit) {
        this.implicit = implicit;
        return (E)this;
    }

    @Override
    public Set<CtTypeReference<?>> getReferencedTypes() {
        TypeReferenceScanner s = new TypeReferenceScanner();
        s.scan(this);
        return s.getReferences();
    }

    @Override
    public <E extends CtElement> List<E> getElements(Filter<E> filter) {
        return this.filterChildren((Filter)filter).list();
    }

    @Override
    public <I> CtQuery map(CtConsumableFunction<I> queryStep) {
        return this.factory.Query().createQuery(this).map(queryStep);
    }

    @Override
    public <I, R> CtQuery map(CtFunction<I, R> function) {
        return this.factory.Query().createQuery(this).map(function);
    }

    public <P extends CtElement> CtQuery filterChildren(Filter<P> predicate) {
        return this.factory.Query().createQuery(this).filterChildren(predicate);
    }

    @Override
    public CtElement getParent() throws ParentNotInitializedException {
        if (this.parent == null) {
            String exceptionMsg = "";
            if (this instanceof CtReference) {
                exceptionMsg = "parent not initialized for " + ((CtReference)((Object)this)).getSimpleName() + "(" + this.getClass() + ")";
            } else {
                SourcePosition pos = this.getPosition();
                exceptionMsg = this instanceof CtNamedElement ? "parent not initialized for " + ((CtNamedElement)((Object)this)).getSimpleName() + "(" + this.getClass() + ")" + (pos != null ? " " + pos : " (?)") : "parent not initialized for " + this.getClass() + (pos != null ? " " + pos : " (?)");
            }
            throw new ParentNotInitializedException(exceptionMsg);
        }
        return this.parent;
    }

    @Override
    public <E extends CtElement> E setParent(E parent) {
        this.parent = parent;
        return (E)this;
    }

    @Override
    public boolean isParentInitialized() {
        return this.parent != null;
    }

    @Override
    public <P extends CtElement> P getParent(Class<P> parentType) throws ParentNotInitializedException {
        if (this.parent == null) {
            return null;
        }
        if (parentType.isAssignableFrom(this.getParent().getClass())) {
            return (P)this.getParent();
        }
        return this.getParent().getParent(parentType);
    }

    @Override
    public <E extends CtElement> E getParent(Filter<E> filter) throws ParentNotInitializedException {
        CtElement current = this.getParent();
        while (true) {
            try {
                while (current != null && !filter.matches(current)) {
                    current = current.getParent();
                }
            }
            catch (ClassCastException e) {
                current = current.getParent();
                continue;
            }
            break;
        }
        if (current != null && filter.matches(current)) {
            return (E)current;
        }
        return null;
    }

    @Override
    public boolean hasParent(CtElement candidate) {
        try {
            return this != this.getFactory().getModel().getRootPackage() && (this.getParent() == candidate || this.getParent().hasParent(candidate));
        }
        catch (ParentNotInitializedException e) {
            return false;
        }
    }

    @Override
    public void updateAllParentsBelow() {
        new ModelConsistencyChecker(this.getFactory().getEnvironment(), true, true).scan(this);
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        LOGGER.setLevel(factory.getEnvironment().getLevel());
    }

    @Override
    public void replace(CtElement element) {
        ReplacementVisitor.replace(this, element);
    }

    @Override
    public <E extends CtElement> E putMetadata(String key, Object val) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, val);
        return (E)this;
    }

    @Override
    public Object getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    @Override
    public Set<String> getMetadataKeys() {
        return this.metadata.keySet();
    }

    @Override
    public List<CtComment> getComments() {
        return CtElementImpl.unmodifiableList(this.comments);
    }

    @Override
    public <E extends CtElement> E addComment(CtComment comment) {
        if (comment == null) {
            return (E)this;
        }
        if (this.comments == CtElementImpl.emptyList()) {
            this.comments = new ArrayList<CtComment>(2);
        }
        this.comments.add(comment);
        comment.setParent(this);
        return (E)this;
    }

    @Override
    public <E extends CtElement> E removeComment(CtComment comment) {
        if (this.comments != CtElementImpl.emptyList()) {
            this.comments.remove(comment);
        }
        return (E)this;
    }

    @Override
    public <E extends CtElement> E setComments(List<CtComment> comments) {
        if (comments == null || comments.isEmpty()) {
            this.comments = CtElementImpl.emptyList();
            return (E)this;
        }
        this.comments.clear();
        for (CtComment comment : comments) {
            this.addComment(comment);
        }
        return (E)this;
    }

    @Override
    public CtElement clone() {
        return CloneHelper.clone(this);
    }
}

