/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.cu.position;

import java.io.File;
import java.io.Serializable;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;

public class SourcePositionImpl
implements SourcePosition,
Serializable {
    private static final long serialVersionUID = 1L;
    private int sourceStart = -1;
    private int sourceEnd = -1;
    private int sourceStartline = -1;
    int[] lineSeparatorPositions;
    transient CompilationUnit compilationUnit;

    protected int searchLineNumber(int position) {
        if (this.lineSeparatorPositions == null) {
            return 1;
        }
        int length = this.lineSeparatorPositions.length;
        if (length == 0) {
            return -1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            int start = this.lineSeparatorPositions[m];
            if (position < start) {
                d = m - 1;
                continue;
            }
            if (position > start) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < this.lineSeparatorPositions[m]) {
            return m + 1;
        }
        return m + 2;
    }

    private int searchColumnNumber(int position) {
        if (this.lineSeparatorPositions == null) {
            return -1;
        }
        int length = this.lineSeparatorPositions.length;
        if (length == 0) {
            return -1;
        }
        int i = 0;
        for (i = 0; i < this.lineSeparatorPositions.length - 1; ++i) {
            if (this.lineSeparatorPositions[i] >= position || this.lineSeparatorPositions[i + 1] <= position) continue;
            return position - this.lineSeparatorPositions[i];
        }
        int tabCount = 0;
        int tabSize = 0;
        if (this.getCompilationUnit() != null) {
            tabSize = this.getCompilationUnit().getFactory().getEnvironment().getTabulationSize();
            String source = this.getCompilationUnit().getOriginalSourceCode();
            for (int j = this.lineSeparatorPositions[i]; j < position; ++j) {
                if (source.charAt(j) != '\t') continue;
                ++tabCount;
            }
        }
        return position - this.lineSeparatorPositions[i] - tabCount + tabCount * tabSize;
    }

    public SourcePositionImpl(CompilationUnit compilationUnit, int sourceStart, int sourceEnd, int[] lineSeparatorPositions) {
        this.compilationUnit = compilationUnit;
        this.sourceEnd = sourceEnd;
        this.sourceStart = sourceStart;
        this.lineSeparatorPositions = lineSeparatorPositions;
    }

    @Override
    public int getColumn() {
        return this.searchColumnNumber(this.sourceStart);
    }

    @Override
    public int getEndColumn() {
        return this.searchColumnNumber(this.sourceEnd);
    }

    @Override
    public File getFile() {
        if (this.compilationUnit == null) {
            return null;
        }
        return this.compilationUnit.getFile();
    }

    @Override
    public int getLine() {
        if (this.sourceStartline == -1) {
            this.sourceStartline = this.searchLineNumber(this.sourceStart);
        }
        return this.sourceStartline;
    }

    @Override
    public int getEndLine() {
        return this.searchLineNumber(this.sourceEnd);
    }

    @Override
    public int getSourceEnd() {
        return this.sourceEnd;
    }

    @Override
    public int getSourceStart() {
        return this.sourceStart;
    }

    @Override
    public String toString() {
        if (this.getFile() == null) {
            return "(unknown file)";
        }
        int ln = this.getLine();
        return ln >= 1 ? "(" + this.getFile().getAbsolutePath().replace('\\', '/').replace("C:/", "/") + ":" + ln + ")" : this.getFile().getAbsolutePath().replace('\\', '/').replace("C:/", "/");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourcePosition)) {
            return false;
        }
        SourcePosition s = (SourcePosition)obj;
        return (this.getFile() == null ? s.getFile() == null : this.getFile().equals(s.getFile())) && this.getLine() == s.getLine() && this.getColumn() == s.getColumn();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getLine();
        result = 31 * result + this.getColumn();
        result = 31 * result + (this.getFile() != null ? this.getFile().hashCode() : 1);
        return result;
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }
}

