/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.code;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtVisitor;
import spoon.support.reflect.code.CtExpressionImpl;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.util.QualifiedNameBasedSortedSet;
import spoon.support.visitor.SignaturePrinter;

public class CtLambdaImpl<T>
extends CtExpressionImpl<T>
implements CtLambda<T> {
    String simpleName = "";
    CtExpression<T> expression;
    CtBlock<?> body;
    List<CtParameter<?>> parameters = CtLambdaImpl.emptyList();
    Set<CtTypeReference<? extends Throwable>> thrownTypes = CtLambdaImpl.emptySet();

    @Override
    public void accept(CtVisitor visitor) {
        visitor.visitCtLambda(this);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public <C extends CtNamedElement> C setSimpleName(String simpleName) {
        this.simpleName = simpleName;
        return (C)this;
    }

    @Override
    public CtBlock<T> getBody() {
        return this.body;
    }

    public <C extends CtBodyHolder> C setBody(CtStatement statement) {
        if (statement != null) {
            CtBlock<?> body = this.getFactory().Code().getOrCreateCtBlock(statement);
            if (this.expression != null && body != null) {
                throw new SpoonException("A lambda can't have two bodys.");
            }
            if (body != null) {
                body.setParent(this);
            }
            this.body = body;
        } else {
            this.body = null;
        }
        return (C)this;
    }

    @Override
    public <R> CtMethod<R> getOverriddenMethod() {
        CtTypeReference lambdaTypeRef = this.getType();
        if (lambdaTypeRef == null) {
            return null;
        }
        CtType lambdaType = lambdaTypeRef.getTypeDeclaration();
        if (!lambdaType.isInterface()) {
            throw new SpoonException("The lambda can be based on interface only. But type " + lambdaTypeRef.getQualifiedName() + " is not an interface");
        }
        Set<CtMethod<?>> lambdaTypeMethods = lambdaType.getAllMethods();
        CtMethod<?> lambdaExecutableMethod = null;
        if (lambdaTypeMethods.size() == 1) {
            lambdaExecutableMethod = lambdaTypeMethods.iterator().next();
        } else {
            for (CtMethod<?> method : lambdaTypeMethods) {
                if (method.isDefaultMethod() || method.hasModifier(ModifierKind.PRIVATE) || method.hasModifier(ModifierKind.STATIC)) continue;
                if (lambdaExecutableMethod != null) {
                    throw new SpoonException("The lambda can be based on interface, which has only one method. But " + lambdaTypeRef.getQualifiedName() + " has at least two: " + lambdaExecutableMethod.getSignature() + " and " + method.getSignature());
                }
                lambdaExecutableMethod = method;
            }
        }
        if (lambdaExecutableMethod == null) {
            throw new SpoonException("The lambda can be based on interface, which has one method. But " + lambdaTypeRef.getQualifiedName() + " has no one");
        }
        return lambdaExecutableMethod;
    }

    @Override
    public List<CtParameter<?>> getParameters() {
        return CtLambdaImpl.unmodifiableList(this.parameters);
    }

    @Override
    public <C extends CtExecutable<T>> C setParameters(List<CtParameter<?>> params) {
        if (params == null || params.isEmpty()) {
            this.parameters = CtElementImpl.emptyList();
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        this.parameters.clear();
        for (CtParameter<?> p : params) {
            this.addParameter(p);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addParameter(CtParameter<?> parameter) {
        if (parameter == null) {
            return (C)this;
        }
        if (this.parameters == CtElementImpl.emptyList()) {
            this.parameters = new ArrayList(2);
        }
        parameter.setParent(this);
        this.parameters.add(parameter);
        return (C)this;
    }

    @Override
    public boolean removeParameter(CtParameter<?> parameter) {
        return this.parameters != CtElementImpl.emptyList() && this.parameters.remove(parameter);
    }

    @Override
    public Set<CtTypeReference<? extends Throwable>> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    public <C extends CtExecutable<T>> C setThrownTypes(Set<CtTypeReference<? extends Throwable>> thrownTypes) {
        if (thrownTypes == null || thrownTypes.isEmpty()) {
            this.thrownTypes = CtElementImpl.emptySet();
            return (C)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        this.thrownTypes.clear();
        for (CtTypeReference<? extends Throwable> thrownType : thrownTypes) {
            this.addThrownType(thrownType);
        }
        return (C)this;
    }

    @Override
    public <C extends CtExecutable<T>> C addThrownType(CtTypeReference<? extends Throwable> throwType) {
        if (throwType == null) {
            return (C)this;
        }
        if (this.thrownTypes == CtElementImpl.emptySet()) {
            this.thrownTypes = new QualifiedNameBasedSortedSet<CtTypeReference<? extends Throwable>>();
        }
        throwType.setParent(this);
        this.thrownTypes.add(throwType);
        return (C)this;
    }

    @Override
    public boolean removeThrownType(CtTypeReference<? extends Throwable> throwType) {
        return this.thrownTypes.remove(throwType);
    }

    @Override
    public String getSignature() {
        SignaturePrinter pr = new SignaturePrinter();
        pr.scan(this);
        return pr.getSignature();
    }

    @Override
    public CtExecutableReference<T> getReference() {
        return this.getFactory().Executable().createReference(this);
    }

    @Override
    public CtExpression<T> getExpression() {
        return this.expression;
    }

    @Override
    public <C extends CtLambda<T>> C setExpression(CtExpression<T> expression) {
        if (this.body != null && expression != null) {
            throw new SpoonException("A lambda can't have two bodys.");
        }
        if (expression != null) {
            expression.setParent(this);
        }
        this.expression = expression;
        return (C)this;
    }

    @Override
    public CtLambda<T> clone() {
        return (CtLambda)super.clone();
    }
}

