/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import spoon.reflect.code.CtLambda;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.PackageFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderHelper;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.TreeBuilderCompiler;

public class ReferenceBuilder {
    private Map<String, CtTypeReference<?>> basestypes = new TreeMap();
    private boolean bounds = false;
    private final JDTTreeBuilder jdtTreeBuilder;
    final Map<TypeBinding, CtTypeReference> bindingCache = new HashMap<TypeBinding, CtTypeReference>();

    ReferenceBuilder(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    private CtTypeReference<?> getBoundedTypeReference(TypeBinding binding) {
        this.bounds = true;
        CtTypeReference ref = this.getTypeReference(binding);
        this.bounds = false;
        return ref;
    }

    <T> CtTypeReference<T> buildTypeReference(TypeReference type, Scope scope) {
        if (type == null) {
            return null;
        }
        return this.buildTypeReferenceInternal(this.getTypeReference(type.resolvedType, type), type, scope);
    }

    <T> CtTypeReference<T> buildTypeReference(QualifiedTypeReference type, Scope scope) {
        CtTypeReference<T> ref;
        TypeBinding receiverType;
        CtTypeReference<T> accessedType = this.buildTypeReference((TypeReference)type, scope);
        TypeBinding typeBinding = receiverType = type != null ? type.resolvedType : null;
        if (receiverType != null && (ref = this.getQualifiedTypeReference(type.tokens, receiverType, receiverType.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

            @Override
            public boolean onAccess(char[][] tokens, int index) {
                return true;
            }
        })) != null) {
            accessedType = ref;
        }
        return accessedType;
    }

    private CtTypeParameterReference buildTypeParameterReference(TypeReference type, Scope scope) {
        if (type == null) {
            return null;
        }
        return (CtTypeParameterReference)this.buildTypeReferenceInternal(this.getTypeParameterReference(type.resolvedType, type), type, scope);
    }

    private <T> CtTypeReference<T> buildTypeReferenceInternal(CtTypeReference<T> typeReference, TypeReference type, Scope scope) {
        if (type == null) {
            return null;
        }
        CtTypeReference<Object> currentReference = typeReference;
        for (int position = type.getTypeName().length - 1; position >= 0 && currentReference != null; currentReference = currentReference.getDeclaringType(), --position) {
            this.jdtTreeBuilder.getContextBuilder().enter(currentReference, type);
            if (type.annotations != null && type.annotations.length - 1 <= position && type.annotations[position] != null && type.annotations[position].length > 0) {
                for (Expression expression : type.annotations[position]) {
                    if (scope instanceof ClassScope) {
                        ((Annotation)expression).traverse((ASTVisitor)this.jdtTreeBuilder, (ClassScope)scope);
                        continue;
                    }
                    if (scope instanceof BlockScope) {
                        ((Annotation)expression).traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)scope);
                        continue;
                    }
                    ((Annotation)expression).traverse((ASTVisitor)this.jdtTreeBuilder, (BlockScope)null);
                }
            }
            if (type.getTypeArguments() != null && type.getTypeArguments().length - 1 <= position && type.getTypeArguments()[position] != null && type.getTypeArguments()[position].length > 0) {
                currentReference.getActualTypeArguments().clear();
                for (Expression expression : type.getTypeArguments()[position]) {
                    if (expression instanceof Wildcard || ((TypeReference)expression).resolvedType instanceof WildcardBinding || ((TypeReference)expression).resolvedType instanceof TypeVariableBinding) {
                        currentReference.addActualTypeArgument(this.buildTypeParameterReference((TypeReference)expression, scope));
                        continue;
                    }
                    currentReference.addActualTypeArgument(this.buildTypeReference((TypeReference)expression, scope));
                }
            } else if ((type instanceof ParameterizedSingleTypeReference || type instanceof ParameterizedQualifiedTypeReference) && !this.isTypeArgumentExplicit(type.getTypeArguments())) {
                for (CtTypeReference<?> actualTypeArgument : currentReference.getActualTypeArguments()) {
                    actualTypeArgument.setImplicit(true);
                    if (!(actualTypeArgument instanceof CtArrayTypeReference)) continue;
                    ((CtArrayTypeReference)actualTypeArgument).getComponentType().setImplicit(true);
                }
            }
            if (type instanceof Wildcard && typeReference instanceof CtTypeParameterReference) {
                ((CtTypeParameterReference)typeReference).setBoundingType(this.buildTypeReference(((Wildcard)type).bound, scope));
            }
            this.jdtTreeBuilder.getContextBuilder().exit(type);
        }
        return typeReference;
    }

    private boolean isTypeArgumentExplicit(TypeReference[][] typeArguments) {
        if (typeArguments == null) {
            return true;
        }
        boolean isGenericTypeExplicit = true;
        for (TypeReference[] typeArgument : typeArguments) {
            boolean bl = isGenericTypeExplicit = typeArgument != null && typeArgument.length > 0;
            if (isGenericTypeExplicit) break;
        }
        return isGenericTypeExplicit;
    }

    <T> CtTypeReference<T> getQualifiedTypeReference(char[][] tokens, TypeBinding receiverType, ReferenceBinding enclosingType, JDTTreeBuilder.OnAccessListener listener) {
        if (enclosingType != null && Collections.disjoint(Arrays.asList(ModifierKind.PUBLIC, ModifierKind.PROTECTED), JDTTreeBuilderQuery.getModifiers(enclosingType.modifiers))) {
            TypeBinding accessBinding;
            int i;
            String access = "";
            CompilationUnitDeclaration[] units = ((TreeBuilderCompiler)this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.typeRequestor).unitsToProcess;
            for (i = 0; i < tokens.length; ++i) {
                char[][] qualified = (char[][])Arrays.copyOfRange(tokens, 0, i + 1);
                if (JDTTreeBuilderQuery.searchPackage(qualified, units) != null) continue;
                access = CharOperation.toString(qualified);
                break;
            }
            if (!access.contains(".")) {
                access = JDTTreeBuilderQuery.searchType(access, this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.imports);
            }
            if ((accessBinding = JDTTreeBuilderQuery.searchTypeBinding(access, units)) != null && listener.onAccess(tokens, i)) {
                TypeBinding superClassBinding = JDTTreeBuilderQuery.searchTypeBinding(accessBinding.superclass(), CharOperation.charToString(tokens[i + 1]));
                if (superClassBinding != null) {
                    return this.getTypeReference(superClassBinding.clone(accessBinding));
                }
                return this.getTypeReference(receiverType);
            }
            return this.getTypeReference(receiverType);
        }
        return null;
    }

    CtReference getDeclaringReferenceFromImports(char[] expectedName) {
        if (this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration != null && this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.imports != null) {
            for (ImportReference anImport : this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.imports) {
                if (!CharOperation.equals(anImport.getImportName()[anImport.getImportName().length - 1], expectedName)) continue;
                if (anImport.isStatic()) {
                    int indexDeclaring = 2;
                    if ((anImport.bits & 0x20000) != 0) {
                        indexDeclaring = 1;
                    }
                    char[][] packageName = CharOperation.subarray(anImport.getImportName(), 0, anImport.getImportName().length - indexDeclaring);
                    char[][] className = CharOperation.subarray(anImport.getImportName(), anImport.getImportName().length - indexDeclaring, anImport.getImportName().length - (indexDeclaring - 1));
                    PackageBinding aPackage = packageName.length != 0 ? this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createPackage(packageName) : null;
                    MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(aPackage, className);
                    this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = true;
                    CtTypeReference typeReference = this.getTypeReference(declaringType);
                    this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports = false;
                    return typeReference;
                }
                PackageBinding packageBinding = null;
                char[][] chars = CharOperation.subarray(anImport.getImportName(), 0, anImport.getImportName().length - 1);
                if (chars.length > 0) {
                    Binding someBinding = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.findImport(chars, false, false);
                    packageBinding = someBinding != null && someBinding.isValidBinding() && someBinding instanceof PackageBinding ? (PackageBinding)someBinding : this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createPackage(chars);
                }
                if (packageBinding == null) {
                    packageBinding = new PackageBinding(chars, null, this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment);
                }
                return this.getPackageReference(packageBinding);
            }
        }
        return null;
    }

    <T> CtExecutableReference<T> getExecutableReference(MethodBinding exec) {
        ArrayList parameters;
        if (exec == null) {
            return null;
        }
        CtExecutableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        if (exec.isConstructor()) {
            ref.setSimpleName("<init>");
            ref.setType(this.getTypeReference(exec.declaringClass));
        } else {
            ref.setSimpleName(new String(exec.selector));
            ref.setType(this.getTypeReference(exec.returnType));
        }
        if (exec instanceof ProblemMethodBinding) {
            if (exec.declaringClass != null && Arrays.asList(exec.declaringClass.methods()).contains(exec)) {
                ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            } else {
                CtReference declaringType = this.getDeclaringReferenceFromImports(exec.constantPoolName());
                if (declaringType instanceof CtTypeReference) {
                    ref.setDeclaringType((CtTypeReference)declaringType);
                }
            }
            if (exec.isConstructor()) {
                ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            }
            ref.setStatic(true);
        } else {
            ref.setDeclaringType(this.getTypeReference(exec.declaringClass));
            ref.setStatic(exec.isStatic());
        }
        if (exec.declaringClass instanceof ParameterizedTypeBinding) {
            ref.setDeclaringType(this.getTypeReference(exec.declaringClass.actualType()));
        }
        if (exec.original() != null) {
            parameters = new ArrayList(exec.original().parameters.length);
            for (TypeBinding b : exec.original().parameters) {
                parameters.add(this.getTypeReference(b));
            }
            ref.setParameters(parameters);
        } else if (exec.parameters != null) {
            parameters = new ArrayList();
            for (TypeBinding b : exec.parameters) {
                parameters.add(this.getTypeReference(b));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    <T> CtExecutableReference<T> getExecutableReference(AllocationExpression allocationExpression) {
        CtExecutableReference<T> ref;
        if (allocationExpression.binding != null) {
            ref = this.getExecutableReference(allocationExpression.binding);
        } else {
            ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            ref.setSimpleName("<init>");
            ref.setDeclaringType(this.getTypeReference(null, allocationExpression.type));
            ArrayList parameters = new ArrayList(allocationExpression.argumentTypes.length);
            for (TypeBinding b : allocationExpression.argumentTypes) {
                parameters.add(this.getTypeReference(b));
            }
            ref.setParameters(parameters);
        }
        if (allocationExpression.type == null) {
            ref.setType(this.getTypeReference(allocationExpression.expectedType()));
        }
        return ref;
    }

    <T> CtExecutableReference<T> getExecutableReference(MessageSend messageSend) {
        if (messageSend.binding != null) {
            return this.getExecutableReference(messageSend.binding);
        }
        CtExecutableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
        ref.setSimpleName(CharOperation.charToString(messageSend.selector));
        ref.setType(this.getTypeReference(messageSend.expectedType()));
        if (messageSend.receiver.resolvedType == null) {
            if (messageSend.receiver instanceof SingleNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((SingleNameReference)messageSend.receiver).getAccessedType());
            } else if (messageSend.receiver instanceof QualifiedNameReference) {
                ref.setDeclaringType(this.jdtTreeBuilder.getHelper().createTypeAccessNoClasspath((QualifiedNameReference)messageSend.receiver).getAccessedType());
            }
        } else {
            ref.setDeclaringType(this.getTypeReference(messageSend.receiver.resolvedType));
        }
        if (messageSend.arguments != null) {
            ArrayList parameters = new ArrayList();
            for (Expression expression : messageSend.arguments) {
                parameters.add(this.getTypeReference(expression.resolvedType));
            }
            ref.setParameters(parameters);
        }
        return ref;
    }

    private CtPackageReference getPackageReference(PackageBinding reference) {
        String name = new String(reference.shortReadableName());
        if (name.length() == 0) {
            return this.jdtTreeBuilder.getFactory().Package().topLevel();
        }
        CtPackageReference ref = this.jdtTreeBuilder.getFactory().Core().createPackageReference();
        ref.setSimpleName(name);
        return ref;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding, TypeReference ref) {
        CtTypeReference<T> ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
            return ctRef;
        }
        return this.getTypeReference(ref);
    }

    CtTypeReference<Object> getTypeParameterReference(TypeBinding binding, TypeReference ref) {
        CtTypeParameterReference ctRef = this.getTypeReference(binding);
        if (ctRef != null && this.isCorrectTypeReference(ref)) {
            if (!(ctRef instanceof CtTypeParameterReference)) {
                CtTypeParameterReference typeParameterRef = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
                typeParameterRef.setSimpleName(ctRef.getSimpleName());
                typeParameterRef.setDeclaringType(ctRef.getDeclaringType());
                typeParameterRef.setPackage(ctRef.getPackage());
                ctRef = typeParameterRef;
            }
            this.insertGenericTypesInNoClasspathFromJDTInSpoon(ref, ctRef);
            return ctRef;
        }
        return this.getTypeParameterReference(CharOperation.toString(ref.getParameterizedTypeName()));
    }

    private boolean isCorrectTypeReference(TypeReference ref) {
        if (ref.resolvedType == null) {
            return false;
        }
        if (!(ref.resolvedType instanceof ProblemReferenceBinding)) {
            return true;
        }
        String[] compoundName = CharOperation.charArrayToStringArray(((ProblemReferenceBinding)ref.resolvedType).compoundName);
        String[] typeName = CharOperation.charArrayToStringArray(ref.getTypeName());
        if (compoundName.length == 0 || typeName.length == 0) {
            return false;
        }
        return compoundName[compoundName.length - 1].equals(typeName[typeName.length - 1]);
    }

    private <T> void insertGenericTypesInNoClasspathFromJDTInSpoon(TypeReference original, CtTypeReference<T> type) {
        if (original.resolvedType instanceof ProblemReferenceBinding && original.getTypeArguments() != null) {
            for (TypeReference[] typeReferences : original.getTypeArguments()) {
                if (typeReferences == null) continue;
                for (TypeReference typeReference : typeReferences) {
                    type.addActualTypeArgument(this.getTypeReference(typeReference.resolvedType));
                }
            }
        }
    }

    <T> CtTypeReference<T> getTypeReference(TypeReference ref) {
        CtTypeReference<T> main;
        int index;
        CtTypeReference<T> res = null;
        CtTypeReference<T> inner = null;
        String[] namesParameterized = CharOperation.charArrayToStringArray(ref.getParameterizedTypeName());
        for (index = namesParameterized.length - 1; index >= 0 && (main = this.getTypeReference(namesParameterized[index])) != null; --index) {
            if (res == null) {
                res = main;
            } else {
                inner.setDeclaringType(main);
            }
            inner = main;
        }
        if (res == null) {
            return this.jdtTreeBuilder.getFactory().Type().createReference(CharOperation.toString(ref.getParameterizedTypeName()));
        }
        if (inner.getPackage() == null) {
            PackageFactory packageFactory = this.jdtTreeBuilder.getFactory().Package();
            CtPackageReference packageReference = index >= 0 ? packageFactory.getOrCreate(this.concatSubArray(namesParameterized, index)).getReference() : packageFactory.topLevel();
            inner.setPackage(packageReference);
        }
        return res;
    }

    private String concatSubArray(String[] a, int endIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < endIndex; ++i) {
            sb.append(a[i]).append('.');
        }
        sb.append(a[endIndex]);
        return sb.toString();
    }

    private <T> CtTypeReference<T> getTypeReference(String name) {
        CtTypeReference<Object> main = null;
        if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            main = name.startsWith("?") ? this.jdtTreeBuilder.getFactory().Core().createWildcardReference() : this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (m.find()) {
                String[] split;
                main.setSimpleName(m.group(1));
                for (String parameter : split = m.group(2).split(",")) {
                    main.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (Character.isUpperCase(name.charAt(0))) {
            main = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            main.setSimpleName(name);
            CtReference declaring = this.getDeclaringReferenceFromImports(name.toCharArray());
            this.setPackageOrDeclaringType(main, declaring);
        } else if (name.startsWith("?")) {
            return this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        }
        return main;
    }

    private CtTypeReference<Object> getTypeParameterReference(String name) {
        CtTypeReference<Object> param = null;
        if (name.contains("extends") || name.contains("super")) {
            String[] split = name.contains("extends") ? name.split("extends") : name.split("super");
            param = this.getTypeParameterReference(split[0].trim());
            ((CtTypeParameterReference)param).setBoundingType(this.getTypeReference(split[split.length - 1].trim()));
        } else if (name.matches(".*(<.+>)")) {
            Pattern pattern = Pattern.compile("([^<]+)<(.+)>");
            Matcher m = pattern.matcher(name);
            if (m.find()) {
                String[] split;
                param = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                param.setSimpleName(m.group(1));
                for (String parameter : split = m.group(2).split(",")) {
                    param.addActualTypeArgument(this.getTypeParameterReference(parameter.trim()));
                }
            }
        } else if (name.contains("?")) {
            param = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
        } else {
            param = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
            param.setSimpleName(name);
        }
        return param;
    }

    <T> CtTypeReference<T> getTypeReference(TypeBinding binding) {
        if (binding == null) {
            return null;
        }
        CtTypeReference<Object> ref = null;
        if (binding instanceof RawTypeBinding) {
            ref = this.getTypeReference(((ParameterizedTypeBinding)binding).genericType());
        } else if (binding instanceof ParameterizedTypeBinding) {
            if (binding.actualType() != null && binding.actualType() instanceof LocalTypeBinding) {
                ref = this.getTypeReference(binding.actualType());
            } else {
                ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                if (binding.isAnonymousType()) {
                    ref.setSimpleName("");
                } else {
                    ref.setSimpleName(String.valueOf(binding.sourceName()));
                    if (binding.enclosingType() != null) {
                        ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                    } else {
                        ref.setPackage(this.getPackageReference(binding.getPackage()));
                    }
                }
            }
            if (((ParameterizedTypeBinding)binding).arguments != null) {
                for (TypeBinding b : ((ParameterizedTypeBinding)binding).arguments) {
                    if (this.bindingCache.containsKey(b)) {
                        ref.addActualTypeArgument(this.getCtCircularTypeReference(b));
                        continue;
                    }
                    ref.addActualTypeArgument(this.getTypeReference(b));
                }
            }
        } else if (binding instanceof MissingTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.sourceName()));
            ref.setPackage(this.getPackageReference(binding.getPackage()));
            if (!this.jdtTreeBuilder.getContextBuilder().ignoreComputeImports) {
                CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
                if (declaring instanceof CtPackageReference) {
                    ref.setPackage((CtPackageReference)declaring);
                } else if (declaring instanceof CtTypeReference) {
                    ref.setDeclaringType((CtTypeReference)declaring);
                }
            }
        } else if (binding instanceof BinaryTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.enclosingType() != null) {
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                ref.setPackage(this.getPackageReference(binding.getPackage()));
            }
            ref.setSimpleName(new String(binding.sourceName()));
        } else if (binding instanceof TypeVariableBinding) {
            boolean oldBounds = this.bounds;
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeParameterReference();
            if (binding instanceof CaptureBinding) {
                ref = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
                this.bounds = true;
            } else {
                ref.setSimpleName(new String(binding.sourceName()));
            }
            TypeVariableBinding b = (TypeVariableBinding)binding;
            if (this.bounds) {
                if (b instanceof CaptureBinding && ((CaptureBinding)b).wildcard != null) {
                    this.bounds = oldBounds;
                    return this.getTypeReference(((CaptureBinding)b).wildcard);
                }
                if (b.superclass != null && b.firstBound == b.superclass) {
                    this.bounds = false;
                    this.bindingCache.put(binding, ref);
                    ((CtTypeParameterReference)ref).setBoundingType(this.getTypeReference(b.superclass));
                    this.bounds = oldBounds;
                }
            }
            if (this.bounds && b.superInterfaces != null && b.superInterfaces != Binding.NO_SUPERINTERFACES) {
                this.bounds = false;
                this.bindingCache.put(binding, ref);
                ArrayList bounds = new ArrayList();
                if (((CtTypeParameterReference)ref).getBoundingType() != null) {
                    bounds.add(((CtTypeParameterReference)ref).getBoundingType());
                }
                for (ReferenceBinding superInterface : b.superInterfaces) {
                    bounds.add(this.getTypeReference(superInterface));
                }
                ((CtTypeParameterReference)ref).setBoundingType(this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(bounds));
            }
            if (binding instanceof CaptureBinding) {
                this.bounds = false;
            }
        } else if (binding instanceof BaseTypeBinding) {
            String name = new String(binding.sourceName());
            ref = this.basestypes.get(name);
            if (ref == null) {
                ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
                ref.setSimpleName(name);
                this.basestypes.put(name, ref);
            } else {
                ref = ref == null ? ref : ref.clone();
            }
        } else if (binding instanceof WildcardBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createWildcardReference();
            if (((WildcardBinding)binding).boundKind == 2 && ref instanceof CtTypeParameterReference) {
                ((CtTypeParameterReference)ref).setUpper(false);
            }
            if (((WildcardBinding)binding).bound != null && ref instanceof CtTypeParameterReference) {
                if (this.bindingCache.containsKey(((WildcardBinding)binding).bound)) {
                    ref.setBoundingType(this.getCtCircularTypeReference(((WildcardBinding)binding).bound));
                } else {
                    ref.setBoundingType(this.getTypeReference(((WildcardBinding)binding).bound));
                }
            }
        } else if (binding instanceof LocalTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.isAnonymousType()) {
                ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                ref.setSimpleName(new String(binding.sourceName()));
                if (((LocalTypeBinding)binding).enclosingMethod == null && binding.enclosingType() != null && binding.enclosingType() instanceof LocalTypeBinding) {
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else if (binding.enclosingMethod() != null) {
                    ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                }
            }
        } else if (binding instanceof SourceTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            if (binding.isAnonymousType()) {
                ref.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(((SourceTypeBinding)binding).constantPoolName()));
                ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
            } else {
                ref.setSimpleName(new String(binding.sourceName()));
                if (binding.enclosingType() != null) {
                    ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
                } else {
                    ref.setPackage(this.getPackageReference(binding.getPackage()));
                }
            }
        } else if (binding instanceof ArrayBinding) {
            CtArrayTypeReference arrayref = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
            ref = arrayref;
            for (int i = 1; i < binding.dimensions(); ++i) {
                CtArrayTypeReference tmp = this.jdtTreeBuilder.getFactory().Core().createArrayTypeReference();
                arrayref.setComponentType(tmp);
                arrayref = tmp;
            }
            arrayref.setComponentType(this.getTypeReference(binding.leafComponentType()));
        } else if (binding instanceof PolyTypeBinding) {
            ref = this.jdtTreeBuilder.getFactory().Type().objectType();
        } else if (binding instanceof ProblemReferenceBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.readableName()));
            CtReference declaring = this.getDeclaringReferenceFromImports(binding.sourceName());
            this.setPackageOrDeclaringType(ref, declaring);
        } else if (binding instanceof JDTTreeBuilder.SpoonReferenceBinding) {
            ref = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
            ref.setSimpleName(new String(binding.sourceName()));
            ref.setDeclaringType(this.getTypeReference(binding.enclosingType()));
        } else if (binding instanceof IntersectionTypeBinding18) {
            ArrayList bounds = new ArrayList();
            for (ReferenceBinding superInterface : binding.getIntersectingTypes()) {
                bounds.add(this.getTypeReference(superInterface));
            }
            ref = this.jdtTreeBuilder.getFactory().Type().createIntersectionTypeReferenceWithBounds(bounds);
        } else {
            throw new RuntimeException("Unknown TypeBinding: " + binding.getClass() + " " + binding);
        }
        this.bindingCache.remove(binding);
        return ref;
    }

    private CtTypeReference<?> getCtCircularTypeReference(TypeBinding b) {
        return this.bindingCache.get(b).clone();
    }

    <T> CtVariableReference<T> getVariableReference(MethodBinding methbin) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        ref.setSimpleName(new String(methbin.selector));
        ref.setType(this.getTypeReference(methbin.returnType));
        if (methbin.declaringClass != null) {
            ref.setDeclaringType(this.getTypeReference(methbin.declaringClass));
        } else {
            ref.setDeclaringType(ref.getType());
        }
        return ref;
    }

    <T> CtFieldReference<T> getVariableReference(FieldBinding varbin) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (varbin == null) {
            return ref;
        }
        ref.setSimpleName(new String(varbin.name));
        ref.setType(this.getTypeReference(varbin.type));
        if (varbin.declaringClass != null) {
            ref.setDeclaringType(this.getTypeReference(varbin.declaringClass));
        } else {
            ref.setDeclaringType(ref.getType());
        }
        ref.setFinal(varbin.isFinal());
        ref.setStatic((varbin.modifiers & 8) != 0);
        return ref;
    }

    <T> CtFieldReference<T> getVariableReference(FieldBinding fieldBinding, char[] tokens) {
        CtFieldReference<T> ref = this.getVariableReference(fieldBinding);
        if (fieldBinding != null) {
            return ref;
        }
        ref.setSimpleName(CharOperation.charToString(tokens));
        return ref;
    }

    <T> CtVariableReference<T> getVariableReference(VariableBinding varbin) {
        if (varbin instanceof FieldBinding) {
            return this.getVariableReference((FieldBinding)varbin);
        }
        if (varbin instanceof LocalVariableBinding) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)varbin;
            if (localVariableBinding.declaration instanceof Argument && localVariableBinding.declaringScope instanceof MethodScope) {
                CtParameterReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createParameterReference();
                ref.setSimpleName(new String(varbin.name));
                ref.setType(this.getTypeReference(varbin.type));
                ReferenceContext referenceContext = localVariableBinding.declaringScope.referenceContext();
                if (referenceContext instanceof LambdaExpression) {
                    ref.setDeclaringExecutable(this.getExecutableReference(((LambdaExpression)referenceContext).binding));
                } else {
                    ref.setDeclaringExecutable(this.getExecutableReference(((AbstractMethodDeclaration)referenceContext).binding));
                }
                return ref;
            }
            if (localVariableBinding.declaration.binding instanceof CatchParameterBinding) {
                CtCatchVariableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createCatchVariableReference();
                ref.setSimpleName(new String(varbin.name));
                CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
                ref.setType(ref2);
                return ref;
            }
            CtLocalVariableReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createLocalVariableReference();
            ref.setSimpleName(new String(varbin.name));
            CtTypeReference<T> ref2 = this.getTypeReference(varbin.type);
            ref.setType(ref2);
            return ref;
        }
        return null;
    }

    <T> CtVariableReference<T> getVariableReference(ProblemBinding binding) {
        CtFieldReference<T> ref = this.jdtTreeBuilder.getFactory().Core().createFieldReference();
        if (binding == null) {
            return ref;
        }
        ref.setSimpleName(new String(binding.name));
        ref.setType(this.getTypeReference(binding.searchType));
        return ref;
    }

    List<CtTypeReference<?>> getBoundedTypesReferences(TypeBinding[] genericTypeArguments) {
        ArrayList res = new ArrayList(genericTypeArguments.length);
        for (TypeBinding tb : genericTypeArguments) {
            res.add(this.getBoundedTypeReference(tb));
        }
        return res;
    }

    void setPackageOrDeclaringType(CtTypeReference<?> ref, CtReference declaring) {
        if (declaring instanceof CtPackageReference) {
            ref.setPackage((CtPackageReference)declaring);
        } else if (declaring instanceof CtTypeReference) {
            ref.setDeclaringType((CtTypeReference)declaring);
        } else if (declaring == null) {
            ref.setPackage(this.jdtTreeBuilder.getFactory().Package().topLevel());
        } else {
            throw new AssertionError((Object)("unexpected declaring type: " + declaring.getClass() + " of " + declaring));
        }
    }

    public CtExecutableReference<?> getLambdaExecutableReference(SingleNameReference singleNameReference) {
        ASTPair potentialLambda = null;
        for (ASTPair astPair : this.jdtTreeBuilder.getContextBuilder().stack) {
            if (!(astPair.node instanceof LambdaExpression)) continue;
            potentialLambda = astPair;
            break;
        }
        if (potentialLambda == null) {
            return null;
        }
        LambdaExpression lambdaJDT = (LambdaExpression)potentialLambda.node;
        for (Argument argument : lambdaJDT.arguments()) {
            if (!CharOperation.equals(argument.name, singleNameReference.token)) continue;
            CtTypeReference declaringType = null;
            if (lambdaJDT.enclosingScope instanceof MethodScope) {
                declaringType = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(((MethodScope)lambdaJDT.enclosingScope).parent.enclosingSourceType());
            }
            CtLambda ctLambda = (CtLambda)potentialLambda.element;
            ArrayList parametersType = new ArrayList();
            List<CtParameter<?>> parameters = ctLambda.getParameters();
            for (CtParameter<?> parameter : parameters) {
                parametersType.add(parameter.getType() != null ? parameter.getType().clone() : this.jdtTreeBuilder.getFactory().Type().OBJECT.clone());
            }
            return this.jdtTreeBuilder.getFactory().Executable().createReference(declaringType, ctLambda.getType(), ctLambda.getSimpleName(), parametersType);
        }
        return null;
    }
}

