/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.CoreFactory;
import spoon.reflect.factory.ExecutableFactory;
import spoon.reflect.factory.TypeFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.support.compiler.jdt.ASTPair;
import spoon.support.compiler.jdt.ContextBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilder;
import spoon.support.compiler.jdt.JDTTreeBuilderQuery;
import spoon.support.compiler.jdt.PositionBuilder;
import spoon.support.compiler.jdt.ReferenceBuilder;

public class JDTTreeBuilderHelper {
    private final JDTTreeBuilder jdtTreeBuilder;

    JDTTreeBuilderHelper(JDTTreeBuilder jdtTreeBuilder) {
        this.jdtTreeBuilder = jdtTreeBuilder;
    }

    static String computeAnonymousName(char[] anonymousQualifiedName) {
        String poolName = CharOperation.charToString(anonymousQualifiedName);
        return poolName.substring(poolName.lastIndexOf("$") + 1, poolName.length());
    }

    static String createQualifiedTypeName(char[][] typeName) {
        String s = "";
        for (int i = 0; i < typeName.length - 1; ++i) {
            s = s + CharOperation.charToString(typeName[i]) + ".";
        }
        s = s + CharOperation.charToString(typeName[typeName.length - 1]);
        return s;
    }

    CtCatchVariable<Throwable> createCatchVariable(TypeReference typeReference) {
        Argument jdtCatch = (Argument)this.jdtTreeBuilder.getContextBuilder().stack.peekFirst().node;
        Set<ModifierKind> modifiers = JDTTreeBuilderQuery.getModifiers(jdtCatch.modifiers);
        return this.jdtTreeBuilder.getFactory().Code().createCatchVariable(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(typeReference.resolvedType), CharOperation.charToString(jdtCatch.name), modifiers.toArray(new ModifierKind[modifiers.size()]));
    }

    public <T> CtVariableAccess<T> createVariableAccess(CtVariableReference<T> variableReference, boolean isReadAccess) {
        CtVariableAccess<T> variableAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        return variableAccess.setVariable(variableReference);
    }

    <T> CtVariableAccess<T> createVariableAccess(SingleNameReference singleNameReference) {
        CtVariableAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createVariableWrite() : this.jdtTreeBuilder.getFactory().Core().createVariableRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)singleNameReference.binding));
        return va;
    }

    <T> CtVariableAccess<T> createVariableAccessNoClasspath(SingleNameReference singleNameReference) {
        CtVariableAccess variableAccess;
        CtVariableReference variableReference;
        TypeFactory typeFactory = this.jdtTreeBuilder.getFactory().Type();
        CoreFactory coreFactory = this.jdtTreeBuilder.getFactory().Core();
        ExecutableFactory executableFactory = this.jdtTreeBuilder.getFactory().Executable();
        ContextBuilder contextBuilder = this.jdtTreeBuilder.getContextBuilder();
        ReferenceBuilder referenceBuilder = this.jdtTreeBuilder.getReferencesBuilder();
        PositionBuilder positionBuilder = this.jdtTreeBuilder.getPositionBuilder();
        String name = CharOperation.charToString(singleNameReference.token);
        CtVariable variable = contextBuilder.getVariableDeclaration(name);
        if (variable == null) {
            return null;
        }
        if (variable instanceof CtParameter) {
            CtParameterReference parameterReference = coreFactory.createParameterReference();
            if (variable.getParent() instanceof CtLambda) {
                parameterReference.setDeclaringExecutable(referenceBuilder.getLambdaExecutableReference(singleNameReference));
            } else {
                CtExecutable executable = (CtExecutable)variable.getParent();
                ArrayList parameterTypesOfExecutable = new ArrayList();
                List<CtParameter<?>> parametersOfExecutable = executable.getParameters();
                for (CtParameter<?> parameter : parametersOfExecutable) {
                    parameterTypesOfExecutable.add(parameter.getType() != null ? parameter.getType().clone() : typeFactory.OBJECT.clone());
                }
                AbstractMethodDeclaration executableJDT = null;
                for (ASTPair astPair : contextBuilder.stack) {
                    if (astPair.element != executable) continue;
                    executableJDT = (AbstractMethodDeclaration)astPair.node;
                }
                assert (executableJDT != null);
                CtTypeReference declaringReferenceOfExecutable = executableJDT.binding == null ? coreFactory.createTypeReference() : referenceBuilder.getTypeReference(executableJDT.binding.declaringClass);
                CtTypeReference executableTypeReference = executable instanceof CtConstructor ? declaringReferenceOfExecutable.clone() : executable.getType().clone();
                CtExecutableReference executableReference = executableFactory.createReference(declaringReferenceOfExecutable, executableTypeReference, executable.getSimpleName(), parameterTypesOfExecutable);
                parameterReference.setDeclaringExecutable(executableReference);
            }
            variableReference = parameterReference;
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        } else if (variable instanceof CtField) {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createFieldWrite() : coreFactory.createFieldRead();
        } else {
            variableReference = variable.getReference();
            variableAccess = JDTTreeBuilderQuery.isLhsAssignment(contextBuilder, singleNameReference) ? coreFactory.createVariableWrite() : coreFactory.createVariableRead();
        }
        variableReference.setSimpleName(name);
        variableReference.setPosition(positionBuilder.buildPosition(singleNameReference.sourceStart(), singleNameReference.sourceEnd()));
        variableAccess.setVariable(variableReference);
        return variableAccess;
    }

    <T> CtVariableAccess<T> createVariableAccess(QualifiedNameReference qualifiedNameReference) {
        CtVariableAccess va;
        CtVariableReference ref;
        boolean isOtherBinding;
        long[] positions = qualifiedNameReference.sourcePositions;
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        if (qualifiedNameReference.indexOfFirstFieldBinding < positions.length) {
            sourceEnd = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding] >>> 32) - 2;
        }
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), qualifiedNameReference);
        boolean bl = isOtherBinding = qualifiedNameReference.otherBindings == null || qualifiedNameReference.otherBindings.length == 0;
        if (qualifiedNameReference.binding instanceof FieldBinding) {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(qualifiedNameReference.fieldBinding());
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
            va = this.createFieldAccess(ref, this.createTargetFieldAccess(qualifiedNameReference, (CtFieldReference)ref), isOtherBinding && fromAssignment);
        } else {
            ref = this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((VariableBinding)qualifiedNameReference.binding);
            ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
            va = this.createVariableAccess(ref, isOtherBinding && fromAssignment);
        }
        ref.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        if (qualifiedNameReference.otherBindings != null) {
            int i = 0;
            va.setPosition(ref.getPosition());
            sourceStart = (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32);
            for (FieldBinding b : qualifiedNameReference.otherBindings) {
                isOtherBinding = qualifiedNameReference.otherBindings.length == i + 1;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(b, qualifiedNameReference.tokens[i + 1]), va, isOtherBinding && fromAssignment);
                sourceEnd = i + qualifiedNameReference.indexOfFirstFieldBinding >= qualifiedNameReference.otherBindings.length ? qualifiedNameReference.sourceEnd() : (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding + i + 1] >>> 32) - 2;
                other.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
                ++i;
            }
        } else if (!(qualifiedNameReference.binding instanceof FieldBinding) && qualifiedNameReference.tokens.length > 1) {
            sourceStart = (int)(positions[0] >>> 32);
            for (int i = 1; i < qualifiedNameReference.tokens.length; ++i) {
                isOtherBinding = qualifiedNameReference.tokens.length == i + 1;
                CtFieldAccess other = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(null, qualifiedNameReference.tokens[i]), va, isOtherBinding && fromAssignment);
                sourceEnd = (int)positions[i];
                va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
                va = other;
            }
        }
        va.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), qualifiedNameReference.sourceEnd()));
        return va;
    }

    public <T> CtFieldAccess<T> createFieldAccess(CtVariableReference<T> variableReference, CtExpression<?> target, boolean isReadAccess) {
        CtFieldAccess<T> fieldAccess = isReadAccess ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(variableReference);
        fieldAccess.setTarget(target);
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(singleNameReference.fieldBinding().original()));
        if (va.getVariable() != null) {
            CtFieldReference ref = va.getVariable();
            if (ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
                va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(ref.getDeclaringType()));
            } else if (!ref.isStatic()) {
                va.setTarget(this.jdtTreeBuilder.getFactory().Code().createThisAccess(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(singleNameReference.actualReceiverType), true));
            }
        }
        return va;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(SingleNameReference singleNameReference) {
        CtFieldAccess va = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), singleNameReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        va.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)singleNameReference.binding));
        CtReference declaring = this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token);
        if (declaring instanceof CtTypeReference && va.getVariable() != null) {
            CtTypeReference declaringRef = (CtTypeReference)declaring;
            va.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef));
            va.getVariable().setDeclaringType(declaringRef);
            va.getVariable().setStatic(true);
        }
        return va;
    }

    <T> CtFieldAccess<T> createFieldAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        boolean fromAssignment = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), qualifiedNameReference);
        CtFieldAccess fieldAccess = this.createFieldAccess(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference((ProblemBinding)qualifiedNameReference.binding), null, fromAssignment);
        char[][] declaringClass = CharOperation.subarray(qualifiedNameReference.tokens, 0, qualifiedNameReference.tokens.length - 1);
        MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(null, declaringClass);
        CtTypeReference declaringRef = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringType);
        fieldAccess.getVariable().setDeclaringType(declaringRef);
        fieldAccess.getVariable().setStatic(true);
        fieldAccess.setTarget(this.jdtTreeBuilder.getFactory().Code().createTypeAccess(declaringRef));
        fieldAccess.getVariable().setSimpleName(JDTTreeBuilderHelper.createQualifiedTypeName(CharOperation.subarray(qualifiedNameReference.tokens, qualifiedNameReference.tokens.length - 1, qualifiedNameReference.tokens.length)));
        return fieldAccess;
    }

    <T> CtFieldAccess<T> createFieldAccess(FieldReference fieldReference) {
        CtFieldAccess fieldAccess = JDTTreeBuilderQuery.isLhsAssignment(this.jdtTreeBuilder.getContextBuilder(), fieldReference) ? this.jdtTreeBuilder.getFactory().Core().createFieldWrite() : this.jdtTreeBuilder.getFactory().Core().createFieldRead();
        fieldAccess.setVariable(this.jdtTreeBuilder.getReferencesBuilder().getVariableReference(fieldReference.binding, fieldReference.token));
        fieldAccess.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(fieldReference.resolvedType));
        return fieldAccess;
    }

    CtTypeAccess<?> createTypeAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<?> fieldReference) {
        TypeBinding receiverType = qualifiedNameReference.actualReceiverType;
        if (receiverType != null) {
            CtTypeReference qualifiedRef = this.jdtTreeBuilder.getReferencesBuilder().getQualifiedTypeReference(qualifiedNameReference.tokens, receiverType, qualifiedNameReference.fieldBinding().declaringClass.enclosingType(), new JDTTreeBuilder.OnAccessListener(){

                @Override
                public boolean onAccess(char[][] tokens, int index) {
                    return !CharOperation.equals(tokens[index + 1], tokens[tokens.length - 1]);
                }
            });
            if (qualifiedRef != null) {
                fieldReference.setDeclaringType(qualifiedRef);
            } else {
                fieldReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(receiverType));
            }
        }
        CtTypeAccess<?> typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(fieldReference.getDeclaringType());
        if (qualifiedNameReference.indexOfFirstFieldBinding > 1) {
            long[] positions = qualifiedNameReference.sourcePositions;
            typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(qualifiedNameReference.sourceStart(), (int)(positions[qualifiedNameReference.indexOfFirstFieldBinding - 1] >>> 32) - 2));
        } else {
            typeAccess.setImplicit(qualifiedNameReference.isImplicitThis());
        }
        return typeAccess;
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(QualifiedNameReference qualifiedNameReference) {
        CtTypeReference typeReference;
        if (qualifiedNameReference.binding instanceof ProblemBinding) {
            typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(CharOperation.toString(qualifiedNameReference.tokens));
        } else if (qualifiedNameReference.binding instanceof FieldBinding) {
            ReferenceBinding declaringClass = ((FieldBinding)qualifiedNameReference.binding).declaringClass;
            typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringClass);
        } else {
            char[][] packageName = CharOperation.subarray(qualifiedNameReference.tokens, 0, qualifiedNameReference.tokens.length - 1);
            char[][] className = CharOperation.subarray(qualifiedNameReference.tokens, qualifiedNameReference.tokens.length - 1, qualifiedNameReference.tokens.length);
            if (packageName.length > 0) {
                PackageBinding aPackage = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createPackage(packageName);
                MissingTypeBinding declaringType = this.jdtTreeBuilder.getContextBuilder().compilationunitdeclaration.scope.environment.createMissingType(aPackage, className);
                typeReference = this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(declaringType);
            } else {
                typeReference = this.jdtTreeBuilder.getFactory().Type().createReference(qualifiedNameReference.toString());
            }
        }
        CtTypeAccess typeAccess = this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
        int sourceStart = qualifiedNameReference.sourceStart();
        int sourceEnd = qualifiedNameReference.sourceEnd();
        typeAccess.setPosition(this.jdtTreeBuilder.getPositionBuilder().buildPosition(sourceStart, sourceEnd));
        return typeAccess;
    }

    <T> CtTypeAccess<T> createTypeAccessNoClasspath(SingleNameReference singleNameReference) {
        CtTypeReference typeReference = this.jdtTreeBuilder.getFactory().Core().createTypeReference();
        if (singleNameReference.binding == null) {
            typeReference.setSimpleName(CharOperation.charToString(singleNameReference.token));
        } else {
            typeReference.setSimpleName(CharOperation.charToString(singleNameReference.binding.readableName()));
        }
        this.jdtTreeBuilder.getReferencesBuilder().setPackageOrDeclaringType(typeReference, this.jdtTreeBuilder.getReferencesBuilder().getDeclaringReferenceFromImports(singleNameReference.token));
        return this.jdtTreeBuilder.getFactory().Code().createTypeAccess(typeReference);
    }

    CtExpression<?> createTargetFieldAccess(QualifiedNameReference qualifiedNameReference, CtFieldReference<Object> ref) {
        CtExpression<Void> target = null;
        if (JDTTreeBuilderQuery.isValidProblemBindingField(qualifiedNameReference)) {
            target = this.createTypeAccessNoClasspath(qualifiedNameReference);
        } else if (ref.isStatic()) {
            target = this.createTypeAccess(qualifiedNameReference, ref);
        } else if (!ref.isStatic() && !ref.getDeclaringType().isAnonymous()) {
            target = this.jdtTreeBuilder.getFactory().Code().createThisAccess(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(qualifiedNameReference.actualReceiverType), true);
        }
        return target;
    }

    <T> CtParameter<T> createParameter(Argument argument) {
        CtParameter p = this.jdtTreeBuilder.getFactory().Core().createParameter();
        p.setSimpleName(CharOperation.charToString(argument.name));
        p.setVarArgs(argument.isVarArgs());
        p.setModifiers(JDTTreeBuilderQuery.getModifiers(argument.modifiers));
        if (argument.binding != null && argument.binding.type != null && argument.type == null) {
            p.setType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(argument.binding.type));
            p.getType().setImplicit(argument.type == null);
            if (p.getType() instanceof CtArrayTypeReference) {
                ((CtArrayTypeReference)p.getType()).getComponentType().setImplicit(argument.type == null);
            }
        }
        return p;
    }

    <T, E extends CtExpression<?>> CtExecutableReferenceExpression<T, E> createExecutableReferenceExpression(ReferenceExpression referenceExpression) {
        CtTypeReference<?> declaringType;
        CtExecutableReferenceExpression executableRef = this.jdtTreeBuilder.getFactory().Core().createExecutableReferenceExpression();
        CtExecutableReference<?> executableReference = this.jdtTreeBuilder.getReferencesBuilder().getExecutableReference(referenceExpression.binding);
        if (executableReference == null) {
            executableReference = this.jdtTreeBuilder.getFactory().Core().createExecutableReference();
            executableReference.setSimpleName(CharOperation.charToString(referenceExpression.selector));
            executableReference.setDeclaringType(this.jdtTreeBuilder.getReferencesBuilder().getTypeReference(referenceExpression.lhs.resolvedType));
        }
        executableReference.setType((declaringType = executableReference.getDeclaringType()) == null ? null : declaringType.clone());
        executableRef.setExecutable(executableReference);
        return executableRef;
    }

    CtType<?> createType(TypeDeclaration typeDeclaration) {
        CtType type = (typeDeclaration.modifiers & 0x2000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createAnnotationType() : ((typeDeclaration.modifiers & 0x4000) != 0 ? this.jdtTreeBuilder.getFactory().Core().createEnum() : ((typeDeclaration.modifiers & 0x200) != 0 ? this.jdtTreeBuilder.getFactory().Core().createInterface() : this.jdtTreeBuilder.getFactory().Core().createClass()));
        this.jdtTreeBuilder.getContextBuilder().enter(type, typeDeclaration);
        if (typeDeclaration.superInterfaces != null) {
            for (TypeReference ref : typeDeclaration.superInterfaces) {
                CtTypeReference superInterface = this.jdtTreeBuilder.references.buildTypeReference(ref, null);
                type.addSuperInterface(superInterface);
            }
        }
        if (type instanceof CtClass) {
            if (typeDeclaration.superclass != null) {
                ((CtClass)type).setSuperclass(this.jdtTreeBuilder.references.buildTypeReference(typeDeclaration.superclass, (Scope)typeDeclaration.scope));
            }
            if (typeDeclaration.binding.isAnonymousType() || typeDeclaration.binding instanceof LocalTypeBinding && typeDeclaration.binding.enclosingMethod() != null) {
                type.setSimpleName(JDTTreeBuilderHelper.computeAnonymousName(typeDeclaration.binding.constantPoolName()));
            } else {
                type.setSimpleName(new String(typeDeclaration.name));
            }
        } else {
            type.setSimpleName(new String(typeDeclaration.name));
        }
        type.setModifiers(JDTTreeBuilderQuery.getModifiers(typeDeclaration.modifiers));
        return type;
    }
}

