/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import spoon.SpoonException;
import spoon.compiler.Environment;
import spoon.compiler.SpoonFile;
import spoon.compiler.builder.JDTBuilder;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.SnippetCompilationError;
import spoon.support.compiler.VirtualFile;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;

public class JDTSnippetCompiler
extends JDTBasedSpoonCompiler {
    private final AtomicLong snippetNumber = new AtomicLong(0L);
    public static final String SNIPPET_FILENAME_PREFIX = JDTSnippetCompiler.class.getName() + "_spoonSnippet_";
    private CompilationUnit snippetCompilationUnit;

    public JDTSnippetCompiler(Factory factory, String contents) {
        super(factory);
        this.addInputSource(new VirtualFile(contents, SNIPPET_FILENAME_PREFIX + this.snippetNumber.incrementAndGet()));
    }

    @Override
    public boolean build() {
        return this.build(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build(JDTBuilder builder) {
        boolean srcSuccess;
        if (this.factory == null) {
            throw new SpoonException("Factory not initialized");
        }
        List<SpoonFile> allFiles = this.sources.getAllJavaFiles();
        this.factory.getEnvironment().debugMessage("compiling sources: " + allFiles);
        long t = System.currentTimeMillis();
        this.javaCompliance = this.factory.getEnvironment().getComplianceLevel();
        try {
            srcSuccess = this.buildSources(builder);
        }
        finally {
            for (SpoonFile spoonFile : allFiles) {
                if (!spoonFile.getName().startsWith(SNIPPET_FILENAME_PREFIX)) continue;
                this.snippetCompilationUnit = this.factory.CompilationUnit().removeFromCache(spoonFile.getName());
            }
        }
        this.reportProblems(this.factory.getEnvironment());
        this.factory.getEnvironment().debugMessage("compiled in " + (System.currentTimeMillis() - t) + " ms");
        return srcSuccess;
    }

    @Override
    protected boolean buildSources(JDTBuilder jdtBuilder) {
        return this.buildUnitsAndModel(jdtBuilder, this.sources, this.getSourceClasspath(), "snippet ", false);
    }

    @Override
    protected void report(Environment environment, CategorizedProblem problem) {
        if (problem.isError()) {
            throw new SnippetCompilationError(problem.getMessage() + "at line " + problem.getSourceLineNumber());
        }
    }

    public CompilationUnit getSnippetCompilationUnit() {
        return this.snippetCompilationUnit;
    }
}

