/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.CtInheritanceScanner;
import spoon.reflect.visitor.CtScanner;

class JDTCommentBuilder {
    private static final Logger LOGGER = Logger.getLogger(JDTCommentBuilder.class);
    private final CompilationUnitDeclaration declarationUnit;
    private String filePath;
    private CompilationUnit spoonUnit;
    private Factory factory;
    private ICompilationUnit sourceUnit;
    private char[] contents;

    JDTCommentBuilder(CompilationUnitDeclaration declarationUnit, Factory factory) {
        this.declarationUnit = declarationUnit;
        if (declarationUnit.comments == null) {
            return;
        }
        this.factory = factory;
        this.sourceUnit = declarationUnit.compilationResult.compilationUnit;
        this.contents = this.sourceUnit.getContents();
        this.filePath = CharOperation.charToString(this.sourceUnit.getFileName());
        this.spoonUnit = factory.CompilationUnit().create(this.filePath);
    }

    public void build() {
        if (this.declarationUnit.comments == null) {
            return;
        }
        for (int j = 0; j < this.declarationUnit.comments.length; ++j) {
            int[] positions = this.declarationUnit.comments[j];
            this.buildComment(positions);
        }
    }

    private void buildComment(int[] positions) {
        int start = positions[0];
        int end = -positions[1];
        CtComment comment = this.factory.Core().createComment();
        comment.setCommentType(CtComment.CommentType.BLOCK);
        if (start < 0) {
            comment.setCommentType(CtComment.CommentType.INLINE);
            start = -start;
        }
        if (end <= 0) {
            comment.setCommentType(CtComment.CommentType.JAVADOC);
            end = -end;
        }
        String commentContent = this.getCommentContent(start, end);
        int[] lineSeparatorPositions = this.declarationUnit.compilationResult.lineSeparatorPositions;
        SourcePosition sourcePosition = this.factory.Core().createSourcePosition(this.spoonUnit, start, end, lineSeparatorPositions);
        comment.setContent(commentContent);
        comment.setPosition(sourcePosition);
        this.insertCommentInAST(comment);
    }

    private CtElement addCommentToNear(CtComment comment, Collection<CtElement> elements) {
        CtElement best = null;
        int smallDistance = Integer.MAX_VALUE;
        for (CtElement element : elements) {
            if (element.getPosition() == null || element.isImplicit() || element instanceof CtComment) continue;
            boolean isAfter = element.getPosition().getSourceEnd() < comment.getPosition().getSourceStart();
            int distance = Math.abs(element.getPosition().getSourceStart() - comment.getPosition().getSourceEnd());
            if (isAfter) {
                distance = Math.abs(element.getPosition().getSourceEnd() - comment.getPosition().getSourceStart());
            }
            int elementEndLine = element.getPosition().getEndLine();
            int commentLine = comment.getPosition().getLine();
            if (distance >= smallDistance || isAfter && elementEndLine != commentLine) continue;
            best = element;
            smallDistance = distance;
        }
        if (best != null) {
            best.addComment(comment);
        }
        return best;
    }

    private void insertCommentInAST(final CtComment comment) {
        CtElement commentParent = this.findCommentParent(comment);
        if (commentParent == null) {
            File file = this.spoonUnit.getFile();
            if (file != null && file.getName().equals("package-info.java")) {
                this.spoonUnit.getDeclaredPackage().addComment(comment);
            } else {
                comment.setCommentType(CtComment.CommentType.FILE);
                this.addCommentToNear(comment, new ArrayList<CtElement>(this.spoonUnit.getDeclaredTypes()));
            }
            return;
        }
        CtInheritanceScanner insertionVisitor = new CtInheritanceScanner(){
            private boolean isScanned = false;

            @Override
            public void scan(CtElement e) {
                if (e == null) {
                    return;
                }
                if (!this.isScanned) {
                    this.isScanned = true;
                    if (e.getPosition().getSourceStart() == comment.getPosition().getSourceStart()) {
                        e.addComment(comment);
                        return;
                    }
                    super.scan(e);
                }
            }

            @Override
            public <R> void visitCtStatementList(CtStatementList e) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(e.getStatements()));
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addStatement(comment);
                }
            }

            @Override
            public <T> void visitCtMethod(CtMethod<T> e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtConstructor(CtConstructor<T> e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtConditional(CtConditional<T> e) {
                ArrayList<CtExpression<T>> elements = new ArrayList<CtExpression<T>>();
                elements.add(e.getElseExpression());
                elements.add(e.getThenExpression());
                elements.add(e.getCondition());
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
            }

            @Override
            public <T> void visitCtBinaryOperator(CtBinaryOperator<T> e) {
                ArrayList elements = new ArrayList();
                elements.add(e.getLeftHandOperand());
                elements.add(e.getRightHandOperand());
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
            }

            @Override
            public <T> void visitCtClass(CtClass<T> e) {
                if (comment.getPosition().getLine() <= e.getPosition().getLine()) {
                    e.addComment(comment);
                    return;
                }
                ArrayList<CtTypeMember> elements = new ArrayList<CtTypeMember>();
                for (CtTypeMember typeMember : e.getTypeMembers()) {
                    if (!(typeMember instanceof CtField) && !(typeMember instanceof CtMethod) && !(typeMember instanceof CtConstructor)) continue;
                    elements.add(typeMember);
                }
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtInterface(CtInterface<T> e) {
                ArrayList<CtTypeMember> elements = new ArrayList<CtTypeMember>();
                for (CtTypeMember typeMember : e.getTypeMembers()) {
                    if (!(typeMember instanceof CtField) && !(typeMember instanceof CtMethod)) continue;
                    elements.add(typeMember);
                }
                JDTCommentBuilder.this.addCommentToNear(comment, elements);
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtField(CtField<T> e) {
                e.addComment(comment);
            }

            @Override
            public <E> void visitCtSwitch(CtSwitch<E> e) {
                List<CtCase<E>> cases = e.getCases();
                CtCase<E> previous = null;
                for (int i = 0; i < cases.size(); ++i) {
                    CtCase<E> ctCase = cases.get(i);
                    if (previous == null) {
                        if (comment.getPosition().getSourceStart() < ctCase.getPosition().getSourceStart() && e.getPosition().getSourceStart() < comment.getPosition().getSourceStart()) {
                            ctCase.addComment(comment);
                            return;
                        }
                    } else if (previous.getPosition().getSourceEnd() < comment.getPosition().getSourceStart() && ctCase.getPosition().getSourceStart() > comment.getPosition().getSourceStart()) {
                        JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(previous.getStatements()));
                        try {
                            comment.getParent();
                        }
                        catch (ParentNotInitializedException ex) {
                            previous.addStatement(comment);
                        }
                        return;
                    }
                    previous = ctCase;
                }
                if (previous.getPosition().getSourceEnd() < comment.getPosition().getSourceStart()) {
                    JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList<CtStatement>(previous.getStatements()));
                    try {
                        comment.getParent();
                    }
                    catch (ParentNotInitializedException ex) {
                        previous.addStatement(comment);
                    }
                    return;
                }
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public void visitCtIf(CtIf e) {
                if (!(e.getThenStatement() instanceof CtBlock) && comment.getPosition().getSourceEnd() <= e.getThenStatement().getPosition().getSourceStart()) {
                    e.getThenStatement().addComment(comment);
                    return;
                }
                if (e.getElseStatement() != null) {
                    SourcePosition elsePosition;
                    SourcePosition thenPosition = e.getThenStatement().getPosition() == null ? ((CtBlock)e.getThenStatement()).getStatement(0).getPosition() : e.getThenStatement().getPosition();
                    SourcePosition sourcePosition = elsePosition = e.getElseStatement().getPosition() == null ? ((CtBlock)e.getElseStatement()).getStatement(0).getPosition() : e.getElseStatement().getPosition();
                    if (comment.getPosition().getSourceStart() > thenPosition.getSourceEnd() && comment.getPosition().getSourceEnd() < elsePosition.getSourceStart()) {
                        e.getElseStatement().addComment(comment);
                    }
                }
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public void scanCtStatement(CtStatement s) {
                if (!(s instanceof CtStatementList) && !(s instanceof CtSwitch)) {
                    s.addComment(comment);
                }
            }

            @Override
            public void visitCtAnonymousExecutable(CtAnonymousExecutable e) {
                e.addComment(comment);
            }

            @Override
            public <T> void visitCtNewArray(CtNewArray<T> e) {
                JDTCommentBuilder.this.addCommentToNear(comment, new ArrayList(e.getElements()));
                try {
                    comment.getParent();
                }
                catch (ParentNotInitializedException ex) {
                    e.addComment(comment);
                }
            }

            @Override
            public <T> void visitCtParameter(CtParameter<T> e) {
                e.addComment(comment);
            }

            @Override
            public void visitCtCatch(CtCatch e) {
                if (comment.getPosition().getLine() <= e.getPosition().getLine()) {
                    e.addComment(comment);
                    return;
                }
            }
        };
        insertionVisitor.scan(commentParent);
        try {
            comment.getParent();
        }
        catch (ParentNotInitializedException e) {
            LOGGER.error((Object)(comment + " is not added into the AST"), (Throwable)e);
        }
    }

    private CtElement findCommentParent(CtComment comment) {
        class FindCommentParentScanner
        extends CtScanner {
            public CtElement commentParent;
            private int start;
            private int end;

            FindCommentParentScanner(int start, int end) {
                this.start = start;
                this.end = end;
            }

            @Override
            public void scan(CtElement element) {
                if (element == null) {
                    return;
                }
                if (element.isImplicit()) {
                    return;
                }
                CtElement body = JDTCommentBuilder.getBody(element);
                if (body != null && body.getPosition() == null) {
                    body = null;
                }
                if (element.getPosition() != null && (element.getPosition().getSourceStart() <= this.start && element.getPosition().getSourceEnd() >= this.end || body != null && body.getPosition().getSourceStart() <= this.start && body.getPosition().getSourceEnd() >= this.end)) {
                    this.commentParent = element;
                    element.accept(this);
                }
            }
        }
        FindCommentParentScanner findCommentParentScanner = new FindCommentParentScanner(comment.getPosition().getSourceStart(), comment.getPosition().getSourceEnd());
        findCommentParentScanner.scan(this.spoonUnit.getDeclaredTypes());
        return findCommentParentScanner.commentParent;
    }

    static CtElement getBody(CtElement e) {
        if (e instanceof CtBodyHolder) {
            return ((CtBodyHolder)e).getBody();
        }
        return null;
    }

    private String getCommentContent(int start, int end) {
        return JDTCommentBuilder.cleanComment(new String(this.contents, start += 2, end - start));
    }

    public static String cleanComment(String comment) {
        StringBuffer ret = new StringBuffer();
        String[] lines = comment.split("\n");
        if (lines.length == 1) {
            return lines[0].replaceAll("^/\\*+ ?", "").replaceAll("\\*+/$", "").trim();
        }
        for (String s : lines) {
            String cleanUpLine = s.trim();
            cleanUpLine = cleanUpLine.startsWith("/**") ? cleanUpLine.replaceAll("/\\*+ ?", "") : (cleanUpLine.endsWith("*/") ? cleanUpLine.replaceAll("\\*+/$", "").replaceAll("^[ \t]*\\*+ ?", "") : cleanUpLine.replaceAll("^[ \t]*\\*+ ?", ""));
            ret.append(cleanUpLine);
            ret.append("\n");
        }
        StringBuffer ret2 = new StringBuffer();
        for (int i = 0; i < ret.length(); ++i) {
            if (ret.charAt(i) == '\r') continue;
            ret2.append(ret.charAt(i));
        }
        return ret2.toString().trim();
    }
}

