/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler.jdt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import spoon.SpoonException;
import spoon.SpoonModelBuilder;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.compiler.jdt.JDTBatchCompiler;

public class FileCompilerConfig
implements SpoonModelBuilder.InputType {
    public static final SpoonModelBuilder.InputType INSTANCE = new FileCompilerConfig((List)null){

        @Override
        public List<SpoonFile> getFiles(JDTBatchCompiler compiler) {
            JDTBasedSpoonCompiler jdtCompiler = compiler.getJdtCompiler();
            ArrayList<SpoonFile> files = new ArrayList<SpoonFile>();
            files.addAll(jdtCompiler.sources.getAllJavaFiles());
            files.addAll(jdtCompiler.templates.getAllJavaFiles());
            return files;
        }
    };
    private final List<SpoonFile> files;

    public FileCompilerConfig(List<SpoonFile> files) {
        this.files = files;
    }

    public FileCompilerConfig(SpoonFolder folder) {
        this(folder.getAllJavaFiles());
    }

    @Override
    public void initializeCompiler(JDTBatchCompiler compiler) {
        JDTBasedSpoonCompiler jdtCompiler = compiler.getJdtCompiler();
        ArrayList<CompilationUnit> cuList = new ArrayList<CompilationUnit>();
        InputStream inputStream = null;
        try {
            for (SpoonFile f : this.getFiles(compiler)) {
                if (compiler.filesToBeIgnored.contains(f.getPath())) continue;
                String fName = f.isActualFile() ? f.getPath() : f.getName();
                inputStream = f.getContent();
                char[] content = IOUtils.toCharArray((InputStream)inputStream, (String)jdtCompiler.encoding);
                cuList.add(new CompilationUnit(content, fName, null));
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            IOUtils.closeQuietly(inputStream);
            throw new SpoonException(e);
        }
        compiler.setCompilationUnits(cuList.toArray(new CompilationUnit[0]));
    }

    protected List<SpoonFile> getFiles(JDTBatchCompiler compiler) {
        return this.files;
    }
}

