/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import spoon.compiler.SpoonFile;
import spoon.compiler.SpoonFolder;

public class VirtualFolder
implements SpoonFolder {
    protected final Set<SpoonFile> files = new HashSet<SpoonFile>();

    @Override
    public void addFile(SpoonFile o) {
        this.files.add(o);
    }

    @Override
    public void addFolder(SpoonFolder o) {
        for (SpoonFile f : o.getAllFiles()) {
            if (!f.isFile()) continue;
            this.files.add(f);
        }
    }

    @Override
    public List<SpoonFile> getAllFiles() {
        ArrayList<SpoonFile> result = new ArrayList<SpoonFile>();
        for (SpoonFile f : this.getFiles()) {
            if (result.contains(f)) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    public List<SpoonFile> getAllJavaFiles() {
        ArrayList<SpoonFile> result = new ArrayList<SpoonFile>();
        for (SpoonFile f : this.getAllFiles()) {
            if (!f.isJava()) continue;
            result.add(f);
        }
        return result;
    }

    @Override
    public List<SpoonFile> getFiles() {
        return Collections.unmodifiableList(new ArrayList<SpoonFile>(this.files));
    }

    @Override
    public String getName() {
        return "Virtual directory";
    }

    @Override
    public SpoonFolder getParent() {
        return null;
    }

    @Override
    public List<SpoonFolder> getSubFolders() {
        ArrayList<SpoonFolder> result = new ArrayList<SpoonFolder>();
        for (SpoonFile f : this.getAllFiles()) {
            SpoonFolder folder = f.getParent();
            if (folder == null || result.contains(folder)) continue;
            result.add(folder);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public String getPath() {
        return ".";
    }

    @Override
    public File getFileSystemParent() {
        return null;
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public File toFile() {
        return null;
    }

    public String toString() {
        return "<virtual folder>: " + super.toString();
    }
}

