/*
 * Decompiled with CFR 0.152.
 */
package spoon.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import spoon.processing.ProcessInterruption;
import spoon.processing.ProcessingManager;
import spoon.processing.Processor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.factory.Factory;
import spoon.support.util.Timer;
import spoon.support.visitor.ProcessingVisitor;

public class RuntimeProcessingManager
implements ProcessingManager {
    Processor<?> current;
    Factory factory;
    List<Processor<?>> processors;
    ProcessingVisitor visitor;

    public RuntimeProcessingManager(Factory factory) {
        this.setFactory(factory);
    }

    @Override
    public void addProcessor(Class<? extends Processor<?>> type) {
        try {
            Processor<?> p = type.newInstance();
            p.setFactory(this.factory);
            p.init();
            this.addProcessor(p);
        }
        catch (Exception e) {
            this.factory.getEnvironment().report(null, Level.ERROR, "Unable to instantiate processor \"" + type.getName() + "\" - Your processor should have a constructor with no arguments");
        }
    }

    @Override
    public boolean addProcessor(Processor<?> p) {
        p.setFactory(this.getFactory());
        return this.getProcessors().add(p);
    }

    @Override
    public void addProcessor(String qualifiedName) {
        try {
            this.addProcessor(this.getFactory().getEnvironment().getInputClassLoader().loadClass(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            this.factory.getEnvironment().report(null, Level.ERROR, "Unable to load processor \"" + qualifiedName + "\" - Check your classpath.");
        }
    }

    public Processor<?> getCurrentProcessor() {
        return this.current;
    }

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    public List<Processor<?>> getProcessors() {
        if (this.processors == null) {
            this.processors = new LinkedList();
        }
        return this.processors;
    }

    private ProcessingVisitor getVisitor() {
        if (this.visitor == null) {
            this.visitor = new ProcessingVisitor(this.getFactory());
        }
        return this.visitor;
    }

    @Override
    public void process(Collection<? extends CtElement> elements) {
        Iterator iterator = this.getProcessors().iterator();
        while (iterator.hasNext()) {
            Processor p;
            this.current = p = (Processor)iterator.next();
            this.process(elements, p);
        }
    }

    public void process(Collection<? extends CtElement> elements, Processor<?> processor) {
        try {
            this.getFactory().getEnvironment().debugMessage("processing with '" + processor.getClass().getName() + "'...");
            this.current = processor;
            Timer.start(processor.getClass().getName());
            for (CtElement ctElement : elements) {
                this.process(ctElement, processor);
            }
            Timer.stop(processor.getClass().getName());
        }
        catch (ProcessInterruption processInterruption) {
            // empty catch block
        }
    }

    @Override
    public void process(CtElement element) {
        Iterator iterator = this.getProcessors().iterator();
        while (iterator.hasNext()) {
            Processor p;
            this.current = p = (Processor)iterator.next();
            this.process(element, p);
        }
    }

    public void process(CtElement element, Processor<?> processor) {
        this.getFactory().getEnvironment().debugMessage("processing '" + (element instanceof CtNamedElement ? ((CtNamedElement)element).getSimpleName() : element.toString()) + "' with '" + processor.getClass().getName() + "'...");
        processor.init();
        this.getVisitor().setProcessor(processor);
        this.getVisitor().scan(element);
        processor.processingDone();
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
        factory.getEnvironment().setManager(this);
    }
}

