/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import spoon.SpoonException;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.filter.CatchVariableReferenceFunction;
import spoon.reflect.visitor.filter.FieldReferenceFunction;
import spoon.reflect.visitor.filter.LocalVariableReferenceFunction;
import spoon.reflect.visitor.filter.ParameterReferenceFunction;

public class VariableReferenceFunction
implements CtConsumableFunction<CtVariable<?>> {
    protected final Visitor visitor = new Visitor();
    protected CtConsumer<Object> outputConsumer;
    private static final FieldReferenceFunction fieldReferenceFunction = new FieldReferenceFunction();
    private static final LocalVariableReferenceFunction localVariableReferenceFunction = new LocalVariableReferenceFunction();
    private static final ParameterReferenceFunction parameterReferenceFunction = new ParameterReferenceFunction();
    private static final CatchVariableReferenceFunction catchVariableReferenceFunction = new CatchVariableReferenceFunction();

    @Override
    public void apply(CtVariable<?> variable, CtConsumer<Object> outputConsumer) {
        this.outputConsumer = outputConsumer;
        variable.accept(this.visitor);
    }

    protected class Visitor
    extends CtScanner {
        protected Visitor() {
        }

        @Override
        protected void enter(CtElement e) {
            throw new SpoonException("Unsupported variable of type " + e.getClass().getName());
        }

        @Override
        public <T> void visitCtField(CtField<T> field) {
            fieldReferenceFunction.apply(field, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
            localVariableReferenceFunction.apply(localVariable, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtParameter(CtParameter<T> parameter) {
            parameterReferenceFunction.apply(parameter, VariableReferenceFunction.this.outputConsumer);
        }

        @Override
        public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
            catchVariableReferenceFunction.apply(catchVariable, VariableReferenceFunction.this.outputConsumer);
        }
    }
}

