/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.Set;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.support.SpoonClassNotFoundException;

public class SuperInheritanceHierarchyFunction
implements CtConsumableFunction<CtType<?>>,
CtQueryAware {
    private boolean includingSelf = false;
    private boolean includingInterfaces = true;
    private Set<String> visitedSet;
    private CtQuery query;
    private boolean failOnClassNotFound = false;

    public SuperInheritanceHierarchyFunction() {
    }

    public SuperInheritanceHierarchyFunction(Set<String> visitedSet) {
        this.visitedSet = visitedSet;
    }

    public SuperInheritanceHierarchyFunction includingSelf(boolean includingSelf) {
        this.includingSelf = includingSelf;
        return this;
    }

    public SuperInheritanceHierarchyFunction includingInterfaces(boolean includingInterfaces) {
        this.includingInterfaces = includingInterfaces;
        return this;
    }

    @Override
    public void apply(CtType<?> input, CtConsumer<Object> outputConsumer) {
        if (this.includingSelf) {
            if (!this.canVisitType(input.getQualifiedName())) {
                return;
            }
            outputConsumer.accept(input);
            if (this.query.isTerminated()) {
                return;
            }
        }
        if (input instanceof CtClass) {
            this.visitSuperClasses(input, outputConsumer, this.includingInterfaces);
        } else if (input instanceof CtInterface) {
            this.visitSuperInterfaces(input, outputConsumer);
        } else {
            if (input instanceof CtAnnotationType) {
                return;
            }
            if (input instanceof CtTypeParameter) {
                this.visitSuperClasses(input, outputConsumer, false);
            }
        }
    }

    protected void visitSuperClasses(CtType<?> superType, CtConsumer<Object> outputConsumer, boolean includingInterfaces) {
        do {
            block8: {
                if (includingInterfaces && !this.visitSuperInterfaces(superType, outputConsumer)) {
                    return;
                }
                CtTypeReference<?> superClassRef = superType.getSuperclass();
                if (superClassRef == null) {
                    if (superType instanceof CtClass) {
                        superType = superType.getFactory().Type().get(Object.class);
                        if (this.canVisitType(Object.class.getName())) {
                            outputConsumer.accept(superType);
                        }
                    }
                    return;
                }
                if (!this.canVisitType(superClassRef.getQualifiedName())) {
                    return;
                }
                try {
                    superType = superClassRef.getTypeDeclaration();
                }
                catch (SpoonClassNotFoundException e) {
                    if (!this.failOnClassNotFound) break block8;
                    throw e;
                }
            }
            outputConsumer.accept(superType);
        } while (!this.query.isTerminated());
    }

    protected boolean visitSuperInterfaces(CtType<?> type, CtConsumer<Object> outputConsumer) {
        for (CtTypeReference<?> ifaceRef : type.getSuperInterfaces()) {
            CtType<?> superType;
            if (!this.canVisitType(ifaceRef.getQualifiedName())) continue;
            try {
                superType = ifaceRef.getTypeDeclaration();
            }
            catch (SpoonClassNotFoundException e) {
                if (!this.failOnClassNotFound) continue;
                throw e;
            }
            if (superType == null) continue;
            outputConsumer.accept(superType);
            if (this.query.isTerminated()) {
                return false;
            }
            if (this.visitSuperInterfaces(superType, outputConsumer)) continue;
            return false;
        }
        return true;
    }

    protected boolean canVisitType(String qualifiedName) {
        if (this.visitedSet != null) {
            return this.visitedSet.add(qualifiedName);
        }
        return true;
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }

    public SuperInheritanceHierarchyFunction failOnClassNotFound(boolean failOnClassNotFound) {
        this.failOnClassNotFound = failOnClassNotFound;
        return this;
    }
}

