/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor.filter;

import java.util.Collection;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.chain.CtConsumableFunction;
import spoon.reflect.visitor.chain.CtConsumer;
import spoon.reflect.visitor.chain.CtQuery;
import spoon.reflect.visitor.chain.CtQueryAware;
import spoon.reflect.visitor.filter.NameFilter;
import spoon.reflect.visitor.filter.SiblingsFunction;
import spoon.reflect.visitor.filter.TypeFilter;

public class PotentialVariableDeclarationFunction
implements CtConsumableFunction<CtElement>,
CtQueryAware {
    private boolean isTypeOnTheWay;
    private final String variableName;
    private CtQuery query;

    public PotentialVariableDeclarationFunction() {
        this.variableName = null;
    }

    public PotentialVariableDeclarationFunction(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public void apply(CtElement input, CtConsumer<Object> outputConsumer) {
        this.isTypeOnTheWay = false;
        CtQuery siblingsQuery = input.getFactory().createQuery().map(new SiblingsFunction().mode(SiblingsFunction.Mode.PREVIOUS)).select(new TypeFilter<CtVariable>(CtVariable.class));
        if (this.variableName != null) {
            siblingsQuery = siblingsQuery.select(new NameFilter(this.variableName));
        }
        CtElement scopeElement = input;
        while (scopeElement != null && !(scopeElement instanceof CtPackage) && scopeElement.isParentInitialized()) {
            CtElement parent = scopeElement.getParent();
            if (parent instanceof CtType) {
                this.isTypeOnTheWay = true;
                Collection<CtFieldReference<?>> allFields = ((CtType)parent).getAllFields();
                for (CtFieldReference<?> ctFieldReference : allFields) {
                    if (!this.sendToOutput(ctFieldReference.getFieldDeclaration(), outputConsumer)) continue;
                    return;
                }
            } else if (parent instanceof CtBodyHolder || parent instanceof CtStatementList) {
                siblingsQuery.setInput(scopeElement).forEach(outputConsumer);
                if (this.query.isTerminated()) {
                    return;
                }
                if (parent instanceof CtCatch) {
                    CtCatch ctCatch = (CtCatch)parent;
                    if (this.sendToOutput(ctCatch.getParameter(), outputConsumer)) {
                        return;
                    }
                } else if (parent instanceof CtExecutable) {
                    CtExecutable exec = (CtExecutable)parent;
                    for (CtParameter ctParameter : exec.getParameters()) {
                        if (!this.sendToOutput(ctParameter, outputConsumer)) continue;
                        return;
                    }
                }
            }
            scopeElement = parent;
        }
    }

    private boolean sendToOutput(CtVariable<?> var, CtConsumer<Object> output) {
        if (this.variableName == null || this.variableName.equals(var.getSimpleName())) {
            output.accept(var);
        }
        return this.query.isTerminated();
    }

    public boolean isTypeOnTheWay() {
        return this.isTypeOnTheWay;
    }

    @Override
    public void setQuery(CtQuery query) {
        this.query = query;
    }
}

