/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.chain.CtScannerListener;
import spoon.reflect.visitor.chain.ScanningMode;

public class EarlyTerminatingScanner<T>
extends CtScanner {
    private boolean terminate = false;
    private T result;
    private CtScannerListener listener;

    protected void terminate() {
        this.terminate = true;
    }

    protected boolean isTerminated() {
        return this.terminate;
    }

    protected void setResult(T result) {
        this.result = result;
    }

    public T getResult() {
        return this.result;
    }

    public CtScannerListener getListener() {
        return this.listener;
    }

    public EarlyTerminatingScanner<T> setListener(CtScannerListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public void scan(Collection<? extends CtElement> elements) {
        if (this.isTerminated() || elements == null) {
            return;
        }
        for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
            this.scan(ctElement);
            if (!this.isTerminated()) continue;
            return;
        }
    }

    @Override
    public void scan(CtElement element) {
        if (element == null || this.isTerminated()) {
            return;
        }
        if (this.listener == null) {
            this.doScan(element, ScanningMode.NORMAL);
        } else {
            ScanningMode mode = this.listener.enter(element);
            if (mode != ScanningMode.SKIP_ALL) {
                this.doScan(element, mode);
                this.listener.exit(element);
            }
        }
    }

    protected void doScan(CtElement element, ScanningMode mode) {
        super.scan(element);
    }

    @Override
    public void scan(Object o) {
        if (this.isTerminated() || o == null) {
            return;
        }
        if (o instanceof CtElement) {
            this.scan((CtElement)o);
        } else if (o instanceof Collection) {
            this.scan((Collection)o);
        } else if (o instanceof Map) {
            for (Object obj : ((Map)o).values()) {
                this.scan(obj);
                if (!this.isTerminated()) continue;
                return;
            }
        }
    }
}

