/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtVisitor;

public abstract class CtScanner
implements CtVisitor {
    protected void enter(CtElement e) {
    }

    protected void exit(CtElement e) {
    }

    public void scan(Collection<? extends CtElement> elements) {
        if (elements != null) {
            for (CtElement ctElement : new ArrayList<CtElement>(elements)) {
                this.scan(ctElement);
            }
        }
    }

    public void scan(CtElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.enter(annotation);
        this.scan(annotation.getType());
        this.scan(annotation.getComments());
        this.scan(annotation.getAnnotationType());
        this.scan(annotation.getAnnotations());
        this.scan(annotation.getValues());
        this.exit(annotation);
    }

    public void scan(Object o) {
        if (o instanceof CtElement) {
            this.scan((CtElement)o);
        }
        if (o instanceof Collection) {
            for (Object obj : (Collection)o) {
                this.scan(obj);
            }
        }
        if (o instanceof Map) {
            for (Object obj : ((Map)o).values()) {
                this.scan(obj);
            }
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.enter(annotationType);
        this.scan(annotationType.getAnnotations());
        this.scan(annotationType.getTypeMembers());
        this.scan(annotationType.getComments());
        this.exit(annotationType);
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        this.enter(anonymousExec);
        this.scan(anonymousExec.getAnnotations());
        this.scan(anonymousExec.getBody());
        this.scan(anonymousExec.getComments());
        this.exit(anonymousExec);
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.enter(arrayRead);
        this.scan(arrayRead.getAnnotations());
        this.scan(arrayRead.getType());
        this.scan(arrayRead.getTypeCasts());
        this.scan((CtElement)arrayRead.getTarget());
        this.scan(arrayRead.getIndexExpression());
        this.scan(arrayRead.getComments());
        this.exit(arrayRead);
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.enter(arrayWrite);
        this.scan(arrayWrite.getAnnotations());
        this.scan(arrayWrite.getType());
        this.scan(arrayWrite.getTypeCasts());
        this.scan((CtElement)arrayWrite.getTarget());
        this.scan(arrayWrite.getIndexExpression());
        this.scan(arrayWrite.getComments());
        this.exit(arrayWrite);
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getComments());
        this.scan(reference.getPackage());
        this.scan(reference.getDeclaringType());
        this.scan(reference.getComponentType());
        this.scan(reference.getActualTypeArguments());
        this.scan(reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.enter(asserted);
        this.scan(asserted.getAnnotations());
        this.scan(asserted.getAssertExpression());
        this.scan(asserted.getExpression());
        this.scan(asserted.getComments());
        this.exit(asserted);
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.enter(assignement);
        this.scan(assignement.getAnnotations());
        this.scan(assignement.getType());
        this.scan(assignement.getTypeCasts());
        this.scan(assignement.getAssigned());
        this.scan(assignement.getAssignment());
        this.scan(assignement.getComments());
        this.exit(assignement);
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.enter(operator);
        this.scan(operator.getAnnotations());
        this.scan(operator.getType());
        this.scan(operator.getTypeCasts());
        this.scan(operator.getLeftHandOperand());
        this.scan(operator.getRightHandOperand());
        this.scan(operator.getComments());
        this.exit(operator);
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.enter(block);
        this.scan(block.getAnnotations());
        this.scan(block.getStatements());
        this.scan(block.getComments());
        this.exit(block);
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.enter(breakStatement);
        this.scan(breakStatement.getAnnotations());
        this.scan(breakStatement.getComments());
        this.exit(breakStatement);
    }

    @Override
    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.enter(caseStatement);
        this.scan(caseStatement.getAnnotations());
        this.scan(caseStatement.getCaseExpression());
        this.scan(caseStatement.getStatements());
        this.scan(caseStatement.getComments());
        this.exit(caseStatement);
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.enter(catchBlock);
        this.scan(catchBlock.getAnnotations());
        this.scan(catchBlock.getParameter());
        this.scan(catchBlock.getBody());
        this.scan(catchBlock.getComments());
        this.exit(catchBlock);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.enter(ctClass);
        this.scan(ctClass.getAnnotations());
        this.scan(ctClass.getSuperclass());
        this.scan(ctClass.getSuperInterfaces());
        this.scan(ctClass.getFormalCtTypeParameters());
        this.scan(ctClass.getTypeMembers());
        this.scan(ctClass.getComments());
        this.exit(ctClass);
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.enter(typeParameter);
        this.scan(typeParameter.getAnnotations());
        this.scan(typeParameter.getSuperclass());
        this.scan(typeParameter.getComments());
        this.exit(typeParameter);
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.enter(conditional);
        this.scan(conditional.getType());
        this.scan(conditional.getAnnotations());
        this.scan(conditional.getCondition());
        this.scan(conditional.getThenExpression());
        this.scan(conditional.getElseExpression());
        this.scan(conditional.getComments());
        this.scan(conditional.getTypeCasts());
        this.exit(conditional);
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.enter(c);
        this.scan(c.getAnnotations());
        this.scan(c.getParameters());
        this.scan(c.getThrownTypes());
        this.scan(c.getFormalCtTypeParameters());
        this.scan(c.getBody());
        this.scan(c.getComments());
        this.exit(c);
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.enter(continueStatement);
        this.scan(continueStatement.getAnnotations());
        this.scan(continueStatement.getLabelledStatement());
        this.scan(continueStatement.getComments());
        this.exit(continueStatement);
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.enter(doLoop);
        this.scan(doLoop.getAnnotations());
        this.scan(doLoop.getLoopingExpression());
        this.scan(doLoop.getBody());
        this.scan(doLoop.getComments());
        this.exit(doLoop);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.enter(ctEnum);
        this.scan(ctEnum.getAnnotations());
        this.scan(ctEnum.getSuperInterfaces());
        this.scan(ctEnum.getTypeMembers());
        this.scan(ctEnum.getEnumValues());
        this.scan(ctEnum.getComments());
        this.exit(ctEnum);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getType());
        this.scan(reference.getParameters());
        this.scan(reference.getActualTypeArguments());
        this.scan(reference.getAnnotations());
        this.scan(reference.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.enter(f);
        this.scan(f.getAnnotations());
        this.scan(f.getType());
        this.scan(f.getDefaultExpression());
        this.scan(f.getComments());
        this.exit(f);
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        this.enter(enumValue);
        this.scan(enumValue.getAnnotations());
        this.scan(enumValue.getType());
        this.scan(enumValue.getDefaultExpression());
        this.scan(enumValue.getComments());
        this.exit(enumValue);
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.enter(thisAccess);
        this.scan(thisAccess.getComments());
        this.scan(thisAccess.getAnnotations());
        this.scan(thisAccess.getType());
        this.scan(thisAccess.getTypeCasts());
        this.scan((CtElement)thisAccess.getTarget());
        this.exit(thisAccess);
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.enter(annotationFieldAccess);
        this.scan(annotationFieldAccess.getComments());
        this.scan(annotationFieldAccess.getAnnotations());
        this.scan(annotationFieldAccess.getTypeCasts());
        this.scan((CtElement)annotationFieldAccess.getTarget());
        this.scan(annotationFieldAccess.getType());
        this.scan(annotationFieldAccess.getVariable());
        this.exit(annotationFieldAccess);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getDeclaringType());
        this.scan(reference.getType());
        this.scan(reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.enter(forLoop);
        this.scan(forLoop.getAnnotations());
        this.scan(forLoop.getForInit());
        this.scan(forLoop.getExpression());
        this.scan(forLoop.getForUpdate());
        this.scan(forLoop.getBody());
        this.scan(forLoop.getComments());
        this.exit(forLoop);
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.enter(foreach);
        this.scan(foreach.getAnnotations());
        this.scan(foreach.getVariable());
        this.scan(foreach.getExpression());
        this.scan(foreach.getBody());
        this.scan(foreach.getComments());
        this.exit(foreach);
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.enter(ifElement);
        this.scan(ifElement.getAnnotations());
        this.scan(ifElement.getCondition());
        this.scan((CtElement)ifElement.getThenStatement());
        this.scan((CtElement)ifElement.getElseStatement());
        this.scan(ifElement.getComments());
        this.exit(ifElement);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.enter(intrface);
        this.scan(intrface.getAnnotations());
        this.scan(intrface.getSuperInterfaces());
        this.scan(intrface.getFormalCtTypeParameters());
        this.scan(intrface.getTypeMembers());
        this.scan(intrface.getComments());
        this.exit(intrface);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enter(invocation);
        this.scan(invocation.getAnnotations());
        this.scan(invocation.getTypeCasts());
        this.scan((CtElement)invocation.getTarget());
        this.scan(invocation.getExecutable());
        this.scan(invocation.getArguments());
        this.scan(invocation.getComments());
        this.exit(invocation);
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.enter(literal);
        this.scan(literal.getAnnotations());
        this.scan(literal.getType());
        this.scan(literal.getTypeCasts());
        this.scan(literal.getComments());
        this.exit(literal);
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.enter(localVariable);
        this.scan(localVariable.getAnnotations());
        this.scan(localVariable.getType());
        this.scan(localVariable.getDefaultExpression());
        this.scan(localVariable.getComments());
        this.exit(localVariable);
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getType());
        this.scan(reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        this.enter(catchVariable);
        this.scan(catchVariable.getComments());
        this.scan(catchVariable.getAnnotations());
        this.scan(catchVariable.getDefaultExpression());
        this.scan(catchVariable.getType());
        this.scan(catchVariable.getMultiTypes());
        this.exit(catchVariable);
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getComments());
        this.scan(reference.getType());
        this.scan(reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.enter(m);
        this.scan(m.getAnnotations());
        this.scan(m.getFormalCtTypeParameters());
        this.scan(m.getType());
        this.scan(m.getParameters());
        this.scan(m.getThrownTypes());
        this.scan(m.getBody());
        this.scan(m.getComments());
        this.exit(m);
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.enter(annotationMethod);
        this.scan(annotationMethod.getAnnotations());
        this.scan(annotationMethod.getType());
        this.scan(annotationMethod.getDefaultExpression());
        this.scan(annotationMethod.getComments());
        this.exit(annotationMethod);
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.enter(newArray);
        this.scan(newArray.getAnnotations());
        this.scan(newArray.getType());
        this.scan(newArray.getTypeCasts());
        this.scan(newArray.getElements());
        this.scan(newArray.getDimensionExpressions());
        this.scan(newArray.getComments());
        this.exit(newArray);
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.enter(ctConstructorCall);
        this.scan(ctConstructorCall.getAnnotations());
        this.scan(ctConstructorCall.getTypeCasts());
        this.scan(ctConstructorCall.getExecutable());
        this.scan((CtElement)ctConstructorCall.getTarget());
        this.scan(ctConstructorCall.getArguments());
        this.scan(ctConstructorCall.getComments());
        this.exit(ctConstructorCall);
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.enter(newClass);
        this.scan(newClass.getAnnotations());
        this.scan(newClass.getTypeCasts());
        this.scan(newClass.getExecutable());
        this.scan((CtElement)newClass.getTarget());
        this.scan(newClass.getArguments());
        this.scan(newClass.getAnonymousClass());
        this.scan(newClass.getComments());
        this.exit(newClass);
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.enter(lambda);
        this.scan(lambda.getAnnotations());
        this.scan(lambda.getType());
        this.scan(lambda.getTypeCasts());
        this.scan(lambda.getParameters());
        this.scan(lambda.getThrownTypes());
        this.scan(lambda.getBody());
        this.scan(lambda.getExpression());
        this.scan(lambda.getComments());
        this.exit(lambda);
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.enter(expression);
        this.scan(expression.getComments());
        this.scan(expression.getAnnotations());
        this.scan(expression.getType());
        this.scan(expression.getTypeCasts());
        this.scan(expression.getExecutable());
        this.scan((CtElement)expression.getTarget());
        this.exit(expression);
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.enter(assignment);
        this.scan(assignment.getAnnotations());
        this.scan(assignment.getType());
        this.scan(assignment.getTypeCasts());
        this.scan(assignment.getAssigned());
        this.scan(assignment.getAssignment());
        this.scan(assignment.getComments());
        this.exit(assignment);
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.enter(ctPackage);
        this.scan(ctPackage.getAnnotations());
        this.scan(ctPackage.getPackages());
        this.scan(ctPackage.getTypes());
        this.scan(ctPackage.getComments());
        this.exit(ctPackage);
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.enter(reference);
        this.scan(reference.getAnnotations());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.enter(parameter);
        this.scan(parameter.getAnnotations());
        this.scan(parameter.getType());
        this.scan(parameter.getComments());
        this.exit(parameter);
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getType());
        this.scan(reference.getAnnotations());
        this.scan(reference.getDeclaringExecutable());
        this.exit(reference);
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.enter(returnStatement);
        this.scan(returnStatement.getAnnotations());
        this.scan(returnStatement.getReturnedExpression());
        this.scan(returnStatement.getComments());
        this.exit(returnStatement);
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        this.enter(statements);
        this.scan(statements.getAnnotations());
        this.scan(statements.getStatements());
        this.scan(statements.getComments());
        this.exit(statements);
    }

    @Override
    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.enter(switchStatement);
        this.scan(switchStatement.getAnnotations());
        this.scan(switchStatement.getSelector());
        this.scan(switchStatement.getCases());
        this.scan(switchStatement.getComments());
        this.exit(switchStatement);
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.enter(synchro);
        this.scan(synchro.getAnnotations());
        this.scan(synchro.getExpression());
        this.scan(synchro.getBlock());
        this.scan(synchro.getComments());
        this.exit(synchro);
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.enter(throwStatement);
        this.scan(throwStatement.getAnnotations());
        this.scan(throwStatement.getThrownExpression());
        this.scan(throwStatement.getComments());
        this.exit(throwStatement);
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.enter(tryBlock);
        this.scan(tryBlock.getAnnotations());
        this.scan(tryBlock.getBody());
        this.scan(tryBlock.getCatchers());
        this.scan(tryBlock.getFinalizer());
        this.scan(tryBlock.getComments());
        this.exit(tryBlock);
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.enter(tryWithResource);
        this.scan(tryWithResource.getAnnotations());
        this.scan(tryWithResource.getResources());
        this.scan(tryWithResource.getBody());
        this.scan(tryWithResource.getCatchers());
        this.scan(tryWithResource.getFinalizer());
        this.scan(tryWithResource.getComments());
        this.exit(tryWithResource);
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.enter(ref);
        this.scan(ref.getPackage());
        this.scan(ref.getDeclaringType());
        this.scan(ref.getAnnotations());
        this.scan(ref.getBoundingType());
        this.exit(ref);
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        this.enter(wildcardReference);
        this.scan(wildcardReference.getPackage());
        this.scan(wildcardReference.getDeclaringType());
        this.scan(wildcardReference.getAnnotations());
        this.scan(wildcardReference.getBoundingType());
        this.exit(wildcardReference);
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getPackage());
        this.scan(reference.getDeclaringType());
        this.scan(reference.getAnnotations());
        this.scan(reference.getBounds());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getPackage());
        this.scan(reference.getDeclaringType());
        this.scan(reference.getActualTypeArguments());
        this.scan(reference.getAnnotations());
        this.scan(reference.getComments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.enter(typeAccess);
        this.scan(typeAccess.getAnnotations());
        this.scan(typeAccess.getTypeCasts());
        this.scan(typeAccess.getAccessedType());
        this.scan(typeAccess.getComments());
        this.exit(typeAccess);
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.enter(operator);
        this.scan(operator.getAnnotations());
        this.scan(operator.getType());
        this.scan(operator.getTypeCasts());
        this.scan(operator.getOperand());
        this.scan(operator.getComments());
        this.exit(operator);
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.enter(variableRead);
        this.scan(variableRead.getAnnotations());
        this.scan(variableRead.getTypeCasts());
        this.scan(variableRead.getVariable());
        this.scan(variableRead.getComments());
        this.exit(variableRead);
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.enter(variableWrite);
        this.scan(variableWrite.getAnnotations());
        this.scan(variableWrite.getTypeCasts());
        this.scan(variableWrite.getVariable());
        this.scan(variableWrite.getComments());
        this.exit(variableWrite);
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.enter(whileLoop);
        this.scan(whileLoop.getAnnotations());
        this.scan(whileLoop.getLoopingExpression());
        this.scan(whileLoop.getBody());
        this.scan(whileLoop.getComments());
        this.exit(whileLoop);
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.enter(expression);
        this.scan(expression.getType());
        this.scan(expression.getComments());
        this.scan(expression.getAnnotations());
        this.scan(expression.getTypeCasts());
        this.exit(expression);
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.enter(statement);
        this.scan(statement.getComments());
        this.scan(statement.getAnnotations());
        this.exit(statement);
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.enter(reference);
        this.scan(reference.getType());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.enter(fieldRead);
        this.scan(fieldRead.getAnnotations());
        this.scan(fieldRead.getTypeCasts());
        this.scan((CtElement)fieldRead.getTarget());
        this.scan(fieldRead.getVariable());
        this.scan(fieldRead.getComments());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.enter(fieldWrite);
        this.scan(fieldWrite.getAnnotations());
        this.scan(fieldWrite.getTypeCasts());
        this.scan((CtElement)fieldWrite.getTarget());
        this.scan(fieldWrite.getVariable());
        this.scan(fieldWrite.getComments());
        this.exit(fieldWrite);
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.enter(f);
        this.scan(f.getType());
        this.scan(f.getComments());
        this.scan(f.getAnnotations());
        this.scan(f.getTypeCasts());
        this.scan((CtElement)f.getTarget());
        this.scan(f.getVariable());
        this.exit(f);
    }

    @Override
    public void visitCtComment(CtComment comment) {
        this.enter(comment);
        this.scan(comment.getComments());
        this.scan(comment.getAnnotations());
        this.exit(comment);
    }
}

