/*
 * Decompiled with CFR 0.152.
 */
package spoon.compiler.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import spoon.compiler.builder.AdvancedOptions;
import spoon.compiler.builder.AnnotationProcessingOptions;
import spoon.compiler.builder.ClasspathOptions;
import spoon.compiler.builder.ComplianceOptions;
import spoon.compiler.builder.JDTBuilder;
import spoon.compiler.builder.SourceOptions;

public class JDTBuilderImpl
implements JDTBuilder {
    private final List<String> args = new ArrayList<String>();
    private boolean hasSources = false;

    @Override
    public JDTBuilder classpathOptions(ClasspathOptions<?> options) {
        this.checkSources();
        this.args.addAll(Arrays.asList(options.build()));
        return this;
    }

    @Override
    public JDTBuilder complianceOptions(ComplianceOptions<?> options) {
        this.checkSources();
        this.args.addAll(Arrays.asList(options.build()));
        return this;
    }

    @Override
    public JDTBuilder annotationProcessingOptions(AnnotationProcessingOptions<?> options) {
        this.checkSources();
        this.args.addAll(Arrays.asList(options.build()));
        return this;
    }

    @Override
    public JDTBuilder advancedOptions(AdvancedOptions<?> options) {
        this.checkSources();
        this.args.addAll(Arrays.asList(options.build()));
        return this;
    }

    @Override
    public JDTBuilder sources(SourceOptions<?> options) {
        this.hasSources = true;
        this.args.addAll(Arrays.asList(options.build()));
        return this;
    }

    @Override
    public String[] build() {
        return this.args.toArray(new String[this.args.size()]);
    }

    private void checkSources() {
        if (this.hasSources) {
            throw new RuntimeException("Please, specify sources at the end.");
        }
    }
}

