/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.lib;

import io.apisense.crop.api.CropContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class Sting {
    private final Class<?> desc;

    protected Sting(Class<?> desc) {
        this.desc = desc;
    }

    protected String getId() {
        return CropContext.peek();
    }

    public <S> S inject(String crop) {
        return (S)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.desc}, (InvocationHandler)new StingInterceptor(this, crop));
    }

    public void start() {
    }

    public void stop() {
    }

    public void stopEvent(String eventName) {
    }

    public boolean isAvailable() {
        return true;
    }

    private static class StingInterceptor
    implements InvocationHandler {
        private final Sting sting;
        private final String crop;

        public StingInterceptor(Sting sting, String crop) {
            this.sting = sting;
            this.crop = crop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            CropContext.push(this.crop);
            try {
                Object object = method.invoke((Object)this.sting, args);
                return object;
            }
            finally {
                CropContext.pop();
            }
        }
    }
}

