/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.documentation;

import io.apisense.NoDoc;
import io.apisense.generation.JavaToJS;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.PrettyPrinter;

final class JsPrettyPrinter
extends CtScanner
implements PrettyPrinter {
    private static final Logger logger = LoggerFactory.getLogger(JsPrettyPrinter.class);
    private JavaToJS javaToJs;
    private StringBuilder jsFile;

    JsPrettyPrinter(JavaToJS javaToJs) {
        this.javaToJs = javaToJs;
        this.jsFile = new StringBuilder();
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        if (!this.discardDocGeneration((CtElement)ctClass)) {
            logger.debug("Documenting class: " + ctClass.getSimpleName());
            this.addTypeEntry((CtType<T>)ctClass, DocumentedType.CLASS);
            this.addPropertiesDoc((CtType<T>)ctClass);
            Set methods = ctClass.getMethods();
            methods.removeIf(method -> !method.getModifiers().contains(ModifierKind.PUBLIC) || this.discardDocGeneration((CtElement)method));
            this.addMethods((CtType<T>)ctClass, methods);
        }
    }

    public <T> void visitCtInterface(CtInterface<T> intrface) {
        if (!this.discardDocGeneration((CtElement)intrface)) {
            logger.debug("Documenting interface: " + intrface.getSimpleName());
            this.addTypeEntry((CtType<T>)intrface, DocumentedType.INTERFACE);
            this.addPropertiesDoc((CtType<T>)intrface);
            this.addMethods((CtType<T>)intrface, intrface.getAllMethods());
        }
    }

    public String getPackageDeclaration() {
        return null;
    }

    public String printPackageInfo(CtPackage pack) {
        return null;
    }

    public String getResult() {
        return this.jsFile.toString();
    }

    public void reset() {
        this.jsFile = new StringBuilder();
    }

    public void calculate(CompilationUnit sourceCompilationUnit, List<CtType<?>> types) {
        for (CtType<?> type : types) {
            this.scan((CtElement)type);
        }
    }

    public Map<Integer, Integer> getLineNumberMapping() {
        return null;
    }

    private <T> void addTypeEntry(CtType<T> ctType, DocumentedType type) {
        StringBuilder classDoc = new StringBuilder();
        classDoc.append("/**\n");
        this.appendAvailableJavadoc((CtElement)ctType, classDoc);
        classDoc.append(" * @").append(type.keyword);
        for (CtTypeReference superInterface : ctType.getSuperInterfaces()) {
            classDoc.append("\n * @implements {").append(superInterface.getSimpleName()).append("}");
        }
        classDoc.append("\n */\n");
        this.jsFile.append((CharSequence)classDoc).append(this.javaToJs.generateClassDeclaration(ctType)).append("\n");
    }

    private <T> void addPropertiesDoc(CtType<T> ctType) {
        List fields = ctType.getFields();
        fields.removeIf(field -> ctType instanceof CtClass && !field.getModifiers().contains(ModifierKind.PUBLIC) || this.discardDocGeneration((CtElement)field));
        for (CtField field2 : fields) {
            String typeDoc = this.generatePropertyDoc(field2);
            String typeDec = this.javaToJs.generateFieldDeclaration(ctType, (CtNamedElement)field2);
            this.jsFile.append(typeDoc).append(typeDec).append(";\n");
        }
    }

    private String generatePropertyDoc(CtField<?> field) {
        StringBuilder typeDoc = new StringBuilder("/**\n");
        this.appendAvailableJavadoc((CtElement)field, typeDoc);
        typeDoc.append(" * @type {").append(this.javaToJs.findJsType((CtTypedElement)field)).append("}");
        if (field.hasModifier(ModifierKind.FINAL)) {
            typeDoc.append("\n * @const");
        }
        typeDoc.append("\n */\n");
        return typeDoc.toString();
    }

    private void appendAvailableJavadoc(CtElement element, StringBuilder stringBuilder) {
        if (this.javadocAvailable(element)) {
            String docComment = element.getDocComment();
            for (String line : docComment.split("\n")) {
                stringBuilder.append(" * ").append(line).append("\n");
            }
        }
    }

    private <T> void addMethods(CtType<T> ctType, Collection<CtMethod<?>> methods) {
        for (CtMethod<?> method : methods) {
            logger.debug("Documenting method: " + method.getSimpleName());
            if (this.javadocAvailable((CtElement)method)) {
                String javaDoc = this.generateDocForMethod(method);
                this.jsFile.append("/**").append(javaDoc).append("\n */\n");
            }
            String methDec = this.javaToJs.generateFieldDeclaration(ctType, (CtNamedElement)method);
            String methDef = this.javaToJs.generateFunctionDefinition(method);
            this.jsFile.append(methDec).append(" = ").append(methDef).append(";\n");
        }
    }

    private <T> String generateDocForMethod(CtMethod<T> method) {
        String[] commentLines;
        StringBuilder doc = new StringBuilder();
        for (String content : commentLines = method.getDocComment().split("\n")) {
            String replace;
            String type;
            doc.append("\n *");
            if (content.contains("@param")) {
                type = this.retrieveArgType(content, method.getParameters());
                replace = content.replace("@param", "@param {" + type + "}");
                doc.append(" ").append(replace);
                continue;
            }
            if (content.contains("@return")) {
                type = this.javaToJs.findJsType((CtTypedElement)method);
                replace = content.replace("@return", "@return {" + type + "}");
                doc.append(" ").append(replace);
                continue;
            }
            if (content.isEmpty()) continue;
            doc.append(" ").append(content);
        }
        return doc.toString();
    }

    private String retrieveArgType(String javadocLine, List<CtParameter<?>> params) {
        Pattern regex = Pattern.compile("@param\\s+(\\w+)\\s*.*");
        Matcher matcher = regex.matcher(javadocLine);
        if (matcher.matches()) {
            String paramName = matcher.group(1);
            for (CtParameter<?> param : params) {
                if (!paramName.equals(param.getSimpleName())) continue;
                return this.javaToJs.findJsType((CtTypedElement)param);
            }
        }
        return "unknown";
    }

    private boolean discardDocGeneration(CtElement ctElement) {
        return ctElement.getAnnotation(NoDoc.class) != null;
    }

    private boolean javadocAvailable(CtElement element) {
        return element.getDocComment() != null && !element.getDocComment().isEmpty();
    }

    private static enum DocumentedType {
        CLASS("class"),
        INTERFACE("interface");

        public final String keyword;

        private DocumentedType(String keyword) {
            this.keyword = keyword;
        }
    }
}

