/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.PrettyPrinter;
import spoon.support.JavaOutputProcessor;

public class SingleFileOutputProcessor
extends JavaOutputProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileOutputProcessor.class);
    private final File outputFile;

    public SingleFileOutputProcessor(File outputDirectory, File outputFile, PrettyPrinter printer) {
        super(outputDirectory, printer);
        this.outputFile = outputFile;
    }

    public void process(CtNamedElement nameElement) {
        if (nameElement instanceof CtType) {
            this.getPrinter().calculate(null, Collections.singletonList((CtType)nameElement));
        }
    }

    public void processingDone() {
        String result = this.getPrinter().getResult();
        try {
            logger.debug("Writing to output file: " + this.outputFile);
            FileWriter writer = new FileWriter(this.outputFile);
            writer.write(result);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

