/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation;

import io.apisense.JSDoc;
import io.apisense.generation.documentation.DocGenerator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractAnnotationProcessor;
import spoon.reflect.declaration.CtType;

public class JSDocAnnotationProcessor
extends AbstractAnnotationProcessor<JSDoc, CtType> {
    private static final Logger logger = LoggerFactory.getLogger(JSDocAnnotationProcessor.class);
    private final File outputFile;
    private List<String> toDocumentAsJs = new ArrayList<String>();

    public JSDocAnnotationProcessor(File output) {
        this.outputFile = output;
    }

    public void process(JSDoc annotation, CtType element) {
        logger.debug("Annotation detected in " + element.getSimpleName());
        this.toDocumentAsJs.add(element.getPosition().getFile().getAbsolutePath());
    }

    public void processingDone() {
        super.processingDone();
        try {
            logger.debug("Got files to generate: " + this.toDocumentAsJs);
            new DocGenerator(this.outputFile, this.toDocumentAsJs).generateDocumentation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

