/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing.utils;

import java.io.File;
import spoon.reflect.declaration.CtElement;

public final class Check {
    private Check() {
        throw new AssertionError();
    }

    public static <T> T assertNotNull(T reference) {
        if (reference == null) {
            throw new AssertionError((Object)"Your parameter can't be null.");
        }
        return reference;
    }

    public static <T extends File> T assertExists(T file) {
        if (!file.exists()) {
            throw new AssertionError((Object)"You should specify an existing file.");
        }
        return file;
    }

    public static <A extends CtElement, E extends CtElement> A assertIsSame(A actual, E expected) {
        Check.assertNotNull(actual);
        Check.assertNotNull(expected);
        if (!actual.getClass().equals(expected.getClass())) {
            throw new AssertionError((Object)String.format("Actual value is typed by %1$s and expected is typed by %2$s, these objects should be the same type.", actual.getClass().getName(), expected.getClass().getName()));
        }
        return actual;
    }
}

